/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.bundled;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.JarUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import groovy.lang.GroovyObject;
import java.io.File;
import java.util.jar.Attributes;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.bundled.BundledGroovy;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\b\u0010\u0006\u001a\u00020\u0002H\u0002\u001a\b\u0010\n\u001a\u00020\bH\u0002\u001a\n\u0010\u000e\u001a\u0004\u0018\u00010\fH\u0002\u001a\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012\"\u001c\u0010\u0000\u001a\r\u0012\t\u0012\u00070\u0002\u00a2\u0006\u0002\b\u00030\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0005\"\u0019\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0005\u00a8\u0006\u0013"}, d2={"bundledGroovyVersion", "Lcom/intellij/util/concurrency/SynchronizedClearableLazy;", "", "Lcom/intellij/openapi/util/NlsSafe;", "getBundledGroovyVersion", "()Lcom/intellij/util/concurrency/SynchronizedClearableLazy;", "doGetBundledGroovyVersion", "bundledGroovyFile", "Ljava/io/File;", "getBundledGroovyFile", "doGetBundledGroovyFile", "bundledGroovyJarRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "getBundledGroovyJarRoot", "doGetBundledGroovyRoot", "createBundledGroovyScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.groovy"})
@JvmName(name="BundledGroovy")
public final class BundledGroovy {
    @NotNull
    private static final SynchronizedClearableLazy<String> bundledGroovyVersion = new SynchronizedClearableLazy((Function0)bundledGroovyVersion.1.INSTANCE);
    @NotNull
    private static final SynchronizedClearableLazy<File> bundledGroovyFile = new SynchronizedClearableLazy((Function0)bundledGroovyFile.1.INSTANCE);
    @NotNull
    private static final SynchronizedClearableLazy<VirtualFile> bundledGroovyJarRoot = new SynchronizedClearableLazy((Function0)bundledGroovyJarRoot.1.INSTANCE);

    @NotNull
    public static final SynchronizedClearableLazy<String> getBundledGroovyVersion() {
        return bundledGroovyVersion;
    }

    private static final String doGetBundledGroovyVersion() {
        String string = JarUtil.getJarAttribute((File)((File)bundledGroovyFile.get()), (Attributes.Name)Attributes.Name.IMPLEMENTATION_VERSION);
        if (string == null) {
            string = "undefined";
        }
        return string;
    }

    @NotNull
    public static final SynchronizedClearableLazy<File> getBundledGroovyFile() {
        return bundledGroovyFile;
    }

    private static final File doGetBundledGroovyFile() {
        String string = PathManager.getJarPathForClass(GroovyObject.class);
        if (string == null) {
            throw new IllegalStateException("Cannot find JAR containing groovy classes".toString());
        }
        String jarPath = string;
        return new File(jarPath);
    }

    @NotNull
    public static final SynchronizedClearableLazy<VirtualFile> getBundledGroovyJarRoot() {
        return bundledGroovyJarRoot;
    }

    private static final VirtualFile doGetBundledGroovyRoot() {
        File jar = (File)bundledGroovyFile.get();
        VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)jar, (boolean)false);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile jarFile = virtualFile;
        return JarFileSystem.getInstance().getJarRootForLocalFile(jarFile);
    }

    @Nullable
    public static final GlobalSearchScope createBundledGroovyScope(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        VirtualFile virtualFile = (VirtualFile)bundledGroovyJarRoot.get();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile root = virtualFile;
        return GlobalSearchScopesCore.directoryScope((Project)project, (VirtualFile)root, (boolean)true);
    }

    public static final /* synthetic */ String access$doGetBundledGroovyVersion() {
        return BundledGroovy.doGetBundledGroovyVersion();
    }

    public static final /* synthetic */ File access$doGetBundledGroovyFile() {
        return BundledGroovy.doGetBundledGroovyFile();
    }

    public static final /* synthetic */ VirtualFile access$doGetBundledGroovyRoot() {
        return BundledGroovy.doGetBundledGroovyRoot();
    }
}

