/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.typing;

import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrTupleType;
import org.jetbrains.plugins.groovy.lang.psi.util.CompileStaticUtil;
import org.jetbrains.plugins.groovy.lang.typing.FixedMultiAssignmentTypes;
import org.jetbrains.plugins.groovy.lang.typing.MultiAssignmentTypes;
import org.jetbrains.plugins.groovy.lang.typing.UnboundedMultiAssignmentTypes;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u0015\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006\u001a\u0018\u0010\u0007\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003\u001a\u0010\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\b\u001a\u00020\t\u001a\u0015\u0010\r\u001a\u0004\u0018\u00010\u00032\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000e\u001a\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00102\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00102\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00102\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0012\u0010\u0015\u001a\u0004\u0018\u00010\f2\u0006\u0010\b\u001a\u00020\tH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"tupleRegex", "Lkotlin/text/Regex;", "getTupleComponentCountOrNull", "", "type", "Lcom/intellij/psi/PsiType;", "(Lcom/intellij/psi/PsiType;)Ljava/lang/Integer;", "getMultiAssignmentType", "rValue", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrExpression;", "position", "getMultiAssignmentTypes", "Lorg/jetbrains/plugins/groovy/lang/typing/MultiAssignmentTypes;", "getMultiAssignmentTypesCountCS", "(Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrExpression;)Ljava/lang/Integer;", "getMultiAssignmentTypesCS", "Lorg/jetbrains/plugins/groovy/lang/typing/FixedMultiAssignmentTypes;", "getLiteralMultiAssignmentTypesCS", "getLiteralMultiAssignmentTypes", "getTupleMultiAssignmentTypesCS", "getTupleMultiAssignmentTypes", "getIterableMultiAssignmentTypes", "intellij.groovy.psi"})
public final class TuplesKt {
    @NotNull
    private static final Regex tupleRegex = new Regex("groovy.lang.Tuple(\\d+)");

    @Nullable
    public static final Integer getTupleComponentCountOrNull(@NotNull PsiType type) {
        String string;
        List list;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        PsiClassType psiClassType = type instanceof PsiClassType ? (PsiClassType)type : null;
        if (psiClassType == null) {
            return null;
        }
        PsiClassType classType = psiClassType;
        Object object = classType.resolve();
        if (object == null || (object = object.getQualifiedName()) == null) {
            return null;
        }
        Object fqn = object;
        MatchResult matchResult = tupleRegex.matchEntire((CharSequence)fqn);
        return matchResult != null && (list = matchResult.getGroupValues()) != null && (string = (String)CollectionsKt.getOrNull((List)list, (int)1)) != null ? StringsKt.toIntOrNull((String)string) : null;
    }

    @Nullable
    public static final PsiType getMultiAssignmentType(@NotNull GrExpression rValue, int position) {
        Intrinsics.checkNotNullParameter((Object)rValue, (String)"rValue");
        MultiAssignmentTypes multiAssignmentTypes = TuplesKt.getMultiAssignmentTypes(rValue);
        return multiAssignmentTypes != null ? multiAssignmentTypes.getComponentType(position) : null;
    }

    @Nullable
    public static final MultiAssignmentTypes getMultiAssignmentTypes(@NotNull GrExpression rValue) {
        MultiAssignmentTypes multiAssignmentTypes;
        Intrinsics.checkNotNullParameter((Object)rValue, (String)"rValue");
        if (CompileStaticUtil.isCompileStatic(rValue)) {
            return TuplesKt.getMultiAssignmentTypesCS(rValue);
        }
        FixedMultiAssignmentTypes fixedMultiAssignmentTypes = TuplesKt.getLiteralMultiAssignmentTypes(rValue);
        if (fixedMultiAssignmentTypes != null) {
            multiAssignmentTypes = fixedMultiAssignmentTypes;
        } else {
            FixedMultiAssignmentTypes fixedMultiAssignmentTypes2 = TuplesKt.getTupleMultiAssignmentTypes(rValue);
            multiAssignmentTypes = fixedMultiAssignmentTypes2 != null ? (MultiAssignmentTypes)fixedMultiAssignmentTypes2 : TuplesKt.getIterableMultiAssignmentTypes(rValue);
        }
        return multiAssignmentTypes;
    }

    @Nullable
    public static final Integer getMultiAssignmentTypesCountCS(@NotNull GrExpression rValue) {
        Intrinsics.checkNotNullParameter((Object)rValue, (String)"rValue");
        Object object = TuplesKt.getMultiAssignmentTypesCS(rValue);
        return object != null && (object = ((FixedMultiAssignmentTypes)object).getTypes()) != null ? Integer.valueOf(object.size()) : null;
    }

    private static final FixedMultiAssignmentTypes getMultiAssignmentTypesCS(GrExpression rValue) {
        FixedMultiAssignmentTypes fixedMultiAssignmentTypes = TuplesKt.getLiteralMultiAssignmentTypesCS(rValue);
        if (fixedMultiAssignmentTypes == null) {
            fixedMultiAssignmentTypes = TuplesKt.getTupleMultiAssignmentTypesCS(rValue);
        }
        return fixedMultiAssignmentTypes;
    }

    private static final FixedMultiAssignmentTypes getLiteralMultiAssignmentTypesCS(GrExpression rValue) {
        if (!(rValue instanceof GrListOrMap) || ((GrListOrMap)rValue).isMap()) {
            return null;
        }
        return TuplesKt.getLiteralMultiAssignmentTypes(rValue);
    }

    private static final FixedMultiAssignmentTypes getLiteralMultiAssignmentTypes(GrExpression rValue) {
        PsiType psiType = rValue.getType();
        GrTupleType grTupleType = psiType instanceof GrTupleType ? (GrTupleType)psiType : null;
        if (grTupleType == null) {
            return null;
        }
        GrTupleType tupleType = grTupleType;
        List<PsiType> list = tupleType.getComponentTypes();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getComponentTypes(...)");
        return new FixedMultiAssignmentTypes(list);
    }

    private static final FixedMultiAssignmentTypes getTupleMultiAssignmentTypesCS(GrExpression rValue) {
        if (GroovyConfigUtils.getInstance().getSDKVersion(rValue).compareTo("3.0") < 0) {
            return null;
        }
        return TuplesKt.getTupleMultiAssignmentTypes(rValue);
    }

    private static final FixedMultiAssignmentTypes getTupleMultiAssignmentTypes(GrExpression rValue) {
        Object object = rValue.getType();
        PsiClassType psiClassType = object instanceof PsiClassType ? (PsiClassType)object : null;
        if (psiClassType == null) {
            return null;
        }
        PsiClassType classType = psiClassType;
        Object object2 = classType.resolve();
        if (object2 == null || (object2 = object2.getQualifiedName()) == null) {
            return null;
        }
        Object fqn = object2;
        object = (CharSequence)fqn;
        if (!tupleRegex.matches((CharSequence)object)) {
            return null;
        }
        PsiType[] psiTypeArray = classType.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)psiTypeArray, (String)"getParameters(...)");
        return new FixedMultiAssignmentTypes(ArraysKt.toList((Object[])psiTypeArray));
    }

    private static final MultiAssignmentTypes getIterableMultiAssignmentTypes(GrExpression rValue) {
        PsiType psiType = PsiUtil.extractIterableTypeParameter((PsiType)rValue.getType(), (boolean)false);
        if (psiType == null) {
            return null;
        }
        PsiType iterableTypeParameter = psiType;
        return new UnboundedMultiAssignmentTypes(iterableTypeParameter);
    }
}

