/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProducer;
import com.intellij.openapi.vcs.changes.ui.ChangeDiffRequestChain;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicyFactory;
import com.intellij.openapi.vcs.changes.ui.SimpleAsyncChangesTreeModel;
import com.intellij.openapi.vcs.changes.ui.TagChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.EventDispatcher;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.history.FileHistoryUtil;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.MergedChange;
import com.intellij.vcs.log.impl.MergedChangeDiffRequestProvider;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.ui.frame.ParentTag;
import com.intellij.vcs.log.ui.frame.VcsLogChangesTreeComponents;
import com.intellij.vcs.log.ui.frame.VcsLogChangesTreeModifier;
import com.intellij.vcs.log.util.VcsLogUtil;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.tree.DefaultTreeModel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\"\n\u0002\b\u0007\b\u0007\u0018\u0000 K2\u00020\u0001:\u0004HIJKB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u00072\u0006\u00101\u001a\u00020 J\u000e\u00102\u001a\u0002032\u0006\u00104\u001a\u000205J\u0014\u00106\u001a\u00020/2\f\u00107\u001a\b\u0012\u0004\u0012\u0002080\u0013J\u0006\u00109\u001a\u00020/J\u0006\u0010:\u001a\u00020/J\u0010\u0010;\u001a\u00020/2\u0006\u0010<\u001a\u00020\fH\u0002J\u0010\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@H\u0017J\u0010\u0010A\u001a\u00020\u000e2\u0006\u0010<\u001a\u00020\fH\u0002JX\u0010=\u001a\u00020B2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0018\u0010C\u001a\u0014\u0012\u0004\u0012\u000205\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140E0D2\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u00172\u0006\u0010F\u001a\u00020#2\u0006\u0010G\u001a\u00020#2\u0006\u0010?\u001a\u00020@H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R4\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u00172\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u0017@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR!\u0010\u001e\u001a\u0015\u0012\f\u0012\n !*\u0004\u0018\u00010 0 0\u001f\u00a2\u0006\u0002\b\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010$\u001a\u00020#2\u0006\u0010\r\u001a\u00020#@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b%\u0010&R$\u0010'\u001a\u00020#2\u0006\u0010\r\u001a\u00020#8F@GX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b'\u0010(\"\u0004\b)\u0010&R\u001e\u0010*\u001a\u00020#2\u0006\u0010\r\u001a\u00020#@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b+\u0010&R$\u0010,\u001a\u00020#2\u0006\u0010\r\u001a\u00020#8F@GX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b,\u0010(\"\u0004\b-\u0010&\u00a8\u0006L"}, d2={"Lcom/intellij/vcs/log/ui/frame/VcsLogAsyncChangesTreeModel;", "Lcom/intellij/openapi/vcs/changes/ui/SimpleAsyncChangesTreeModel;", "logData", "Lcom/intellij/vcs/log/data/VcsLogData;", "uiProperties", "Lcom/intellij/vcs/log/impl/VcsLogUiProperties;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/vcs/log/data/VcsLogData;Lcom/intellij/vcs/log/impl/VcsLogUiProperties;Lcom/intellij/openapi/Disposable;)V", "unprocessedSelectionState", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/vcs/log/ui/frame/VcsLogAsyncChangesTreeModel$SelectionState;", "value", "Lcom/intellij/vcs/log/ui/frame/VcsLogAsyncChangesTreeModel$ChangesState;", "changesState", "getChangesState", "()Lcom/intellij/vcs/log/ui/frame/VcsLogAsyncChangesTreeModel$ChangesState;", "changes", "", "Lcom/intellij/openapi/vcs/changes/Change;", "getChanges", "()Ljava/util/List;", "", "Lcom/intellij/openapi/vcs/FilePath;", "affectedPaths", "getAffectedPaths", "()Ljava/util/Collection;", "setAffectedPaths", "(Ljava/util/Collection;)V", "listeners", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/vcs/log/ui/frame/VcsLogAsyncChangesTreeModel$Listener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "", "_isShowChangesFromParents", "set_isShowChangesFromParents", "(Z)V", "isShowChangesFromParents", "()Z", "setShowChangesFromParents", "_isShowOnlyAffectedChanges", "set_isShowOnlyAffectedChanges", "isShowOnlyAffectedChanges", "setShowOnlyAffectedChanges", "addListener", "", "disposable", "listener", "getCommitDetails", "Lcom/intellij/vcs/log/VcsShortCommitDetails;", "commitId", "Lcom/intellij/vcs/log/CommitId;", "setSelectedDetails", "details", "Lcom/intellij/vcs/log/VcsFullCommitDetails;", "setSelectionError", "setEmptySelection", "updateSelectionState", "state", "buildTreeModelSync", "Ljavax/swing/tree/DefaultTreeModel;", "grouping", "Lcom/intellij/openapi/vcs/changes/ui/ChangesGroupingPolicyFactory;", "createChangesState", "Lcom/intellij/openapi/vcs/changes/ui/TreeModelBuilder;", "changesToParents", "", "", "showOnlyAffectedChanges", "showChangesFromParents", "Listener", "SelectionState", "ChangesState", "Companion", "intellij.platform.vcs.log.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nVcsLogAsyncChangesTreeModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsLogAsyncChangesTreeModel.kt\ncom/intellij/vcs/log/ui/frame/VcsLogAsyncChangesTreeModel\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,321:1\n18#2:322\n1586#3:323\n1661#3,3:324\n1205#3,2:327\n1282#3,4:329\n1266#3,4:335\n466#4:333\n415#4:334\n*S KotlinDebug\n*F\n+ 1 VcsLogAsyncChangesTreeModel.kt\ncom/intellij/vcs/log/ui/frame/VcsLogAsyncChangesTreeModel\n*L\n53#1:322\n185#1:323\n185#1:324,3\n197#1:327,2\n197#1:329,4\n228#1:335,4\n228#1:333\n228#1:334\n*E\n"})
public final class VcsLogAsyncChangesTreeModel
extends SimpleAsyncChangesTreeModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VcsLogData logData;
    @NotNull
    private final VcsLogUiProperties uiProperties;
    @NotNull
    private final AtomicReference<SelectionState> unprocessedSelectionState;
    @NotNull
    private volatile ChangesState changesState;
    @Nullable
    private volatile Collection<? extends FilePath> affectedPaths;
    @NotNull
    private final EventDispatcher<Listener> listeners;
    private volatile boolean _isShowChangesFromParents;
    private volatile boolean _isShowOnlyAffectedChanges;
    @JvmField
    @NotNull
    public static final DataKey<Boolean> HAS_AFFECTED_FILES = DataKey.Companion.create("VcsLogAsyncChangesTreeModel.HasAffectedFiles");

    public VcsLogAsyncChangesTreeModel(@NotNull VcsLogData logData, @NotNull VcsLogUiProperties uiProperties, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)logData, (String)"logData");
        Intrinsics.checkNotNullParameter((Object)uiProperties, (String)"uiProperties");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.logData = logData;
        this.uiProperties = uiProperties;
        this.unprocessedSelectionState = new AtomicReference<Object>(null);
        this.changesState = new ChangesState.Empty(false);
        EventDispatcher eventDispatcher = EventDispatcher.create(Listener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        this.listeners = eventDispatcher;
        VcsLogUiProperties.PropertiesChangeListener propertiesChangeListener2 = new VcsLogUiProperties.PropertiesChangeListener(this){
            final /* synthetic */ VcsLogAsyncChangesTreeModel this$0;
            {
                this.this$0 = $receiver;
            }

            public <T> void onPropertyChanged(VcsLogUiProperties.VcsLogUiProperty<T> property) {
                Intrinsics.checkNotNullParameter(property, (String)"property");
                VcsLogAsyncChangesTreeModel.access$_init_$updateUiSettings(this.this$0);
            }
        };
        this.uiProperties.addChangeListener(propertiesChangeListener2, parentDisposable);
        VcsLogAsyncChangesTreeModel._init_$updateUiSettings(this);
        Disposer.register((Disposable)parentDisposable, () -> VcsLogAsyncChangesTreeModel._init_$lambda$0(this));
    }

    @NotNull
    public final ChangesState getChangesState() {
        return this.changesState;
    }

    @NotNull
    public final List<Change> getChanges() {
        Object object;
        ChangesState $this$asSafely$iv = this.changesState;
        boolean $i$f$asSafely = false;
        ChangesState changesState = $this$asSafely$iv;
        if (!(changesState instanceof ChangesState.Changes)) {
            changesState = null;
        }
        if ((object = (ChangesState.Changes)changesState) == null || (object = ((ChangesState.Changes)object).getChanges()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @Nullable
    public final Collection<FilePath> getAffectedPaths() {
        return this.affectedPaths;
    }

    public final void setAffectedPaths(@Nullable Collection<? extends FilePath> value) {
        this.affectedPaths = value;
        ((Listener)this.listeners.getMulticaster()).onStateChanged();
    }

    private final void set_isShowChangesFromParents(boolean value) {
        if (value == this._isShowChangesFromParents) {
            return;
        }
        this._isShowChangesFromParents = value;
        ((Listener)this.listeners.getMulticaster()).onStateChanged();
    }

    public final boolean isShowChangesFromParents() {
        return this._isShowChangesFromParents;
    }

    @RequiresEdt
    public final void setShowChangesFromParents(boolean value) {
        VcsLogUiProperties.VcsLogUiProperty<Boolean> vcsLogUiProperty = MainVcsLogUiProperties.SHOW_CHANGES_FROM_PARENTS;
        Intrinsics.checkNotNullExpressionValue(vcsLogUiProperty, (String)"SHOW_CHANGES_FROM_PARENTS");
        if (!Intrinsics.areEqual((Object)this.uiProperties.get(vcsLogUiProperty), (Object)value)) {
            VcsLogUiProperties.VcsLogUiProperty<Boolean> vcsLogUiProperty2 = MainVcsLogUiProperties.SHOW_CHANGES_FROM_PARENTS;
            Intrinsics.checkNotNullExpressionValue(vcsLogUiProperty2, (String)"SHOW_CHANGES_FROM_PARENTS");
            this.uiProperties.set(vcsLogUiProperty2, value);
        }
    }

    private final void set_isShowOnlyAffectedChanges(boolean value) {
        if (value == this._isShowOnlyAffectedChanges) {
            return;
        }
        this._isShowOnlyAffectedChanges = value;
        ((Listener)this.listeners.getMulticaster()).onStateChanged();
    }

    public final boolean isShowOnlyAffectedChanges() {
        return this._isShowOnlyAffectedChanges;
    }

    @RequiresEdt
    public final void setShowOnlyAffectedChanges(boolean value) {
        VcsLogUiProperties.VcsLogUiProperty<Boolean> vcsLogUiProperty = MainVcsLogUiProperties.SHOW_ONLY_AFFECTED_CHANGES;
        Intrinsics.checkNotNullExpressionValue(vcsLogUiProperty, (String)"SHOW_ONLY_AFFECTED_CHANGES");
        if (!Intrinsics.areEqual((Object)this.uiProperties.get(vcsLogUiProperty), (Object)value)) {
            VcsLogUiProperties.VcsLogUiProperty<Boolean> vcsLogUiProperty2 = MainVcsLogUiProperties.SHOW_ONLY_AFFECTED_CHANGES;
            Intrinsics.checkNotNullExpressionValue(vcsLogUiProperty2, (String)"SHOW_ONLY_AFFECTED_CHANGES");
            this.uiProperties.set(vcsLogUiProperty2, value);
        }
    }

    public final void addListener(@NotNull Disposable disposable2, @NotNull Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)disposable2, (String)"disposable");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.addListener((EventListener)listener2, disposable2);
    }

    @NotNull
    public final VcsShortCommitDetails getCommitDetails(@NotNull CommitId commitId) {
        Intrinsics.checkNotNullParameter((Object)commitId, (String)"commitId");
        Hash hash = commitId.getHash();
        Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"getHash(...)");
        VirtualFile virtualFile = commitId.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
        int index = this.logData.getCommitIndex(hash, virtualFile);
        return (VcsShortCommitDetails)this.logData.getMiniDetailsGetter().getCachedDataOrPlaceholder(index);
    }

    public final void setSelectedDetails(@NotNull List<? extends VcsFullCommitDetails> details) {
        Intrinsics.checkNotNullParameter(details, (String)"details");
        int maxSize = VcsLogUtil.getMaxSize(details);
        if (maxSize > VcsLogUtil.getShownChangesLimit()) {
            this.updateSelectionState(new SelectionState.ManyDetails(details, maxSize));
        } else {
            this.updateSelectionState(new SelectionState.Details(details));
        }
    }

    public final void setSelectionError() {
        this.updateSelectionState(SelectionState.Error.INSTANCE);
    }

    public final void setEmptySelection() {
        this.updateSelectionState(SelectionState.Empty.INSTANCE);
    }

    private final void updateSelectionState(SelectionState state) {
        this.unprocessedSelectionState.set(state);
        ((Listener)this.listeners.getMulticaster()).onStateChanged();
    }

    @RequiresBackgroundThread
    @NotNull
    public DefaultTreeModel buildTreeModelSync(@NotNull ChangesGroupingPolicyFactory grouping) {
        ChangesState state;
        Intrinsics.checkNotNullParameter((Object)grouping, (String)"grouping");
        SelectionState selectionState = this.unprocessedSelectionState.getAndSet(null);
        if (selectionState != null) {
            ChangesState changesState;
            try {
                ChangesState it = changesState = this.createChangesState(selectionState);
                boolean bl = false;
                this.changesState = it;
            }
            catch (ProcessCanceledException e) {
                this.unprocessedSelectionState.compareAndSet(null, selectionState);
                throw e;
            }
            v0 = changesState;
        } else {
            v0 = state = this.changesState;
        }
        if (state instanceof ChangesState.Changes) {
            TreeModelBuilder treeModel = this.buildTreeModelSync(((ChangesState.Changes)state).getChanges(), ((ChangesState.Changes)state).getChangesToParents(), this.affectedPaths, this.isShowOnlyAffectedChanges(), this.isShowChangesFromParents(), grouping);
            TreeModelBuilder modifiedTreeBuilder = VcsLogChangesTreeModifier.Companion.modifyTreeModelBuilder(treeModel, (ChangesState.Changes)state);
            DefaultTreeModel defaultTreeModel = modifiedTreeBuilder.build();
            Intrinsics.checkNotNullExpressionValue((Object)defaultTreeModel, (String)"build(...)");
            return defaultTreeModel;
        }
        DefaultTreeModel defaultTreeModel = TreeModelBuilder.buildEmpty();
        Intrinsics.checkNotNullExpressionValue((Object)defaultTreeModel, (String)"buildEmpty(...)");
        return defaultTreeModel;
    }

    /*
     * WARNING - void declaration
     */
    private final ChangesState createChangesState(SelectionState state) {
        ChangesState changesState;
        SelectionState selectionState = state;
        if (Intrinsics.areEqual((Object)selectionState, (Object)SelectionState.Empty.INSTANCE)) {
            changesState = new ChangesState.Empty(true);
        } else if (Intrinsics.areEqual((Object)selectionState, (Object)SelectionState.Error.INSTANCE)) {
            changesState = ChangesState.Error.INSTANCE;
        } else if (selectionState instanceof SelectionState.ManyDetails) {
            changesState = new ChangesState.ManyChanges(((SelectionState.ManyDetails)state).getDetails().size(), ((SelectionState.ManyDetails)state).getMaxDetailsSize(), (Function0<Unit>)((Function0)() -> VcsLogAsyncChangesTreeModel.createChangesState$lambda$0(this, state)));
        } else if (selectionState instanceof SelectionState.Details) {
            ChangesState.Changes changes;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = ((SelectionState.Details)state).getDetails();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                VcsFullCommitDetails vcsFullCommitDetails = (VcsFullCommitDetails)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(p0.getRoot());
            }
            Set roots = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            VcsFullCommitDetails singleCommitDetail = (VcsFullCommitDetails)CollectionsKt.singleOrNull(((SelectionState.Details)state).getDetails());
            if (singleCommitDetail == null) {
                List<Change> list = VcsLogUtil.collectChanges(((SelectionState.Details)state).getDetails());
                Intrinsics.checkNotNullExpressionValue(list, (String)"collectChanges(...)");
                changes = new ChangesState.Changes(roots, list, MapsKt.emptyMap());
            } else {
                Map map;
                if (singleCommitDetail.getParents().size() > 1) {
                    void $this$associateTo$iv$iv;
                    List list = singleCommitDetail.getParents();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getParents(...)");
                    Iterable $this$associate$iv = (Iterable)CollectionsKt.getIndices((Collection)list);
                    boolean $i$f$associate = false;
                    int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                    Iterable iterable2 = $this$associate$iv;
                    Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
                    boolean $i$f$associateTo = false;
                    Iterator iterator = $this$associateTo$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        int element$iv$iv = ((IntIterator)iterator).nextInt();
                        Map map2 = destination$iv$iv2;
                        int i = element$iv$iv;
                        boolean bl = false;
                        Pair pair = TuplesKt.to((Object)new CommitId((Hash)singleCommitDetail.getParents().get(i), singleCommitDetail.getRoot()), (Object)new ReferenceOpenHashSet(singleCommitDetail.getChanges(i)));
                        map2.put(pair.getFirst(), pair.getSecond());
                    }
                    map = destination$iv$iv2;
                } else {
                    map = MapsKt.emptyMap();
                }
                Map changesToParents = map;
                Collection collection = singleCommitDetail.getChanges();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getChanges(...)");
                changes = new ChangesState.Changes(roots, CollectionsKt.toList((Iterable)collection), changesToParents);
            }
            changesState = changes;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return changesState;
    }

    /*
     * WARNING - void declaration
     */
    private final TreeModelBuilder buildTreeModelSync(List<? extends Change> changes, Map<CommitId, ? extends Set<? extends Change>> changesToParents, Collection<? extends FilePath> affectedPaths, boolean showOnlyAffectedChanges, boolean showChangesFromParents, ChangesGroupingPolicyFactory grouping) {
        void $this$associateByTo$iv$iv$iv;
        List changes2 = VcsLogAsyncChangesTreeModel.Companion.collectAffectedChanges(changes, affectedPaths, showOnlyAffectedChanges);
        Map<CommitId, ? extends Set<? extends Change>> $this$mapValues$iv = changesToParents;
        boolean $i$f$mapValues = false;
        Map<CommitId, ? extends Set<? extends Change>> object2 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable iterable = object2.entrySet();
        Map destination$iv$iv$iv = destination$iv$iv;
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map = destination$iv$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map2 = map;
            boolean bl2 = false;
            List list = VcsLogAsyncChangesTreeModel.Companion.collectAffectedChanges((Collection)it.getValue(), affectedPaths, showOnlyAffectedChanges);
            map2.put(k, list);
        }
        Map changesToParents2 = destination$iv$iv$iv;
        TreeModelBuilder builder = new TreeModelBuilder(this.logData.getProject(), grouping);
        builder.setChanges((Collection)changes2, null);
        if (showChangesFromParents && !changesToParents2.isEmpty()) {
            if (changes2.isEmpty()) {
                builder.createTagNode(VcsLogBundle.message("vcs.log.changes.no.merge.conflicts.node", new Object[0]));
            }
            for (Map.Entry entry : changesToParents2.entrySet()) {
                CommitId commitId = (CommitId)entry.getKey();
                List changesFromParent = (List)entry.getValue();
                if (changesFromParent.isEmpty()) continue;
                Hash hash = commitId.getHash();
                Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"getHash(...)");
                ChangesBrowserNode parentNode = (ChangesBrowserNode)new TagChangesBrowserNode((ChangesBrowserNode.Tag)new ParentTag(hash, VcsLogChangesTreeComponents.INSTANCE.getText$intellij_platform_vcs_log_impl(this, commitId)), SimpleTextAttributes.REGULAR_ATTRIBUTES, false);
                parentNode.markAsHelperNode();
                builder.insertSubtreeRoot(parentNode);
                builder.insertChanges((Collection)changesFromParent, parentNode);
            }
        }
        return builder;
    }

    /*
     * Unable to fully structure code
     */
    private static final void _init_$updateUiSettings(VcsLogAsyncChangesTreeModel this$0) {
        v0 = this$0.uiProperties;
        v1 = MainVcsLogUiProperties.SHOW_CHANGES_FROM_PARENTS;
        Intrinsics.checkNotNullExpressionValue(v1, (String)"SHOW_CHANGES_FROM_PARENTS");
        if (!v0.exists(v1)) ** GOTO lbl-1000
        v2 = this$0.uiProperties;
        v3 = MainVcsLogUiProperties.SHOW_CHANGES_FROM_PARENTS;
        Intrinsics.checkNotNullExpressionValue(v3, (String)"SHOW_CHANGES_FROM_PARENTS");
        if (v2.get(v3).booleanValue()) {
            v4 = true;
        } else lbl-1000:
        // 2 sources

        {
            v4 = false;
        }
        this$0.set_isShowChangesFromParents(v4);
        v5 = this$0.uiProperties;
        v6 = MainVcsLogUiProperties.SHOW_ONLY_AFFECTED_CHANGES;
        Intrinsics.checkNotNullExpressionValue(v6, (String)"SHOW_ONLY_AFFECTED_CHANGES");
        if (!v5.exists(v6)) ** GOTO lbl-1000
        v7 = this$0.uiProperties;
        v8 = MainVcsLogUiProperties.SHOW_ONLY_AFFECTED_CHANGES;
        Intrinsics.checkNotNullExpressionValue(v8, (String)"SHOW_ONLY_AFFECTED_CHANGES");
        if (v7.get(v8).booleanValue()) {
            v9 = true;
        } else lbl-1000:
        // 2 sources

        {
            v9 = false;
        }
        this$0.set_isShowOnlyAffectedChanges(v9);
    }

    private static final void _init_$lambda$0(VcsLogAsyncChangesTreeModel this$0) {
        this$0.unprocessedSelectionState.set(null);
    }

    private static final Unit createChangesState$lambda$0(VcsLogAsyncChangesTreeModel this$0, SelectionState $state) {
        this$0.setSelectedDetails(((SelectionState.ManyDetails)$state).getDetails());
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$_init_$updateUiSettings(VcsLogAsyncChangesTreeModel this$0) {
        VcsLogAsyncChangesTreeModel._init_$updateUiSettings(this$0);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0004\u0002\u0003\u0004\u0005\u0082\u0001\u0004\u0006\u0007\b\t\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\n\u00c0\u0006\u0001"}, d2={"Lcom/intellij/vcs/log/ui/frame/VcsLogAsyncChangesTreeModel$ChangesState;", "", "Changes", "ManyChanges", "Empty", "Error", "Lcom/intellij/vcs/log/ui/frame/VcsLogAsyncChangesTreeModel$ChangesState$Changes;", "Lcom/intellij/vcs/log/ui/frame/VcsLogAsyncChangesTreeModel$ChangesState$Empty;", "Lcom/intellij/vcs/log/ui/frame/VcsLogAsyncChangesTreeModel$ChangesState$Error;", "Lcom/intellij/vcs/log/ui/frame/VcsLogAsyncChangesTreeModel$ChangesState$ManyChanges;", "intellij.platform.vcs.log.impl"})
    public static sealed interface ChangesState {

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B=\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00030\t\u00a2\u0006\u0004\b\u000b\u0010\fR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R#\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00030\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/intellij/vcs/log/ui/frame/VcsLogAsyncChangesTreeModel$ChangesState$Changes;", "Lcom/intellij/vcs/log/ui/frame/VcsLogAsyncChangesTreeModel$ChangesState;", "roots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "changes", "", "Lcom/intellij/openapi/vcs/changes/Change;", "changesToParents", "", "Lcom/intellij/vcs/log/CommitId;", "<init>", "(Ljava/util/Set;Ljava/util/List;Ljava/util/Map;)V", "getRoots", "()Ljava/util/Set;", "getChanges", "()Ljava/util/List;", "getChangesToParents", "()Ljava/util/Map;", "intellij.platform.vcs.log.impl"})
        public static final class Changes
        implements ChangesState {
            @NotNull
            private final Set<VirtualFile> roots;
            @NotNull
            private final List<Change> changes;
            @NotNull
            private final Map<CommitId, Set<Change>> changesToParents;

            public Changes(@NotNull Set<? extends VirtualFile> roots, @NotNull List<? extends Change> changes, @NotNull Map<CommitId, ? extends Set<? extends Change>> changesToParents) {
                Intrinsics.checkNotNullParameter(roots, (String)"roots");
                Intrinsics.checkNotNullParameter(changes, (String)"changes");
                Intrinsics.checkNotNullParameter(changesToParents, (String)"changesToParents");
                this.roots = roots;
                this.changes = changes;
                this.changesToParents = changesToParents;
            }

            @NotNull
            public final Set<VirtualFile> getRoots() {
                return this.roots;
            }

            @NotNull
            public final List<Change> getChanges() {
                return this.changes;
            }

            @NotNull
            public final Map<CommitId, Set<Change>> getChangesToParents() {
                return this.changesToParents;
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/vcs/log/ui/frame/VcsLogAsyncChangesTreeModel$ChangesState$Empty;", "Lcom/intellij/vcs/log/ui/frame/VcsLogAsyncChangesTreeModel$ChangesState;", "resetText", "", "<init>", "(Z)V", "getResetText", "()Z", "intellij.platform.vcs.log.impl"})
        public static final class Empty
        implements ChangesState {
            private final boolean resetText;

            public Empty(boolean resetText) {
                this.resetText = resetText;
            }

            public final boolean getResetText() {
                return this.resetText;
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0083\u0004J\n\u0010\b\u001a\u00020\tH\u00d6\u0081\u0004J\n\u0010\n\u001a\u00020\u000bH\u00d6\u0081\u0004\u00a8\u0006\f"}, d2={"Lcom/intellij/vcs/log/ui/frame/VcsLogAsyncChangesTreeModel$ChangesState$Error;", "Lcom/intellij/vcs/log/ui/frame/VcsLogAsyncChangesTreeModel$ChangesState;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.platform.vcs.log.impl"})
        public static final class Error
        implements ChangesState {
            @NotNull
            public static final Error INSTANCE = new Error();

            private Error() {
            }

            @NotNull
            public String toString() {
                return "Error";
            }

            public int hashCode() {
                return -233537233;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Error)) {
                    return false;
                }
                Error cfr_ignored_0 = (Error)other;
                return true;
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/vcs/log/ui/frame/VcsLogAsyncChangesTreeModel$ChangesState$ManyChanges;", "Lcom/intellij/vcs/log/ui/frame/VcsLogAsyncChangesTreeModel$ChangesState;", "size", "", "maxSize", "showAnyway", "Lkotlin/Function0;", "", "<init>", "(IILkotlin/jvm/functions/Function0;)V", "getSize", "()I", "getMaxSize", "getShowAnyway", "()Lkotlin/jvm/functions/Function0;", "intellij.platform.vcs.log.impl"})
        public static final class ManyChanges
        implements ChangesState {
            private final int size;
            private final int maxSize;
            @NotNull
            private final Function0<Unit> showAnyway;

            public ManyChanges(int size, int maxSize, @NotNull Function0<Unit> showAnyway) {
                Intrinsics.checkNotNullParameter(showAnyway, (String)"showAnyway");
                this.size = size;
                this.maxSize = maxSize;
                this.showAnyway = showAnyway;
            }

            public final int getSize() {
                return this.size;
            }

            public final int getMaxSize() {
                return this.maxSize;
            }

            @NotNull
            public final Function0<Unit> getShowAnyway() {
                return this.showAnyway;
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J4\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u0006H\u0002J0\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\t2\u0016\u0010\u0014\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0016\u0012\u0004\u0012\u00020\u00010\u0015R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/vcs/log/ui/frame/VcsLogAsyncChangesTreeModel$Companion;", "", "<init>", "()V", "HAS_AFFECTED_FILES", "Lcom/intellij/openapi/actionSystem/DataKey;", "", "collectAffectedChanges", "", "Lcom/intellij/openapi/vcs/changes/Change;", "changes", "", "affectedPaths", "Lcom/intellij/openapi/vcs/FilePath;", "showOnlyAffectedSelected", "createDiffRequestProducer", "Lcom/intellij/openapi/vcs/changes/ui/ChangeDiffRequestChain$Producer;", "project", "Lcom/intellij/openapi/project/Project;", "change", "context", "", "Lcom/intellij/openapi/util/Key;", "intellij.platform.vcs.log.impl"})
    @SourceDebugExtension(value={"SMAP\nVcsLogAsyncChangesTreeModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsLogAsyncChangesTreeModel.kt\ncom/intellij/vcs/log/ui/frame/VcsLogAsyncChangesTreeModel$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,321:1\n777#2:322\n873#2:323\n1807#2,3:324\n874#2:327\n*S KotlinDebug\n*F\n+ 1 VcsLogAsyncChangesTreeModel.kt\ncom/intellij/vcs/log/ui/frame/VcsLogAsyncChangesTreeModel$Companion\n*L\n293#1:322\n293#1:323\n294#1:324,3\n293#1:327\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final List<Change> collectAffectedChanges(Collection<? extends Change> changes, Collection<? extends FilePath> affectedPaths, boolean showOnlyAffectedSelected) {
            List list;
            if (!showOnlyAffectedSelected || affectedPaths == null) {
                list = new ArrayList<Change>(changes);
            } else {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = changes;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    boolean bl;
                    block6: {
                        Change change = (Change)element$iv$iv;
                        boolean bl2 = false;
                        Iterable $this$any$iv = affectedPaths;
                        boolean $i$f$any = false;
                        if (((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                FilePath filePath = (FilePath)element$iv;
                                boolean bl3 = false;
                                boolean bl4 = filePath.isDirectory() ? FileHistoryUtil.INSTANCE.affectsDirectory(change, filePath) : FileHistoryUtil.INSTANCE.affectsFile(change, filePath, false) || FileHistoryUtil.INSTANCE.affectsFile(change, filePath, true);
                                if (!bl4) continue;
                                bl = true;
                                break block6;
                            }
                            bl = false;
                        }
                    }
                    if (!bl) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list = (List)destination$iv$iv;
            }
            return list;
        }

        @Nullable
        public final ChangeDiffRequestChain.Producer createDiffRequestProducer(@NotNull Project project, @NotNull Change change, @NotNull Map<Key<?>, Object> context) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)change, (String)"change");
            Intrinsics.checkNotNullParameter(context, (String)"context");
            return change instanceof MergedChange && ((MergedChange)change).getSourceChanges().size() == 2 ? (ChangeDiffRequestChain.Producer)new MergedChangeDiffRequestProvider.MyProducer(project, (MergedChange)change, context) : (ChangeDiffRequestChain.Producer)ChangeDiffRequestProducer.create((Project)project, (Change)change, context);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0004\u00c0\u0006\u0001"}, d2={"Lcom/intellij/vcs/log/ui/frame/VcsLogAsyncChangesTreeModel$Listener;", "Ljava/util/EventListener;", "onStateChanged", "", "intellij.platform.vcs.log.impl"})
    public static interface Listener
    extends EventListener {
        public void onStateChanged();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\br\u0018\u00002\u00020\u0001:\u0004\u0002\u0003\u0004\u0005\u0082\u0001\u0004\u0006\u0007\b\t\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\n\u00c0\u0006\u0001"}, d2={"Lcom/intellij/vcs/log/ui/frame/VcsLogAsyncChangesTreeModel$SelectionState;", "", "Details", "ManyDetails", "Empty", "Error", "Lcom/intellij/vcs/log/ui/frame/VcsLogAsyncChangesTreeModel$SelectionState$Details;", "Lcom/intellij/vcs/log/ui/frame/VcsLogAsyncChangesTreeModel$SelectionState$Empty;", "Lcom/intellij/vcs/log/ui/frame/VcsLogAsyncChangesTreeModel$SelectionState$Error;", "Lcom/intellij/vcs/log/ui/frame/VcsLogAsyncChangesTreeModel$SelectionState$ManyDetails;", "intellij.platform.vcs.log.impl"})
    private static sealed interface SelectionState {

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\n\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0014\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0083\u0004J\n\u0010\u000f\u001a\u00020\u0010H\u00d6\u0081\u0004J\n\u0010\u0011\u001a\u00020\u0012H\u00d6\u0081\u0004R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/vcs/log/ui/frame/VcsLogAsyncChangesTreeModel$SelectionState$Details;", "Lcom/intellij/vcs/log/ui/frame/VcsLogAsyncChangesTreeModel$SelectionState;", "details", "", "Lcom/intellij/vcs/log/VcsFullCommitDetails;", "<init>", "(Ljava/util/List;)V", "getDetails", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.platform.vcs.log.impl"})
        public static final class Details
        implements SelectionState {
            @NotNull
            private final List<VcsFullCommitDetails> details;

            public Details(@NotNull List<? extends VcsFullCommitDetails> details) {
                Intrinsics.checkNotNullParameter(details, (String)"details");
                this.details = details;
            }

            @NotNull
            public final List<VcsFullCommitDetails> getDetails() {
                return this.details;
            }

            @NotNull
            public final List<VcsFullCommitDetails> component1() {
                return this.details;
            }

            @NotNull
            public final Details copy(@NotNull List<? extends VcsFullCommitDetails> details) {
                Intrinsics.checkNotNullParameter(details, (String)"details");
                return new Details(details);
            }

            public static /* synthetic */ Details copy$default(Details details, List list, int n, Object object) {
                if ((n & 1) != 0) {
                    list = details.details;
                }
                return details.copy(list);
            }

            @NotNull
            public String toString() {
                return "Details(details=" + this.details + ")";
            }

            public int hashCode() {
                return ((Object)this.details).hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Details)) {
                    return false;
                }
                Details details = (Details)other;
                return Intrinsics.areEqual(this.details, details.details);
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0083\u0004J\n\u0010\b\u001a\u00020\tH\u00d6\u0081\u0004J\n\u0010\n\u001a\u00020\u000bH\u00d6\u0081\u0004\u00a8\u0006\f"}, d2={"Lcom/intellij/vcs/log/ui/frame/VcsLogAsyncChangesTreeModel$SelectionState$Empty;", "Lcom/intellij/vcs/log/ui/frame/VcsLogAsyncChangesTreeModel$SelectionState;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.platform.vcs.log.impl"})
        public static final class Empty
        implements SelectionState {
            @NotNull
            public static final Empty INSTANCE = new Empty();

            private Empty() {
            }

            @NotNull
            public String toString() {
                return "Empty";
            }

            public int hashCode() {
                return 1471770699;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Empty)) {
                    return false;
                }
                Empty cfr_ignored_0 = (Empty)other;
                return true;
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0083\u0004J\n\u0010\b\u001a\u00020\tH\u00d6\u0081\u0004J\n\u0010\n\u001a\u00020\u000bH\u00d6\u0081\u0004\u00a8\u0006\f"}, d2={"Lcom/intellij/vcs/log/ui/frame/VcsLogAsyncChangesTreeModel$SelectionState$Error;", "Lcom/intellij/vcs/log/ui/frame/VcsLogAsyncChangesTreeModel$SelectionState;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.platform.vcs.log.impl"})
        public static final class Error
        implements SelectionState {
            @NotNull
            public static final Error INSTANCE = new Error();

            private Error() {
            }

            @NotNull
            public String toString() {
                return "Error";
            }

            public int hashCode() {
                return 1471921414;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Error)) {
                    return false;
                }
                Error cfr_ignored_0 = (Error)other;
                return true;
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u000f\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0014\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0083\u0004J\n\u0010\u0014\u001a\u00020\u0006H\u00d6\u0081\u0004J\n\u0010\u0015\u001a\u00020\u0016H\u00d6\u0081\u0004R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/intellij/vcs/log/ui/frame/VcsLogAsyncChangesTreeModel$SelectionState$ManyDetails;", "Lcom/intellij/vcs/log/ui/frame/VcsLogAsyncChangesTreeModel$SelectionState;", "details", "", "Lcom/intellij/vcs/log/VcsFullCommitDetails;", "maxDetailsSize", "", "<init>", "(Ljava/util/List;I)V", "getDetails", "()Ljava/util/List;", "getMaxDetailsSize", "()I", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "", "intellij.platform.vcs.log.impl"})
        public static final class ManyDetails
        implements SelectionState {
            @NotNull
            private final List<VcsFullCommitDetails> details;
            private final int maxDetailsSize;

            public ManyDetails(@NotNull List<? extends VcsFullCommitDetails> details, int maxDetailsSize) {
                Intrinsics.checkNotNullParameter(details, (String)"details");
                this.details = details;
                this.maxDetailsSize = maxDetailsSize;
            }

            @NotNull
            public final List<VcsFullCommitDetails> getDetails() {
                return this.details;
            }

            public final int getMaxDetailsSize() {
                return this.maxDetailsSize;
            }

            @NotNull
            public final List<VcsFullCommitDetails> component1() {
                return this.details;
            }

            public final int component2() {
                return this.maxDetailsSize;
            }

            @NotNull
            public final ManyDetails copy(@NotNull List<? extends VcsFullCommitDetails> details, int maxDetailsSize) {
                Intrinsics.checkNotNullParameter(details, (String)"details");
                return new ManyDetails(details, maxDetailsSize);
            }

            public static /* synthetic */ ManyDetails copy$default(ManyDetails manyDetails, List list, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    list = manyDetails.details;
                }
                if ((n2 & 2) != 0) {
                    n = manyDetails.maxDetailsSize;
                }
                return manyDetails.copy(list, n);
            }

            @NotNull
            public String toString() {
                return "ManyDetails(details=" + this.details + ", maxDetailsSize=" + this.maxDetailsSize + ")";
            }

            public int hashCode() {
                int result = ((Object)this.details).hashCode();
                result = result * 31 + Integer.hashCode(this.maxDetailsSize);
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ManyDetails)) {
                    return false;
                }
                ManyDetails manyDetails = (ManyDetails)other;
                if (!Intrinsics.areEqual(this.details, manyDetails.details)) {
                    return false;
                }
                return this.maxDetailsSize == manyDetails.maxDetailsSize;
            }
        }
    }
}

