/*
 * Decompiled with CFR 0.152.
 */
package git4idea.applyChanges;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListData;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.CommitResultHandler;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.vcs.log.VcsCommitMetadata;
import git4idea.applyChanges.GitApplyChangesCommitStrategy;
import git4idea.applyChanges.GitApplyChangesProcess;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a|\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00140\u00132\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00140\u00132\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002\u001a\f\u0010\u0017\u001a\u00020\u0018*\u00020\u000bH\u0002\u001a\u0012\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\u001a*\u00020\u001bH\u0002\u001a\u001a\u0010\u001c\u001a\u00020\u0014*\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0002\u001a*\u0010!\u001a\u00020\u0003*\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "commitChangelist", "", "repository", "Lgit4idea/repo/GitRepository;", "gitApplyChangesProcess", "Lgit4idea/applyChanges/GitApplyChangesProcess;", "changeListManager", "Lcom/intellij/openapi/vcs/changes/ChangeListManagerEx;", "commit", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "commitMessage", "", "changeList", "Lcom/intellij/openapi/vcs/changes/LocalChangeList;", "vcsHelper", "Lcom/intellij/openapi/vcs/AbstractVcsHelper;", "onSuccessfulCommit", "Lkotlin/Function1;", "", "onSkippedCommit", "onCancelledCommit", "toChangeListData", "Lcom/intellij/openapi/vcs/changes/ChangeListData;", "getAllChangesInLogFriendlyPresentation", "", "Lcom/intellij/openapi/vcs/changes/ChangeListManager;", "markDirty", "Lcom/intellij/openapi/project/Project;", "changes", "", "Lcom/intellij/openapi/vcs/changes/Change;", "showCommitDialogAndWaitForCommit", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitApplyChangesCommitStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitApplyChangesCommitStrategy.kt\ngit4idea/applyChanges/GitApplyChangesCommitStrategyKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,206:1\n1586#2:207\n1661#2,3:208\n13#3:211\n*S KotlinDebug\n*F\n+ 1 GitApplyChangesCommitStrategy.kt\ngit4idea/applyChanges/GitApplyChangesCommitStrategyKt\n*L\n150#1:207\n150#1:208,3\n21#1:211\n*E\n"})
public final class GitApplyChangesCommitStrategyKt {
    @NotNull
    private static final Logger LOG;

    private static final boolean commitChangelist(GitRepository repository2, GitApplyChangesProcess gitApplyChangesProcess, ChangeListManagerEx changeListManager, VcsCommitMetadata commit, String commitMessage, LocalChangeList changeList, AbstractVcsHelper vcsHelper, Function1<? super VcsCommitMetadata, Unit> onSuccessfulCommit, Function1<? super VcsCommitMetadata, Unit> onSkippedCommit, Function1<? super VcsCommitMetadata, Unit> onCancelledCommit) {
        LocalChangeList localChangeList = changeListManager.getChangeList(changeList.getId());
        if (localChangeList == null) {
            boolean bl = false;
            LOG.error("Couldn't find the changelist with id " + changeList.getId() + " and name " + changeList.getName() + " among " + GitApplyChangesCommitStrategyKt.getAllChangesInLogFriendlyPresentation((ChangeListManager)changeListManager));
            return false;
        }
        LocalChangeList actualList = localChangeList;
        Collection changes = actualList.getChanges();
        if (changes.isEmpty()) {
            LOG.debug("No changes in the " + actualList + ". All changes in the CLM: " + GitApplyChangesCommitStrategyKt.getAllChangesInLogFriendlyPresentation((ChangeListManager)changeListManager));
            onSkippedCommit.invoke((Object)commit);
            return true;
        }
        LOG.debug("Showing commit dialog for changes: " + changes);
        gitApplyChangesProcess.cleanupBeforeCommit(repository2);
        Intrinsics.checkNotNull((Object)changes);
        boolean committed = GitApplyChangesCommitStrategyKt.showCommitDialogAndWaitForCommit(vcsHelper, changeList, commitMessage, changes);
        if (committed) {
            Project project = repository2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            GitApplyChangesCommitStrategyKt.markDirty(project, changes);
            changeListManager.waitForUpdate();
            onSuccessfulCommit.invoke((Object)commit);
            return true;
        }
        onCancelledCommit.invoke((Object)commit);
        return false;
    }

    private static final ChangeListData toChangeListData(VcsCommitMetadata $this$toChangeListData) {
        return new ChangeListData($this$toChangeListData.getAuthor(), new Date($this$toChangeListData.getAuthorTime()), true);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<String> getAllChangesInLogFriendlyPresentation(ChangeListManager $this$getAllChangesInLogFriendlyPresentation) {
        void $this$mapTo$iv$iv;
        List list = $this$getAllChangesInLogFriendlyPresentation.getChangeLists();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChangeLists(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LocalChangeList localChangeList = (LocalChangeList)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add("[" + it.getName() + "] " + it.getChanges());
        }
        return (List)destination$iv$iv;
    }

    private static final void markDirty(Project $this$markDirty, Collection<? extends Change> changes) {
        VcsDirtyScopeManager.getInstance((Project)$this$markDirty).filePathsDirty((Collection)ChangesUtil.getPaths(changes), null);
    }

    private static final boolean showCommitDialogAndWaitForCommit(AbstractVcsHelper $this$showCommitDialogAndWaitForCommit, LocalChangeList changeList, String commitMessage, Collection<? extends Change> changes) {
        AtomicBoolean commitSucceeded = new AtomicBoolean();
        Semaphore sem = new Semaphore(0);
        Function0 runnable2 = () -> GitApplyChangesCommitStrategyKt.showCommitDialogAndWaitForCommit$lambda$0($this$showCommitDialogAndWaitForCommit, changes, changeList, commitMessage, commitSucceeded, sem);
        ApplicationManager.getApplication().invokeAndWait(() -> GitApplyChangesCommitStrategyKt.showCommitDialogAndWaitForCommit$lambda$1(runnable2), ModalityState.nonModal());
        try {
            sem.acquire();
        }
        catch (InterruptedException e) {
            LOG.error((Throwable)e);
            return false;
        }
        return commitSucceeded.get();
    }

    private static final Unit showCommitDialogAndWaitForCommit$lambda$0(AbstractVcsHelper $this_showCommitDialogAndWaitForCommit, Collection $changes, LocalChangeList $changeList, String $commitMessage, AtomicBoolean $commitSucceeded, Semaphore $sem) {
        try {
            boolean commitNotCancelled2 = $this_showCommitDialogAndWaitForCommit.commitChanges($changes, $changeList, $commitMessage, new CommitResultHandler($commitSucceeded, $sem){
                final /* synthetic */ AtomicBoolean $commitSucceeded;
                final /* synthetic */ Semaphore $sem;
                {
                    this.$commitSucceeded = $commitSucceeded;
                    this.$sem = $sem;
                }

                public void onSuccess(String commitMessage1) {
                    Intrinsics.checkNotNullParameter((Object)commitMessage1, (String)"commitMessage1");
                    this.$commitSucceeded.set(true);
                    this.$sem.release();
                }

                public void onCancel() {
                    this.$commitSucceeded.set(false);
                    this.$sem.release();
                }

                public void onFailure(List<? extends VcsException> errors) {
                    Intrinsics.checkNotNullParameter(errors, (String)"errors");
                    this.$commitSucceeded.set(false);
                    this.$sem.release();
                }
            });
            if (!commitNotCancelled2) {
                $commitSucceeded.set(false);
                $sem.release();
            }
        }
        catch (Throwable t) {
            LOG.error(t);
            $commitSucceeded.set(false);
            $sem.release();
        }
        return Unit.INSTANCE;
    }

    private static final void showCommitDialogAndWaitForCommit$lambda$1(Function0 $tmp0) {
        $tmp0.invoke();
    }

    public static final /* synthetic */ ChangeListData access$toChangeListData(VcsCommitMetadata $receiver) {
        return GitApplyChangesCommitStrategyKt.toChangeListData($receiver);
    }

    public static final /* synthetic */ boolean access$commitChangelist(GitRepository repository2, GitApplyChangesProcess gitApplyChangesProcess, ChangeListManagerEx changeListManager, VcsCommitMetadata commit, String commitMessage, LocalChangeList changeList, AbstractVcsHelper vcsHelper, Function1 onSuccessfulCommit, Function1 onSkippedCommit, Function1 onCancelledCommit) {
        return GitApplyChangesCommitStrategyKt.commitChangelist(repository2, gitApplyChangesProcess, changeListManager, commit, commitMessage, changeList, vcsHelper, (Function1<? super VcsCommitMetadata, Unit>)onSuccessfulCommit, (Function1<? super VcsCommitMetadata, Unit>)onSkippedCommit, (Function1<? super VcsCommitMetadata, Unit>)onCancelledCommit);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GitApplyChangesCommitStrategy.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

