/*
 * Decompiled with CFR 0.152.
 */
package git4idea.checkin;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.vcsUtil.VcsFileUtil;
import git4idea.GitUtil;
import git4idea.changes.GitChangeUtils;
import git4idea.checkin.GitCheckinEnvironment;
import git4idea.checkin.GitStagingAreaStateManager;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.util.GitFileUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u0000 *2\u00020\u0001:\u0001*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u000fH\u0002J\b\u0010\u0014\u001a\u00020\u000fH\u0016Jn\u0010\u0015\u001a\u00020\u000f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\u00112\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\r0\u00112:\u0010\u001b\u001a6\u0012\u0015\u0012\u0013\u0018\u00010\r\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(\u001f\u0012\u0015\u0012\u0013\u0018\u00010\r\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b( \u0012\u0004\u0012\u00020\u000f0\u001cH\u0002J&\u0010!\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\u0017H\u0002J\b\u0010&\u001a\u00020\u000fH\u0002J \u0010'\u001a\u00020(2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010)\u001a\u00020\nH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lgit4idea/checkin/GitResetAddStagingAreaStateManager;", "Lgit4idea/checkin/GitStagingAreaStateManager;", "repository", "Lgit4idea/repo/GitRepository;", "<init>", "(Lgit4idea/repo/GitRepository;)V", "getRepository", "()Lgit4idea/repo/GitRepository;", "excludedStagedChanges", "", "Lgit4idea/checkin/GitCheckinEnvironment$ChangedPath;", "excludedUnstagedDeletions", "", "Lcom/intellij/openapi/vcs/FilePath;", "prepareStagingArea", "", "toAdd", "", "toRemove", "validateNoUnmerged", "restore", "processExcludedPaths", "changes", "", "Lgit4idea/changes/GitChangeUtils$GitDiffChange;", "toCommitAdded", "toCommitRemoved", "function", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "before", "after", "resetExcluded", "project", "Lcom/intellij/openapi/project/Project;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "restoreExcluded", "addAsCaseOnlyRename", "", "change", "Companion", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitResetAddStagingAreaStateManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitResetAddStagingAreaStateManager.kt\ngit4idea/checkin/GitResetAddStagingAreaStateManager\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,169:1\n60#2,5:170\n60#2,5:175\n60#2,5:180\n60#2,5:185\n13#2:190\n*S KotlinDebug\n*F\n+ 1 GitResetAddStagingAreaStateManager.kt\ngit4idea/checkin/GitResetAddStagingAreaStateManager\n*L\n40#1:170,5\n51#1:175,5\n134#1:180,5\n152#1:185,5\n166#1:190\n*E\n"})
public final class GitResetAddStagingAreaStateManager
implements GitStagingAreaStateManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GitRepository repository;
    @NotNull
    private final List<GitCheckinEnvironment.ChangedPath> excludedStagedChanges;
    @NotNull
    private final Set<FilePath> excludedUnstagedDeletions;
    @NotNull
    private static final Logger LOG;

    public GitResetAddStagingAreaStateManager(@NotNull GitRepository repository2) {
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        this.repository = repository2;
        this.excludedStagedChanges = new ArrayList();
        this.excludedUnstagedDeletions = new LinkedHashSet();
    }

    @NotNull
    public final GitRepository getRepository() {
        return this.repository;
    }

    @Override
    public void prepareStagingArea(@NotNull Set<? extends FilePath> toAdd, @NotNull Set<? extends FilePath> toRemove) {
        Logger logger;
        Intrinsics.checkNotNullParameter(toAdd, (String)"toAdd");
        Intrinsics.checkNotNullParameter(toRemove, (String)"toRemove");
        Project project = this.repository.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        VirtualFile virtualFile = this.repository.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
        VirtualFile root = virtualFile;
        String string = root.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String rootPath = string;
        this.validateNoUnmerged();
        Collection<GitChangeUtils.GitDiffChange> collection = GitChangeUtils.getStagedChanges(project2, root);
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getStagedChanges(...)");
        Collection<GitChangeUtils.GitDiffChange> stagedChanges = collection;
        Logger $this$debug_u24default$iv = LOG;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Found staged changes: " + GitUtil.getLogStringGitDiffChanges(rootPath, stagedChanges), t$iv);
        }
        List excludedStagedAdditions = new ArrayList();
        this.processExcludedPaths(stagedChanges, toAdd, toRemove, (Function2<? super FilePath, ? super FilePath, Unit>)((Function2)(arg_0, arg_1) -> GitResetAddStagingAreaStateManager.prepareStagingArea$lambda$1(this, excludedStagedAdditions, arg_0, arg_1)));
        Collection<GitChangeUtils.GitDiffChange> collection2 = GitChangeUtils.getUnstagedChanges(project2, root, excludedStagedAdditions, false);
        Intrinsics.checkNotNullExpressionValue(collection2, (String)"getUnstagedChanges(...)");
        Collection<GitChangeUtils.GitDiffChange> unstagedChanges = collection2;
        Logger $this$debug_u24default$iv2 = LOG;
        Throwable t$iv2 = null;
        boolean $i$f$debug2 = false;
        if ($this$debug_u24default$iv2.isDebugEnabled()) {
            logger = $this$debug_u24default$iv2;
            boolean bl = false;
            logger.debug("Found unstaged changes: " + GitUtil.getLogStringGitDiffChanges(rootPath, unstagedChanges), t$iv2);
        }
        this.processExcludedPaths(unstagedChanges, toAdd, toRemove, (Function2<? super FilePath, ? super FilePath, Unit>)((Function2)(arg_0, arg_1) -> GitResetAddStagingAreaStateManager.prepareStagingArea$lambda$3(this, arg_0, arg_1)));
        if (!((Collection)this.excludedStagedChanges).isEmpty()) {
            LOG.info("Staged changes excluded for commit: " + GitCheckinEnvironment.Companion.getLogString(rootPath, (Collection<? extends GitCheckinEnvironment.ChangedPath>)this.excludedStagedChanges));
            this.resetExcluded(project2, root, (Collection<? extends GitCheckinEnvironment.ChangedPath>)this.excludedStagedChanges);
        }
    }

    private final void validateNoUnmerged() {
        List<FilePath> list = GitChangeUtils.getUnmergedFiles(this.repository);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getUnmergedFiles(...)");
        List<FilePath> unmergedFiles = list;
        if (!((Collection)unmergedFiles).isEmpty()) {
            throw new VcsException(GitBundle.message((String)"error.commit.cant.commit.with.unmerged.paths", (Object[])new Object[0]));
        }
    }

    @Override
    public void restore() {
        if (!((Collection)this.excludedStagedChanges).isEmpty()) {
            this.restoreExcluded();
        }
    }

    private final void processExcludedPaths(Collection<? extends GitChangeUtils.GitDiffChange> changes, Set<? extends FilePath> toCommitAdded, Set<? extends FilePath> toCommitRemoved, Function2<? super FilePath, ? super FilePath, Unit> function) {
        for (GitChangeUtils.GitDiffChange gitDiffChange : changes) {
            FilePath before = gitDiffChange.getBeforePath();
            FilePath after = gitDiffChange.getAfterPath();
            if (CollectionsKt.contains((Iterable)toCommitRemoved, (Object)before)) {
                before = null;
            }
            if (CollectionsKt.contains((Iterable)toCommitAdded, (Object)after)) {
                after = null;
            }
            function.invoke((Object)before, (Object)after);
        }
    }

    private final void resetExcluded(Project project, VirtualFile root, Collection<? extends GitCheckinEnvironment.ChangedPath> changes) throws VcsException {
        Set set = CollectionFactory.createCustomHashingStrategySet((HashingStrategy)ChangesUtil.CASE_SENSITIVE_FILE_PATH_HASHING_STRATEGY);
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createCustomHashingStrategySet(...)");
        Set allPaths = set;
        for (GitCheckinEnvironment.ChangedPath changedPath : changes) {
            ContainerUtil.addIfNotNull((Collection)allPaths, (Object)changedPath.getAfterPath());
            ContainerUtil.addIfNotNull((Collection)allPaths, (Object)changedPath.getBeforePath());
        }
        for (List list : VcsFileUtil.chunkPaths((VirtualFile)root, (Collection)allPaths)) {
            GitLineHandler gitLineHandler;
            GitLineHandler $this$resetExcluded_u24lambda_u240 = gitLineHandler = new GitLineHandler(project, root, GitCommand.RESET);
            boolean bl = false;
            $this$resetExcluded_u24lambda_u240.endOptions();
            $this$resetExcluded_u24lambda_u240.addParameters(list);
            GitLineHandler handler = gitLineHandler;
            Git.getInstance().runCommand(handler).throwOnError(new int[0]);
        }
    }

    private final void restoreExcluded() {
        Project project = this.repository.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        VirtualFile virtualFile = this.repository.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
        VirtualFile root = virtualFile;
        Set toAdd = new LinkedHashSet();
        Set toRemove = new LinkedHashSet();
        for (GitCheckinEnvironment.ChangedPath change : this.excludedStagedChanges) {
            if (this.addAsCaseOnlyRename(project2, root, change)) continue;
            if (change.getBeforePath() == null && CollectionsKt.contains((Iterable)this.excludedUnstagedDeletions, (Object)change.getAfterPath())) {
                LOG.info("Ignored added-deleted staged change in " + change.getAfterPath());
                continue;
            }
            ContainerUtil.addIfNotNull((Collection)toAdd, (Object)change.getAfterPath());
            ContainerUtil.addIfNotNull((Collection)toRemove, (Object)change.getBeforePath());
        }
        toRemove.removeAll(toAdd);
        Logger $this$debug_u24default$iv = LOG;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Restoring staged changes after commit: added: " + toAdd + ", removed: " + toRemove, t$iv);
        }
        List exceptions = new ArrayList();
        GitFileUtils.stageForCommit(project2, root, toAdd, toRemove, exceptions);
        for (VcsException e : exceptions) {
            LOG.warn((Throwable)e);
        }
    }

    private final boolean addAsCaseOnlyRename(Project project, VirtualFile root, GitCheckinEnvironment.ChangedPath change) {
        try {
            GitLineHandler gitLineHandler;
            if (!GitCheckinEnvironment.Companion.isCaseOnlyRename(change)) {
                return false;
            }
            FilePath filePath = change.getBeforePath();
            Intrinsics.checkNotNull((Object)filePath);
            FilePath beforePath = filePath;
            FilePath filePath2 = change.getAfterPath();
            Intrinsics.checkNotNull((Object)filePath2);
            FilePath afterPath = filePath2;
            Logger $this$debug_u24default$iv = LOG;
            Throwable t$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Restoring staged case-only rename after commit: " + change, t$iv);
            }
            GitLineHandler $this$addAsCaseOnlyRename_u24lambda_u241 = gitLineHandler = new GitLineHandler(project, root, GitCommand.MV);
            boolean bl = false;
            String[] stringArray = new String[]{"-f", beforePath.getPath(), afterPath.getPath()};
            $this$addAsCaseOnlyRename_u24lambda_u241.addParameters(stringArray);
            GitLineHandler h = gitLineHandler;
            Git.getInstance().runCommandWithoutCollectingOutput(h).throwOnError(new int[0]);
            return true;
        }
        catch (VcsException e) {
            LOG.warn((Throwable)e);
            return false;
        }
    }

    private static final Unit prepareStagingArea$lambda$1(GitResetAddStagingAreaStateManager this$0, List $excludedStagedAdditions, FilePath before, FilePath after) {
        if (before != null || after != null) {
            this$0.excludedStagedChanges.add(new GitCheckinEnvironment.ChangedPath(before, after));
        }
        if (before == null && after != null) {
            $excludedStagedAdditions.add(after);
        }
        return Unit.INSTANCE;
    }

    private static final Unit prepareStagingArea$lambda$3(GitResetAddStagingAreaStateManager this$0, FilePath before, FilePath after) {
        if (before != null && after == null) {
            this$0.excludedUnstagedDeletions.add(before);
        }
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GitResetAddStagingAreaStateManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lgit4idea/checkin/GitResetAddStagingAreaStateManager$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

