/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.dockerFile.quoteHandler;

import com.intellij.codeInsight.editorActions.SimpleTokenSetQuoteHandler;
import com.intellij.docker.dockerFile.lexer.DockerTokenTypes;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.tree.IElementType;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\r\n\u0000\n\u0002\u0010\f\n\u0002\b\u0003\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0013\u0010\u000f\u001a\u00020\u0005*\u0004\u0018\u00010\u0010H\u0002\u00a2\u0006\u0002\u0010\u0011\u00a8\u0006\u0013"}, d2={"Lcom/intellij/docker/dockerFile/quoteHandler/DockerQuoteHandler;", "Lcom/intellij/codeInsight/editorActions/SimpleTokenSetQuoteHandler;", "<init>", "()V", "isClosingQuote", "", "iterator", "Lcom/intellij/openapi/editor/highlighter/HighlighterIterator;", "offset", "", "isOpeningQuote", "isEmptyDoubleQuotes", "start", "charSequence", "", "isQuote", "", "(Ljava/lang/Character;)Z", "Companion", "intellij.clouds.docker.file"})
public final class DockerQuoteHandler
extends SimpleTokenSetQuoteHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Set<Character> allowedPrevSymbolsForOpeningQuote;

    public DockerQuoteHandler() {
        IElementType[] iElementTypeArray = new IElementType[]{DockerTokenTypes.QUOTE};
        super(iElementTypeArray);
    }

    public boolean isClosingQuote(@NotNull HighlighterIterator iterator, int offset) {
        Intrinsics.checkNotNullParameter((Object)iterator, (String)"iterator");
        int start2 = iterator.getStart();
        CharSequence charSequence = iterator.getDocument().getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
        CharSequence charSequence2 = charSequence;
        return super.isClosingQuote(iterator, offset) && !this.isEmptyDoubleQuotes(start2, charSequence2);
    }

    public boolean isOpeningQuote(@NotNull HighlighterIterator iterator, int offset) {
        Intrinsics.checkNotNullParameter((Object)iterator, (String)"iterator");
        CharSequence charSequence = iterator.getDocument().getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
        CharSequence charSequence2 = charSequence;
        int start2 = iterator.getStart();
        return super.isOpeningQuote(iterator, offset) && allowedPrevSymbolsForOpeningQuote.contains(StringsKt.getOrNull((CharSequence)charSequence2, (int)(start2 - 1)));
    }

    private final boolean isEmptyDoubleQuotes(int start2, CharSequence charSequence) {
        return this.isQuote(StringsKt.getOrNull((CharSequence)charSequence, (int)start2)) && this.isQuote(StringsKt.getOrNull((CharSequence)charSequence, (int)(start2 + 1)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isQuote(Character $this$isQuote) {
        Character c = $this$isQuote;
        char c2 = '\"';
        if (c != null) {
            if (c.charValue() == c2) return true;
        }
        Character c3 = $this$isQuote;
        c2 = '\'';
        if (c3 == null) return false;
        if (c3.charValue() != c2) return false;
        return true;
    }

    static {
        Object[] objectArray = new Character[]{null, Character.valueOf(' '), Character.valueOf('{'), Character.valueOf('['), Character.valueOf('='), Character.valueOf(','), Character.valueOf(':')};
        allowedPrevSymbolsForOpeningQuote = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\f\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/docker/dockerFile/quoteHandler/DockerQuoteHandler$Companion;", "", "<init>", "()V", "allowedPrevSymbolsForOpeningQuote", "", "", "intellij.clouds.docker.file"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

