/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ktor.actions.test.route;

import com.intellij.buildsystem.model.DeclaredDependency;
import com.intellij.buildsystem.model.unified.UnifiedCoordinates;
import com.intellij.buildsystem.model.unified.UnifiedDependency;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.actions.OptimizeImportsProcessor;
import com.intellij.codeInsight.actions.ReformatCodeProcessor;
import com.intellij.externalSystem.DependencyModifierService;
import com.intellij.ide.fileTemplates.FileTemplateDescriptor;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.java.JavaBundle;
import com.intellij.ktor.KtorFusCollectors;
import com.intellij.ktor.KtorLibraryUtilKt;
import com.intellij.ktor.KtorStarterBundle;
import com.intellij.ktor.KtorStarterIcons;
import com.intellij.ktor.KtorUrlMapping;
import com.intellij.ktor.KtorUtilsKt;
import com.intellij.ktor.RequestMethod;
import com.intellij.ktor.actions.test.KtorMultiRouteTestDialog;
import com.intellij.ktor.actions.test.KtorMultiRouteTestGenerator;
import com.intellij.ktor.actions.test.KtorTestFramework;
import com.intellij.ktor.actions.test.TestActionsUtils;
import com.intellij.ktor.actions.test.route.GenerateRouteTestAction;
import com.intellij.ktor.actions.test.route.KtorRouteTestDialog;
import com.intellij.ktor.fus.test.TestGenerationSource;
import com.intellij.ktor.fus.test.TestGenerationTarget;
import com.intellij.ktor.updates.migration.step.UpdateDependenciesKt;
import com.intellij.ktor.utils.KtorVersionModel;
import com.intellij.lang.Language;
import com.intellij.microservices.url.UrlConstants;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.UrlResolveRequest;
import com.intellij.microservices.url.inlay.UrlPathInlayAction;
import com.intellij.microservices.url.inlay.UrlPathInlayHint;
import com.intellij.microservices.url.references.UrlPathContext;
import com.intellij.microservices.utils.MicroservicesUsageCollector;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.externalSystem.autoimport.ProjectRefreshAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JVMElementFactories;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.testIntegration.TestFramework;
import com.intellij.testIntegration.TestIntegrationUtils;
import com.intellij.testIntegration.createTest.CreateTestAction;
import com.intellij.testIntegration.createTest.CreateTestUtils;
import com.intellij.util.IncorrectOperationException;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.facet.KotlinFacetUtils;
import org.jetbrains.kotlin.idea.base.util.GenericPsiUtils;
import org.jetbrains.kotlin.idea.base.util.ProjectStructureUtils;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\b \u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH&J0\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\t2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H&J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J(\u0010%\u001a\u00020&2\u0006\u0010!\u001a\u00020\"2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0016J\u001d\u0010-\u001a\u00020&2\u0006\u0010.\u001a\u00020/2\u0006\u0010)\u001a\u00020*H\u0000\u00a2\u0006\u0002\b0J\u0016\u00101\u001a\b\u0012\u0004\u0012\u00020\t0\u000f2\u0006\u0010)\u001a\u00020*H\u0002J \u00102\u001a\u00020&2\u0006\u0010.\u001a\u00020/2\u0006\u00103\u001a\u0002042\u0006\u0010)\u001a\u00020*H\u0002J*\u00105\u001a\u00020 2\u0006\u0010.\u001a\u00020/2\u0006\u00103\u001a\u0002042\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u00106\u001a\u000207H\u0002J0\u00108\u001a\u0002092\u0006\u0010.\u001a\u00020/2\u0006\u00103\u001a\u0002042\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\f\u0010:\u001a\b\u0012\u0004\u0012\u0002070\u000fH\u0002J`\u0010;\u001a\u00020 2\u0006\u0010<\u001a\u00020\t2\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@2\u0006\u00103\u001a\u0002042\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020\t2\u0006\u0010D\u001a\u00020\t2\u0006\u0010E\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010F\u001a\u00020\t2\u0006\u0010G\u001a\u00020 H\u0002J\u0018\u0010H\u001a\u00020&2\u0006\u00103\u001a\u0002042\u0006\u0010I\u001a\u000209H\u0002J \u0010J\u001a\u00020 2\u0006\u0010K\u001a\u00020\t2\u0006\u0010L\u001a\u00020M2\u0006\u0010'\u001a\u00020(H\u0002JM\u0010N\u001a\u00020 2\u0006\u0010<\u001a\u00020\t2\u0006\u0010C\u001a\u00020\t2\u0006\u00103\u001a\u0002042\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010F\u001a\u00020\t2\u0006\u0010D\u001a\u00020\t2\u0006\u0010O\u001a\u00020\t2\u0006\u0010G\u001a\u00020 H\u0000\u00a2\u0006\u0002\bPR\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006Q"}, d2={"Lcom/intellij/ktor/actions/test/route/GenerateRouteTestAction;", "Lcom/intellij/microservices/url/inlay/UrlPathInlayAction;", "<init>", "()V", "createTestDialog", "Lcom/intellij/ktor/actions/test/route/KtorRouteTestDialog;", "project", "Lcom/intellij/openapi/project/Project;", "route", "", "methodName", "createMultiRouteTestDialog", "Lcom/intellij/ktor/actions/test/KtorMultiRouteTestDialog;", "moduleName", "mappings", "", "Lcom/intellij/ktor/KtorUrlMapping;", "srcPackage", "Lcom/intellij/psi/PsiPackage;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "name", "getName", "()Ljava/lang/String;", "CREATE_KTOR_TEST_IN_THE_SAME_ROOT", "TODO_BODY", "KTOR_DEPENDENCY_STRING", "KTOR_DEPENDENCY_STRING_200", "KOTLIN_DEPENDENCY_STRING", "isAvailable", "", "file", "Lcom/intellij/psi/PsiFile;", "urlPathInlayHint", "Lcom/intellij/microservices/url/inlay/UrlPathInlayHint;", "actionPerformed", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "urlPathContext", "Lcom/intellij/microservices/url/references/UrlPathContext;", "mouseEvent", "Ljava/awt/event/MouseEvent;", "invoke", "element", "Lcom/intellij/psi/PsiElement;", "invoke$intellij_ktor", "getMethods", "generateTestFromUrlPathContext", "module", "Lcom/intellij/openapi/module/Module;", "generateSingleTest", "request", "Lcom/intellij/microservices/url/UrlResolveRequest;", "generateMultipleTests", "", "requests", "generateTest", "testClassName", "fileTemplateDescriptor", "Lcom/intellij/ide/fileTemplates/FileTemplateDescriptor;", "targetDirectory", "Lcom/intellij/psi/PsiDirectory;", "framework", "Lcom/intellij/testIntegration/TestFramework;", "testName", "requestPath", "requestMethodName", "dstPackage", "optimizeImports", "installTestDependenciesIfAbsent", "ktorMajorVersion", "generateMethod", "templateText", "targetClass", "Lorg/jetbrains/uast/UClass;", "generateTestForRoute", "requestMethod", "generateTestForRoute$intellij_ktor", "intellij.ktor"})
@SourceDebugExtension(value={"SMAP\nGenerateRouteTestAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenerateRouteTestAction.kt\ncom/intellij/ktor/actions/test/route/GenerateRouteTestAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 UastContext.kt\norg/jetbrains/uast/UastContextKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,400:1\n1786#2,3:401\n1696#2,8:404\n1642#2,10:412\n1915#2:422\n1916#2:424\n1652#2:425\n1586#2:433\n1661#2,3:434\n832#2:437\n862#2,2:438\n2802#2:440\n1#3:423\n1#3:427\n1#3:441\n1#3:443\n207#4:426\n207#4:428\n207#4:442\n207#4:444\n11705#5:429\n12052#5,3:430\n*S KotlinDebug\n*F\n+ 1 GenerateRouteTestAction.kt\ncom/intellij/ktor/actions/test/route/GenerateRouteTestAction\n*L\n107#1:401,3\n145#1:404,8\n216#1:412,10\n216#1:422\n216#1:424\n216#1:425\n321#1:433\n321#1:434,3\n329#1:437\n329#1:438,2\n330#1:440\n216#1:423\n330#1:441\n226#1:426\n227#1:428\n179#1:442\n180#1:444\n265#1:429\n265#1:430,3\n*E\n"})
public abstract class GenerateRouteTestAction
implements UrlPathInlayAction {
    @NotNull
    private final String CREATE_KTOR_TEST_IN_THE_SAME_ROOT;
    @NotNull
    private final String TODO_BODY;
    @NotNull
    private final String KTOR_DEPENDENCY_STRING;
    @NotNull
    private final String KTOR_DEPENDENCY_STRING_200;
    @NotNull
    private final String KOTLIN_DEPENDENCY_STRING;

    public GenerateRouteTestAction() {
        this.CREATE_KTOR_TEST_IN_THE_SAME_ROOT = "create.ktor.test.in.the.same.root";
        this.TODO_BODY = "TODO(\"Please write your test here\")";
        this.KTOR_DEPENDENCY_STRING = "io.ktor:ktor-server-test-host";
        this.KTOR_DEPENDENCY_STRING_200 = "io.ktor:ktor-server-test-host-jvm";
        this.KOTLIN_DEPENDENCY_STRING = "org.jetbrains.kotlin:kotlin-test-junit";
    }

    @NotNull
    public abstract KtorRouteTestDialog createTestDialog(@NotNull Project var1, @NotNull String var2, @NotNull String var3);

    @NotNull
    public abstract KtorMultiRouteTestDialog createMultiRouteTestDialog(@NotNull Project var1, @NotNull String var2, @NotNull List<KtorUrlMapping> var3, @Nullable PsiPackage var4);

    @NotNull
    public Icon getIcon() {
        Icon icon = KtorStarterIcons.Ktor;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Ktor");
        return icon;
    }

    @NotNull
    public String getName() {
        return KtorStarterBundle.INSTANCE.message("ktor.generate.route.test.action", new Object[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAvailable(@NotNull PsiFile file, @NotNull UrlPathInlayHint urlPathInlayHint) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)urlPathInlayHint, (String)"urlPathInlayHint");
        UrlPathContext urlPathContext = urlPathInlayHint.getContext();
        List schemes = urlPathContext.getSchemes();
        if (((Collection)schemes).isEmpty()) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        Iterable $this$all$iv = schemes;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            bl = true;
        } else {
            for (Object element$iv : $this$all$iv) {
                String it = (String)element$iv;
                boolean bl3 = false;
                if (!UrlConstants.HTTP_SCHEMES.contains(it)) {
                    if (!UrlConstants.WS_SCHEMES.contains(it)) return false;
                }
                boolean bl4 = true;
                if (bl4) continue;
                return false;
            }
            bl = true;
        }
        if (!bl) return false;
        boolean bl5 = true;
        boolean hasValidScheme = bl5;
        if (!hasValidScheme) return false;
        if (!KtorLibraryUtilKt.hasKtorServerLibrary(GenericPsiUtils.getModule((PsiElement)((PsiElement)file)))) return false;
        return true;
    }

    public void actionPerformed(@NotNull PsiFile file, @NotNull Editor editor2, @NotNull UrlPathContext urlPathContext, @NotNull MouseEvent mouseEvent) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)urlPathContext, (String)"urlPathContext");
        Intrinsics.checkNotNullParameter((Object)mouseEvent, (String)"mouseEvent");
        PsiElement psiElement = file.findElementAt(editor2.getCaretModel().getOffset());
        if (psiElement == null) {
            return;
        }
        PsiElement element = psiElement;
        MicroservicesUsageCollector.INSTANCE.getURL_INLAY_ACTION_TRIGGERED_EVENT().log(file.getProject(), (Object)"generate_test");
        this.invoke$intellij_ktor(element, urlPathContext);
    }

    public final void invoke$intellij_ktor(@NotNull PsiElement element, @NotNull UrlPathContext urlPathContext) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)urlPathContext, (String)"urlPathContext");
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return;
        }
        Module module2 = module;
        this.generateTestFromUrlPathContext(element, module2, urlPathContext);
    }

    private final List<String> getMethods(UrlPathContext urlPathContext) {
        return urlPathContext.getMethods();
    }

    private final void generateTestFromUrlPathContext(PsiElement element, Module module, UrlPathContext urlPathContext) {
        boolean isTestGenerationSuccessful;
        PsiDirectory srcDir = element.getContainingFile().getContainingDirectory();
        PsiPackage srcPackage = JavaDirectoryService.getInstance().getPackage(srcDir);
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)module.getProject());
        Module module2 = CreateTestAction.suggestModuleForTests((Project)module.getProject(), (Module)module);
        Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"suggestModuleForTests(...)");
        Module testModule = module2;
        List testRootUrls = CreateTestUtils.computeTestRoots((Module)testModule);
        if (testRootUrls.isEmpty() && CreateTestUtils.computeSuitableTestRootUrls((Module)testModule).isEmpty() && !propertiesComponent.getBoolean(this.CREATE_KTOR_TEST_IN_THE_SAME_ROOT)) {
            if (Messages.showOkCancelDialog((Project)module.getProject(), (String)JavaBundle.message((String)"dialog.message.create.test.in.the.same.source.root", (Object[])new Object[0]), (String)JavaBundle.message((String)"dialog.title.no.test.roots.found", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) != 0) {
                return;
            }
            propertiesComponent.setValue(this.CREATE_KTOR_TEST_IN_THE_SAME_ROOT, true);
        }
        Iterable $this$distinctBy$iv = urlPathContext.getResolveRequests();
        boolean $i$f$distinctBy = false;
        HashSet<Pair> set$iv = new HashSet<Pair>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            UrlResolveRequest it = (UrlResolveRequest)e$iv;
            boolean bl = false;
            Pair key$iv = new Pair((Object)it.getMethod(), (Object)it.getPath());
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        List requests = list$iv;
        boolean bl = requests.size() == 1 ? this.generateSingleTest(element, module, srcPackage, (UrlResolveRequest)CollectionsKt.single((List)requests)) : (isTestGenerationSuccessful = this.generateMultipleTests(element, module, srcPackage, requests) != 0);
        if (isTestGenerationSuccessful) {
            KtorFusCollectors.INSTANCE.getKTOR_FUS_EVENT_TEST_GENERATED$intellij_ktor().log((Object)TestGenerationSource.ACTION, (Object)TestGenerationTarget.ROUTE);
        }
    }

    private final boolean generateSingleTest(PsiElement element, Module module, PsiPackage srcPackage, UrlResolveRequest request) {
        String string = request.getMethod();
        if (string == null) {
            return false;
        }
        String method = string;
        char c = method.charAt(0);
        String string2 = StringsKt.drop((String)method, (int)1);
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        string2 = string3;
        String methodName = c + string2;
        String route = KtorUtilsKt.getFullPresentation(request.getPath());
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtorRouteTestDialog dialog = this.createTestDialog(project, route, methodName);
        if (!dialog.showAndGet()) {
            return false;
        }
        Project project2 = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        Project project3 = project2;
        Ref.BooleanRef testIsGenerated = new Ref.BooleanRef();
        CommandProcessor.getInstance().executeCommand(project3, () -> GenerateRouteTestAction.generateSingleTest$lambda$0(dialog, element, srcPackage, testIsGenerated, this, module, request), CodeInsightBundle.message((String)"intention.create.test", (Object[])new Object[0]), (Object)this);
        return testIsGenerated.element;
    }

    /*
     * WARNING - void declaration
     */
    private final int generateMultipleTests(PsiElement element, Module module, PsiPackage srcPackage, List<UrlResolveRequest> requests) {
        Object object;
        List<KtorUrlMapping> mappings;
        KtorMultiRouteTestGenerator multiRouteGenerator2;
        block7: {
            block6: {
                void $this$mapNotNullTo$iv$iv;
                multiRouteGenerator2 = new KtorMultiRouteTestGenerator(this){
                    final /* synthetic */ GenerateRouteTestAction this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    protected GenerateRouteTestAction getRouteAction() {
                        return this.this$0;
                    }

                    public KtorMultiRouteTestDialog createDialog(Project project, String moduleName, List<KtorUrlMapping> mappings, PsiPackage srcPackage) {
                        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
                        Intrinsics.checkNotNullParameter(mappings, (String)"mappings");
                        return this.this$0.createMultiRouteTestDialog(project, moduleName, mappings, srcPackage);
                    }
                };
                Iterable $this$mapNotNull$iv = requests;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    KtorUrlMapping ktorUrlMapping;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    UrlResolveRequest it = (UrlResolveRequest)element$iv$iv;
                    boolean bl2 = false;
                    if (RequestMethod.Companion.of(it.getMethod()) == null) {
                        ktorUrlMapping = null;
                    } else {
                        RequestMethod requestMethod;
                        UrlPath urlPath = it.getPath();
                        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.createPointer((PsiElement)element);
                        ktorUrlMapping = new KtorUrlMapping(urlPath, requestMethod, null, null, null, smartPsiElementPointer, 28, null);
                    }
                    if (ktorUrlMapping == null) continue;
                    KtorUrlMapping it$iv$iv = ktorUrlMapping;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                mappings = KtorUtilsKt.uniqueAndSorted((List)destination$iv$iv);
                PsiElement $this$getUastParentOfType_u24default$iv = element;
                boolean strict$iv = false;
                boolean $i$f$getUastParentOfType = false;
                object = (UClass)UastContextKt.getUastParentOfType((PsiElement)$this$getUastParentOfType_u24default$iv, UClass.class, (boolean)strict$iv);
                if (object == null || (object = object.getQualifiedName()) == null) break block6;
                Object p0 = object;
                boolean bl = false;
                String string = StringUtil.getShortName((String)p0);
                object = string;
                if (string != null) break block7;
            }
            PsiElement $this$getUastParentOfType_u24default$iv = element;
            boolean strict$iv = false;
            boolean $i$f$getUastParentOfType = false;
            UElement uElement = UastContextKt.getUastParentOfType((PsiElement)$this$getUastParentOfType_u24default$iv, UFile.class, (boolean)strict$iv);
            Intrinsics.checkNotNull((Object)uElement);
            String string = ((UFile)uElement).getSourcePsi().getVirtualFile().getNameWithoutExtension();
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNameWithoutExtension(...)");
        }
        Object className = object;
        Ref.IntRef generatedTestsCount = new Ref.IntRef();
        CommandProcessor.getInstance().executeCommand(module.getProject(), () -> GenerateRouteTestAction.generateMultipleTests$lambda$1(generatedTestsCount, multiRouteGenerator2, module, mappings, (String)className, srcPackage), CodeInsightBundle.message((String)"intention.create.test", (Object[])new Object[0]), (Object)this);
        return generatedTestsCount.element;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean generateTest(String testClassName, FileTemplateDescriptor fileTemplateDescriptor, PsiDirectory targetDirectory, Module module, TestFramework framework, String testName, String requestPath, String requestMethodName, String srcPackage, String dstPackage, boolean optimizeImports) {
        UMethod[] uMethodArray;
        void $this$mapTo$iv$iv;
        KtorVersionModel ktorVersionModel = KtorLibraryUtilKt.getKtorServerVersion(module);
        int ktorMajorVersion = ktorVersionModel != null ? ktorVersionModel.getMajor() : 1;
        UClass uClass = TestActionsUtils.Companion.createTestClassFromCodeTemplate(testClassName, fileTemplateDescriptor, targetDirectory, srcPackage, dstPackage, ktorMajorVersion);
        if (uClass == null) {
            return false;
        }
        UClass targetClass = uClass;
        PsiFile psiFile = targetClass.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        PsiFile file = psiFile;
        Editor editor2 = CodeInsightUtil.positionCursorAtLBrace((Project)module.getProject(), (PsiFile)file, (PsiClass)((PsiClass)targetClass));
        UMethod[] $this$map$iv = targetClass.getMethods();
        boolean $i$f$map = false;
        UMethod[] uMethodArray2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var25_30 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        HashSet existingNames = CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv));
        Object methodName = testName;
        int idx = 0;
        while (existingNames.contains(methodName)) {
            methodName = testName + idx++;
        }
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        String templateText = TestActionsUtils.Companion.createTestMethodText(framework, project, (String)methodName, requestPath, requestMethodName, ktorMajorVersion);
        JVMElementFactory elementFactory = JVMElementFactories.getFactory((Language)targetClass.getLanguage(), (Project)targetClass.getProject());
        try {
            Object object = elementFactory;
            if (object == null || (object = object.createMethodFromText(templateText, (PsiElement)targetClass)) == null || (object = object.getName()) == null) {
                object = "";
            }
            uMethodArray = object;
        }
        catch (IncorrectOperationException e) {
            uMethodArray = "";
        }
        UMethod[] prefix = uMethodArray;
        for (UMethod existingMethod : targetClass.getMethods()) {
            existingNames.add(StringUtil.decapitalize((String)StringUtil.trimStart((String)existingMethod.getName(), (String)prefix)));
        }
        Intrinsics.checkNotNull((Object)editor2);
        if (!this.generateMethod(templateText, targetClass, editor2)) {
            return false;
        }
        String string = editor2.getDocument().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        int bodyIndex = StringsKt.lastIndexOf$default((CharSequence)string, (String)this.TODO_BODY, (int)0, (boolean)false, (int)6, null);
        if (bodyIndex == -1) {
            return false;
        }
        editor2.getCaretModel().getCurrentCaret().moveToOffset(bodyIndex);
        editor2.getCaretModel().getCurrentCaret().setSelection(bodyIndex, bodyIndex + this.TODO_BODY.length());
        editor2.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        this.installTestDependenciesIfAbsent(module, ktorMajorVersion);
        if (optimizeImports) {
            new OptimizeImportsProcessor(module.getProject(), file).run();
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final void installTestDependenciesIfAbsent(Module module, int ktorMajorVersion) {
        void $this$onEach$iv;
        void var10_11;
        UnifiedCoordinates it;
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv;
        String string;
        Iterable $this$mapTo$iv$iv;
        UnifiedCoordinates unifiedCoordinates;
        Object dependencyString;
        if (KotlinFacetUtils.isMultiPlatformModule((Module)module)) {
            return;
        }
        KtorVersionModel ktorVersionModel = KtorLibraryUtilKt.getKtorServerVersion(module);
        if (ktorVersionModel != null) {
            KtorVersionModel it2 = ktorVersionModel;
            boolean bl = false;
            dependencyString = ktorMajorVersion >= 2 ? this.KTOR_DEPENDENCY_STRING_200 : this.KTOR_DEPENDENCY_STRING;
            unifiedCoordinates = UpdateDependenciesKt.stringToDep((String)dependencyString, it2.toString());
        } else {
            unifiedCoordinates = null;
        }
        List testDependencies = CollectionsKt.listOfNotNull(unifiedCoordinates);
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        DependencyModifierService dependencyService = DependencyModifierService.Companion.getInstance(project);
        Iterable $this$map$iv = dependencyService.declaredDependencies(module);
        boolean $i$f$map = false;
        dependencyString = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it3;
            DeclaredDependency declaredDependency = (DeclaredDependency)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(UpdateDependenciesKt.depToString(it3.getCoordinates()));
        }
        List declaredDependencies = (List)destination$iv$iv;
        if (ProjectStructureUtils.isGradleModule((Module)module)) {
            string = "testImplementation";
        } else if (ProjectStructureUtils.isMavenModule((Module)module)) {
            string = "test";
        } else {
            return;
        }
        String scope = string;
        $this$mapTo$iv$iv = testDependencies;
        boolean $i$f$filterNot = false;
        void $i$f$mapTo22 = $this$filterNot$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (UnifiedCoordinates)element$iv$iv;
            boolean bl = false;
            if (declaredDependencies.contains(UpdateDependenciesKt.depToString(it))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv2;
        boolean $i$f$onEach = false;
        void $this$onEach_u24lambda_u240$iv = var10_11 = $this$onEach$iv;
        boolean bl = false;
        for (Object element$iv : $this$onEach_u24lambda_u240$iv) {
            it = (UnifiedCoordinates)element$iv;
            boolean bl2 = false;
            dependencyService.addDependency(module, new UnifiedDependency(it, scope));
        }
        boolean anyDependenciesInstalled = CollectionsKt.any((Iterable)var10_11);
        if (anyDependenciesInstalled) {
            Project project2 = module.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            ProjectRefreshAction.Manager.INSTANCE.refreshProject(project2);
        }
    }

    private final boolean generateMethod(String templateText, UClass targetClass, Editor editor2) {
        PsiElement psiElement = targetClass.getSourcePsi();
        if (psiElement == null) {
            return false;
        }
        PsiElement psiTargetClass = psiElement;
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)psiTargetClass.getProject());
        int endPosition = PsiTreeUtilKt.getEndOffset((PsiElement)psiTargetClass) - 1;
        editor2.getDocument().insertString(endPosition, (CharSequence)templateText);
        documentManager.commitDocument(editor2.getDocument());
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)psiTargetClass.getProject());
        PsiElement psiElement2 = (PsiElement)psiTargetClass.getContainingFile();
        PsiFile psiFile = psiTargetClass.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        int n = PsiTreeUtilKt.getStartOffset((PsiElement)((PsiElement)psiFile));
        PsiFile psiFile2 = psiTargetClass.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"getContainingFile(...)");
        codeStyleManager.reformatRange(psiElement2, n, PsiTreeUtilKt.getEndOffset((PsiElement)((PsiElement)psiFile2)));
        new ReformatCodeProcessor(psiTargetClass.getContainingFile(), false).run();
        return true;
    }

    public final boolean generateTestForRoute$intellij_ktor(@NotNull String testClassName, @NotNull String testName, @NotNull Module module, @NotNull String srcPackage, @NotNull String dstPackage, @NotNull String requestPath, @NotNull String requestMethod, boolean optimizeImports) {
        Intrinsics.checkNotNullParameter((Object)testClassName, (String)"testClassName");
        Intrinsics.checkNotNullParameter((Object)testName, (String)"testName");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)srcPackage, (String)"srcPackage");
        Intrinsics.checkNotNullParameter((Object)dstPackage, (String)"dstPackage");
        Intrinsics.checkNotNullParameter((Object)requestPath, (String)"requestPath");
        Intrinsics.checkNotNullParameter((Object)requestMethod, (String)"requestMethod");
        KtorTestFramework.Protocol protocol = Intrinsics.areEqual((Object)requestMethod, (Object)"WEBSOCKET") ? KtorTestFramework.Protocol.WEB_SOCKET : KtorTestFramework.Protocol.HTTP;
        KtorVersionModel ktorVersionModel = KtorLibraryUtilKt.getKtorServerVersion(module);
        int ktorMajorVersion = ktorVersionModel != null ? ktorVersionModel.getMajor() : 1;
        KtorTestFramework framework = new KtorTestFramework(protocol, ktorMajorVersion);
        PsiDirectory psiDirectory = CreateTestUtils.selectTargetDirectory((String)dstPackage, (Project)module.getProject(), (Module)module);
        if (psiDirectory == null) {
            return false;
        }
        PsiDirectory targetDirectory = psiDirectory;
        FileTemplateDescriptor fileTemplateDescriptor = TestIntegrationUtils.MethodKind.TEST_CLASS.getFileTemplateDescriptor((TestFramework)framework);
        Ref.BooleanRef isGenerated = new Ref.BooleanRef();
        PostprocessReformattingAspect.getInstance((Project)module.getProject()).postponeFormattingInside(() -> GenerateRouteTestAction.generateTestForRoute$lambda$0(isGenerated, this, testClassName, fileTemplateDescriptor, targetDirectory, module, framework, testName, requestPath, requestMethod, srcPackage, dstPackage, optimizeImports));
        return isGenerated.element;
    }

    private static final void generateSingleTest$lambda$0(KtorRouteTestDialog $dialog, PsiElement $element, PsiPackage $srcPackage, Ref.BooleanRef $testIsGenerated, GenerateRouteTestAction this$0, Module $module, UrlResolveRequest $request) {
        Object object;
        Object testName;
        block6: {
            block5: {
                CharSequence charSequence = $dialog.getTestName();
                testName = new Regex("[a-zA-Z]([a-zA-Z0-9_])*").matches(charSequence) ? $dialog.getTestName() : "`" + $dialog.getTestName() + "`";
                PsiElement $this$getUastParentOfType_u24default$iv = $element;
                boolean strict$iv = false;
                boolean $i$f$getUastParentOfType = false;
                object = (UClass)UastContextKt.getUastParentOfType((PsiElement)$this$getUastParentOfType_u24default$iv, UClass.class, (boolean)strict$iv);
                if (object == null || (object = object.getQualifiedName()) == null) break block5;
                Object p0 = object;
                boolean bl = false;
                String string = StringUtil.getShortName((String)p0);
                object = string;
                if (string != null) break block6;
            }
            PsiElement $this$getUastParentOfType_u24default$iv = $element;
            boolean strict$iv = false;
            boolean $i$f$getUastParentOfType = false;
            UElement uElement = UastContextKt.getUastParentOfType((PsiElement)$this$getUastParentOfType_u24default$iv, UFile.class, (boolean)strict$iv);
            Intrinsics.checkNotNull((Object)uElement);
            String string = ((UFile)uElement).getSourcePsi().getVirtualFile().getNameWithoutExtension();
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNameWithoutExtension(...)");
        }
        Object className = object;
        String testClassName = (String)className + "Test";
        Object object2 = $srcPackage;
        if (object2 == null || (object2 = object2.getQualifiedName()) == null) {
            object2 = "";
        }
        Object srcPkg = object2;
        String string = KtorUtilsKt.getFullPresentation($request.getPath());
        String string2 = $request.getMethod();
        if (string2 == null) {
            string2 = "GET";
        }
        $testIsGenerated.element = this$0.generateTestForRoute$intellij_ktor(testClassName, (String)testName, $module, (String)srcPkg, (String)srcPkg, string, string2, true);
    }

    private static final void generateMultipleTests$lambda$1(Ref.IntRef $generatedTestsCount, generateMultipleTests.multiRouteGenerator.1 $multiRouteGenerator, Module $module, List $mappings, String $className, PsiPackage $srcPackage) {
        $generatedTestsCount.element = $multiRouteGenerator.generateRouteTests($module, $mappings, $className, $srcPackage);
    }

    private static final void generateTestForRoute$lambda$0$0(Ref.BooleanRef $isGenerated, GenerateRouteTestAction this$0, String $testClassName, FileTemplateDescriptor $fileTemplateDescriptor, PsiDirectory $targetDirectory, Module $module, KtorTestFramework $framework, String $testName, String $requestPath, String $requestMethod, String $srcPackage, String $dstPackage, boolean $optimizeImports) {
        Intrinsics.checkNotNull((Object)$fileTemplateDescriptor);
        $isGenerated.element = this$0.generateTest($testClassName, $fileTemplateDescriptor, $targetDirectory, $module, (TestFramework)$framework, $testName, $requestPath, $requestMethod, $srcPackage, $dstPackage, $optimizeImports);
    }

    private static final Unit generateTestForRoute$lambda$0(Ref.BooleanRef $isGenerated, GenerateRouteTestAction this$0, String $testClassName, FileTemplateDescriptor $fileTemplateDescriptor, PsiDirectory $targetDirectory, Module $module, KtorTestFramework $framework, String $testName, String $requestPath, String $requestMethod, String $srcPackage, String $dstPackage, boolean $optimizeImports) {
        ApplicationManager.getApplication().runWriteAction(() -> GenerateRouteTestAction.generateTestForRoute$lambda$0$0($isGenerated, this$0, $testClassName, $fileTemplateDescriptor, $targetDirectory, $module, $framework, $testName, $requestPath, $requestMethod, $srcPackage, $dstPackage, $optimizeImports));
        return Unit.INSTANCE;
    }
}

