/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ktor.initializr.plugins;

import com.intellij.ktor.initializr.plugins.KtorPluginsGroupComponent;
import com.intellij.ktor.initializr.plugins.ListKtorPluginComponent;
import com.intellij.ktor.initializr.plugins.PageKtorPluginLayout;
import com.intellij.ktor.initializr.plugins.UIKtorPluginGroup;
import com.intellij.util.ui.AbstractLayoutManager;
import com.intellij.util.ui.AnimatedIcon;
import com.intellij.util.ui.JBValue;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\bH\u0002J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0012H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ktor/initializr/plugins/KtorPluginListLayout;", "Lcom/intellij/util/ui/AbstractLayoutManager;", "Lcom/intellij/ktor/initializr/plugins/PageKtorPluginLayout;", "<init>", "()V", "myGroupGap", "Lcom/intellij/util/ui/JBValue;", "myMiddleLineHeight", "", "preferredLayoutSize", "Ljava/awt/Dimension;", "parent", "Ljava/awt/Container;", "layoutContainer", "", "calculateLineHeight", "lines", "getPageCount", "Ljavax/swing/JComponent;", "intellij.ktor"})
public final class KtorPluginListLayout
extends AbstractLayoutManager
implements PageKtorPluginLayout {
    @NotNull
    private final JBValue myGroupGap = (JBValue)new JBValue.Float(10.0f);
    private int myMiddleLineHeight;

    @NotNull
    public Dimension preferredLayoutSize(@NotNull Container parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        int height = 0;
        int count = parent.getComponentCount();
        int lines = 0;
        this.myMiddleLineHeight = 0;
        for (int i = 0; i < count; ++i) {
            Component component = parent.getComponent(i);
            if (component instanceof AnimatedIcon) continue;
            int lineHeight = component.getPreferredSize().height;
            height += lineHeight;
            if (!(component instanceof ListKtorPluginComponent)) continue;
            this.myMiddleLineHeight += lineHeight;
            ++lines;
        }
        this.calculateLineHeight(lines);
        int size = ((KtorPluginsGroupComponent)((Object)parent)).getGroups().size();
        if (size > 1) {
            height += this.myGroupGap.get() * (size - 1);
        }
        return new Dimension(0, height);
    }

    public void layoutContainer(@NotNull Container parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        List<UIKtorPluginGroup> groups = ((KtorPluginsGroupComponent)((Object)parent)).getGroups();
        int width = ((KtorPluginsGroupComponent)((Object)parent)).getWidth();
        int y = 0;
        int groupGap = this.myGroupGap.get();
        int lines = 0;
        this.myMiddleLineHeight = 0;
        for (UIKtorPluginGroup group : groups) {
            Component component;
            Component component2 = component = group.getPanel();
            Intrinsics.checkNotNull((Object)component2);
            int height = component2.getPreferredSize().height;
            component.setBounds(0, y, width, height);
            y += height;
            for (ListKtorPluginComponent KtorPlugin : group.getFeatures()) {
                int lineHeight = KtorPlugin.getPreferredSize().height;
                KtorPlugin.setBounds(0, y, width, lineHeight);
                y += lineHeight;
                this.myMiddleLineHeight += lineHeight;
            }
            lines += group.getFeatures().size();
            y += groupGap;
        }
        this.calculateLineHeight(lines);
    }

    private final void calculateLineHeight(int lines) {
        this.myMiddleLineHeight = lines == 0 || this.myMiddleLineHeight == 0 ? 10 : (this.myMiddleLineHeight /= lines);
    }

    @Override
    public int getPageCount(@NotNull JComponent parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        return parent.getVisibleRect().height / this.myMiddleLineHeight;
    }
}

