/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.actions;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.UpdateSession;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Key;
import com.jetbrains.rd.ide.model.ActionTimestampSetModel;
import com.jetbrains.rd.ide.model.ComponentRect;
import com.jetbrains.rd.ide.model.InputEventModel;
import com.jetbrains.rd.ide.model.MouseEventModel;
import com.jetbrains.rd.ide.model.RdProjectId;
import com.jetbrains.rd.ide.model.ScreenPointMouseEvent;
import com.jetbrains.rd.ide.requests.PatchEngineErrorsKt;
import com.jetbrains.rd.platform.client.SessionUtilKt;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.actions.ActionTimestampSet;
import com.jetbrains.rdserver.actions.BackendActionDataContext;
import com.jetbrains.rdserver.actions.BackendActionTimestampProvider;
import com.jetbrains.rdserver.actions.BackendActionTimestampValidator;
import com.jetbrains.rdserver.actions.BackendDataKeys;
import com.jetbrains.rdserver.actions.ClientMouseEvent;
import com.jetbrains.rdserver.actions.TimestampUpgradeResult;
import com.jetbrains.rdserver.actions.timestamps.EditorTimestamp;
import com.jetbrains.rdserver.actions.timestamps.ProjectTimestamp;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.SwingUtilities;
import kotlin.KotlinNothingValueException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\u001a\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n\u001a\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u001a(\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002\u001a\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\fH\u0002\u001a\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dH\u0000\"\u0019\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0003\u0010\u0004\u00a8\u0006\u001e\u00b2\u0006\n\u0010\u001f\u001a\u00020 X\u008a\u0084\u0002"}, d2={"logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLogger$annotations", "()V", "createInputEvent", "Ljava/awt/event/InputEvent;", "inputEventModel", "Lcom/jetbrains/rd/ide/model/InputEventModel;", "component", "Ljava/awt/Component;", "createDataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "actionId", "", "protocolTimestampSet", "Lcom/jetbrains/rd/ide/model/ActionTimestampSetModel;", "validateTimestampSet", "", "requestTimestampSet", "Lcom/jetbrains/rdserver/actions/ActionTimestampSet;", "actualTimestampSet", "createSetFromModel", "createSetFromDataContext", "dataContext", "initUpdateSessionIfNeededLazily", "actionEvent", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.platform.backend.split", "delegate", "Lcom/intellij/openapi/actionSystem/UpdateSession;"})
@SourceDebugExtension(value={"SMAP\nActionUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ActionUtils.kt\ncom/jetbrains/rdserver/actions/ActionUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,202:1\n1#2:203\n67#3,4:204\n67#3,4:208\n*S KotlinDebug\n*F\n+ 1 ActionUtils.kt\ncom/jetbrains/rdserver/actions/ActionUtilsKt\n*L\n125#1:204,4\n129#1:208,4\n*E\n"})
public final class ActionUtilsKt {
    @NotNull
    private static final Logger logger;

    private static /* synthetic */ void getLogger$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final InputEvent createInputEvent(@Nullable InputEventModel inputEventModel, @NotNull Component component) {
        void $this$createInputEvent_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        if (!(inputEventModel instanceof MouseEventModel)) {
            return null;
        }
        Point point = new Point(((MouseEventModel)inputEventModel).getX(), ((MouseEventModel)inputEventModel).getY());
        if (inputEventModel instanceof ScreenPointMouseEvent) {
            SwingUtilities.convertPointFromScreen(point, component);
        }
        ComponentRect componentRect = ((MouseEventModel)inputEventModel).getComponentRect();
        int n = ((MouseEventModel)inputEventModel).getButton();
        boolean bl = false;
        int n2 = ((MouseEventModel)inputEventModel).getClickCount();
        int n3 = point.y;
        int n4 = point.x;
        int n5 = ((MouseEventModel)inputEventModel).getModifiers();
        long l = System.currentTimeMillis();
        int n6 = ((MouseEventModel)inputEventModel).getId();
        Component component2 = component;
        boolean bl2 = false;
        Rectangle rectangle = new Rectangle($this$createInputEvent_u24lambda_u240.getX(), $this$createInputEvent_u24lambda_u240.getY(), $this$createInputEvent_u24lambda_u240.getWidth(), $this$createInputEvent_u24lambda_u240.getHeight());
        Rectangle rectangle2 = rectangle;
        int n7 = n;
        boolean bl3 = bl;
        int n8 = n2;
        int n9 = n3;
        int n10 = n4;
        int n11 = n5;
        long l2 = l;
        int n12 = n6;
        Component component3 = component2;
        return new ClientMouseEvent(component3, n12, l2, n11, n10, n9, n8, bl3, n7, rectangle2);
    }

    @NotNull
    public static final DataContext createDataContext(@NotNull ClientAppSession session, @NotNull String actionId, @NotNull ActionTimestampSetModel protocolTimestampSet) {
        RdProjectId projectId;
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        Intrinsics.checkNotNullParameter((Object)protocolTimestampSet, (String)"protocolTimestampSet");
        ActionTimestampSet requestTimestampSet = ActionUtilsKt.createSetFromModel(protocolTimestampSet);
        EditorTimestamp editorTimestamp = requestTimestampSet.getTimestamp(EditorTimestamp.Companion.getNAME());
        Editor editor = editorTimestamp != null ? editorTimestamp.getData() : null;
        SimpleDataContext.Builder builder = SimpleDataContext.builder();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder(...)");
        SimpleDataContext.Builder builder2 = builder;
        builder2.add(PlatformDataKeys.EDITOR, (Object)editor);
        for (Map.Entry<String, ActionTimestamp<?>> entry : requestTimestampSet.getAllTimestamps().entrySet()) {
            Object data;
            String key = entry.getKey();
            ActionTimestamp<?> value = entry.getValue();
            if (value.getData() == null) continue;
            builder2.add(DataKey.Companion.create(key), data);
        }
        builder2.add(BackendDataKeys.INSTANCE.getAPP_SESSION(), (Object)session);
        ProjectTimestamp projectTimestamp = requestTimestampSet.getTimestamp(ProjectTimestamp.Companion.getNAME());
        Object object = projectId = projectTimestamp != null ? projectTimestamp.getProjectId() : null;
        if (projectId != null) {
            ClientProjectSession projectSession = SessionUtilKt.getProjectSession((ClientAppSession)session, (RdProjectId)projectId);
            builder2.add(BackendDataKeys.INSTANCE.getPROJECT_SESSION(), (Object)projectSession);
            Object object2 = projectSession;
            if (object2 == null || (object2 = object2.getProject()) == null) {
                Editor editor2 = editor;
                object2 = editor2 != null ? editor2.getProject() : null;
            }
            builder2.add(CommonDataKeys.PROJECT, object2);
        }
        DataContext dataContext = builder2.build();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"build(...)");
        ActionTimestampSet actualTimestampSet = ActionUtilsKt.createSetFromDataContext(dataContext);
        ActionUtilsKt.validateTimestampSet(session, actionId, requestTimestampSet, actualTimestampSet);
        return BackendActionDataContext.INSTANCE.create(session, requestTimestampSet, actualTimestampSet);
    }

    private static final void validateTimestampSet(ClientAppSession session, String actionId, ActionTimestampSet requestTimestampSet, ActionTimestampSet actualTimestampSet) {
        for (BackendActionTimestampValidator validator : (BackendActionTimestampValidator[])BackendActionTimestampValidator.Companion.getEP().getExtensions()) {
            TimestampUpgradeResult result;
            if (validator.validate(session, actionId, requestTimestampSet, actualTimestampSet) == null) continue;
            TimestampUpgradeResult timestampUpgradeResult = result;
            if (timestampUpgradeResult instanceof TimestampUpgradeResult.Failure) {
                Logger $this$trace$iv = logger;
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    Logger logger = $this$trace$iv;
                    boolean bl = false;
                    logger.trace("Timestamp upgrade failed: " + ((TimestampUpgradeResult.Failure)result).getMessage());
                }
                PatchEngineErrorsKt.patchEngineFail$default((String)((TimestampUpgradeResult.Failure)result).getMessage(), null, (int)2, null);
                throw new KotlinNothingValueException();
            }
            if (timestampUpgradeResult instanceof TimestampUpgradeResult.RetryRequest) {
                Logger $this$trace$iv = logger;
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    Logger logger = $this$trace$iv;
                    boolean bl = false;
                    logger.trace("Timestamp upgrade required a retry: " + ((TimestampUpgradeResult.RetryRequest)result).getMessage());
                }
                PatchEngineErrorsKt.patchEngineFail$default((String)((TimestampUpgradeResult.RetryRequest)result).getMessage(), null, (int)2, null);
                throw new KotlinNothingValueException();
            }
            if (timestampUpgradeResult instanceof TimestampUpgradeResult.Success) continue;
            throw new NoWhenBranchMatchedException();
        }
    }

    private static final ActionTimestampSet createSetFromModel(ActionTimestampSetModel protocolTimestampSet) {
        ActionTimestampSet resultSet = ActionTimestampSet.Companion.getEMPTY();
        for (BackendActionTimestampProvider provider : BackendActionTimestampProvider.Companion.getEP().getExtensionList()) {
            ActionTimestampSet set = provider.createSet(protocolTimestampSet);
            resultSet = resultSet.merge(set);
        }
        return resultSet;
    }

    private static final ActionTimestampSet createSetFromDataContext(DataContext dataContext) {
        ActionTimestampSet resultSet = ActionTimestampSet.Companion.getEMPTY();
        for (BackendActionTimestampProvider provider : BackendActionTimestampProvider.Companion.getEP().getExtensionList()) {
            ActionTimestampSet set = provider.createSet(dataContext);
            resultSet = resultSet.merge(set);
        }
        return resultSet;
    }

    public static final void initUpdateSessionIfNeededLazily(@NotNull AnActionEvent actionEvent) {
        Intrinsics.checkNotNullParameter((Object)actionEvent, (String)"actionEvent");
        if (!Intrinsics.areEqual((Object)actionEvent.getUpdateSession(), (Object)UpdateSession.EMPTY)) {
            return;
        }
        Lazy delegate$delegate = LazyKt.lazy(() -> ActionUtilsKt.initUpdateSessionIfNeededLazily$lambda$0(actionEvent));
        actionEvent.setUpdateSession(new UpdateSession((Lazy<? extends UpdateSession>)delegate$delegate){
            final /* synthetic */ Lazy<UpdateSession> $delegate$delegate;
            {
                this.$delegate$delegate = $delegate$delegate;
            }

            public Iterable<AnAction> expandedChildren(ActionGroup actionGroup) {
                Intrinsics.checkNotNullParameter((Object)actionGroup, (String)"actionGroup");
                Iterable iterable = ActionUtilsKt.access$initUpdateSessionIfNeededLazily$lambda$1(this.$delegate$delegate).expandedChildren(actionGroup);
                Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"expandedChildren(...)");
                return iterable;
            }

            public List<? extends AnAction> children(ActionGroup actionGroup) {
                Intrinsics.checkNotNullParameter((Object)actionGroup, (String)"actionGroup");
                List list = ActionUtilsKt.access$initUpdateSessionIfNeededLazily$lambda$1(this.$delegate$delegate).children(actionGroup);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"children(...)");
                return list;
            }

            public Presentation presentation(AnAction action) {
                Intrinsics.checkNotNullParameter((Object)action, (String)"action");
                Presentation presentation = ActionUtilsKt.access$initUpdateSessionIfNeededLazily$lambda$1(this.$delegate$delegate).presentation(action);
                Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"presentation(...)");
                return presentation;
            }

            public <T> T sharedData(Key<T> key, Supplier<? extends T> supplier) {
                Intrinsics.checkNotNullParameter(key, (String)"key");
                Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
                Object object = ActionUtilsKt.access$initUpdateSessionIfNeededLazily$lambda$1(this.$delegate$delegate).sharedData(key, supplier);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sharedData(...)");
                return (T)object;
            }

            public <T> T compute(Object action, String operationName, ActionUpdateThread updateThread, Supplier<? extends T> supplier) {
                Intrinsics.checkNotNullParameter((Object)action, (String)"action");
                Intrinsics.checkNotNullParameter((Object)operationName, (String)"operationName");
                Intrinsics.checkNotNullParameter((Object)updateThread, (String)"updateThread");
                Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
                return (T)ActionUtilsKt.access$initUpdateSessionIfNeededLazily$lambda$1(this.$delegate$delegate).compute(action, operationName, updateThread, supplier);
            }
        });
    }

    private static final UpdateSession initUpdateSessionIfNeededLazily$lambda$1(Lazy<? extends UpdateSession> $delegate$delegate) {
        Lazy<? extends UpdateSession> lazy = $delegate$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (UpdateSession)object;
    }

    private static final UpdateSession initUpdateSessionIfNeededLazily$lambda$0(AnActionEvent $actionEvent) {
        $actionEvent.setUpdateSession(UpdateSession.EMPTY);
        Utils.initUpdateSession((AnActionEvent)$actionEvent);
        return $actionEvent.getUpdateSession();
    }

    public static final /* synthetic */ UpdateSession access$initUpdateSessionIfNeededLazily$lambda$1(Lazy $delegate$delegate) {
        return ActionUtilsKt.initUpdateSessionIfNeededLazily$lambda$1((Lazy<? extends UpdateSession>)$delegate$delegate);
    }

    static {
        Logger logger = Logger.getInstance((String)"#com.jetbrains.rdserver.actions.ActionUtilsKt");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ActionUtilsKt.logger = logger;
    }
}

