/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.editors.crumbs;

import com.intellij.codeInsight.breadcrumbs.FileBreadcrumbsCollector;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.jetbrains.rd.ide.model.CrumbSession;
import com.jetbrains.rd.ide.model.CrumbsTextControlExtension;
import com.jetbrains.rd.ide.model.TextControlExtension;
import com.jetbrains.rd.platform.util.ComponentsKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rdserver.editors.BackendEditorExtensionsProvider;
import com.jetbrains.rdserver.editors.crumbs.CrumbExtensionProviderKt;
import java.util.List;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rdserver/editors/crumbs/CrumbExtensionProvider;", "Lcom/jetbrains/rdserver/editors/BackendEditorExtensionsProvider;", "<init>", "()V", "getExtensions", "", "Lcom/jetbrains/rd/ide/model/TextControlExtension;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "editor", "Lcom/intellij/openapi/editor/Editor;", "Companion", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nCrumbExtensionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CrumbExtensionProvider.kt\ncom/jetbrains/rdserver/editors/crumbs/CrumbExtensionProvider\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,81:1\n13#2:82\n*S KotlinDebug\n*F\n+ 1 CrumbExtensionProvider.kt\ncom/jetbrains/rdserver/editors/crumbs/CrumbExtensionProvider\n*L\n54#1:82\n*E\n"})
public final class CrumbExtensionProvider
implements BackendEditorExtensionsProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger logger;

    @Override
    @NotNull
    public List<TextControlExtension> getExtensions(@NotNull ClientAppSession session, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        CrumbsTextControlExtension extension = new CrumbsTextControlExtension();
        VirtualFile virtualFile = editor.getVirtualFile();
        if (virtualFile == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile virtualFile2 = virtualFile;
        Project project = editor.getProject();
        if (project == null) {
            return CollectionsKt.emptyList();
        }
        Project project2 = project;
        extension.getCrumbsSession().view(ComponentsKt.getLifetime((UserDataHolder)((UserDataHolder)session)), (arg_0, arg_1) -> CrumbExtensionProvider.getExtensions$lambda$0(project2, extension, virtualFile2, editor, session, arg_0, arg_1));
        return CollectionsKt.listOf((Object)extension);
    }

    private static final Iterable getExtensions$lambda$0$0(Project $project, VirtualFile $virtualFile, Editor $editor, CrumbSession $crumbSession) {
        FileBreadcrumbsCollector breadcrumbsCollector = FileBreadcrumbsCollector.findBreadcrumbsCollector((Project)$project, (VirtualFile)$virtualFile);
        if (breadcrumbsCollector == null) {
            return CollectionsKt.emptyList();
        }
        return breadcrumbsCollector.computeCrumbs($virtualFile, $editor.getDocument(), $crumbSession.getOffset(), Boolean.valueOf(true));
    }

    private static final Unit getExtensions$lambda$0$1(CrumbSession $crumbSession, Editor $editor, ClientAppSession $session, Iterable it) {
        IOptProperty iOptProperty = $crumbSession.getCrumbs();
        Intrinsics.checkNotNull((Object)it);
        iOptProperty.set(CrumbExtensionProviderKt.toModel(it, $editor, $session));
        return Unit.INSTANCE;
    }

    private static final void getExtensions$lambda$0$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit getExtensions$lambda$0(Project $project, CrumbsTextControlExtension $extension, VirtualFile $virtualFile, Editor $editor, ClientAppSession $session, Lifetime lt, CrumbSession crumbSession) {
        Intrinsics.checkNotNullParameter((Object)lt, (String)"lt");
        if (crumbSession == null || ClientId.Companion.isCurrentlyUnderLocalId()) {
            return Unit.INSTANCE;
        }
        logger.trace("crumbs requested for " + crumbSession.getOffset() + " offset");
        Object[] objectArray = new Object[]{$extension};
        ReadAction.nonBlocking(() -> CrumbExtensionProvider.getExtensions$lambda$0$0($project, $virtualFile, $editor, crumbSession)).withDocumentsCommitted($project).expireWith(LifetimeDisposableExKt.createNestedDisposable((Lifetime)lt, (String)"crumbSession")).coalesceBy(objectArray).finishOnUiThread(ModalityState.defaultModalityState(), arg_0 -> CrumbExtensionProvider.getExtensions$lambda$0$2(arg_0 -> CrumbExtensionProvider.getExtensions$lambda$0$1(crumbSession, $editor, $session, arg_0), arg_0)).submit((Executor)AppExecutorUtil.getAppExecutorService());
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CrumbExtensionProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        CrumbExtensionProvider.logger = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/editors/crumbs/CrumbExtensionProvider$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.backend.split"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

