/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.lux.services;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientKind;
import com.intellij.openapi.client.ClientSession;
import com.intellij.openapi.client.ClientSessionsManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.framework.IProtocol;
import com.jetbrains.rd.framework.base.RdExtBase;
import com.jetbrains.rd.ide.model.LuxModel;
import com.jetbrains.rd.ide.model.LuxModel_GeneratedKt;
import com.jetbrains.rd.ide.model.LxAbstractComponent;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.protocol.PermittedModalityProtocolEntities;
import com.jetbrains.rd.util.CollectionExKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rdserver.core.RemoteSessionKt;
import com.jetbrains.rdserver.lux.adapter.LuxComponentAdapter;
import com.jetbrains.rdserver.lux.adapter.LuxFrameAdapter;
import com.jetbrains.rdserver.lux.adapter.LuxGraphicsAdapter;
import com.jetbrains.rdserver.lux.services.LuxHostService;
import com.jetbrains.rdserver.unattendedHost.UtilKt;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 '2\u00020\u0001:\u0001'B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u001a\u001a\u00020\u001bJ\u001e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020 J\u0014\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\f0$J\n\u0010%\u001a\u00020&H\u0096\u0080\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006("}, d2={"Lcom/jetbrains/rdserver/lux/services/LuxHostConnection;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "<init>", "(Lcom/intellij/openapi/client/ClientAppSession;)V", "getSession", "()Lcom/intellij/openapi/client/ClientAppSession;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "boundAdapters", "", "", "Lcom/jetbrains/rdserver/lux/adapter/LuxComponentAdapter;", "model", "Lcom/jetbrains/rd/ide/model/LuxModel;", "getModel", "()Lcom/jetbrains/rd/ide/model/LuxModel;", "hostService", "Lcom/jetbrains/rdserver/lux/services/LuxHostService;", "getHostService", "()Lcom/jetbrains/rdserver/lux/services/LuxHostService;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "isControllerConnection", "", "bindAdapter", "Lcom/jetbrains/rdserver/lux/adapter/LuxGraphicsAdapter;", "adapter", "componentModel", "Lcom/jetbrains/rd/ide/model/LxAbstractComponent;", "removeItemsFromCache", "", "items", "", "toString", "", "Companion", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nLuxHostConnection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LuxHostConnection.kt\ncom/jetbrains/rdserver/lux/services/LuxHostConnection\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,101:1\n13#2:102\n67#2,4:103\n67#2,4:107\n1915#3,2:111\n*S KotlinDebug\n*F\n+ 1 LuxHostConnection.kt\ncom/jetbrains/rdserver/lux/services/LuxHostConnection\n*L\n43#1:102\n57#1:103,4\n84#1:107,4\n92#1:111,2\n*E\n"})
public final class LuxHostConnection
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClientAppSession session;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Map<Integer, LuxComponentAdapter> boundAdapters;

    public LuxHostConnection(@NotNull ClientAppSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.session = session;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(LuxHostConnection.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.boundAdapters = new LinkedHashMap();
        this.getHostService().getImageCache().clear();
        Logger $this$trace$iv = this.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger2 = $this$trace$iv;
            boolean bl = false;
            logger2.trace("LuxHostConnection created for client " + this.session.getClientId());
        }
        CoroutineScope coroutineScope = this.getLifetime().getCoroutineScope();
        CoroutineContext coroutineContext = CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE).plus(ClientId.Companion.coroutineContext());
        ModalityState modalityState = ModalityState.any();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"any(...)");
        BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)coroutineContext.plus(ModalityKt.asContextElement((ModalityState)modalityState)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ LuxHostConnection this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        PermittedModalityProtocolEntities.Companion.getInstance().allowAnyModalityPumpingUnder(this.this$0.getLifetime(), (RdExtBase)this.this$0.getModel());
                        this.this$0.getModel().getShowMainWindow().advise(this.this$0.getLifetime(), arg_0 -> 2.invokeSuspend$lambda$0(this.this$0, arg_0));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$0(LuxHostConnection this$0, boolean show2) {
                block4: {
                    LuxFrameAdapter luxFrameAdapter;
                    LuxFrameAdapter luxFrameAdapter2 = this$0.getHostService().getMainWindow();
                    if (luxFrameAdapter2 == null) break block4;
                    LuxFrameAdapter $this$invokeSuspend_u24lambda_u240_u240 = luxFrameAdapter = luxFrameAdapter2;
                    boolean bl = false;
                    if (show2) {
                        Logger $this$trace$iv = this$0.logger;
                        boolean $i$f$trace = false;
                        if ($this$trace$iv.isTraceEnabled()) {
                            Logger logger = $this$trace$iv;
                            boolean bl2 = false;
                            logger.trace("Showing main window");
                        }
                        LuxHostConnection localHostConnection = Companion.getInstance((ClientAppSession)CollectionsKt.first((List)ClientSessionsManager.Companion.getAppSessions(ClientKind.CONTROLLER)));
                        $this$invokeSuspend_u24lambda_u240_u240.bindTo(localHostConnection);
                    } else {
                        Logger $this$trace$iv = this$0.logger;
                        boolean $i$f$trace = false;
                        if ($this$trace$iv.isTraceEnabled()) {
                            Logger logger = $this$trace$iv;
                            boolean bl3 = false;
                            logger.trace("Hiding main window");
                        }
                        $this$invokeSuspend_u24lambda_u240_u240.unbind();
                    }
                }
                return Unit.INSTANCE;
            }
        }), (int)2, null);
    }

    @NotNull
    public final ClientAppSession getSession() {
        return this.session;
    }

    private final LuxModel getModel() {
        return LuxModel_GeneratedKt.getLuxModel((IProtocol)((IProtocol)RemoteSessionKt.getProtocol(this.session)));
    }

    private final LuxHostService getHostService() {
        return LuxHostService.Companion.getInstance();
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.getServiceLifetime();
    }

    public final boolean isControllerConnection() {
        return this.session.isController();
    }

    @NotNull
    public final LuxGraphicsAdapter bindAdapter(@NotNull Lifetime lifetime, @NotNull LuxComponentAdapter adapter, @NotNull LxAbstractComponent componentModel) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
        Intrinsics.checkNotNullParameter((Object)componentModel, (String)"componentModel");
        Lifetime adapterBoundedLifetime = RLifetimeKt.intersect((Lifetime)this.getServiceLifetime(), (Lifetime)lifetime);
        int id = adapter.getLuxId();
        Logger $this$trace$iv = this.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Binding adapter " + id + " -> " + this);
        }
        CollectionExKt.addUnique(this.boundAdapters, (Lifetime)adapterBoundedLifetime, (Object)id, (Object)adapter);
        CollectionExKt.addUnique((Map)((Map)this.getModel().getComponents()), (Lifetime)adapterBoundedLifetime, (Object)id, (Object)componentModel);
        return new LuxGraphicsAdapter(this, adapter, componentModel.getGraphics());
    }

    public final void removeItemsFromCache(@NotNull List<Integer> items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        this.getModel().getCleanImagesFromCache().fire(items);
        Iterable $this$forEach$iv = this.boundAdapters.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LuxComponentAdapter it = (LuxComponentAdapter)element$iv;
            boolean bl = false;
            it.clearDrawOperations();
            it.repaint();
        }
    }

    @NotNull
    public String toString() {
        return "LuxHostConnection(" + this.session + ")";
    }

    @JvmStatic
    @NotNull
    public static final LuxHostConnection getInstance(@NotNull ClientAppSession session) {
        return Companion.getInstance(session);
    }

    @JvmStatic
    @NotNull
    public static final List<LuxHostConnection> getAllInstances() {
        return Companion.getAllInstances();
    }

    @JvmStatic
    @Nullable
    public static final LuxHostConnection getControllerInstance() {
        return Companion.getControllerInstance();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tH\u0007J\n\u0010\n\u001a\u0004\u0018\u00010\u0005H\u0007\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/lux/services/LuxHostConnection$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/rdserver/lux/services/LuxHostConnection;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "getAllInstances", "", "getControllerInstance", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nLuxHostConnection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LuxHostConnection.kt\ncom/jetbrains/rdserver/lux/services/LuxHostConnection$Companion\n+ 2 Components.kt\ncom/jetbrains/rd/platform/util/ComponentsKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,101:1\n23#2:102\n23#2:104\n65#3:103\n*S KotlinDebug\n*F\n+ 1 LuxHostConnection.kt\ncom/jetbrains/rdserver/lux/services/LuxHostConnection$Companion\n*L\n33#1:102\n39#1:104\n36#1:103\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final LuxHostConnection getInstance(@NotNull ClientAppSession session) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            ClientSession $this$service$iv = (ClientSession)session;
            boolean $i$f$service = false;
            Object object = $this$service$iv.getService(LuxHostConnection.class);
            if (object == null) {
                throw new IllegalStateException(("Can't find service for " + $this$service$iv).toString());
            }
            return (LuxHostConnection)((Object)object);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final List<LuxHostConnection> getAllInstances() {
            void $this$services$iv;
            ComponentManager componentManager = (ComponentManager)ApplicationKt.getApplication();
            boolean includeLocal$iv = false;
            boolean $i$f$services = false;
            List list = $this$services$iv.getServices(LuxHostConnection.class, ClientKind.REMOTE);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getServices(...)");
            return list;
        }

        @JvmStatic
        @Nullable
        public final LuxHostConnection getControllerInstance() {
            LuxHostConnection luxHostConnection;
            ClientAppSession clientAppSession = UtilKt.getControllerSessionOrNull(ApplicationKt.getApplication());
            if (clientAppSession != null) {
                ClientSession $this$service$iv = (ClientSession)clientAppSession;
                boolean $i$f$service = false;
                Object object = $this$service$iv.getService(LuxHostConnection.class);
                if (object == null) {
                    throw new IllegalStateException(("Can't find service for " + $this$service$iv).toString());
                }
                luxHostConnection = (LuxHostConnection)((Object)object);
            } else {
                luxHostConnection = null;
            }
            return luxHostConnection;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

