/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.permissions.impl;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientSessionsUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.DocumentWriteAccessGuard;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ApplicationKt;
import com.intellij.util.SlowOperations;
import com.jetbrains.rdserver.execution.BackendConsoleDocumentWriteAccessGuard;
import com.jetbrains.rdserver.permissions.ClientPermissionManager;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/permissions/impl/BackendDocumentWriteAccessGuard;", "Lcom/intellij/openapi/editor/impl/DocumentWriteAccessGuard;", "<init>", "()V", "isWritable", "Lcom/intellij/openapi/editor/impl/DocumentWriteAccessGuard$Result;", "document", "Lcom/intellij/openapi/editor/Document;", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nBackendDocumentWriteAccessGuard.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendDocumentWriteAccessGuard.kt\ncom/jetbrains/rdserver/permissions/impl/BackendDocumentWriteAccessGuard\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,50:1\n13#2:51\n*S KotlinDebug\n*F\n+ 1 BackendDocumentWriteAccessGuard.kt\ncom/jetbrains/rdserver/permissions/impl/BackendDocumentWriteAccessGuard\n*L\n31#1:51\n*E\n"})
public final class BackendDocumentWriteAccessGuard
extends DocumentWriteAccessGuard {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public DocumentWriteAccessGuard.Result isWritable(@NotNull Document document) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        if (ClientId.Companion.isCurrentlyUnderLocalId()) {
            DocumentWriteAccessGuard.Result result = DocumentWriteAccessGuard.success();
            Intrinsics.checkNotNullExpressionValue((Object)result, (String)"success(...)");
            return result;
        }
        if (document instanceof DocumentImpl && !((DocumentImpl)document).isWriteThreadOnly()) {
            DocumentWriteAccessGuard.Result result = DocumentWriteAccessGuard.success();
            Intrinsics.checkNotNullExpressionValue((Object)result, (String)"success(...)");
            return result;
        }
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
        if (file2 == null) {
            DocumentWriteAccessGuard.Result result = DocumentWriteAccessGuard.success();
            Intrinsics.checkNotNullExpressionValue((Object)result, (String)"success(...)");
            return result;
        }
        ClientAppSession session = ClientSessionsUtil.getCurrentSessionOrNull((Application)ApplicationKt.getApplication());
        if (session == null || session.isDisposed()) {
            String message = "The client (" + ClientId.Companion.getCurrent() + ") session has expired. Modifying a document is prohibited";
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(BackendConsoleDocumentWriteAccessGuard.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error(message, new Throwable());
            DocumentWriteAccessGuard.Result result = DocumentWriteAccessGuard.fail((String)message);
            Intrinsics.checkNotNullExpressionValue((Object)result, (String)"fail(...)");
            return result;
        }
        AutoCloseable $i$f$logger = (AutoCloseable)SlowOperations.knownIssue((String)"CWM-9708");
        Throwable throwable = null;
        try {
            AccessToken it = (AccessToken)$i$f$logger;
            boolean bl2 = false;
            bl = ClientPermissionManager.Companion.getInstance(session).isWritable(file2);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)$i$f$logger, (Throwable)throwable);
        }
        boolean writable = bl;
        if (writable) {
            DocumentWriteAccessGuard.Result result = DocumentWriteAccessGuard.success();
            Intrinsics.checkNotNullExpressionValue((Object)result, (String)"success(...)");
            return result;
        }
        String info2 = "(class=" + file2.getClass().getSimpleName() + " name=" + file2.getName() + ")";
        if (!ClientPermissionManager.Companion.getInstance(session).hasFileWriteAccess()) {
            DocumentWriteAccessGuard.Result result = DocumentWriteAccessGuard.fail((String)("The client (" + session.getName() + ") has no write access at all. The file bound to document is " + info2));
            Intrinsics.checkNotNullExpressionValue((Object)result, (String)"fail(...)");
            return result;
        }
        DocumentWriteAccessGuard.Result result = DocumentWriteAccessGuard.fail((String)("The client (" + session.getName() + ") has no write access to the file " + info2 + "."));
        Intrinsics.checkNotNullExpressionValue((Object)result, (String)"fail(...)");
        return result;
    }
}

