/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.portForwarding.persist;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.ForwardedPort;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.PortConfiguration;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.PortConfigurationKt;
import com.jetbrains.rdserver.portForwarding.persist.PerProjectDirectPortForwardingPersistentComponent;
import com.jetbrains.rdserver.portForwarding.persist.PerProjectPortForwardingPersistentComponentBase;
import com.jetbrains.rdserver.portForwarding.persist.PerProjectReversePortForwardingPersistentComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rdserver/portForwarding/persist/PerProjectPortForwardingPersistentService;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "persistPort", "", "forwardedPort", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/ForwardedPort;", "deletePersistedPort", "Companion", "intellij.platform.backend.split"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nPerProjectPortForwardingPersistentService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PerProjectPortForwardingPersistentService.kt\ncom/jetbrains/rdserver/portForwarding/persist/PerProjectPortForwardingPersistentService\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,59:1\n60#2,5:60\n60#2,5:65\n13#2:70\n*S KotlinDebug\n*F\n+ 1 PerProjectPortForwardingPersistentService.kt\ncom/jetbrains/rdserver/portForwarding/persist/PerProjectPortForwardingPersistentService\n*L\n26#1:60,5\n43#1:65,5\n19#1:70\n*E\n"})
public final class PerProjectPortForwardingPersistentService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final Logger logger;

    public PerProjectPortForwardingPersistentService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    public final void persistPort(@NotNull ForwardedPort forwardedPort) {
        Intrinsics.checkNotNullParameter((Object)forwardedPort, (String)"forwardedPort");
        if (PortConfigurationKt.isExposedPort((PortConfiguration)forwardedPort.getConfiguration())) {
            Logger $this$debug_u24default$iv = logger;
            Throwable t$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Unable to persist exposed port: " + forwardedPort.getTargetPortNumber(), t$iv);
            }
            return;
        }
        PerProjectPortForwardingPersistentComponentBase persistentComponent = PortConfigurationKt.isPerClientReversedForwardedPort((PortConfiguration)forwardedPort.getConfiguration()) ? PerProjectReversePortForwardingPersistentComponent.Companion.getInstance(this.project) : PerProjectDirectPortForwardingPersistentComponent.Companion.getInstance(this.project);
        ((PerProjectPortForwardingPersistentComponentBase)persistentComponent).persistPort(forwardedPort);
    }

    public final void deletePersistedPort(@NotNull ForwardedPort forwardedPort) {
        Intrinsics.checkNotNullParameter((Object)forwardedPort, (String)"forwardedPort");
        if (PortConfigurationKt.isExposedPort((PortConfiguration)forwardedPort.getConfiguration())) {
            Logger $this$debug_u24default$iv = logger;
            Throwable t$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Unable to delete exposed port: " + forwardedPort.getTargetPortNumber(), t$iv);
            }
            return;
        }
        PerProjectPortForwardingPersistentComponentBase persistentComponent = PortConfigurationKt.isPerClientReversedForwardedPort((PortConfiguration)forwardedPort.getConfiguration()) ? PerProjectReversePortForwardingPersistentComponent.Companion.getInstance(this.project) : PerProjectDirectPortForwardingPersistentComponent.Companion.getInstance(this.project);
        ((PerProjectPortForwardingPersistentComponentBase)persistentComponent).deletePersistedPort(forwardedPort);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PerProjectPortForwardingPersistentService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        PerProjectPortForwardingPersistentService.logger = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rdserver/portForwarding/persist/PerProjectPortForwardingPersistentService$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/jetbrains/rdserver/portForwarding/persist/PerProjectPortForwardingPersistentService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nPerProjectPortForwardingPersistentService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PerProjectPortForwardingPersistentService.kt\ncom/jetbrains/rdserver/portForwarding/persist/PerProjectPortForwardingPersistentService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,59:1\n30#2,2:60\n*S KotlinDebug\n*F\n+ 1 PerProjectPortForwardingPersistentService.kt\ncom/jetbrains/rdserver/portForwarding/persist/PerProjectPortForwardingPersistentService$Companion\n*L\n21#1:60,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PerProjectPortForwardingPersistentService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<PerProjectPortForwardingPersistentService> serviceClass$iv = PerProjectPortForwardingPersistentService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (PerProjectPortForwardingPersistentService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

