/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.unattendedHost.customization.splitMode;

import com.intellij.CommonBundle;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ExitStarter;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.components.ComponentManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.util.UserDataHolderKt;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.messages.MessagesService;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.Restarter;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.codeWithMe.model.UnattendedHostTerminationReason;
import com.jetbrains.rd.platform.util.ApplicationKt;
import com.jetbrains.rdserver.SplitBackendBundle;
import com.jetbrains.rdserver.unattendedHost.UtilKt;
import com.jetbrains.rdserver.unattendedHost.customization.SplitModeCustomization;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u0012\u0010\n\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rdserver/unattendedHost/customization/splitMode/EnterMonolithModeManager;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "runInMonolithMode", "", "project", "Lcom/intellij/openapi/project/Project;", "showCannotRestartDialog", "showConfirmationDialog", "", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nEnterMonolithModeAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnterMonolithModeAction.kt\ncom/jetbrains/rdserver/unattendedHost/customization/splitMode/EnterMonolithModeManager\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,107:1\n23#2:108\n*S KotlinDebug\n*F\n+ 1 EnterMonolithModeAction.kt\ncom/jetbrains/rdserver/unattendedHost/customization/splitMode/EnterMonolithModeManager\n*L\n38#1:108\n*E\n"})
public final class EnterMonolithModeManager {
    @NotNull
    public static final EnterMonolithModeManager INSTANCE;
    @NotNull
    private static final Logger logger;

    private EnterMonolithModeManager() {
    }

    public final void runInMonolithMode(@Nullable Project project) {
        ClientAppSession controllerSession;
        logger.info("Run app in Monolith Mode action");
        if (!SplitModeCustomization.Companion.getInstance().isFrontendStartedFromBackend()) {
            logger.info("Application is running in Monolith mode already. Skip restart in Monolith mode action.");
            return;
        }
        Application application = ApplicationKt.getApplicationOrNull();
        Object object = controllerSession = application != null ? UtilKt.getControllerSessionOrNull(application) : null;
        if (controllerSession == null) {
            logger.error("Unable to switch to Monolith Mode. Controller session is not initialized");
            return;
        }
        if (!Restarter.isSupported()) {
            this.showCannotRestartDialog(project);
            return;
        }
        if (!this.showConfirmationDialog(project)) {
            return;
        }
        Application application2 = ApplicationManager.getApplication();
        Intrinsics.checkNotNull((Object)application2, (String)"null cannot be cast to non-null type com.intellij.openapi.components.ComponentManagerEx");
        BuildersKt.launch$default((CoroutineScope)((ComponentManagerEx)application2).getCoroutineScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(controllerSession, null){
            int label;
            final /* synthetic */ ClientAppSession $controllerSession;
            {
                this.$controllerSession = $controllerSession;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        EnterMonolithModeManager.access$getLogger$p().info("Notify a controller about host restart");
                        this.label = 1;
                        v0 = com.jetbrains.rdserver.ui.notification.UtilKt.notifyControllerAboutHostClose$default(this.$controllerSession, UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)this.$controllerSession)), UnattendedHostTerminationReason.EXIT, null, (Continuation)this, 8, null);
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl14
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl14:
                        // 2 sources

                        EnterMonolithModeManager.access$getLogger$p().info("Perform application restart to launch in Monolith Mode");
                        Restarter.setMainAppArgs((List)CollectionsKt.emptyList());
                        ExitStarter.Companion.forceExitApplication("EnterMonolithModeManager requested restart", true);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void showCannotRestartDialog(Project project) {
        String title = SplitBackendBundle.INSTANCE.message("widget.EnterMonolithMode.text", new Object[0]);
        String message = StringsKt.trimIndent((String)SplitBackendBundle.INSTANCE.message(PluginManagerCore.isRunningFromSources() ? "action.EnterMonolithMode.restart.error.run.from.sources.message" : "action.EnterMonolithMode.restart.error.run.from.launcher.message", new Object[0]));
        String okText = CommonBundle.getOkButtonText();
        MessagesService messagesService = MessagesService.Companion.getInstance();
        String[] stringArray = new String[1];
        Intrinsics.checkNotNull((Object)okText);
        stringArray[0] = okText;
        MessagesService.showMessageDialog$default((MessagesService)messagesService, (Project)project, null, (String)message, (String)title, (String[])stringArray, (int)0, (int)0, (Icon)UIUtil.getWarningIcon(), null, (boolean)true, null, (int)1122, null);
    }

    private final boolean showConfirmationDialog(Project project) {
        String title = SplitBackendBundle.INSTANCE.message("widget.EnterMonolithMode.text", new Object[0]);
        String message = StringsKt.trimIndent((String)SplitBackendBundle.INSTANCE.message("action.EnterMonolithMode.restart.application.confirmation.message", new Object[0]));
        return Messages.showYesNoDialog((Project)project, (String)message, (String)title, (Icon)Messages.getQuestionIcon()) == 0;
    }

    public static final /* synthetic */ Logger access$getLogger$p() {
        return logger;
    }

    static {
        EnterMonolithModeManager $this$thisLogger$iv = INSTANCE = new EnterMonolithModeManager();
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(EnterMonolithModeManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        EnterMonolithModeManager.logger = logger;
    }
}

