/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.pro.utils;

import com.jetbrains.python.debugger.PyXDebugValue;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u001a\u0012\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0000\u001a\u0010\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u0010\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0001H\u0000\u00a8\u0006\t"}, d2={"defineObjectType", "", "debugValue", "Lcom/jetbrains/python/debugger/PyXDebugValue;", "getBufferedImageTypeString", "imageType", "", "defineFrameAccessorType", "frameAccessor", "intellij.jupyter.py.pro"})
public final class ImageUtilsKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static final String defineObjectType(@Nullable PyXDebugValue debugValue) {
        if (debugValue == null) {
            return "Unknown";
        }
        String string = debugValue.getType();
        if (string == null) return "Other";
        int n = -1;
        switch (string.hashCode()) {
            case 1460321977: {
                if (string.equals("SparseTensor")) {
                    n = 1;
                }
                break;
            }
            case 411652298: {
                if (string.equals("ResourceVariable")) {
                    n = 2;
                }
                break;
            }
            case -1793451911: {
                if (string.equals("Tensor")) {
                    n = 3;
                }
                break;
            }
            case 2021122961: {
                if (string.equals("EagerTensor")) {
                    n = 4;
                }
                break;
            }
            case -295105170: {
                if (string.equals("PngImageFile")) {
                    n = 5;
                }
                break;
            }
            case 70760763: {
                if (string.equals("Image")) {
                    n = 6;
                }
                break;
            }
            case -1703718449: {
                if (string.equals("JpegImageFile")) {
                    n = 7;
                }
                break;
            }
            case 1797162595: {
                if (string.equals("ndarray")) {
                    n = 8;
                }
                break;
            }
            case 2104194820: {
                if (string.equals("Figure")) {
                    n = 9;
                }
                break;
            }
        }
        switch (n) {
            case 8: {
                return "NDArray";
            }
            case 4: {
                return "EagerTensor";
            }
            case 1: {
                return "SparseTensor";
            }
            case 2: {
                return "VariableTensor";
            }
            case 3: {
                return "TorchTensor";
            }
            case 6: {
                return "Image";
            }
            case 7: {
                return "JpegImageFile";
            }
            case 5: {
                return "PngImageFile";
            }
            case 9: {
                return "Figure";
            }
            default: {
                return "Other";
            }
        }
    }

    @NotNull
    public static final String getBufferedImageTypeString(int imageType) {
        return switch (imageType) {
            case 0 -> "TYPE_CUSTOM";
            case 1 -> "TYPE_INT_RGB";
            case 2 -> "TYPE_INT_ARGB";
            case 3 -> "TYPE_INT_ARGB_PRE";
            case 4 -> "TYPE_INT_BGR";
            case 5 -> "TYPE_3BYTE_BGR";
            case 6 -> "TYPE_4BYTE_ABGR";
            case 7 -> "TYPE_4BYTE_ABGR_PRE";
            case 8 -> "TYPE_USHORT_565_RGB";
            case 9 -> "TYPE_USHORT_555_RGB";
            case 10 -> "TYPE_BYTE_GRAY";
            case 11 -> "TYPE_USHORT_GRAY";
            case 12 -> "TYPE_BYTE_BINARY";
            case 13 -> "TYPE_BYTE_INDEXED";
            default -> "UNKNOWN_TYPE";
        };
    }

    @NotNull
    public static final String defineFrameAccessorType(@NotNull String frameAccessor) {
        Intrinsics.checkNotNullParameter((Object)frameAccessor, (String)"frameAccessor");
        if (StringsKt.contains$default((CharSequence)frameAccessor, (CharSequence)"JupyterDebug", (boolean)false, (int)2, null)) {
            return "JupyterDebug";
        }
        if (StringsKt.contains$default((CharSequence)frameAccessor, (CharSequence)"PydevConsole", (boolean)false, (int)2, null)) {
            return "PydevConsole";
        }
        if (StringsKt.contains$default((CharSequence)frameAccessor, (CharSequence)"JupyterVars", (boolean)false, (int)2, null)) {
            return "JupyterVars";
        }
        if (StringsKt.contains$default((CharSequence)frameAccessor, (CharSequence)"PythonDap", (boolean)false, (int)2, null)) {
            return "PythonDap";
        }
        return "Unknown";
    }
}

