/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.run.actions.GridEditAction;
import com.intellij.database.util.DataGridUIUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.actions.DeleteAction;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.util.NlsSafe;
import java.awt.Component;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DeleteActionBase
extends DeleteAction
implements DeleteProvider,
GridEditAction {
    protected DeleteActionBase() {
        super(null, null, AllIcons.General.Remove);
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            DeleteActionBase.$$$reportNull$$$0(0);
        }
        super.update(event);
        DataGrid grid = (DataGrid)event.getData(DatabaseDataKeys.DATA_GRID_KEY);
        if (grid == null) {
            event.getPresentation().setTextWithMnemonic(this.getTemplatePresentation().getTextWithPossibleMnemonic());
        } else {
            int itemsCount = this.itemsCount(grid);
            String text = itemsCount == 1 ? this.text((DataGrid)grid).simpleDelete : this.text((DataGrid)grid).simpleDeletePlural;
            event.getPresentation().setText(text);
        }
        event.getPresentation().setEnabled(grid != null && this.isEnabled(grid));
        event.getPresentation().setVisible(this.isVisible(grid));
    }

    @NotNull
    protected DeleteProvider getDeleteProvider(DataContext dataContext) {
        DeleteActionBase deleteActionBase = this;
        if (deleteActionBase == null) {
            DeleteActionBase.$$$reportNull$$$0(1);
        }
        return deleteActionBase;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            DeleteActionBase.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    public boolean canDeleteElement(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            DeleteActionBase.$$$reportNull$$$0(3);
        }
        DataGrid grid = (DataGrid)DatabaseDataKeys.DATA_GRID_KEY.getData(dataContext);
        Component focusedComponent = (Component)dataContext.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT);
        return grid != null && this.isVisible(grid) && (focusedComponent == null || DataGridUIUtil.isInsideGrid(grid, focusedComponent)) && this.itemsCount(grid) > 0;
    }

    public void deleteElement(@NotNull DataContext dataContext) {
        DataGrid grid;
        if (dataContext == null) {
            DeleteActionBase.$$$reportNull$$$0(4);
        }
        if ((grid = (DataGrid)DatabaseDataKeys.DATA_GRID_KEY.getData(dataContext)) == null) {
            return;
        }
        ModelIndex<GridColumn> column = grid.getContextColumn();
        if (!grid.getDataHookup().isForSingleSource()) {
            return;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && grid.getDataSupport().isSubmitImmediately()) {
            String message;
            int itemsCount = this.itemsCount(grid);
            ActionText text = this.text(grid);
            String title = itemsCount == 1 ? String.format(text.dialogTitlePattern, this.getItemName(grid)) : text.dialogTitlePlural;
            String string = message = itemsCount == 1 ? String.format(text.confirmationPattern, this.getItemName(grid)) : String.format(text.confirmationPluralPattern, itemsCount);
            if (!MessageDialogBuilder.okCancel((String)title, (String)message).ask((Component)grid.getPanel().getComponent())) {
                return;
            }
        }
        this.doDelete(grid, column);
    }

    @NlsSafe
    @NotNull
    protected abstract String getItemName(@NotNull DataGrid var1);

    protected abstract boolean isEnabled(@NotNull DataGrid var1);

    protected abstract void doDelete(@NotNull DataGrid var1, @NotNull ModelIndex<GridColumn> var2);

    protected abstract int itemsCount(@NotNull DataGrid var1);

    @NotNull
    protected abstract ActionText text(@NotNull DataGrid var1);

    protected abstract boolean isVisible(@Nullable DataGrid var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/DeleteActionBase";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/DeleteActionBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeleteProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "canDeleteElement";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "deleteElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }

    protected static class ActionText {
        @Nls(capitalization=Nls.Capitalization.Title)
        final String simpleDelete;
        @Nls(capitalization=Nls.Capitalization.Title)
        final String simpleDeletePlural;
        @Nls(capitalization=Nls.Capitalization.Title)
        final String dialogTitlePattern;
        @Nls(capitalization=Nls.Capitalization.Title)
        final String dialogTitlePlural;
        @Nls(capitalization=Nls.Capitalization.Sentence)
        final String confirmationPattern;
        @Nls(capitalization=Nls.Capitalization.Sentence)
        final String confirmationPluralPattern;

        public ActionText(@Nls(capitalization=Nls.Capitalization.Title) String simpleDelete, @Nls(capitalization=Nls.Capitalization.Title) String simpleDeletePlural, @Nls(capitalization=Nls.Capitalization.Title) String dialogTitlePattern, @Nls(capitalization=Nls.Capitalization.Title) String dialogTitlePlural, @Nls(capitalization=Nls.Capitalization.Sentence) String confirmationPattern, @Nls(capitalization=Nls.Capitalization.Sentence) String confirmationPluralPattern) {
            this.simpleDelete = simpleDelete;
            this.simpleDeletePlural = simpleDeletePlural;
            this.dialogTitlePattern = dialogTitlePattern;
            this.dialogTitlePlural = dialogTitlePlural;
            this.confirmationPattern = confirmationPattern;
            this.confirmationPluralPattern = confirmationPluralPattern;
        }
    }
}

