/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.data.input;

import com.intellij.icons.AllIcons;
import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputCellMetadataKt;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputValuesContributorExtensionPoint;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/jupyter/core/jupyter/data/input/JupyterAttachNewFileAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "editor", "Lcom/intellij/openapi/editor/Editor;", "cell", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterCell;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterCell;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "Util", "intellij.jupyter.core"})
public final class JupyterAttachNewFileAction
extends DumbAwareAction {
    @NotNull
    private final Editor editor;
    @NotNull
    private final JupyterCell cell;

    public JupyterAttachNewFileAction(@NotNull Editor editor, @NotNull JupyterCell cell) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        super(JupyterBundle.message("jupyter.data.input.toolbar.attach.new.file", new Object[0]), null, AllIcons.Actions.Upload);
        this.editor = editor;
        this.cell = cell;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        Util.INSTANCE.attachNewFile$intellij_jupyter_core(project2, this.editor, this.cell);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\fJ\u0013\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0000\u00a2\u0006\u0002\b\u0010J\r\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0013\u00a8\u0006\u0014"}, d2={"Lcom/intellij/jupyter/core/jupyter/data/input/JupyterAttachNewFileAction$Util;", "", "<init>", "()V", "attachNewFile", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "cell", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterCell;", "attachNewFile$intellij_jupyter_core", "getSupportedExtensions", "", "", "getSupportedExtensions$intellij_jupyter_core", "getTableDataFileChooserDescriptor", "Lcom/intellij/openapi/fileChooser/FileChooserDescriptor;", "getTableDataFileChooserDescriptor$intellij_jupyter_core", "intellij.jupyter.core"})
    @SourceDebugExtension(value={"SMAP\nJupyterAttachNewFileAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterAttachNewFileAction.kt\ncom/intellij/jupyter/core/jupyter/data/input/JupyterAttachNewFileAction$Util\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,45:1\n1586#2:46\n1661#2,3:47\n37#3,2:50\n*S KotlinDebug\n*F\n+ 1 JupyterAttachNewFileAction.kt\ncom/intellij/jupyter/core/jupyter/data/input/JupyterAttachNewFileAction$Util\n*L\n36#1:46\n36#1:47,3\n42#1:50,2\n*E\n"})
    public static final class Util {
        @NotNull
        public static final Util INSTANCE = new Util();

        private Util() {
        }

        public final void attachNewFile$intellij_jupyter_core(@NotNull Project project, @NotNull Editor editor, @NotNull JupyterCell cell) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
            Object object = FileChooser.chooseFile((FileChooserDescriptor)this.getTableDataFileChooserDescriptor$intellij_jupyter_core(), (Project)project, null);
            if (object == null || (object = object.toNioPath()) == null) {
                return;
            }
            Object file = object;
            Object object2 = FileDocumentManager.getInstance().getFile(editor.getDocument());
            if (object2 == null || (object2 = object2.toNioPath()) == null) {
                return;
            }
            Object notebookPath = object2;
            Document document = editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            JupyterDataInputCellMetadataKt.setFileInfoUndoable(cell, (Path)file, project, (Path)notebookPath, document);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Set<String> getSupportedExtensions$intellij_jupyter_core() {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = JupyterDataInputValuesContributorExtensionPoint.Companion.getEP_NAME().getExtensionList();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                JupyterDataInputValuesContributorExtensionPoint jupyterDataInputValuesContributorExtensionPoint = (JupyterDataInputValuesContributorExtensionPoint)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getDataFileExtensions());
            }
            return CollectionsKt.toSet((Iterable)CollectionsKt.flatten((Iterable)((List)destination$iv$iv)));
        }

        @NotNull
        public final FileChooserDescriptor getTableDataFileChooserDescriptor$intellij_jupyter_core() {
            Collection $this$toTypedArray$iv = this.getSupportedExtensions$intellij_jupyter_core();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.singleFile().withExtensionFilter(JupyterBundle.message("jupyter.data.input.data.files", new Object[0]), Arrays.copyOf(stringArray, stringArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)fileChooserDescriptor, (String)"withExtensionFilter(...)");
            return fileChooserDescriptor;
        }
    }
}

