/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.nbformat.outputs;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.TextNode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\f\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u00020\u000fH\u0002J\b\u0010\u0013\u001a\u00020\u000fH\u0002J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0018\u001a\u00020\u000fH\u0002J\b\u0010\u0019\u001a\u00020\u000fH\u0002J\b\u0010\u001a\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00060\u0007j\u0002`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/jupyter/core/jupyter/nbformat/outputs/JupyterOutputNewLineProcessor;", "", "jsonArray", "Lcom/fasterxml/jackson/databind/node/ArrayNode;", "<init>", "(Lcom/fasterxml/jackson/databind/node/ArrayNode;)V", "currentLine", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "nextCharPosition", "", "pendingCarriageReturn", "", "modifyingLastLine", "process", "", "text", "", "prepareState", "backspace", "putCharAndCheckForCarriage", "c", "", "putChar", "carriageReturn", "newLine", "flushLine", "intellij.jupyter.core"})
public final class JupyterOutputNewLineProcessor {
    @NotNull
    private final ArrayNode jsonArray;
    @NotNull
    private final StringBuilder currentLine;
    private int nextCharPosition;
    private boolean pendingCarriageReturn;
    private boolean modifyingLastLine;

    public JupyterOutputNewLineProcessor(@NotNull ArrayNode jsonArray) {
        Intrinsics.checkNotNullParameter((Object)jsonArray, (String)"jsonArray");
        this.jsonArray = jsonArray;
        this.currentLine = new StringBuilder();
    }

    public final void process(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.prepareState();
        int n = text.length();
        block5: for (int i = 0; i < n; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '\n': {
                    this.newLine();
                    continue block5;
                }
                case '\r': {
                    this.carriageReturn();
                    continue block5;
                }
                case '\b': {
                    this.backspace();
                    continue block5;
                }
                default: {
                    this.putCharAndCheckForCarriage(c);
                }
            }
        }
        if (this.pendingCarriageReturn) {
            this.putChar('\r');
        }
        this.flushLine();
    }

    private final void prepareState() {
        int size = this.jsonArray.size();
        this.currentLine.setLength(0);
        this.nextCharPosition = 0;
        this.pendingCarriageReturn = false;
        this.modifyingLastLine = false;
        if (size > 0) {
            Character lastChar;
            String lastLine = this.jsonArray.get(size - 1).asText();
            Intrinsics.checkNotNull((Object)lastLine);
            Character c = lastChar = StringsKt.lastOrNull((CharSequence)lastLine);
            char c2 = '\n';
            if (c == null || c.charValue() != c2) {
                this.modifyingLastLine = true;
                this.currentLine.append(lastLine);
                Character c3 = lastChar;
                c2 = '\r';
                if (c3 != null && c3.charValue() == c2) {
                    this.pendingCarriageReturn = true;
                    this.currentLine.deleteCharAt(this.currentLine.length() - 1);
                } else {
                    this.nextCharPosition = this.currentLine.length();
                }
            }
        }
    }

    private final void backspace() {
        if (((CharSequence)this.currentLine).length() > 0) {
            this.currentLine.deleteCharAt(this.currentLine.length() - 1);
            if (this.nextCharPosition > 0) {
                int n = this.nextCharPosition;
                this.nextCharPosition = n + -1;
            }
        }
    }

    private final void putCharAndCheckForCarriage(char c) {
        if (this.pendingCarriageReturn) {
            this.nextCharPosition = 0;
            this.pendingCarriageReturn = false;
        }
        this.putChar(c);
    }

    private final void putChar(char c) {
        if (this.nextCharPosition < this.currentLine.length()) {
            this.currentLine.setCharAt(this.nextCharPosition, c);
        } else {
            this.currentLine.append(c);
        }
        int n = this.nextCharPosition;
        this.nextCharPosition = n + 1;
    }

    private final void carriageReturn() {
        this.pendingCarriageReturn = true;
    }

    private final void newLine() {
        this.nextCharPosition = this.currentLine.length();
        if (this.pendingCarriageReturn) {
            this.pendingCarriageReturn = false;
            this.putChar('\r');
        }
        this.putChar('\n');
        this.flushLine();
    }

    private final void flushLine() {
        String string = this.currentLine.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String line = string;
        if (((CharSequence)line).length() > 0) {
            JsonNode jsonNode = this.modifyingLastLine ? this.jsonArray.set(this.jsonArray.size() - 1, (JsonNode)TextNode.valueOf((String)line)) : (JsonNode)this.jsonArray.add(line);
        }
        this.modifyingLastLine = false;
        this.currentLine.setLength(0);
        this.nextCharPosition = 0;
    }
}

