/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.commons.view;

import com.intellij.microservices.jvm.beans.BeansElementItem;
import com.intellij.microservices.jvm.beans.BeansListItem;
import com.intellij.microservices.jvm.beans.BeansSidePanel;
import com.intellij.microservices.jvm.beans.BeansSidePanelProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiClass;
import com.intellij.spring.data.commons.view.SpringDataPanelProvider;
import com.intellij.spring.data.commons.view.SpringRepositoriesViewSettings;
import com.intellij.spring.data.commons.view.SpringRepositoryMethodPanel;
import com.intellij.spring.data.commons.view.SpringRepositoryStereotype;
import com.intellij.spring.data.utils.SpringDataBundle;
import com.intellij.spring.toolWindow.beans.SpringBeanItem;
import com.intellij.spring.toolWindow.beans.SpringBeansGroup;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/spring/data/commons/view/SpringDataPanelProvider;", "Lcom/intellij/microservices/jvm/beans/BeansSidePanelProvider;", "<init>", "()V", "create", "Lcom/intellij/microservices/jvm/beans/BeansSidePanel;", "project", "Lcom/intellij/openapi/project/Project;", "SpringDataPanel", "intellij.spring.data"})
public final class SpringDataPanelProvider
implements BeansSidePanelProvider {
    @NotNull
    public BeansSidePanel create(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new SpringDataPanel(project);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0016J\u0016\u0010\u0019\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0016J\u001e\u0010\u001a\u001a\u00020\u001b2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u001c\u001a\u00020\u0015H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001d"}, d2={"Lcom/intellij/spring/data/commons/view/SpringDataPanelProvider$SpringDataPanel;", "Lcom/intellij/microservices/jvm/beans/BeansSidePanel;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "mainPanel", "Lcom/intellij/ui/components/JBPanelWithEmptyText;", "disposable", "Lcom/intellij/openapi/Disposable;", "title", "", "getTitle", "()Ljava/lang/String;", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "isAvailable", "", "selectedItems", "", "Lcom/intellij/microservices/jvm/beans/BeansListItem;", "isVisible", "update", "", "isActive", "intellij.spring.data"})
    private static final class SpringDataPanel
    implements BeansSidePanel {
        @NotNull
        private final Project project;
        @NotNull
        private final JBPanelWithEmptyText mainPanel;
        @Nullable
        private Disposable disposable;

        public SpringDataPanel(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
            this.mainPanel = new JBPanelWithEmptyText();
            this.mainPanel.setLayout((LayoutManager)new BorderLayout());
            this.mainPanel.getEmptyText().setText(SpringDataBundle.message("spring.data.repositories.not.found", new Object[0]));
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public String getTitle() {
            String string = SpringDataBundle.message("spring.data.tab.title", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @NotNull
        public JComponent getComponent() {
            return (JComponent)this.mainPanel;
        }

        public boolean isAvailable(@NotNull List<? extends BeansListItem> selectedItems) {
            Intrinsics.checkNotNullParameter(selectedItems, (String)"selectedItems");
            BeansListItem beansListItem = (BeansListItem)CollectionsKt.singleOrNull(selectedItems);
            if (beansListItem == null) {
                return false;
            }
            BeansListItem item = beansListItem;
            if (!(item instanceof BeansElementItem)) {
                return false;
            }
            Object bean = ((BeansElementItem)item).getBean();
            if (!(bean instanceof SpringBeanItem)) {
                return false;
            }
            Object group = ((BeansElementItem)item).getGroup();
            if (!(group instanceof SpringBeansGroup)) {
                return false;
            }
            return ((SpringBeanItem)bean).getStereotype() instanceof SpringRepositoryStereotype;
        }

        public boolean isVisible(@NotNull List<? extends BeansListItem> selectedItems) {
            Intrinsics.checkNotNullParameter(selectedItems, (String)"selectedItems");
            return this.isAvailable(selectedItems);
        }

        public void update(@NotNull List<? extends BeansListItem> selectedItems, boolean isActive) {
            Intrinsics.checkNotNullParameter(selectedItems, (String)"selectedItems");
            this.mainPanel.removeAll();
            if (this.disposable != null) {
                Disposable disposable = this.disposable;
                Intrinsics.checkNotNull((Object)disposable);
                Disposer.dispose((Disposable)disposable);
                this.disposable = null;
            }
            if (!isActive) {
                return;
            }
            BeansListItem beansListItem = (BeansListItem)CollectionsKt.singleOrNull(selectedItems);
            if (beansListItem == null) {
                return;
            }
            BeansListItem item = beansListItem;
            if (!(item instanceof BeansElementItem)) {
                return;
            }
            Object bean = ((BeansElementItem)item).getBean();
            if (!(bean instanceof SpringBeanItem)) {
                return;
            }
            Object group = ((BeansElementItem)item).getGroup();
            if (!(group instanceof SpringBeansGroup)) {
                return;
            }
            if (!(((SpringBeanItem)bean).getStereotype() instanceof SpringRepositoryStereotype)) {
                return;
            }
            PsiClass psiClass = ((SpringBeanItem)bean).getPointer().getBeanClass();
            if (psiClass == null) {
                return;
            }
            PsiClass beanClass = psiClass;
            Project project = this.project;
            SpringRepositoryMethodPanel panel2 = new SpringRepositoryMethodPanel(beanClass, project){

                protected AnAction[] getCustomListActions() {
                    AnAction anAction = ActionManager.getInstance().getAction("SpringRepositoryViewShowMembers");
                    if (anAction == null) {
                        Intrinsics.checkNotNullExpressionValue((Object)AnAction.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
                        return AnAction.EMPTY_ARRAY;
                    }
                    AnAction showMembersAction = anAction;
                    AnAction[] anActionArray = new AnAction[]{showMembersAction};
                    return anActionArray;
                }
            };
            MessageBusConnection messageBusConnection = this.project.getMessageBus().connect((Disposable)panel2);
            Topic<SpringRepositoriesViewSettings.Listener> topic = SpringRepositoriesViewSettings.TOPIC;
            Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
            messageBusConnection.subscribe(topic, arg_0 -> SpringDataPanel.update$lambda$0(panel2, arg_0));
            this.disposable = (Disposable)panel2;
            Disposer.register((Disposable)((Disposable)this.project), (Disposable)((Disposable)panel2));
            this.mainPanel.add((Component)((Object)panel2), (Object)"Center");
            panel2.initPanel();
            this.mainPanel.revalidate();
            this.mainPanel.repaint();
        }

        private static final void update$lambda$0(update.panel.1 $panel, SpringRepositoriesViewSettings.ChangeType changeType) {
            Intrinsics.checkNotNullParameter((Object)((Object)changeType), (String)"changeType");
            if (WhenMappings.$EnumSwitchMapping$0[changeType.ordinal()] != 1) {
                throw new NoWhenBranchMatchedException();
            }
            $panel.updatePanel();
        }

        @Metadata(mv={2, 3, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[SpringRepositoriesViewSettings.ChangeType.values().length];
                try {
                    nArray[SpringRepositoriesViewSettings.ChangeType.UPDATE_LIST.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

