/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.utils;

import com.intellij.jpa.jpb.model.backend.ds.DataSourceLoader;
import com.intellij.jpa.jpb.model.core.model.AbstractRdbmsStore;
import com.intellij.jpa.jpb.model.model.CustomDataStore;
import com.intellij.jpa.jpb.model.orm.ep.OrmUnitsProvider;
import com.intellij.jpa.jpb.model.orm.jpa.JpaOrmFramework;
import com.intellij.jpa.jpb.model.orm.model.OrmFramework;
import com.intellij.jpa.jpb.model.orm.model.OrmUnit;
import com.intellij.jpa.jpb.model.orm.model.SpringDataOrmFramework;
import com.intellij.jpa.jpb.model.util.DependenciesUtils;
import com.intellij.jpa.jpb.model.util.PsiUtilsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.spring.data.jdbc.orm.SpringDataJdbcOrmFramework;
import com.intellij.spring.data.utils.SpringDataOrmUtil$getAssociatedDataSourceIds$;
import com.intellij.spring.model.SpringDataSourceInfoProvider;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u00112\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/spring/data/utils/SpringDataOrmUtil;", "", "<init>", "()V", "MONGODB_ORM_FRAMEWORK_NAME", "", "getAssociatedDataSourceIds", "ormUnit", "Lcom/intellij/jpa/jpb/model/orm/model/OrmUnit;", "isMongoDbFramework", "", "ormFramework", "Lcom/intellij/jpa/jpb/model/orm/model/OrmFramework;", "getRepositoryMethodOrmFramework", "uMethod", "Lorg/jetbrains/uast/UMethod;", "getQueryAnnotationFqns", "", "intellij.spring.data"})
@SourceDebugExtension(value={"SMAP\nSpringDataOrmUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringDataOrmUtil.kt\ncom/intellij/spring/data/utils/SpringDataOrmUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,100:1\n1#2:101\n479#3:102\n614#3:103\n1807#4,3:104\n296#4,2:107\n296#4,2:109\n*S KotlinDebug\n*F\n+ 1 SpringDataOrmUtil.kt\ncom/intellij/spring/data/utils/SpringDataOrmUtil\n*L\n40#1:102\n45#1:103\n41#1:104,3\n68#1:107,2\n79#1:109,2\n*E\n"})
public final class SpringDataOrmUtil {
    @NotNull
    public static final SpringDataOrmUtil INSTANCE = new SpringDataOrmUtil();
    @NotNull
    private static final String MONGODB_ORM_FRAMEWORK_NAME = "SpringDataMongodbOrmFramework";

    private SpringDataOrmUtil() {
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String getAssociatedDataSourceIds(@NotNull OrmUnit ormUnit) {
        AbstractRdbmsStore abstractRdbmsStore;
        Intrinsics.checkNotNullParameter((Object)ormUnit, (String)"ormUnit");
        if (!(ormUnit.getOrmFramework() instanceof SpringDataOrmFramework)) {
            return null;
        }
        Module module = ormUnit.getModule();
        if (module == null) {
            return null;
        }
        Module module2 = module;
        String string = ormUnit.getDefaultDataSourceId();
        if (string != null) {
            String it = string;
            boolean bl = false;
            Project project = module2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            abstractRdbmsStore = DataSourceLoader.Companion.getInstance(project).findDataStoreById(it);
        } else {
            abstractRdbmsStore = null;
        }
        AbstractRdbmsStore explicitDataSource = abstractRdbmsStore;
        for (SpringDataSourceInfoProvider provider : SpringDataSourceInfoProvider.Companion.getEP_NAME().getExtensionList()) {
            void $this$sortedBy$iv;
            Sequence $this$filterIsInstance$iv;
            if (!provider.isAboveExplicit() && explicitDataSource != null) continue;
            List ids = provider.getModuleDataSourceIds(module2);
            if (!((Collection)ids).isEmpty()) {
                return (String)CollectionsKt.firstOrNull((List)ids);
            }
            List urls = provider.getModuleDataSourceUrls(module2);
            if (urls.isEmpty()) continue;
            Project project = module2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Sequence sequence = CollectionsKt.asSequence((Iterable)DataSourceLoader.Companion.getInstance(project).getCustomDataStores());
            boolean $i$f$filterIsInstance = false;
            Sequence sequence2 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)getAssociatedDataSourceIds$$inlined$filterIsInstance$1.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence2, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            $this$filterIsInstance$iv = SequencesKt.filter((Sequence)sequence2, arg_0 -> SpringDataOrmUtil.getAssociatedDataSourceIds$lambda$1(urls, arg_0));
            boolean $i$f$sortedBy = false;
            ids = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    CustomDataStore it = (CustomDataStore)a;
                    boolean bl = false;
                    boolean bl2 = !it.isImported();
                    it = (CustomDataStore)b;
                    Comparable comparable = Boolean.valueOf(bl2);
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Boolean.valueOf(!it.isImported()));
                }
            }), SpringDataOrmUtil::getAssociatedDataSourceIds$lambda$3));
            if (ids.size() != 1) continue;
            return (String)CollectionsKt.first((List)ids);
        }
        AbstractRdbmsStore abstractRdbmsStore2 = explicitDataSource;
        return abstractRdbmsStore2 != null ? abstractRdbmsStore2.getId() : null;
    }

    public final boolean isMongoDbFramework(@NotNull OrmFramework ormFramework) {
        Intrinsics.checkNotNullParameter((Object)ormFramework, (String)"ormFramework");
        return Intrinsics.areEqual((Object)ormFramework.getClass().getSimpleName(), (Object)MONGODB_ORM_FRAMEWORK_NAME);
    }

    @Nullable
    public final OrmFramework getRepositoryMethodOrmFramework(@NotNull UMethod uMethod) {
        Intrinsics.checkNotNullParameter((Object)uMethod, (String)"uMethod");
        UClass uClass = UastUtils.getContainingUClass((UElement)((UElement)uMethod));
        if (uClass == null || (uClass = uClass.getSourcePsi()) == null) {
            return (OrmFramework)JpaOrmFramework.INSTANCE;
        }
        UClass repositoryOriginalClass = uClass;
        return (OrmFramework)CachedValuesManager.getCachedValue((PsiElement)repositoryOriginalClass, () -> SpringDataOrmUtil.getRepositoryMethodOrmFramework$lambda$0((PsiElement)repositoryOriginalClass));
    }

    @NotNull
    public final List<String> getQueryAnnotationFqns(@NotNull OrmFramework ormFramework) {
        Intrinsics.checkNotNullParameter((Object)ormFramework, (String)"ormFramework");
        if (!(ormFramework instanceof SpringDataOrmFramework)) {
            throw new IllegalArgumentException("Not SpringDataOrmFramework: " + ormFramework);
        }
        if (this.isMongoDbFramework(ormFramework)) {
            return CollectionsKt.listOf((Object)"org.springframework.data.mongodb.repository.Query");
        }
        if (ormFramework instanceof JpaOrmFramework) {
            Object[] objectArray = new String[]{"org.springframework.data.jpa.repository.Query", "org.springframework.data.jpa.repository.NativeQuery"};
            return CollectionsKt.listOf((Object[])objectArray);
        }
        return CollectionsKt.listOf((Object)"org.springframework.data.jdbc.repository.query.Query");
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean getAssociatedDataSourceIds$lambda$1(List $urls, CustomDataStore dataStore) {
        boolean bl;
        block5: {
            Iterable $this$any$iv;
            block6: {
                Intrinsics.checkNotNullParameter((Object)dataStore, (String)"dataStore");
                $this$any$iv = $urls;
                boolean $i$f$any = false;
                if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) break block6;
                bl = false;
                break block5;
            }
            for (Object element$iv : $this$any$iv) {
                String string;
                String string2;
                block8: {
                    String url;
                    block7: {
                        void it;
                        String dataStoreUrl;
                        url = (String)element$iv;
                        boolean bl2 = false;
                        String string3 = dataStore.getDbProperties().getUrlWithoutParams();
                        if (string3 == null) {
                            string3 = dataStore.getDbProperties().getUrl();
                        }
                        string2 = dataStoreUrl = string3;
                        string = dataStore.getDbProperties().getType().getStartSeparator();
                        if (string == null) break block7;
                        String string4 = string;
                        String string5 = string2;
                        boolean bl3 = false;
                        String string6 = StringsKt.substringBefore$default((String)url, (String)it, null, (int)2, null);
                        string2 = string5;
                        string = string6;
                        if (string6 != null) break block8;
                    }
                    string = url;
                }
                if (!Intrinsics.areEqual((Object)string2, (Object)string)) continue;
                bl = true;
                break block5;
            }
            bl = false;
        }
        return bl;
    }

    private static final String getAssociatedDataSourceIds$lambda$3(CustomDataStore it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getId();
    }

    private static final CachedValueProvider.Result getRepositoryMethodOrmFramework$lambda$0(PsiElement $repositoryOriginalClass) {
        Object object;
        PsiClass repositoryClass;
        Object[] objectArray;
        Object object2 = $repositoryOriginalClass instanceof PsiClass ? (PsiClass)$repositoryOriginalClass : null;
        if (object2 == null) {
            UElement uElement = UastContextKt.toUElement((PsiElement)$repositoryOriginalClass);
            objectArray = uElement != null ? uElement.getJavaPsi() : null;
            object2 = objectArray instanceof PsiClass ? (PsiClass)objectArray : null;
        }
        if ((repositoryClass = object2) == null) {
            object = (OrmFramework)JpaOrmFramework.INSTANCE;
        } else if (InheritanceUtil.isInheritor((PsiClass)repositoryClass, (String)"org.springframework.data.jpa.repository.JpaRepository")) {
            object = (OrmFramework)JpaOrmFramework.INSTANCE;
        } else if (InheritanceUtil.isInheritor((PsiClass)repositoryClass, (String)"org.springframework.data.mongodb.repository.MongoRepository")) {
            Object v3;
            block12: {
                Iterable $this$firstOrNull$iv = OrmUnitsProvider.Companion.getEP_NAME().getExtensionList();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    OrmUnitsProvider it = (OrmUnitsProvider)element$iv;
                    boolean bl = false;
                    if (!INSTANCE.isMongoDbFramework(it.getFramework())) continue;
                    v3 = element$iv;
                    break block12;
                }
                v3 = null;
            }
            objectArray = v3;
            object = objectArray != null ? objectArray.getFramework() : null;
        } else {
            Project project = repositoryClass.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            Module module = PsiUtilsKt.module((PsiElement)$repositoryOriginalClass);
            if (DependenciesUtils.INSTANCE.isJpaProject(project2, module)) {
                object = (OrmFramework)JpaOrmFramework.INSTANCE;
            } else {
                Object v5;
                block13: {
                    Iterable $this$firstOrNull$iv = OrmUnitsProvider.Companion.getEP_NAME().getExtensionList();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        OrmUnitsProvider it = (OrmUnitsProvider)element$iv;
                        boolean bl = false;
                        if (!(Intrinsics.areEqual((Object)it.getFramework().getClass().getName(), (Object)MONGODB_ORM_FRAMEWORK_NAME) && (module == null || it.isFrameworkPresent(module)))) continue;
                        v5 = element$iv;
                        break block13;
                    }
                    v5 = null;
                }
                OrmUnitsProvider ormUnitsProvider = v5;
                OrmFramework mongoDbFramework = ormUnitsProvider != null ? ormUnitsProvider.getFramework() : null;
                object = mongoDbFramework;
                if (object == null) {
                    object = SpringDataJdbcOrmFramework.INSTANCE;
                }
            }
        }
        OrmFramework result = object;
        objectArray = new Object[]{$repositoryOriginalClass};
        return CachedValueProvider.Result.create((Object)result, (Object[])objectArray);
    }
}

