/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.generator;

import com.intellij.database.dialects.base.generator.AbstractCodeGeneratorKt;
import com.intellij.database.dialects.base.generator.Effect;
import com.intellij.database.dialects.base.generator.EffectType;
import com.intellij.database.dialects.base.generator.Node;
import com.intellij.database.dialects.base.generator.ObjectPathTrie;
import com.intellij.database.dialects.base.generator.Operation;
import com.intellij.database.dialects.base.generator.OperationType;
import com.intellij.database.dialects.base.generator.Producer;
import com.intellij.database.dialects.base.generator.RequiredEffect;
import com.intellij.database.dialects.base.generator.Scenario;
import com.intellij.database.dialects.base.generator.ScenarioOperations;
import com.intellij.database.dialects.base.generator.ScriptGeneratorHelper;
import com.intellij.database.dialects.base.generator.ScriptingContext;
import com.intellij.database.dialects.base.generator.ScriptingFun;
import com.intellij.database.dialects.base.generator.producers.SearchPathProducer;
import com.intellij.database.model.DataType;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.script.generator.AutoNeverAlways;
import com.intellij.database.script.generator.CodeTextBuilder;
import com.intellij.database.script.generator.ScriptConsumer;
import com.intellij.database.script.generator.ScriptLocus;
import com.intellij.database.script.generator.ScriptingOptionStatic;
import com.intellij.database.types.DasType;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.FilteredTraverserBase;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.TreeTraversal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.time.TimeSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 Z2\u00020\u0001:\u0003Z[\\B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0015\u001a\u00020\u0016H&J\u0013\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u0018H \u00a2\u0006\u0002\b\u0019J\b\u0010\u001a\u001a\u00020\u0016H\u0017J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001c\u001a\u00020\u0010H\u0017J\b\u0010\u001d\u001a\u00020\u0016H\u0016J\b\u0010\u001e\u001a\u00020\u0016H\u0016J\b\u0010\u001f\u001a\u00020\u0016H\u0002J\u0016\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00050\u0018H\u0014J\b\u0010#\u001a\u00020!H\u0014J\u0016\u0010$\u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00050\u0018H\u0002J\u0016\u0010%\u001a\u00020&2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00050\u0018H\u0002J3\u0010'\u001a\u00020\u00162\u0006\u0010(\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u00052\u0018\u0010*\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00160+H\u0082\bJ\u000e\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u0018H\u0016J\u0010\u0010.\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0018H\u0002J\b\u0010/\u001a\u00020\u0016H\u0002J\b\u00100\u001a\u00020\u0016H\u0002J&\u00101\u001a\u00020\u00162\u0006\u00102\u001a\u00020\u00052\u0014\u0010\u000e\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0012\u0004\u0012\u00020\u00050\u000fH\u0002J*\u00103\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0012\u0004\u0012\u00020\u00050\u000f\"\u0004\b\u0000\u001042\f\u00105\u001a\b\u0012\u0004\u0012\u0002H406H\u0002J\u000e\u00107\u001a\u00020\u00162\u0006\u00108\u001a\u00020\u0005J\u0006\u00107\u001a\u00020\u0016J\b\u00109\u001a\u00020!H\u0014J,\u0010:\u001a\u00020\u00162\n\b\u0002\u0010;\u001a\u0004\u0018\u00010<2\b\b\u0002\u0010=\u001a\u00020!2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00160?H\u0004J%\u0010@\u001a\u00020\u00162\u001b\u0010>\u001a\u0017\u0012\b\u0012\u00060AR\u00020\u0003\u0012\u0004\u0012\u00020\u00160\u000f\u00a2\u0006\u0002\bBH\u0004J\u0006\u0010C\u001a\u00020\u0016J\u0010\u0010C\u001a\u00020\u00162\u0006\u0010D\u001a\u00020EH\u0002J\u001c\u0010F\u001a\u0004\u0018\u00010G2\u0006\u0010H\u001a\u00020\u00102\n\b\u0002\u0010I\u001a\u0004\u0018\u00010GJ\u0018\u0010J\u001a\u00020G*\u00020\u00102\n\b\u0002\u0010K\u001a\u0004\u0018\u00010GH\u0004J\u0012\u0010L\u001a\u00020!2\b\u0010M\u001a\u0004\u0018\u00010GH\u0002J\u000e\u0010N\u001a\u00020G2\u0006\u0010O\u001a\u00020PJ\b\u0010Q\u001a\u00020\u000bH\u0007J\r\u0010\f\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\bRJ(\u0010S\u001a\u00060AR\u00020\u0003*\u00060AR\u00020\u00032\b\u0010T\u001a\u0004\u0018\u00010U2\b\u0010V\u001a\u0004\u0018\u00010GH\u0004J(\u0010W\u001a\u00060AR\u00020\u0003*\u00060AR\u00020\u00032\b\u0010X\u001a\u0004\u0018\u00010Y2\b\u0010V\u001a\u0004\u0018\u00010GH\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001e\u0010\u000e\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u0012X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006]"}, d2={"Lcom/intellij/database/dialects/base/generator/AbstractCodeGenerator;", "", "context", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "rootOp", "Lcom/intellij/database/dialects/base/generator/Operation;", "<init>", "(Lcom/intellij/database/dialects/base/generator/ScriptingContext;Lcom/intellij/database/dialects/base/generator/Operation;)V", "getContext", "()Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "scenario", "Lcom/intellij/database/dialects/base/generator/Scenario;", "getScenario", "()Lcom/intellij/database/dialects/base/generator/Scenario;", "outputFactory", "Lkotlin/Function1;", "Lcom/intellij/database/model/basic/BasicElement;", "builder", "Lcom/intellij/database/script/generator/CodeTextBuilder;", "getBuilder", "()Lcom/intellij/database/script/generator/CodeTextBuilder;", "prepareScenario", "", "preparedOperations", "", "preparedOperations$intellij_database_dialects_base", "clear", "makeOperation", "element", "resolve", "transform", "breakCycles", "breakCycle", "", "cycle", "preferForward", "breakByEdge", "findCycleMin", "", "forEachEdge", "op1", "op2", "action", "Lkotlin/Function2;", "getEdgeFixers", "Lcom/intellij/database/dialects/base/generator/AbstractCodeGenerator$EdgeFixer;", "findCycle", "groupBySearchPath", "prepareOutput", "wrapProducers", "root", "createOutputFactory", "T", "consumer", "Lcom/intellij/database/script/generator/ScriptConsumer;", "produce", "op", "isNewCodeGen", "coding", "locus", "Lcom/intellij/database/script/generator/ScriptLocus;", "indent", "block", "Lkotlin/Function0;", "newCoding", "Lcom/intellij/database/dialects/base/generator/ScriptingContext$NewCodingAdapter;", "Lkotlin/ExtensionFunctionType;", "flush", "statement", "Lcom/intellij/database/model/properties/CompositeText;", "quote", "", "e", "name", "currentScopeName", "renameScr", "useSchemaName", "schemaName", "script", "d", "Lcom/intellij/database/types/DasType;", "getInternalScenario", "getScenario$intellij_database_dialects_base", "alterTable", "table", "Lcom/intellij/database/model/basic/BasicLikeTable;", "scrName", "alterColumn", "c", "Lcom/intellij/database/model/basic/BasicLikeColumn;", "Companion", "EdgeFixer", "SinkProducer", "intellij.database.dialects.base"})
@SourceDebugExtension(value={"SMAP\nAbstractCodeGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractCodeGenerator.kt\ncom/intellij/database/dialects/base/generator/AbstractCodeGenerator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 ScriptingContext.kt\ncom/intellij/database/dialects/base/generator/ScriptingContext$NewCodingAdapter\n*L\n1#1,523:1\n150#1,2:538\n152#1,2:541\n154#1:545\n155#1,2:547\n1#2:524\n1915#3:525\n1915#3:526\n1916#3:534\n1916#3:535\n1915#3,2:536\n1915#3:540\n1915#3,2:543\n1916#3:546\n1915#3,2:549\n1915#3:551\n1915#3,2:552\n1916#3:554\n1915#3:555\n1915#3,2:556\n1916#3:558\n1512#3:559\n1538#3,3:560\n1541#3,3:570\n1915#3,2:573\n383#4,7:527\n383#4,7:563\n383#4,7:592\n241#5,8:575\n254#5:583\n241#5,8:584\n*S KotlinDebug\n*F\n+ 1 AbstractCodeGenerator.kt\ncom/intellij/database/dialects/base/generator/AbstractCodeGenerator\n*L\n126#1:538,2\n126#1:541,2\n126#1:545\n126#1:547,2\n73#1:525\n74#1:526\n74#1:534\n73#1:535\n79#1:536,2\n126#1:540\n127#1:543,2\n126#1:546\n143#1:549,2\n151#1:551\n152#1:552,2\n151#1:554\n163#1:555\n172#1:556,2\n163#1:558\n184#1:559\n184#1:560,3\n184#1:570,3\n190#1:573,2\n75#1:527,7\n184#1:563,7\n223#1:592,7\n341#1:575,8\n344#1:583\n344#1:584,8\n*E\n"})
public abstract class AbstractCodeGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ScriptingContext context;
    @NotNull
    private final Scenario scenario;
    @Nullable
    private final Function1<BasicElement, Operation> outputFactory;
    @NotNull
    private final CodeTextBuilder builder;
    @NotNull
    private static final OperationType ROOT = new OperationType("root");
    @NotNull
    private static final OperationType SINK = new OperationType("text sink");
    @NotNull
    private static final OperationType ERROR = new OperationType("error");
    @NotNull
    private static final OperationType GRANT = new OperationType("grant");
    @NotNull
    private static final OperationType SEARCH_PATH = new OperationType("search_path");
    @NotNull
    private static final Logger LOG;
    private static boolean ignoreFormatting;
    @Nullable
    private static TimeSource.Monotonic.ValueTimeMark lastReportedCycle;

    /*
     * WARNING - void declaration
     */
    public AbstractCodeGenerator(@NotNull ScriptingContext context, @Nullable Operation rootOp) {
        Function1<BasicElement, Operation> function1;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        Operation operation = rootOp;
        if (operation == null) {
            operation = AbstractCodeGeneratorKt.createRootOperation(this.context);
        }
        this.scenario = new Scenario(operation);
        AbstractCodeGenerator abstractCodeGenerator = this;
        ScriptConsumer scriptConsumer = this.context.getTask().getConsumer();
        if (scriptConsumer != null) {
            void it;
            ScriptConsumer scriptConsumer2 = scriptConsumer;
            AbstractCodeGenerator abstractCodeGenerator2 = abstractCodeGenerator;
            boolean bl = false;
            function1 = this.createOutputFactory((ScriptConsumer)it);
            abstractCodeGenerator = abstractCodeGenerator2;
        } else {
            function1 = null;
        }
        abstractCodeGenerator.outputFactory = function1;
        this.builder = this.context.getBuilder();
    }

    public /* synthetic */ AbstractCodeGenerator(ScriptingContext scriptingContext, Operation operation, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            operation = null;
        }
        this(scriptingContext, operation);
    }

    @NotNull
    public final ScriptingContext getContext() {
        return this.context;
    }

    @NotNull
    protected final Scenario getScenario() {
        return this.scenario;
    }

    @NotNull
    protected final CodeTextBuilder getBuilder() {
        return this.builder;
    }

    public abstract void prepareScenario();

    @NotNull
    public abstract List<Operation> preparedOperations$intellij_database_dialects_base();

    @TestOnly
    public void clear() {
    }

    @TestOnly
    @Nullable
    public Operation makeOperation(@NotNull BasicElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void resolve() {
        HashMap effects = new HashMap();
        ObjectPathTrie trie = new ObjectPathTrie();
        JBIterable jBIterable = this.scenario.traverse().bfsTraversal();
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"bfsTraversal(...)");
        JBIterable operations = jBIterable;
        Iterable $this$forEach$iv = (Iterable)operations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Operation it = (Operation)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = it.getEffects();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Object object;
                void $this$getOrPut$iv;
                Effect e = (Effect)element$iv2;
                boolean bl2 = false;
                Map map = effects;
                EffectType key$iv = e.getType();
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get((Object)key$iv);
                if (value$iv == null) {
                    MultiMap answer$iv;
                    boolean bl3 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)MultiMap.create(), (String)"create(...)");
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((MultiMap)object).putValue((Object)e.getTarget(), (Object)it);
                trie.add(e.getTarget());
            }
        }
        $this$forEach$iv = (Iterable)operations;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JBIterable req2;
            Operation op = (Operation)element$iv;
            boolean bl = false;
            op.unlinkAll();
            Intrinsics.checkNotNullExpressionValue((Object)JBIterable.from((Iterable)op.getRequires()).flatten(arg_0 -> AbstractCodeGenerator.resolve$lambda$1$1(arg_0 -> AbstractCodeGenerator.resolve$lambda$1$0(effects, trie, arg_0), arg_0)), (String)"flatten(...)");
            op.link((Iterable)req2);
        }
    }

    public void transform() {
        this.groupBySearchPath();
        this.prepareOutput();
        this.breakCycles();
    }

    private final void breakCycles() {
        List<Operation> cycle;
        do {
            if (this.findCycle() != null) continue;
            return;
        } while (this.breakCycle(cycle));
    }

    protected boolean breakCycle(@NotNull List<Operation> cycle) {
        Intrinsics.checkNotNullParameter(cycle, (String)"cycle");
        return this.breakByEdge(cycle);
    }

    protected boolean preferForward() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean breakByEdge(List<Operation> cycle) {
        int size;
        int s = this.findCycleMin(cycle);
        Object t = ((Operation)CollectionsKt.first(cycle)).getParent();
        Intrinsics.checkNotNull(t);
        Operation root = (Operation)t;
        List<EdgeFixer> fixers = this.getEdgeFixers();
        if (fixers.isEmpty()) {
            return false;
        }
        for (int i = size = cycle.size(); i >= 0; --i) {
            void op1$iv;
            int p = s + i + size;
            Operation cur = cycle.get(p % size);
            Operation next = cycle.get((p + 1) % size);
            boolean fwOnly = i == 0;
            boolean bkOnly = i == size;
            AbstractCodeGenerator abstractCodeGenerator = this;
            Operation operation = cur;
            Operation op2$iv = next;
            boolean $i$f$forEachEdge = false;
            Collection collection = ScenarioOperations.traverse((Operation)op1$iv).traverse().addAllTo((Collection)new HashSet());
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"addAllTo(...)");
            HashSet targets$iv = (HashSet)collection;
            Iterable $this$forEach$iv$iv = (Iterable)ScenarioOperations.traverse(op2$iv);
            boolean $i$f$forEach = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                Operation so2$iv = (Operation)element$iv$iv;
                boolean bl = false;
                Iterable $this$forEach$iv$iv2 = so2$iv.getPreceders();
                boolean $i$f$forEach2 = false;
                for (Object element$iv$iv2 : $this$forEach$iv$iv2) {
                    Operation so1$iv = (Operation)element$iv$iv2;
                    boolean bl2 = false;
                    if (!targets$iv.contains(so1$iv)) continue;
                    Intrinsics.checkNotNull((Object)so2$iv);
                    Operation operation2 = so2$iv;
                    Operation so1 = so1$iv;
                    boolean bl3 = false;
                    Iterable $this$forEach$iv = fixers;
                    boolean $i$f$forEach3 = false;
                    for (Object element$iv : $this$forEach$iv) {
                        void so2;
                        EdgeFixer it = (EdgeFixer)element$iv;
                        boolean bl4 = false;
                        if (fwOnly && it.isBackward() || bkOnly && !it.isBackward() || !it.fix(root, so1, (Operation)so2, this.outputFactory)) continue;
                        if (it.requiresResolve()) {
                            this.resolve();
                        }
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final int findCycleMin(List<Operation> cycle) {
        Comparator cmp = AbstractCodeGeneratorKt.access$createPreOrderComparator();
        int mini = 0;
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)1, (int)cycle.size());
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int it = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            if (cmp.compare(cycle.get(mini), cycle.get(it)) <= 0) continue;
            mini = it;
        }
        return mini;
    }

    private final void forEachEdge(Operation op1, Operation op2, Function2<? super Operation, ? super Operation, Unit> action) {
        boolean $i$f$forEachEdge = false;
        Collection collection = ScenarioOperations.traverse(op1).traverse().addAllTo((Collection)new HashSet());
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"addAllTo(...)");
        HashSet targets = (HashSet)collection;
        Iterable $this$forEach$iv = (Iterable)ScenarioOperations.traverse(op2);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Operation so2 = (Operation)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = so2.getPreceders();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Operation so1 = (Operation)element$iv2;
                boolean bl2 = false;
                if (!targets.contains(so1)) continue;
                Intrinsics.checkNotNull((Object)so2);
                action.invoke((Object)so1, (Object)so2);
            }
        }
    }

    @NotNull
    public List<EdgeFixer> getEdgeFixers() {
        return CollectionsKt.emptyList();
    }

    private final List<Operation> findCycle() {
        HashSet<Operation> visited = new HashSet<Operation>();
        FilteredTraverserBase filteredTraverserBase = ScenarioOperations.traversePreceders().expandAndFilter(arg_0 -> AbstractCodeGenerator.findCycle$lambda$1(arg_0 -> AbstractCodeGenerator.findCycle$lambda$0(visited, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)filteredTraverserBase, (String)"expandAndFilter(...)");
        JBTreeTraverser traverser = (JBTreeTraverser)filteredTraverserBase;
        JBIterable jBIterable = this.scenario.traverse().bfsTraversal().filter(arg_0 -> AbstractCodeGenerator.findCycle$lambda$3(arg_0 -> AbstractCodeGenerator.findCycle$lambda$2(visited, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
        Iterable $this$forEach$iv = (Iterable)jBIterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Operation root = (Operation)element$iv;
            boolean bl = false;
            Iterator iterator = ((JBTreeTraverser)traverser.withRoot((Object)root)).biOrderDfsTraversal().typedIterator();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"typedIterator(...)");
            TreeTraversal.TracingIt it = (TreeTraversal.TracingIt)iterator;
            while (it.advance()) {
                Operation op = (Operation)it.current();
                op.setIncidence(op.getIncidence() + (it.isDescending() ? 1 : -1));
                if (!it.isDescending()) {
                    visited.add(op);
                }
                if (op.getIncidence() < 2) continue;
                LinkedList<Operation> res = new LinkedList<Operation>();
                boolean add = false;
                add = true;
                JBIterable jBIterable2 = it.backtrace();
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"backtrace(...)");
                Iterable $this$forEach$iv2 = (Iterable)jBIterable2;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Operation it2 = (Operation)element$iv2;
                    boolean bl2 = false;
                    it2.setIncidence(0);
                    if (add) {
                        boolean bl3 = add = res.isEmpty() || !Intrinsics.areEqual((Object)it2, (Object)op);
                    }
                    if (!add) continue;
                    res.add(it2);
                }
                return res;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final void groupBySearchPath() {
        void $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = this.scenario.getRoot().getNestedOperations();
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            void $this$getOrPut$iv$iv$iv;
            Operation it = (Operation)element$iv$iv;
            boolean bl = false;
            SearchPath key$iv$iv = this.context.getHelper().requiredSearchPath(it.getProducer());
            Map map = destination$iv$iv;
            SearchPath key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map byPath = destination$iv$iv;
        for (Map.Entry entry : byPath.entrySet()) {
            Object object;
            SearchPath path = (SearchPath)entry.getKey();
            List ops = (List)entry.getValue();
            if (path == null) continue;
            if (path.elements.size() == 1) {
                String string = path.getCurrent().name;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
                if (((CharSequence)string).length() == 0) continue;
            }
            if ((object = this.context.getHelper().createSearchPathGroup(this.context, path)) == null || (object = ((SearchPathProducer)object).register(this.scenario.getRoot())) == null) continue;
            Object gr = object;
            boolean bl = false;
            Iterable $this$forEach$iv = ops;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Operation it = (Operation)element$iv;
                boolean bl3 = false;
                it.setParent((Node)gr);
            }
        }
    }

    private final void prepareOutput() {
        Function1<BasicElement, Operation> outputFactory = this.outputFactory;
        if (outputFactory != null) {
            this.wrapProducers(this.scenario.getRoot(), outputFactory);
        } else {
            Operation sink = new Operation(new SinkProducer<Object>(this.context, null, null));
            sink.stealChildrenFrom((Node)this.scenario.getRoot());
            sink.setParent((Node)this.scenario.getRoot());
        }
    }

    private final void wrapProducers(Operation root, Function1<? super BasicElement, Operation> outputFactory) {
        for (Operation op : CollectionsKt.toMutableList((Collection)root.getNestedOperations())) {
            BasicElement element = ScenarioOperations.element(op);
            if (element == null) {
                this.wrapProducers(op, outputFactory);
                continue;
            }
            op.setParent((Node)outputFactory.invoke((Object)element));
        }
    }

    private final <T> Function1<BasicElement, Operation> createOutputFactory(ScriptConsumer<T> consumer) {
        HashMap sinks = new HashMap();
        return arg_0 -> AbstractCodeGenerator.createOutputFactory$lambda$0(sinks, consumer, this, arg_0);
    }

    public final void produce(@NotNull Operation op) {
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        op.getProducer().produce();
    }

    public final void produce() {
        this.produce(this.scenario.getRoot());
    }

    protected boolean isNewCodeGen() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void coding(@Nullable ScriptLocus locus, boolean indent, @NotNull Function0<Unit> block) {
        boolean complete;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        ScriptLocus oldContext = this.context.getLocus();
        ScriptLocus scriptLocus = locus;
        if (scriptLocus == null) {
            scriptLocus = oldContext == ScriptLocus.OUTSIDE ? ScriptLocus.IN_STATEMENT : oldContext;
        }
        ScriptLocus newContext = scriptLocus;
        CodeTextBuilder.IndentationState savedIndentation = this.builder.getCurrentIndentationState();
        try {
            this.context.setLocus(newContext);
            if (indent) {
                CodeTextBuilder.indent$default((CodeTextBuilder)this.builder, null, (int)1, null);
            }
            block.invoke();
        }
        catch (Throwable throwable) {
            boolean complete2;
            this.builder.returnToIndentation(savedIndentation);
            this.context.setLocus(oldContext);
            boolean bl = complete2 = oldContext == ScriptLocus.OUTSIDE && newContext != ScriptLocus.OUTSIDE && this.builder.isNotEmpty();
            if (complete2) {
                this.flush();
            }
            throw throwable;
        }
        this.builder.returnToIndentation(savedIndentation);
        this.context.setLocus(oldContext);
        boolean bl = complete = oldContext == ScriptLocus.OUTSIDE && newContext != ScriptLocus.OUTSIDE && this.builder.isNotEmpty();
        if (complete) {
            this.flush();
        }
    }

    public static /* synthetic */ void coding$default(AbstractCodeGenerator abstractCodeGenerator, ScriptLocus scriptLocus, boolean bl, Function0 function0, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: coding");
        }
        if ((n & 1) != 0) {
            scriptLocus = null;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        abstractCodeGenerator.coding(scriptLocus, bl, (Function0<Unit>)function0);
    }

    protected final void newCoding(@NotNull Function1<? super ScriptingContext.NewCodingAdapter, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        AbstractCodeGenerator.coding$default(this, null, false, () -> AbstractCodeGenerator.newCoding$lambda$0(block, this), 3, null);
    }

    public final void flush() {
        if (this.builder.isNotEmpty()) {
            this.flush(this.builder.build());
        }
        this.builder.clearAll();
    }

    private final void flush(CompositeText statement) {
        this.context.getScript().add(statement);
    }

    @Nullable
    public final String quote(@NotNull BasicElement e, @Nullable String name) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (name == null) {
            return null;
        }
        return ScriptingFun.prepareNameToScript$default(this.context, e, name, false, 8, null);
    }

    public static /* synthetic */ String quote$default(AbstractCodeGenerator abstractCodeGenerator, BasicElement basicElement, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: quote");
        }
        if ((n & 2) != 0) {
            string = basicElement.getName();
        }
        return abstractCodeGenerator.quote(basicElement, string);
    }

    @NotNull
    protected final String currentScopeName(@NotNull BasicElement $this$currentScopeName, @Nullable String renameScr) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$currentScopeName, (String)"<this>");
        String string2 = renameScr;
        if (string2 == null && (string2 = AbstractCodeGenerator.quote$default(this, $this$currentScopeName, null, 2, null)) == null) {
            string2 = "???";
        }
        String name = string2;
        BasicElement basicElement = this.context.getHelper().qualifier($this$currentScopeName);
        if (basicElement == null) {
            return name;
        }
        BasicElement q = basicElement;
        if (q instanceof BasicSchema) {
            String schemaName = ((BasicSchema)q).getRealName();
            String prefix = schemaName != null && this.useSchemaName(schemaName) ? this.quote(q, schemaName) + "." : "";
            string = prefix + name;
        } else {
            string = AbstractCodeGenerator.currentScopeName$default(this, q, null, 1, null) + "." + name;
        }
        return string;
    }

    public static /* synthetic */ String currentScopeName$default(AbstractCodeGenerator abstractCodeGenerator, BasicElement basicElement, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: currentScopeName");
        }
        if ((n & 1) != 0) {
            string = null;
        }
        return abstractCodeGenerator.currentScopeName(basicElement, string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean useSchemaName(String schemaName) {
        if (schemaName == null) return false;
        switch (WhenMappings.$EnumSwitchMapping$0[((AutoNeverAlways)this.context.getOptions().get(ScriptingOptionStatic.CONSIDER_SCHEMA_NAME)).ordinal()]) {
            case 1: {
                if (Intrinsics.areEqual((Object)schemaName, (Object)this.context.getCurrentSchemaName())) return false;
                return true;
            }
            case 2: {
                return false;
            }
            case 3: {
                return true;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @NotNull
    public final String script(@NotNull DasType d) {
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        ScriptGeneratorHelper scriptGeneratorHelper = this.context.getHelper();
        DataType dataType = d.toDataType();
        Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"toDataType(...)");
        return scriptGeneratorHelper.script(dataType, this.context, null);
    }

    @TestOnly
    @NotNull
    public final Scenario getInternalScenario() {
        return this.getScenario$intellij_database_dialects_base();
    }

    @NotNull
    public final Scenario getScenario$intellij_database_dialects_base() {
        return this.scenario;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final ScriptingContext.NewCodingAdapter alterTable(@NotNull ScriptingContext.NewCodingAdapter $this$alterTable, @Nullable BasicLikeTable table, @Nullable String scrName) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)$this$alterTable, (String)"<this>");
        ScriptingContext.NewCodingAdapter newCodingAdapter = $this$alterTable;
        BasicLikeTable basicLikeTable = table;
        String text$iv = basicLikeTable != null ? this.currentScopeName((BasicElement)basicLikeTable, scrName) : null;
        boolean $i$f$orError = false;
        return $this$alterTable.plus($this$alterTable.plus($this$alterTable.unaryPlus("alter"), this.context.getHelper().getTableTerm(table)), (Function0<? extends Object>)((Function0)new Function0<Unit>(text$iv, (ScriptingContext.NewCodingAdapter)this_$iv){
            final /* synthetic */ String $text;
            final /* synthetic */ ScriptingContext.NewCodingAdapter this$0;
            {
                this.$text = $text;
                this.this$0 = $receiver;
            }

            public final void invoke() {
                if (this.$text != null) {
                    ScriptingContext.NewCodingAdapter.appendSimple$default(this.this$0, this.$text, null, null, 6, null);
                } else {
                    CompositeText.Kind kind = null;
                    CharSequence charSequence = "???";
                    ScriptingContext.NewCodingAdapter newCodingAdapter = this.this$0;
                    boolean bl = false;
                    String string = "table is unknown";
                    ScriptingContext.NewCodingAdapter.appendSimple$default(newCodingAdapter, charSequence, kind, string, 2, null);
                }
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final ScriptingContext.NewCodingAdapter alterColumn(@NotNull ScriptingContext.NewCodingAdapter $this$alterColumn, @Nullable BasicLikeColumn c, @Nullable String scrName) {
        void this_$iv$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)$this$alterColumn, (String)"<this>");
        BasicLikeColumn basicLikeColumn = c;
        ScriptingContext.NewCodingAdapter newCodingAdapter = $this$alterColumn;
        String quotedName$iv = scrName;
        boolean $i$f$name = false;
        void var7_7 = this_$iv;
        String text$iv$iv = quotedName$iv;
        boolean $i$f$orError = false;
        return $this$alterColumn.plus($this$alterColumn.plus(this.alterTable($this$alterColumn, (BasicLikeTable)(basicLikeColumn != null ? basicLikeColumn.getLikeTable() : null), null), "alter column"), (Function0<? extends Object>)((Function0)new Function0<Unit>(text$iv$iv, (ScriptingContext.NewCodingAdapter)this_$iv$iv){
            final /* synthetic */ String $text;
            final /* synthetic */ ScriptingContext.NewCodingAdapter this$0;
            {
                this.$text = $text;
                this.this$0 = $receiver;
            }

            public final void invoke() {
                if (this.$text != null) {
                    ScriptingContext.NewCodingAdapter.appendSimple$default(this.this$0, this.$text, null, null, 6, null);
                } else {
                    CompositeText.Kind kind = null;
                    CharSequence charSequence = "???";
                    ScriptingContext.NewCodingAdapter newCodingAdapter = this.this$0;
                    boolean bl = false;
                    String string = "unknown name";
                    ScriptingContext.NewCodingAdapter.appendSimple$default(newCodingAdapter, charSequence, kind, string, 2, null);
                }
            }
        }));
    }

    private static final Iterable resolve$lambda$1$0$0$0(Function1 $tmp0, Object p0) {
        return (Iterable)$tmp0.invoke(p0);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final Iterable resolve$lambda$1$0(HashMap $effects, ObjectPathTrie $trie, RequiredEffect it) {
        Iterable iterable;
        MultiMap multiMap = (MultiMap)$effects.get((Object)it.getType());
        if (multiMap != null) {
            MultiMap ops = multiMap;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            JBIterable jBIterable = ScenarioOperations.expand(it, $trie).flatMap(arg_0 -> AbstractCodeGenerator.resolve$lambda$1$0$0$0((Function1)new Function1<ObjectPath, Collection<Operation>>((Object)ops){

                public final Collection<Operation> invoke(ObjectPath p0) {
                    return ((MultiMap)this.receiver).get((Object)p0);
                }
            }, arg_0));
            multiMap = jBIterable;
            if (jBIterable != null) {
                iterable = (Iterable)multiMap;
                return iterable;
            }
        }
        iterable = (Iterable)JBIterable.empty();
        return iterable;
    }

    private static final Iterable resolve$lambda$1$1(Function1 $tmp0, Object p0) {
        return (Iterable)$tmp0.invoke(p0);
    }

    private static final boolean findCycle$lambda$0(HashSet $visited, Operation it) {
        return !$visited.contains(it);
    }

    private static final boolean findCycle$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean findCycle$lambda$2(HashSet $visited, Operation it) {
        return !$visited.contains(it);
    }

    private static final boolean findCycle$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    /*
     * WARNING - void declaration
     */
    private static final Operation createOutputFactory$lambda$0(HashMap $sinks, ScriptConsumer $consumer, AbstractCodeGenerator this$0, BasicElement obj) {
        Object object;
        void $this$getOrPut$iv;
        Object object2;
        Object object3;
        BasicElement basicElement = obj;
        if (basicElement != null) {
            BasicElement it = basicElement;
            boolean bl = false;
            object3 = $consumer.distribute(it);
        } else {
            object3 = null;
        }
        Object tag = object3;
        Map map = $sinks;
        Object object4 = tag;
        if (object4 != null) {
            Object it = object4;
            boolean bl = false;
            object2 = $consumer.getId(it);
        } else {
            object2 = null;
        }
        Object key$iv = object2;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            Operation operation;
            boolean bl = false;
            Operation $this$createOutputFactory_u24lambda_u240_u242_u240 = operation = new Operation(new SinkProducer<Object>(this$0.context, tag, $consumer));
            boolean bl2 = false;
            $this$createOutputFactory_u24lambda_u240_u242_u240.setParent((Node)this$0.scenario.getRoot());
            Operation answer$iv = operation;
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (Operation)object;
    }

    private static final Unit newCoding$lambda$0(Function1 $block, AbstractCodeGenerator this$0) {
        $block.invoke((Object)this$0.context.getAdapter());
        this$0.context.getAdapter().newLine();
        return Unit.INSTANCE;
    }

    static {
        Logger logger = Logger.getInstance(AbstractCodeGenerator.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0007R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u0016\u0010\u0010\u001a\u00070\u0011\u00a2\u0006\u0002\b\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0016@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#\u00a8\u0006$"}, d2={"Lcom/intellij/database/dialects/base/generator/AbstractCodeGenerator$Companion;", "", "<init>", "()V", "ROOT", "Lcom/intellij/database/dialects/base/generator/OperationType;", "getROOT", "()Lcom/intellij/database/dialects/base/generator/OperationType;", "SINK", "getSINK", "ERROR", "getERROR", "GRANT", "getGRANT", "SEARCH_PATH", "getSEARCH_PATH", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "value", "", "ignoreFormatting", "getIgnoreFormatting", "()Z", "setIgnoreFormatting", "", "parent", "Lcom/intellij/openapi/Disposable;", "lastReportedCycle", "Lkotlin/time/TimeSource$Monotonic$ValueTimeMark;", "getLastReportedCycle-LFT3Okc", "()Lkotlin/time/TimeSource$Monotonic$ValueTimeMark;", "setLastReportedCycle-rEXM0dE", "(Lkotlin/time/TimeSource$Monotonic$ValueTimeMark;)V", "intellij.database.dialects.base"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final OperationType getROOT() {
            return ROOT;
        }

        @NotNull
        protected final OperationType getSINK() {
            return SINK;
        }

        @NotNull
        public final OperationType getERROR() {
            return ERROR;
        }

        @NotNull
        public final OperationType getGRANT() {
            return GRANT;
        }

        @NotNull
        public final OperationType getSEARCH_PATH() {
            return SEARCH_PATH;
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public final boolean getIgnoreFormatting() {
            return ignoreFormatting;
        }

        @TestOnly
        public final void setIgnoreFormatting(@NotNull Disposable parent) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            ignoreFormatting = true;
            Disposer.register((Disposable)parent, Companion::setIgnoreFormatting$lambda$0);
        }

        @Nullable
        public final TimeSource.Monotonic.ValueTimeMark getLastReportedCycle-LFT3Okc() {
            return lastReportedCycle;
        }

        public final void setLastReportedCycle-rEXM0dE(@Nullable TimeSource.Monotonic.ValueTimeMark valueTimeMark) {
            lastReportedCycle = valueTimeMark;
        }

        private static final void setIgnoreFormatting$lambda$0() {
            ignoreFormatting = false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J8\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0016\u0010\n\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u000bH&J\b\u0010\r\u001a\u00020\u0005H\u0016J\b\u0010\u000e\u001a\u00020\u0005H\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/dialects/base/generator/AbstractCodeGenerator$EdgeFixer;", "", "<init>", "()V", "fix", "", "root", "Lcom/intellij/database/dialects/base/generator/Operation;", "op1", "op2", "parent", "Lkotlin/Function1;", "Lcom/intellij/database/model/basic/BasicElement;", "isBackward", "requiresResolve", "intellij.database.dialects.base"})
    public static abstract class EdgeFixer {
        public abstract boolean fix(@NotNull Operation var1, @NotNull Operation var2, @NotNull Operation var3, @Nullable Function1<? super BasicElement, Operation> var4);

        public boolean isBackward() {
            return false;
        }

        public boolean requiresResolve() {
            return false;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00018\u0000\u0012\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0015\u0010\u0005\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u0019\u0010\u0006\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/dialects/base/generator/AbstractCodeGenerator$SinkProducer;", "T", "Lcom/intellij/database/dialects/base/generator/Producer;", "context", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "tag", "consumer", "Lcom/intellij/database/script/generator/ScriptConsumer;", "<init>", "(Lcom/intellij/database/dialects/base/generator/ScriptingContext;Ljava/lang/Object;Lcom/intellij/database/script/generator/ScriptConsumer;)V", "getContext", "()Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "getTag", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getConsumer", "()Lcom/intellij/database/script/generator/ScriptConsumer;", "ignoreDeps", "", "produce", "", "intellij.database.dialects.base"})
    public static final class SinkProducer<T>
    extends Producer {
        @NotNull
        private final ScriptingContext context;
        @Nullable
        private final T tag;
        @Nullable
        private final ScriptConsumer<T> consumer;

        public SinkProducer(@NotNull ScriptingContext context, @Nullable T tag, @Nullable ScriptConsumer<T> consumer) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super(Companion.getSINK());
            this.context = context;
            this.tag = tag;
            this.consumer = consumer;
        }

        @NotNull
        public final ScriptingContext getContext() {
            return this.context;
        }

        @Nullable
        public final T getTag() {
            return this.tag;
        }

        @Nullable
        public final ScriptConsumer<T> getConsumer() {
            return this.consumer;
        }

        public final boolean ignoreDeps() {
            return this.consumer != null && this.consumer.ignoreDependencies();
        }

        @Override
        public void produce() {
            this.context.getScript().clear();
            AbstractCodeGeneratorKt.processOperations(this.context, (Iterable<Operation>)this.getNestedOperations(), (Function1<? super Operation, Unit>)((Function1)SinkProducer::produce$lambda$0));
            if (this.tag != null && this.consumer != null) {
                this.consumer.consume(AbstractCodeGeneratorKt.createResult(this.context), this.tag);
            } else {
                this.context.setResult(AbstractCodeGeneratorKt.createResult(this.context));
            }
        }

        private static final Unit produce$lambda$0(Operation it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            it.getProducer().produce();
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AutoNeverAlways.values().length];
            try {
                nArray[AutoNeverAlways.AUTO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AutoNeverAlways.NEVER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AutoNeverAlways.ALWAYS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

