/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.generator;

import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0013\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\fJ\r\u0010\r\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010\u000f\u001a\u00020\u0010R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/dialects/base/generator/LinkedPriorityQueue;", "T", "", "cmp", "Ljava/util/Comparator;", "<init>", "(Ljava/util/Comparator;)V", "map", "Ljava/util/TreeMap;", "add", "", "t", "(Ljava/lang/Object;)V", "poll", "()Ljava/lang/Object;", "isEmpty", "", "intellij.database.dialects.base"})
final class LinkedPriorityQueue<T> {
    @NotNull
    private final TreeMap<T, Object> map;

    public LinkedPriorityQueue(@NotNull Comparator<T> cmp) {
        Intrinsics.checkNotNullParameter(cmp, (String)"cmp");
        this.map = new TreeMap(cmp);
    }

    public final void add(T t) {
        Object v = this.map.get(t);
        if (v == null) {
            Map map = this.map;
            Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type kotlin.Any");
            map.put(t, t);
        } else if (!Intrinsics.areEqual((Object)v, t)) {
            if (TypeIntrinsics.isMutableCollection((Object)v)) {
                TypeIntrinsics.asMutableCollection((Object)v).add(t);
            } else {
                Map map = this.map;
                Object object = new Object[]{v, t};
                object = ContainerUtil.newLinkedHashSet((Object[])object);
                map.put(t, object);
            }
        }
    }

    @Nullable
    public final T poll() {
        Object object;
        Map.Entry<T, Object> entry = this.map.firstEntry();
        if (entry == null) {
            return null;
        }
        Map.Entry<T, Object> entry2 = entry;
        T k = entry2.getKey();
        Object v = entry2.getValue();
        if (TypeIntrinsics.isMutableCollection((Object)v)) {
            Iterator it = ((Collection)v).iterator();
            boolean bl = it.hasNext();
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            Object res = it.next();
            it.remove();
            if (!it.hasNext()) {
                this.map.remove(k);
            }
            object = res;
        } else {
            this.map.remove(k);
            object = v;
        }
        return (T)object;
    }

    public final boolean isEmpty() {
        return this.map.isEmpty();
    }
}

