/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.introspector;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DBConnectionAccessibilityMatcher;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.diagnostic.DataSourceDiagnosticRecorder;
import com.intellij.database.diagnostic.DiagnosticSectionReference;
import com.intellij.database.dialects.base.introspector.BaseIntrospectionFunctions;
import com.intellij.database.dialects.base.introspector.BaseIntrospector;
import com.intellij.database.dialects.base.introspector.BaseMultiDatabaseIntrospector;
import com.intellij.database.dialects.base.introspector.BaseMultiDatabaseIntrospectorKt;
import com.intellij.database.dialects.base.introspector.BaseNativeIntrospector;
import com.intellij.database.dialects.base.introspector.IntrospectionQueryContext;
import com.intellij.database.introspection.BriefIntrospectionTask;
import com.intellij.database.introspection.CombinedIntrospectionTask;
import com.intellij.database.introspection.DBIntrospectionContext;
import com.intellij.database.introspection.DatabaseFragmentIntrospectionTask;
import com.intellij.database.introspection.DatabaseIntrospectionTask;
import com.intellij.database.introspection.DatabaseVisitPolicy;
import com.intellij.database.introspection.DefiniteIntrospectionTask;
import com.intellij.database.introspection.GeneralIntrospectionTask;
import com.intellij.database.introspection.IndefiniteIntrospectionTask;
import com.intellij.database.introspection.IntrospectionTask;
import com.intellij.database.introspection.IntrospectionTaskHelperFun;
import com.intellij.database.introspection.IntrospectionTasks;
import com.intellij.database.introspection.ListSchemasTask;
import com.intellij.database.introspection.SchemasIntrospectionTask;
import com.intellij.database.layoutedQueries.DBTransaction;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.basic.BasicMateDatabase;
import com.intellij.database.model.basic.BasicMateNamespace;
import com.intellij.database.model.basic.BasicModDatabase;
import com.intellij.database.model.basic.BasicModMateDatabase;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModMultiDatabaseRoot;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModNamespace;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.basic.BasicMultiDatabaseRoot;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.IdentifyingFamily;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.common.CollectionFun;
import com.intellij.database.util.common.StringFun;
import com.intellij.ide.PlatformIdeService;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.UtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00f4\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0006\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0004*\b\b\u0002\u0010\u0005*\u00020\u00062\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00050\u0007:\u0005ghijkB)\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\b\u0010\u001b\u001a\u00020\u001cH\u0014J\u001c\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001eH\u0014J\u001c\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001a0\u001e2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001a0\"H\u0014J\u0010\u0010#\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020%H\u0014J\u0010\u0010&\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020%H\u0002J\u0018\u0010'\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0016H\u0002J\u0018\u0010+\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\u0010\u0010,\u001a\u00020\u001c2\u0006\u0010-\u001a\u00020%H\u0014J(\u0010,\u001a\u00020\u001c\"\b\b\u0003\u0010.*\u00020\u00162\u0006\u0010-\u001a\u00020%2\f\u0010/\u001a\b\u0012\u0004\u0012\u0002H.00H\u0004J\u0010\u00101\u001a\u00020\u001c2\u0006\u0010-\u001a\u00020%H\u0004J\u001a\u00102\u001a\u0004\u0018\u00010\u00162\u0006\u0010$\u001a\u00020%2\u0006\u00103\u001a\u000204H\u0014J\u0012\u00105\u001a\u0004\u0018\u00010\u00162\u0006\u00103\u001a\u000204H\u0014J\u0018\u00106\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0019\u001a\u000207H\u0014J\u0018\u00108\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0019\u001a\u000209H\u0014J\u0018\u0010:\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0019\u001a\u00020;H\u0014J\b\u0010<\u001a\u00020=H\u0016J&\u0010>\u001a \u0012\u0002\b\u0003\u0012\u0002\b\u00030?R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0000H$J!\u0010@\u001a\u00020\u001c2\u0012\u0010/\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160A\"\u00020\u0016H\u0016\u00a2\u0006\u0002\u0010BJ\u0018\u0010C\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J \u0010D\u001a\u00020\u001c2\u0006\u0010-\u001a\u00020%2\u000e\u0010E\u001a\n\u0012\u0004\u0012\u00020F\u0018\u00010\"H\u0014J \u0010G\u001a\u00020\u001c2\u0006\u0010-\u001a\u00020%2\u000e\u0010E\u001a\n\u0012\u0004\u0012\u00020F\u0018\u00010\"H\u0002J \u0010H\u001a\u00020\u001c2\u0006\u0010-\u001a\u00020%2\u000e\u0010E\u001a\n\u0012\u0004\u0012\u00020F\u0018\u00010\"H\u0002J\u000e\u0010I\u001a\u0004\u0018\u00010J*\u00020JH\u0002J\u000e\u0010K\u001a\u0004\u0018\u00010\u0016*\u00020\u0016H\u0002J\u0010\u0010L\u001a\u00020\u001c2\u0006\u0010-\u001a\u00020%H\u0014J&\u0010M\u001a\b\u0012\u0004\u0012\u00028\u00010N2\u0006\u0010-\u001a\u00020%2\u000e\u0010E\u001a\n\u0012\u0004\u0012\u00020F\u0018\u00010\"H\u0014J\u0016\u0010O\u001a\b\u0012\u0004\u0012\u00020J0\u001e2\u0006\u0010\u0015\u001a\u00020\u0004H\u0002J\u001e\u0010P\u001a\u00020\u001c2\u0006\u0010-\u001a\u00020%2\f\u0010Q\u001a\b\u0012\u0004\u0012\u00020\u00160\"H\u0002J\u001e\u00108\u001a\u00020\u001c2\u0006\u0010-\u001a\u00020%2\f\u0010R\u001a\b\u0012\u0004\u0012\u00020J0\"H\u0002J9\u0010S\u001a\u001e\u0012\u0004\u0012\u00028\u00010TR\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00072\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0015\u001a\u00028\u0001H\u0014\u00a2\u0006\u0002\u0010UJ;\u0010V\u001a \u0012\u0006\b\u0001\u0012\u00028\u00010WR\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00002\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0015\u001a\u00028\u0001H$\u00a2\u0006\u0002\u0010XJ;\u0010Y\u001a \u0012\u0006\b\u0001\u0012\u00028\u00020ZR\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00072\u0006\u0010$\u001a\u00020%2\u0006\u0010[\u001a\u00028\u0002H$\u00a2\u0006\u0002\u0010\\J\u001d\u0010]\u001a\u00020\u001c2\u0006\u0010-\u001a\u00020%2\u0006\u0010\u0015\u001a\u00028\u0001H\u0014\u00a2\u0006\u0002\u0010^J&\u0010_\u001a\u00180`R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00002\u0006\u0010$\u001a\u00020%H\u0014J8\u0010a\u001a\u00020\u001c2\f\u0010b\u001a\b\u0012\u0004\u0012\u00020c0N2\u0006\u0010d\u001a\u00020\u00132\u0018\u0010e\u001a\u0014\u0012\u0004\u0012\u00020c\u0012\n\u0012\b\u0012\u0004\u0012\u0002040A0fH\u0016R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006l"}, d2={"Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector;", "MR", "Lcom/intellij/database/model/basic/BasicModMultiDatabaseRoot;", "D", "Lcom/intellij/database/model/basic/BasicModMateDatabase;", "S", "Lcom/intellij/database/model/basic/BasicModSchema;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "context", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "nature", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector$Nature;", "dbms", "Lcom/intellij/database/Dbms;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "<init>", "(Lcom/intellij/database/introspection/DBIntrospectionContext;Lcom/intellij/database/dialects/base/introspector/BaseIntrospector$Nature;Lcom/intellij/database/Dbms;Lcom/intellij/database/model/ModelFactory;)V", "databasesAreListed", "", "checkDatabaseIsAccessibleInCurrentConnection", "database", "Lcom/intellij/database/model/basic/BasicDatabase;", "checkConnectionApplicable", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector$ConnectionApplicability;", "task", "Lcom/intellij/database/introspection/IntrospectionTask;", "logModelInfo", "", "reviseTasks", "", "tasks", "reorderTasks", "originalTasks", "", "introspectGeneral", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "introspectGeneralWithDistributionByDatabases", "notifyCannotSwitchDatabase", "root", "Lcom/intellij/database/model/basic/BasicMultiDatabaseRoot;", "db", "introspectNamespaces", "introspectNamespacesInTran", "tran", "T", "databases", "Lcom/intellij/util/containers/JBIterable;", "listAndApplyDatabasesIfNotYet", "reifyDatabase", "databaseName", "", "findDatabase", "introspectDatabase", "Lcom/intellij/database/introspection/DatabaseIntrospectionTask;", "introspectSchemas", "Lcom/intellij/database/introspection/SchemasIntrospectionTask;", "introspectDatabaseFragments", "Lcom/intellij/database/introspection/DatabaseFragmentIntrospectionTask;", "getDefaultScope", "Lcom/intellij/database/util/TreePattern;", "createDatabaseLister", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$DatabaseLister;", "introspectDatabaseSchemas", "", "([Lcom/intellij/database/model/basic/BasicDatabase;)V", "retrieveSchemasOfDatabase", "introspectAutomatically", "namespaces", "Lcom/intellij/database/model/basic/BasicNamespace;", "introspectAutomaticallyLevelByLevel", "introspectAutomaticallyNoLevels", "adjustSchemaInstance", "Lcom/intellij/database/model/basic/BasicSchema;", "adjustDatabaseInstance", "introspectPreDatabaseObjects", "getDatabasesToIntrospect", "", "getSchemasToIntrospect", "introspectDatabases", "databasesToIntrospect", "schemasToIntrospect", "createNativeRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractNativeRetriever;", "(Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/model/basic/BasicModMateDatabase;)Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractNativeRetriever;", "createDatabaseRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$BaseDatabaseRetriever;", "(Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/model/basic/BasicModMateDatabase;)Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$BaseDatabaseRetriever;", "createSchemaRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractSchemaRetriever;", "schema", "(Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/model/basic/BasicModSchema;)Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractSchemaRetriever;", "postProcessDatabase", "(Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/model/basic/BasicModMateDatabase;)V", "createServerObjectsRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$BaseServerObjectsRetriever;", "introspectNativeDefinitions", "elements", "Lcom/intellij/database/model/basic/BasicElement;", "withNestedElements", "result", "", "DatabaseLister", "BaseDatabaseRetriever", "BaseDatabaseSchemasRetriever", "BaseServerObjectsRetriever", "BaseNativeRetriever", "intellij.database.dialects.base"})
@SourceDebugExtension(value={"SMAP\nBaseMultiDatabaseIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseMultiDatabaseIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 IntrospectionQueryContext.kt\ncom/intellij/database/dialects/base/introspector/IntrospectionQueryContext\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 BaseIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospector\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,735:1\n1021#2,2:736\n1021#2,2:738\n1021#2,2:740\n777#2:742\n873#2,2:743\n777#2:745\n873#2,2:746\n777#2:748\n873#2,2:749\n777#2:751\n873#2,2:752\n296#2,2:754\n777#2:756\n873#2,2:757\n777#2:775\n873#2,2:776\n1512#2:791\n1538#2,3:792\n1541#2,3:802\n411#3,2:759\n411#3,2:762\n411#3,2:778\n1#4:761\n1145#5:764\n1230#5:765\n1146#5,5:766\n1234#5,2:771\n1151#5,2:773\n1145#5:780\n1230#5:781\n1146#5,5:782\n1234#5,2:787\n1151#5,2:789\n383#6,7:795\n*S KotlinDebug\n*F\n+ 1 BaseMultiDatabaseIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector\n*L\n160#1:736,2\n161#1:738,2\n162#1:740,2\n185#1:742\n185#1:743,2\n259#1:745\n259#1:746,2\n260#1:748\n260#1:749,2\n263#1:751\n263#1:752,2\n283#1:754,2\n331#1:756\n331#1:757,2\n501#1:775\n501#1:776,2\n714#1:791\n714#1:792,3\n714#1:802,3\n403#1:759,2\n442#1:762,2\n520#1:778,2\n458#1:764\n458#1:765\n458#1:766,5\n458#1:771,2\n458#1:773,2\n608#1:780\n608#1:781\n608#1:782,5\n608#1:787,2\n608#1:789,2\n714#1:795,7\n*E\n"})
public abstract class BaseMultiDatabaseIntrospector<MR extends BasicModMultiDatabaseRoot, D extends BasicModMateDatabase, S extends BasicModSchema>
extends BaseNativeIntrospector<MR, D, S> {
    private boolean databasesAreListed;

    public BaseMultiDatabaseIntrospector(@NotNull DBIntrospectionContext context, @NotNull BaseIntrospector.Nature nature, @NotNull Dbms dbms, @NotNull ModelFactory modelFactory) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)nature, (String)"nature");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
        super(context, nature, dbms, modelFactory);
    }

    protected boolean checkDatabaseIsAccessibleInCurrentConnection(@NotNull BasicDatabase database) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        DatabaseConnectionCore databaseConnectionCore = this.getDbConnection();
        if (databaseConnectionCore == null || (databaseConnectionCore = databaseConnectionCore.getConnectionPoint()) == null) {
            return false;
        }
        DatabaseConnectionCore connectionPoint = databaseConnectionCore;
        DBConnectionAccessibilityMatcher dBConnectionAccessibilityMatcher = this.getAccessibilityMatcher();
        if (dBConnectionAccessibilityMatcher == null) {
            return true;
        }
        DBConnectionAccessibilityMatcher accessibilityMatcher = dBConnectionAccessibilityMatcher;
        return accessibilityMatcher.isDatabaseAccessible((DatabaseConnectionPoint)connectionPoint, database);
    }

    @Override
    @NotNull
    protected BaseIntrospector.ConnectionApplicability checkConnectionApplicable(@NotNull IntrospectionTask task) {
        boolean ok;
        BasicDatabase db;
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        BaseIntrospector.ConnectionApplicability connectionApplicability = this.getDbConnection() == null ? BaseIntrospector.ConnectionApplicability.connNone : (this.isMetadataAccessDependsOnConnection() ? ((db = this.getDatabase(task)) != null ? ((ok = this.checkDatabaseIsAccessibleInCurrentConnection(db)) ? BaseIntrospector.ConnectionApplicability.connApplicableFull : BaseIntrospector.ConnectionApplicability.connInapplicable) : BaseIntrospector.ConnectionApplicability.connApplicablePartial) : BaseIntrospector.ConnectionApplicability.connApplicableFull);
        return connectionApplicability;
    }

    @Override
    protected void logModelInfo() {
        super.logModelInfo();
        BasicModModel basicModModel = this.getMyModel();
        if (basicModModel == null) {
            IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)this, (String)"The model is not initialized yet", null, (int)2, null);
            return;
        }
        BasicModModel model = basicModModel;
        if (!this.getTracing()) {
            return;
        }
        StringBuilder b = new StringBuilder();
        BasicRoot basicRoot = model.getRoot();
        Intrinsics.checkNotNull((Object)basicRoot, (String)"null cannot be cast to non-null type com.intellij.database.model.basic.BasicMultiDatabaseRoot");
        BasicMultiDatabaseRoot root = (BasicMultiDatabaseRoot)basicRoot;
        Iterable iterable = root.getNamespaces();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getNamespaces(...)");
        int n1 = SequencesKt.count((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)iterable), BaseMultiDatabaseIntrospector::logModelInfo$lambda$0));
        StringBuilder stringBuilder = b;
        Iterable iterable2 = root.getNamespaces();
        Intrinsics.checkNotNullExpressionValue((Object)iterable2, (String)"getNamespaces(...)");
        stringBuilder.append("The model contains " + CollectionsKt.count((Iterable)iterable2) + " databases, " + n1 + " of them are with schemas").append('\n');
        BasicMateDatabase currDatabase = root.getCurrentDatabase();
        if (currDatabase != null) {
            BasicSchema currSchema;
            b.append("Current database: " + currDatabase.getName()).append('\n');
            Iterable iterable3 = currDatabase.getNamespaces();
            Intrinsics.checkNotNullExpressionValue((Object)iterable3, (String)"getNamespaces(...)");
            int n2 = SequencesKt.count((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)iterable3), BaseMultiDatabaseIntrospector::logModelInfo$lambda$1));
            StringBuilder stringBuilder2 = b;
            Iterable iterable4 = currDatabase.getNamespaces();
            Intrinsics.checkNotNullExpressionValue((Object)iterable4, (String)"getNamespaces(...)");
            stringBuilder2.append("The current database has " + CollectionsKt.count((Iterable)iterable4) + " schemas, " + n2 + " of them have inner objects").append('\n');
            BasicSchema basicSchema = currSchema = ModelFun.getCurrentSchema((BasicDatabase)((BasicDatabase)currDatabase));
            v7 = basicSchema != null ? b.append("Current schema: " + basicSchema.getName()).append('\n') : b.append("No current schema in this database").append('\n');
        } else {
            v7 = b.append("No current database.").append('\n');
        }
        String string = b.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        this.trace(string);
    }

    @Override
    @NotNull
    protected List<IntrospectionTask> reviseTasks(@NotNull List<? extends IntrospectionTask> tasks) {
        Intrinsics.checkNotNullParameter(tasks, (String)"tasks");
        List theTasks = tasks;
        HashSet<String> taskDatabaseNames = new HashSet<String>();
        boolean hasNsIntrospectionTask = false;
        for (IntrospectionTask task : tasks) {
            if (task instanceof DefiniteIntrospectionTask) {
                taskDatabaseNames.add(((DefiniteIntrospectionTask)task).getDatabaseName());
            }
            if (!(task instanceof GeneralIntrospectionTask) && !(task instanceof BriefIntrospectionTask)) continue;
            hasNsIntrospectionTask = true;
        }
        taskDatabaseNames.remove("@");
        if (!((Collection)taskDatabaseNames).isEmpty() && !hasNsIntrospectionTask) {
            BasicRoot basicRoot = this.getModel().getRoot();
            Intrinsics.checkNotNull((Object)basicRoot, (String)"null cannot be cast to non-null type com.intellij.database.model.basic.BasicMultiDatabaseRoot");
            BasicMultiDatabaseRoot theRoot = (BasicMultiDatabaseRoot)basicRoot;
            NamingFamily namingFamily = theRoot.getDatabases();
            Intrinsics.checkNotNullExpressionValue((Object)namingFamily, (String)"getDatabases(...)");
            Set knownDatabaseNames2 = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)namingFamily)), (Function1)reviseTasks.knownDatabaseNames.1.INSTANCE));
            Set unknownDatabaseNames = SetsKt.minus((Set)taskDatabaseNames, (Iterable)knownDatabaseNames2);
            if (!((Collection)unknownDatabaseNames).isEmpty()) {
                this.trace("The following databases are specified in the tasks but not found in the model: " + unknownDatabaseNames);
                BriefIntrospectionTask nsIntroTask = new BriefIntrospectionTask(this.getDataSourceId(), (DatabaseVisitPolicy)new DatabaseVisitPolicy.Extra(unknownDatabaseNames));
                theTasks = new ArrayList(theTasks.size() + 1);
                ((ArrayList)theTasks).add(nsIntroTask);
                ((ArrayList)theTasks).addAll(tasks);
            }
        }
        return theTasks;
    }

    @Override
    @NotNull
    protected List<IntrospectionTask> reorderTasks(@NotNull Collection<? extends IntrospectionTask> originalTasks) {
        Intrinsics.checkNotNullParameter(originalTasks, (String)"originalTasks");
        ArrayList tasks0 = new ArrayList(0);
        ArrayList tasks1 = new ArrayList(0);
        ArrayList tasks2 = new ArrayList(0);
        BasicModMateDatabase basicModMateDatabase = (BasicModMateDatabase)((BasicModMultiDatabaseRoot)this.getRoot()).getCurrentDatabase();
        String currentDatabaseName = basicModMateDatabase != null ? basicModMateDatabase.getName() : null;
        for (IntrospectionTask introspectionTask : originalTasks) {
            IntrospectionTask introspectionTask2 = introspectionTask;
            if (introspectionTask2 instanceof IndefiniteIntrospectionTask || introspectionTask2 instanceof CombinedIntrospectionTask) {
                ((Collection)tasks0).add(introspectionTask);
                continue;
            }
            if (introspectionTask2 instanceof DefiniteIntrospectionTask) {
                String name = ((DefiniteIntrospectionTask)introspectionTask).getDatabaseName();
                if (Intrinsics.areEqual((Object)name, (Object)currentDatabaseName) || Intrinsics.areEqual((Object)name, (Object)"@") || ((CharSequence)name).length() == 0) {
                    ((Collection)tasks1).add(introspectionTask);
                    continue;
                }
                ((Collection)tasks2).add(introspectionTask);
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
        List $this$sortBy$iv = tasks0;
        boolean bl = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    IntrospectionTask it = (IntrospectionTask)a;
                    boolean bl = false;
                    Comparable comparable = Byte.valueOf(it.getTaskTypeOrder());
                    it = (IntrospectionTask)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Byte.valueOf(it.getTaskTypeOrder()));
                }
            });
        }
        $this$sortBy$iv = tasks1;
        boolean bl2 = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    IntrospectionTask it = (IntrospectionTask)a;
                    boolean bl = false;
                    Comparable comparable = Byte.valueOf(it.getTaskTypeOrder());
                    it = (IntrospectionTask)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Byte.valueOf(it.getTaskTypeOrder()));
                }
            });
        }
        $this$sortBy$iv = tasks2;
        boolean bl3 = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    IntrospectionTask it = (IntrospectionTask)a;
                    boolean bl = false;
                    Comparable comparable = Byte.valueOf(it.getTaskTypeOrder());
                    it = (IntrospectionTask)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Byte.valueOf(it.getTaskTypeOrder()));
                }
            });
        }
        ArrayList tasks = new ArrayList(originalTasks.size());
        tasks.addAll(tasks0);
        tasks.addAll(tasks1);
        tasks.addAll(tasks2);
        return tasks;
    }

    @Override
    protected void introspectGeneral(@NotNull DBTransaction transaction) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        this.introspectServerAndSessionInfo();
        this.listAndApplyDatabasesIfNotYet(transaction);
        if (this.isMetadataAccessDependsOnConnection()) {
            this.introspectGeneralWithDistributionByDatabases(transaction);
        } else {
            super.introspectGeneral(transaction);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void introspectGeneralWithDistributionByDatabases(DBTransaction transaction) {
        void $this$filterTo$iv$iv;
        Iterable iterable = ((BasicModMultiDatabaseRoot)this.getRoot()).getNamespaces();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getNamespaces(...)");
        Iterable $this$filter$iv = iterable;
        boolean $i$f$filter = false;
        Iterable iterable2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            BasicNamespace p0 = (BasicNamespace)element$iv$iv;
            boolean bl = false;
            if (!this.inIntrospectionScope(p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List databasesToIntrospect = (List)destination$iv$iv;
        ArrayList applicableTasks = new ArrayList();
        DBConnectionAccessibilityMatcher accessibilityMatcher = this.getAccessibilityMatcher();
        boolean canSwitchDatabase = accessibilityMatcher != null && accessibilityMatcher.canSwitchDatabase();
        for (BasicModMateDatabase db : databasesToIntrospect) {
            DefiniteIntrospectionTask additionalTask = IntrospectionTasks.prepareDatabaseTask((String)this.getDataSourceId(), (BasicDatabase)((BasicDatabase)db));
            if (this.checkDatabaseIsAccessibleInCurrentConnection((BasicDatabase)db)) {
                ((Collection)applicableTasks).add(additionalTask);
                continue;
            }
            if (canSwitchDatabase) {
                this.deferTask((IntrospectionTask)additionalTask);
                continue;
            }
            this.notifyCannotSwitchDatabase((BasicMultiDatabaseRoot)this.getRoot(), (BasicDatabase)db);
        }
        if (!((Collection)applicableTasks).isEmpty()) {
            this.introspectPreDatabaseObjects(transaction);
            Iterator iterator = applicableTasks.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                Object e = iterator2.next();
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                IntrospectionTask applicableTask = (IntrospectionTask)e;
                this.introspectInTran(transaction, applicableTask);
            }
        }
        this.introspectServerObjectsInTran(transaction);
    }

    private final void notifyCannotSwitchDatabase(BasicMultiDatabaseRoot root, BasicDatabase db) {
        BasicDatabase accessibleDatabase = (BasicDatabase)root.getCurrentDatabase();
        Object object = accessibleDatabase;
        if (object == null || (object = object.getDisplayName()) == null) {
            object = "not detected";
        }
        Object accessibleDatabaseString = object;
        IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)this, (String)("Cannot perform introspection task with non-accessible database (" + db.getDisplayName() + ") because switching database is not possible in this configuration; the only accessible database is " + (String)accessibleDatabaseString), null, (int)2, null);
        Object object2 = accessibleDatabase;
        if (object2 == null || (object2 = object2.getDisplayName()) == null) {
            String string = DatabaseBundle.message((String)"base.introspector.switching.database.singleDatabaseMode.currentDatabaseIsNotDetected", (Object[])new Object[0]);
            object2 = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        }
        Object accessibleDatabaseI18nString = object2;
        Object[] objectArray = new Object[]{accessibleDatabaseI18nString, db.getDisplayName()};
        PlatformIdeService.getInstance().notification("Switching database in introspection", PlatformIdeService.NotificationType.WARNING, DatabaseBundle.message((String)"base.introspector.switching.database.singleDatabaseMode.title", (Object[])new Object[0]), DatabaseBundle.message((String)"base.introspector.switching.database.singleDatabaseMode.subtitle", (Object[])new Object[0]), DatabaseBundle.message((String)"base.introspector.switching.database.singleDatabaseMode.description", (Object[])objectArray), this.getProject(), "base.introspector.switching.database.singleDatabaseMode");
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void introspectNamespaces(@NotNull DBTransaction transaction, @NotNull IntrospectionTask task) {
        boolean needsToListDatabases;
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Iterable iterable = ((BasicModMultiDatabaseRoot)this.getRoot()).getNamespaces();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getNamespaces(...)");
        boolean bl = needsToListDatabases = IntrospectionTaskHelperFun.isEmpty((Iterable)iterable) || task instanceof IndefiniteIntrospectionTask || task instanceof DefiniteIntrospectionTask && this.getDatabaseIsKnown((DefiniteIntrospectionTask)task);
        if (needsToListDatabases) {
            this.listAndApplyDatabasesIfNotYet(transaction);
        }
        boolean allApplicable = !this.isMetadataAccessDependsOnConnection();
        IntrospectionTask introspectionTask = task;
        if (introspectionTask instanceof DefiniteIntrospectionTask || introspectionTask instanceof CombinedIntrospectionTask) {
            boolean applicableRightNow;
            BasicDatabase basicDatabase = this.getDatabase(task);
            if (basicDatabase == null) {
                return;
            }
            BasicDatabase theDatabase = basicDatabase;
            boolean bl2 = applicableRightNow = allApplicable || this.checkDatabaseIsAccessibleInCurrentConnection(theDatabase);
            if (applicableRightNow) {
                this.retrieveSchemasOfDatabase(transaction, theDatabase);
                return;
            } else {
                ListSchemasTask listSchemasTask;
                if (task instanceof ListSchemasTask) {
                    listSchemasTask = (ListSchemasTask)task;
                } else {
                    String string = task.getDataSourceId();
                    String string2 = theDatabase.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                    listSchemasTask = new ListSchemasTask(string, string2);
                }
                ListSchemasTask taskToDefer = listSchemasTask;
                this.deferTask((IntrospectionTask)taskToDefer);
            }
            return;
        } else {
            List list;
            if (!(introspectionTask instanceof IndefiniteIntrospectionTask)) throw new NoWhenBranchMatchedException();
            if ((IndefiniteIntrospectionTask)task instanceof BriefIntrospectionTask) {
                DatabaseVisitPolicy policy = ((BriefIntrospectionTask)task).getPolicy();
                if (Intrinsics.areEqual((Object)policy, (Object)DatabaseVisitPolicy.ByIntrospectionScope.INSTANCE)) {
                    Iterable iterable2 = ((BasicModMultiDatabaseRoot)this.getRoot()).getNamespaces();
                    Intrinsics.checkNotNullExpressionValue((Object)iterable2, (String)"getNamespaces(...)");
                    Iterable $this$filter$iv = iterable2;
                    boolean $i$f$filter = false;
                    Iterable iterable3 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        BasicNamespace p0 = (BasicNamespace)element$iv$iv;
                        boolean bl3 = false;
                        if (!this.inIntrospectionScope(p0)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    list = (List)destination$iv$iv;
                } else if (policy instanceof DatabaseVisitPolicy.Extra) {
                    Iterable iterable4 = ((BasicModMultiDatabaseRoot)this.getRoot()).getNamespaces();
                    Intrinsics.checkNotNullExpressionValue((Object)iterable4, (String)"getNamespaces(...)");
                    Iterable $this$filter$iv = iterable4;
                    boolean $i$f$filter2 = false;
                    $this$filterTo$iv$iv = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        BasicModMateDatabase it = (BasicModMateDatabase)element$iv$iv;
                        boolean bl4 = false;
                        Intrinsics.checkNotNull((Object)it);
                        if (!(this.inIntrospectionScope((BasicNamespace)it) || ((DatabaseVisitPolicy.Extra)policy).getNames().contains(it.getName()))) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    list = (List)destination$iv$iv;
                } else {
                    if (!Intrinsics.areEqual((Object)policy, (Object)DatabaseVisitPolicy.Everything.INSTANCE)) throw new NoWhenBranchMatchedException();
                    Iterable iterable5 = ((BasicModMultiDatabaseRoot)this.getRoot()).getNamespaces();
                    Intrinsics.checkNotNullExpressionValue((Object)iterable5, (String)"getNamespaces(...)");
                    list = CollectionsKt.toList((Iterable)iterable5);
                }
            } else {
                void $this$filterTo$iv$iv;
                Iterable iterable6 = ((BasicModMultiDatabaseRoot)this.getRoot()).getNamespaces();
                Intrinsics.checkNotNullExpressionValue((Object)iterable6, (String)"getNamespaces(...)");
                Iterable $this$filter$iv = iterable6;
                boolean $i$f$filter = false;
                Iterable $i$f$filter2 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    BasicNamespace p0 = (BasicNamespace)element$iv$iv;
                    boolean bl5 = false;
                    if (!this.inIntrospectionScope(p0)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list = (List)destination$iv$iv;
            }
            List databases = list;
            for (BasicModMateDatabase db : databases) {
                boolean applicableRightNow;
                boolean bl6 = applicableRightNow = allApplicable || this.checkDatabaseIsAccessibleInCurrentConnection((BasicDatabase)db);
                if (applicableRightNow) {
                    this.retrieveSchemasOfDatabase(transaction, (BasicDatabase)db);
                    continue;
                }
                String string = task.getDataSourceId();
                String string3 = db.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
                ListSchemasTask additionalTask = new ListSchemasTask(string, string3);
                this.deferTask((IntrospectionTask)additionalTask);
            }
        }
    }

    @Override
    protected void introspectNamespacesInTran(@NotNull DBTransaction tran) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        this.listAndApplyDatabasesIfNotYet(tran);
        BasicDatabase firstDatabase = (BasicDatabase)((BasicModMultiDatabaseRoot)this.getRoot()).getCurrentDatabase();
        if (firstDatabase == null && this.dbms.isSnowflake()) {
            Object v1;
            block3: {
                Iterable iterable = ((BasicModMultiDatabaseRoot)this.getRoot()).getNamespaces();
                Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getNamespaces(...)");
                Iterable $this$firstOrNull$iv = iterable;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    BasicModMateDatabase it = (BasicModMateDatabase)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (!this.inIntrospectionScope((BasicNamespace)it)) continue;
                    v1 = element$iv;
                    break block3;
                }
                v1 = null;
            }
            firstDatabase = v1;
        }
        if (firstDatabase != null) {
            JBIterable jBIterable = JBIterable.of((Object)firstDatabase);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"of(...)");
            this.introspectNamespacesInTran(tran, jBIterable);
        }
    }

    protected final <T extends BasicDatabase> void introspectNamespacesInTran(@NotNull DBTransaction tran, @NotNull JBIterable<T> databases) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        Intrinsics.checkNotNullParameter(databases, (String)"databases");
        for (BasicDatabase database : databases) {
            Intrinsics.checkNotNull((Object)database);
            this.retrieveSchemasOfDatabase(tran, database);
        }
    }

    protected final void listAndApplyDatabasesIfNotYet(@NotNull DBTransaction tran) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        Iterable iterable = ((BasicModMultiDatabaseRoot)this.getRoot()).getNamespaces();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getNamespaces(...)");
        if (IntrospectionTaskHelperFun.isEmpty((Iterable)iterable) || !this.databasesAreListed) {
            this.trace("Listing databases\u2026");
            DatabaseLister<?, ?> databaseLister = this.createDatabaseLister();
            databaseLister.listAndApplyDatabases$intellij_database_dialects_base(tran);
            Iterable iterable2 = ((BasicModMultiDatabaseRoot)this.getRoot()).getNamespaces();
            Intrinsics.checkNotNullExpressionValue((Object)iterable2, (String)"getNamespaces(...)");
            this.databasesAreListed = IntrospectionTaskHelperFun.isNotEmpty((Iterable)iterable2);
        }
    }

    @Override
    @Nullable
    protected BasicDatabase reifyDatabase(@NotNull DBTransaction transaction, @NotNull String databaseName) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)databaseName, (String)"databaseName");
        BasicDatabase database = this.findDatabase(databaseName);
        if (database == null && !this.databasesAreListed) {
            this.listAndApplyDatabasesIfNotYet(transaction);
            database = this.findDatabase(databaseName);
        }
        return database;
    }

    @Override
    @Nullable
    protected BasicDatabase findDatabase(@NotNull String databaseName) {
        Intrinsics.checkNotNullParameter((Object)databaseName, (String)"databaseName");
        return Intrinsics.areEqual((Object)databaseName, (Object)"@") ? (BasicDatabase)((BasicModMultiDatabaseRoot)this.getRoot()).getCurrentDatabase() : (BasicDatabase)((BasicModMultiDatabaseRoot)this.getRoot()).findDatabaseByName(databaseName);
    }

    @Override
    protected void introspectDatabase(@NotNull DBTransaction transaction, @NotNull DatabaseIntrospectionTask task) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        BasicDatabase basicDatabase = this.getDatabase((IntrospectionTask)task);
        if (basicDatabase == null) {
            IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)this, (String)("Cannot find database with name '" + task.getDatabaseName() + "'."), null, (int)2, null);
            return;
        }
        BasicDatabase database = basicDatabase;
        this.introspectAutoInTran(transaction, SetsKt.setOf((Object)database));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void introspectSchemas(@NotNull DBTransaction transaction, @NotNull SchemasIntrospectionTask task) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        BasicDatabase basicDatabase = this.getDatabase((IntrospectionTask)task);
        if (basicDatabase == null) {
            IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)this, (String)("Cannot find database with name '" + task.getDatabaseName() + "'."), null, (int)2, null);
            return;
        }
        BasicDatabase database = basicDatabase;
        Iterable iterable = database.getAllSchemasInDatabase();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getAllSchemasInDatabase(...)");
        Iterable $this$filter$iv = iterable;
        boolean $i$f$filter = false;
        Iterable iterable2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            BasicSchema it = (BasicSchema)element$iv$iv;
            boolean bl = false;
            if (!task.getSchemaNames().contains(it.getName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List schemas = (List)destination$iv$iv;
        this.introspectAutoInTran(transaction, schemas);
    }

    @Override
    protected void introspectDatabaseFragments(@NotNull DBTransaction transaction, @NotNull DatabaseFragmentIntrospectionTask task) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        BasicDatabase basicDatabase = this.getDatabase((IntrospectionTask)task);
        if (basicDatabase == null) {
            IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)this, (String)("Cannot find database with name '" + task.getDatabaseName() + "'."), null, (int)2, null);
            return;
        }
        BasicDatabase database = basicDatabase;
        BasicModMateDatabase d = (BasicModMateDatabase)database;
        BaseDatabaseRetriever<BasicModMateDatabase> databaseRetriever = this.createDatabaseRetriever(transaction, d);
        databaseRetriever.retrieveAuxiliaryObjects();
    }

    @NotNull
    public TreePattern getDefaultScope() {
        return BaseMultiDatabaseIntrospectorKt.getMULTI_DB_SCOPE();
    }

    @NotNull
    protected abstract DatabaseLister<?, ?> createDatabaseLister();

    public void introspectDatabaseSchemas(BasicDatabase ... databases) {
        Intrinsics.checkNotNullParameter((Object)databases, (String)"databases");
        if (!(databases.length == 0)) {
            IntrospectionQueryContext this_$iv = this;
            boolean $i$f$trace = false;
            if (IntrospectionQueryContext.access$getTracing((IntrospectionQueryContext)this_$iv)) {
                IntrospectionQueryContext introspectionQueryContext = this_$iv;
                boolean bl = false;
                String dbs2 = ArraysKt.joinToString$default((Object[])databases, (CharSequence)"", null, null, (int)0, null, (Function1)introspectDatabaseSchemas.1.dbs.1.INSTANCE, (int)30, null);
                introspectionQueryContext.trace("Introspecting database schemas brief info for the following databases: " + dbs2);
            }
            this.inTransactionUnit((Function1<DBTransaction, Unit>)((Function1)arg_0 -> BaseMultiDatabaseIntrospector.introspectDatabaseSchemas$lambda$1(databases, this, arg_0)));
        } else {
            BasicModMateDatabase basicModMateDatabase = (BasicModMateDatabase)((BasicModMultiDatabaseRoot)this.getRoot()).getCurrentDatabase();
            if (basicModMateDatabase == null) {
                return;
            }
            BasicModMateDatabase currentDatabase = basicModMateDatabase;
            this.trace("Introspecting database schemas for the current database " + currentDatabase.getDisplayName());
            this.inTransactionUnit((Function1<DBTransaction, Unit>)((Function1)arg_0 -> BaseMultiDatabaseIntrospector.introspectDatabaseSchemas$lambda$2(this, currentDatabase, arg_0)));
        }
    }

    @Override
    protected void retrieveSchemasOfDatabase(@NotNull DBTransaction transaction, @NotNull BasicDatabase database) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        boolean bl = this.getModel().contains((DasObject)database);
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string = "Alien database.";
            throw new AssertionError((Object)string);
        }
        BaseDatabaseRetriever<BasicModMateDatabase> databaseRetriever = this.createDatabaseRetriever(transaction, (BasicModMateDatabase)database);
        databaseRetriever.retrieveSchemas();
    }

    @Override
    protected void introspectAutomatically(@NotNull DBTransaction tran, @Nullable Collection<? extends BasicNamespace> namespaces) {
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
                this.introspectPreDatabaseObjects(tran);
                if (namespaces == null) break block5;
                Iterable iterable = ((BasicModMultiDatabaseRoot)this.getRoot()).getNamespaces();
                Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getNamespaces(...)");
                if (!IntrospectionTaskHelperFun.isEmpty((Iterable)iterable)) break block6;
            }
            this.listAndApplyDatabasesIfNotYet(tran);
        }
        if (this.nature.getSupportLevelByLevelIntrospection()) {
            this.introspectAutomaticallyLevelByLevel(tran, namespaces);
        } else {
            this.introspectAutomaticallyNoLevels(tran, namespaces);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void introspectAutomaticallyLevelByLevel(DBTransaction tran, Collection<? extends BasicNamespace> namespaces) {
        JBIterable jBIterable;
        void name$iv$iv;
        void this_$iv$iv;
        JBIterable name$iv;
        void this_$iv;
        Object db;
        Object database;
        List databasesToIntrospect = CollectionsKt.toList(this.getDatabasesToIntrospect(tran, namespaces));
        IntrospectionQueryContext this_$iv2 = this;
        boolean $i$f$trace = false;
        if (IntrospectionQueryContext.access$getTracing((IntrospectionQueryContext)this_$iv2)) {
            IntrospectionQueryContext introspectionQueryContext = this_$iv2;
            boolean bl = false;
            introspectionQueryContext.trace("introspectAutomaticallyLevelByLevel: getting the following " + databasesToIntrospect.size() + " databases:" + CollectionsKt.joinToString$default((Iterable)databasesToIntrospect, null, null, null, (int)0, null, (Function1)introspectAutomaticallyLevelByLevel.1.1.INSTANCE, (int)31, null));
        }
        boolean needDatabaseLevel23 = false;
        Map databaseRetrievers = new LinkedHashMap(databasesToIntrospect.size());
        Iterator bl = databasesToIntrospect.iterator();
        while (bl.hasNext()) {
            db = database = (BasicModMateDatabase)bl.next();
            BaseDatabaseRetriever<BasicModMateDatabase> databaseRetriever = this.createDatabaseRetriever(tran, db);
            databaseRetrievers.put(db, databaseRetriever);
        }
        CharSequence sectionMessage = CollectionFun.dumpToLongCharSequence((Collection)databasesToIntrospect, (String)"database", BaseMultiDatabaseIntrospector::introspectAutomaticallyLevelByLevel$lambda$1);
        database = this;
        db = "Introspect:Databases";
        Object message$iv = sectionMessage;
        boolean $i$f$doSection = false;
        void var11_16 = this_$iv;
        void var12_18 = name$iv;
        CharSequence message$iv$iv = message$iv;
        boolean $i$f$logSectionBegin = false;
        DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)this_$iv$iv);
        Object ref$iv = dataSourceDiagnosticRecorder != null ? dataSourceDiagnosticRecorder.recordSectionBegin((String)name$iv$iv, message$iv$iv) : null;
        try {
            boolean bl2 = false;
            for (BaseDatabaseRetriever databaseRetriever : databaseRetrievers.values()) {
                if (databaseRetriever instanceof BaseNativeIntrospector.MultiLevelDatabaseRetriever) {
                    databaseRetriever.retrieveSchemas();
                    ((BaseNativeIntrospector.MultiLevelDatabaseRetriever)((Object)databaseRetriever)).processLevel1();
                    needDatabaseLevel23 = true;
                    continue;
                }
                databaseRetriever.process();
            }
        }
        finally {
            this_$iv$iv = this_$iv;
            DiagnosticSectionReference sectionReference$iv$iv = ref$iv;
            boolean $i$f$logSectionEnd = false;
            if (sectionReference$iv$iv != null) {
                DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder2 = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)this_$iv$iv);
                if (dataSourceDiagnosticRecorder2 != null) {
                    DataSourceDiagnosticRecorder.recordSectionEnd$default((DataSourceDiagnosticRecorder)dataSourceDiagnosticRecorder2, (DiagnosticSectionReference)sectionReference$iv$iv, null, (int)2, null);
                }
            }
        }
        if (namespaces != null && !namespaces.isEmpty()) {
            name$iv = JBIterable.from((Iterable)namespaces).flatMap(arg_0 -> BaseMultiDatabaseIntrospector.introspectAutomaticallyLevelByLevel$lambda$4(arg_0 -> BaseMultiDatabaseIntrospector.introspectAutomaticallyLevelByLevel$lambda$3(this, arg_0), arg_0));
            Intrinsics.checkNotNull((Object)name$iv);
            jBIterable = name$iv;
        } else {
            name$iv = JBIterable.from((Iterable)databasesToIntrospect).flatMap(arg_0 -> BaseMultiDatabaseIntrospector.introspectAutomaticallyLevelByLevel$lambda$6(arg_0 -> BaseMultiDatabaseIntrospector.introspectAutomaticallyLevelByLevel$lambda$5(this, arg_0), arg_0)).filter(arg_0 -> BaseMultiDatabaseIntrospector.introspectAutomaticallyLevelByLevel$lambda$7((Function1)new Function1<BasicNamespace, Boolean>((Object)this){

                public final Boolean invoke(BasicNamespace p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((BaseMultiDatabaseIntrospector)((Object)this.receiver)).inIntrospectionScope(p0);
                }
            }, arg_0));
            Intrinsics.checkNotNull((Object)name$iv);
            jBIterable = name$iv;
        }
        JBIterable schemasToIntrospectSequence2 = jBIterable;
        message$iv = schemasToIntrospectSequence2.map(arg_0 -> BaseMultiDatabaseIntrospector.introspectAutomaticallyLevelByLevel$lambda$9(BaseMultiDatabaseIntrospector::introspectAutomaticallyLevelByLevel$lambda$8, arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue((Object)message$iv, (String)"toList(...)");
        Object schemasToIntrospect2 = message$iv;
        Set relatedDatabases = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)schemasToIntrospect2)), BaseMultiDatabaseIntrospector::introspectAutomaticallyLevelByLevel$lambda$10), BaseMultiDatabaseIntrospector::introspectAutomaticallyLevelByLevel$lambda$11));
        for (BasicModMateDatabase db2 : relatedDatabases) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = (Iterable)schemasToIntrospect2;
            boolean $i$f$filter = false;
            ref$iv = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                BasicModSchema it = (BasicModSchema)element$iv$iv;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it.getDatabase(), (Object)db2)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List schemasToIntrospectInDb = (List)destination$iv$iv;
            BaseNativeIntrospector.MultiLevelDatabaseRetriever databaseRetriever = needDatabaseLevel23 ? (($i$f$filter = databaseRetrievers.get(db2)) instanceof BaseNativeIntrospector.MultiLevelDatabaseRetriever ? (BaseNativeIntrospector.MultiLevelDatabaseRetriever)$i$f$filter : null) : null;
            try {
                this.trace("Going to introspect " + schemasToIntrospectInDb.size() + " schemas in database " + db2.getName() + " level-by-level.");
                this.introspectSchemasByLevels(tran, (BasicModDatabase)db2, schemasToIntrospectInDb, true, null, databaseRetriever);
            }
            catch (Exception e) {
                this.logError("Failed to introspect database " + db2.getName() + " level-by-level.", e);
            }
        }
    }

    private final void introspectAutomaticallyNoLevels(DBTransaction tran, Collection<? extends BasicNamespace> namespaces) {
        JBIterable jBIterable;
        List databasesToIntrospect = CollectionsKt.toList(this.getDatabasesToIntrospect(tran, namespaces));
        IntrospectionQueryContext this_$iv = this;
        boolean $i$f$trace = false;
        if (IntrospectionQueryContext.access$getTracing((IntrospectionQueryContext)this_$iv)) {
            IntrospectionQueryContext introspectionQueryContext = this_$iv;
            boolean bl = false;
            introspectionQueryContext.trace("introspectAutomaticallyNoLevels: getting the following " + databasesToIntrospect.size() + " databases:" + CollectionsKt.joinToString$default((Iterable)databasesToIntrospect, null, null, null, (int)0, null, (Function1)introspectAutomaticallyNoLevels.1.1.INSTANCE, (int)31, null));
        }
        this.introspectDatabases(tran, databasesToIntrospect);
        if (namespaces != null && !namespaces.isEmpty()) {
            $i$f$trace = JBIterable.from((Iterable)namespaces).flatMap(arg_0 -> BaseMultiDatabaseIntrospector.introspectAutomaticallyNoLevels$lambda$2(arg_0 -> BaseMultiDatabaseIntrospector.introspectAutomaticallyNoLevels$lambda$1(this, arg_0), arg_0));
            Intrinsics.checkNotNull((Object)$i$f$trace);
            jBIterable = $i$f$trace;
        } else {
            $i$f$trace = JBIterable.from((Iterable)databasesToIntrospect).flatMap(arg_0 -> BaseMultiDatabaseIntrospector.introspectAutomaticallyNoLevels$lambda$4(arg_0 -> BaseMultiDatabaseIntrospector.introspectAutomaticallyNoLevels$lambda$3(this, arg_0), arg_0)).filter(arg_0 -> BaseMultiDatabaseIntrospector.introspectAutomaticallyNoLevels$lambda$5((Function1)new Function1<BasicNamespace, Boolean>((Object)this){

                public final Boolean invoke(BasicNamespace p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((BaseMultiDatabaseIntrospector)((Object)this.receiver)).inIntrospectionScope(p0);
                }
            }, arg_0));
            Intrinsics.checkNotNull((Object)$i$f$trace);
            jBIterable = $i$f$trace;
        }
        JBIterable schemasToIntrospect2 = jBIterable;
        List list = schemasToIntrospect2.filterMap(arg_0 -> BaseMultiDatabaseIntrospector.introspectAutomaticallyNoLevels$lambda$7(BaseMultiDatabaseIntrospector::introspectAutomaticallyNoLevels$lambda$6, arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
        List schemasWillBeIntrospected = list;
        this.introspectSchemas(tran, schemasWillBeIntrospected);
        for (BasicModMateDatabase d : databasesToIntrospect) {
            this.postProcessDatabase(tran, d);
        }
    }

    private final BasicSchema adjustSchemaInstance(BasicSchema $this$adjustSchemaInstance) {
        if ($this$adjustSchemaInstance instanceof BasicModSchema && ((BasicModSchema)$this$adjustSchemaInstance).isDropped()) {
            BasicNamedElement basicNamedElement;
            BasicDatabase basicDatabase = ((BasicModSchema)$this$adjustSchemaInstance).getDatabase();
            if (basicDatabase == null || (basicDatabase = this.adjustDatabaseInstance(basicDatabase)) == null) {
                return null;
            }
            BasicDatabase database = basicDatabase;
            BasicSchema replacement = null;
            Family schemas = database.familyOf(((BasicModSchema)$this$adjustSchemaInstance).getKind());
            if ($this$adjustSchemaInstance instanceof BasicIdentifiedElement && ((BasicIdentifiedElement)$this$adjustSchemaInstance).getObjectId() != Long.MIN_VALUE && schemas instanceof IdentifyingFamily) {
                basicNamedElement = ((IdentifyingFamily)schemas).getByObjectId(((BasicIdentifiedElement)$this$adjustSchemaInstance).getObjectId());
                BasicSchema basicSchema = replacement = basicNamedElement instanceof BasicSchema ? (BasicSchema)basicNamedElement : null;
            }
            if (replacement == null && schemas instanceof NamingFamily) {
                basicNamedElement = ((NamingFamily)schemas).get(((BasicModSchema)$this$adjustSchemaInstance).getName());
                replacement = basicNamedElement instanceof BasicSchema ? (BasicSchema)basicNamedElement : null;
            }
            return replacement;
        }
        return $this$adjustSchemaInstance;
    }

    private final BasicDatabase adjustDatabaseInstance(BasicDatabase $this$adjustDatabaseInstance) {
        if ($this$adjustDatabaseInstance instanceof BasicModDatabase && ((BasicModDatabase)$this$adjustDatabaseInstance).isDropped()) {
            BasicNamedElement basicNamedElement;
            BasicDatabase replacement = null;
            ModFamily databases = (ModFamily)((BasicModMultiDatabaseRoot)this.getRoot()).familyOf(((BasicModDatabase)$this$adjustDatabaseInstance).getKind());
            if ($this$adjustDatabaseInstance instanceof BasicIdentifiedElement && ((BasicIdentifiedElement)$this$adjustDatabaseInstance).getObjectId() != Long.MIN_VALUE && databases instanceof IdentifyingFamily) {
                basicNamedElement = ((IdentifyingFamily)databases).getByObjectId(((BasicIdentifiedElement)$this$adjustDatabaseInstance).getObjectId());
                BasicDatabase basicDatabase = replacement = basicNamedElement instanceof BasicDatabase ? (BasicDatabase)basicNamedElement : null;
            }
            if (replacement == null && databases instanceof NamingFamily) {
                basicNamedElement = ((NamingFamily)databases).get(((BasicModDatabase)$this$adjustDatabaseInstance).getName());
                replacement = basicNamedElement instanceof BasicDatabase ? (BasicDatabase)basicNamedElement : null;
            }
            return replacement;
        }
        return $this$adjustDatabaseInstance;
    }

    protected void introspectPreDatabaseObjects(@NotNull DBTransaction tran) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
    }

    @NotNull
    protected Iterable<D> getDatabasesToIntrospect(@NotNull DBTransaction tran, @Nullable Collection<? extends BasicNamespace> namespaces) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        if (namespaces != null && !namespaces.isEmpty()) {
            JBIterable jBIterable = JBIterable.from((Iterable)namespaces).filterMap(arg_0 -> BaseMultiDatabaseIntrospector.getDatabasesToIntrospect$lambda$1(BaseMultiDatabaseIntrospector::getDatabasesToIntrospect$lambda$0, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filterMap(...)");
            return (Iterable)jBIterable;
        }
        this.introspectNamespacesInTran(tran);
        JBIterable jBIterable = UtilKt.asJBIterable((Iterable)((BasicModMultiDatabaseRoot)this.getRoot()).getNamespaces()).filter(arg_0 -> BaseMultiDatabaseIntrospector.getDatabasesToIntrospect$lambda$2((Function1)new Function1<BasicNamespace, Boolean>((Object)this){

            public final Boolean invoke(BasicNamespace p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((BaseMultiDatabaseIntrospector)((Object)this.receiver)).inIntrospectionScope(p0);
            }
        }, arg_0)).map(arg_0 -> BaseMultiDatabaseIntrospector.getDatabasesToIntrospect$lambda$4(BaseMultiDatabaseIntrospector::getDatabasesToIntrospect$lambda$3, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"map(...)");
        return (Iterable)jBIterable;
    }

    private final List<BasicSchema> getSchemasToIntrospect(BasicModMateDatabase database) {
        Iterable iterable = database.getNamespaces();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getNamespaces(...)");
        return CollectionsKt.toList((Iterable)iterable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void introspectDatabases(DBTransaction tran, Collection<? extends BasicDatabase> databasesToIntrospect) {
        void name$iv$iv;
        void this_$iv$iv;
        void name$iv;
        void this_$iv;
        CharSequence sectionMessage = CollectionFun.dumpToLongCharSequence(databasesToIntrospect, (String)"database", BaseMultiDatabaseIntrospector::introspectDatabases$lambda$0);
        BaseIntrospector baseIntrospector = this;
        String string = "Introspect:Databases";
        CharSequence message$iv = sectionMessage;
        boolean $i$f$doSection = false;
        void var8_8 = this_$iv;
        void var9_10 = name$iv;
        CharSequence message$iv$iv = message$iv;
        boolean $i$f$logSectionBegin = false;
        DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)this_$iv$iv);
        DiagnosticSectionReference ref$iv = dataSourceDiagnosticRecorder != null ? dataSourceDiagnosticRecorder.recordSectionBegin((String)name$iv$iv, message$iv$iv) : null;
        try {
            boolean bl = false;
            for (BasicDatabase basicDatabase : databasesToIntrospect) {
                this.doSectionAndHandleErrors("Introspect:Database", "Introspect database " + basicDatabase.getName(), (Function0<Unit>)((Function0)new Function0<Unit>(basicDatabase, this, tran){
                    final /* synthetic */ BasicDatabase $database;
                    final /* synthetic */ BaseMultiDatabaseIntrospector<MR, D, S> this$0;
                    final /* synthetic */ DBTransaction $tran;
                    {
                        this.$database = $database;
                        this.this$0 = $receiver;
                        this.$tran = $tran;
                    }

                    public final void invoke() {
                        BasicDatabase basicDatabase = this.$database;
                        Intrinsics.checkNotNull((Object)basicDatabase, (String)"null cannot be cast to non-null type D of com.intellij.database.dialects.base.introspector.BaseMultiDatabaseIntrospector");
                        BasicModMateDatabase db = (BasicModMateDatabase)basicDatabase;
                        BaseDatabaseRetriever<BasicModMateDatabase> databaseRetriever = this.this$0.createDatabaseRetriever(this.$tran, db);
                        databaseRetriever.process();
                    }
                }));
            }
        }
        finally {
            this_$iv$iv = this_$iv;
            DiagnosticSectionReference sectionReference$iv$iv = ref$iv;
            boolean $i$f$logSectionEnd = false;
            if (sectionReference$iv$iv != null) {
                DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder2 = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)this_$iv$iv);
                if (dataSourceDiagnosticRecorder2 != null) {
                    DataSourceDiagnosticRecorder.recordSectionEnd$default((DataSourceDiagnosticRecorder)dataSourceDiagnosticRecorder2, (DiagnosticSectionReference)sectionReference$iv$iv, null, (int)2, null);
                }
            }
        }
    }

    private final void introspectSchemas(DBTransaction tran, Collection<? extends BasicSchema> schemasToIntrospect2) {
        ArrayList retrievers = new ArrayList(schemasToIntrospect2.size());
        for (BasicSchema basicSchema : schemasToIntrospect2) {
            BasicDatabase basicDatabase = basicSchema.getDatabase();
            this.doSectionAndHandleErrors("InitializeSchemaRetriever", "Initialize retriever for database " + (basicDatabase != null ? basicDatabase.getName() : null) + " schema " + basicSchema.getName(), (Function0<Unit>)((Function0)() -> BaseMultiDatabaseIntrospector.introspectSchemas$lambda$1(basicSchema, this, tran, retrievers)));
        }
        Iterator iterator = retrievers.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<Object> iterator2 = iterator;
        while (iterator2.hasNext()) {
            Object object = iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"next(...)");
            BaseNativeIntrospector.AbstractSchemaRetriever abstractSchemaRetriever = (BaseNativeIntrospector.AbstractSchemaRetriever)object;
            BasicDatabase basicDatabase = abstractSchemaRetriever.getSchema().getDatabase();
            this.doSectionAndHandleErrors("Introspect:Schema", "Introspect database " + (basicDatabase != null ? basicDatabase.getName() : null) + " schema " + abstractSchemaRetriever.getSchema().getName() + " (names)", (Function0<Unit>)((Function0)() -> BaseMultiDatabaseIntrospector.introspectSchemas$lambda$2(abstractSchemaRetriever)));
        }
        Iterator iterator3 = retrievers.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator3, (String)"iterator(...)");
        iterator2 = iterator3;
        while (iterator2.hasNext()) {
            Object object = iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"next(...)");
            BaseNativeIntrospector.AbstractSchemaRetriever abstractSchemaRetriever = (BaseNativeIntrospector.AbstractSchemaRetriever)object;
            BasicDatabase basicDatabase = abstractSchemaRetriever.getSchema().getDatabase();
            this.doSectionAndHandleErrors("Introspect:Schema", "Introspect database " + (basicDatabase != null ? basicDatabase.getName() : null) + " schema " + abstractSchemaRetriever.getSchema().getName() + " (details)", (Function0<Unit>)((Function0)() -> BaseMultiDatabaseIntrospector.introspectSchemas$lambda$3(abstractSchemaRetriever)));
        }
    }

    @Override
    @NotNull
    protected BaseNativeIntrospector.AbstractNativeRetriever<D> createNativeRetriever(@NotNull DBTransaction transaction, @NotNull D database) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter(database, (String)"database");
        return new BaseNativeIntrospector.AbstractNativeRetriever<D>(this, transaction, database){};
    }

    @Override
    @NotNull
    protected abstract BaseDatabaseRetriever<? extends D> createDatabaseRetriever(@NotNull DBTransaction var1, @NotNull D var2);

    @Override
    @NotNull
    protected abstract BaseNativeIntrospector.AbstractSchemaRetriever<? extends S> createSchemaRetriever(@NotNull DBTransaction var1, @NotNull S var2);

    protected void postProcessDatabase(@NotNull DBTransaction tran, @NotNull D database) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        Intrinsics.checkNotNullParameter(database, (String)"database");
    }

    @Override
    @NotNull
    protected BaseServerObjectsRetriever createServerObjectsRetriever(@NotNull DBTransaction transaction) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        return new BaseServerObjectsRetriever(transaction);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void introspectNativeDefinitions(@NotNull Iterable<? extends BasicElement> elements, boolean withNestedElements, @NotNull Map<BasicElement, String[]> result) {
        void $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        JBIterable jBIterable = JBIterable.from(elements);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"from(...)");
        Iterable $this$groupBy$iv = (Iterable)jBIterable;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            void $this$getOrPut$iv$iv$iv;
            BasicElement it = (BasicElement)element$iv$iv;
            boolean bl = false;
            BasicDatabase key$iv$iv = it.getDatabase();
            Map map = destination$iv$iv;
            BasicDatabase key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map groups = destination$iv$iv;
        for (Map.Entry entry : groups.entrySet()) {
            BasicDatabase db = (BasicDatabase)entry.getKey();
            List dbElements = (List)entry.getValue();
            if (db == null) continue;
            if (!this.getModel().contains((DasObject)db)) {
                throw new IllegalArgumentException("The database " + db + " is from another model");
            }
            BasicModMateDatabase database = (BasicModMateDatabase)db;
            this.inTransactionUnit((Function1<DBTransaction, Unit>)((Function1)arg_0 -> BaseMultiDatabaseIntrospector.introspectNativeDefinitions$lambda$1(this, database, dbElements, withNestedElements, result, arg_0)));
        }
    }

    private static final boolean logModelInfo$lambda$0(BasicMateDatabase it) {
        Iterable iterable = it.getNamespaces();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getNamespaces(...)");
        return IntrospectionTaskHelperFun.isNotEmpty((Iterable)iterable);
    }

    private static final boolean logModelInfo$lambda$1(BasicMateNamespace it) {
        return it.getChildren().isNotEmpty();
    }

    private static final Unit introspectDatabaseSchemas$lambda$1(BasicDatabase[] $databases, BaseMultiDatabaseIntrospector this$0, DBTransaction it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        for (BasicDatabase database : $databases) {
            this$0.retrieveSchemasOfDatabase(it, database);
        }
        return Unit.INSTANCE;
    }

    private static final Unit introspectDatabaseSchemas$lambda$2(BaseMultiDatabaseIntrospector this$0, BasicModMateDatabase $currentDatabase, DBTransaction it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.retrieveSchemasOfDatabase(it, (BasicDatabase)$currentDatabase);
        return Unit.INSTANCE;
    }

    private static final boolean introspectAutomaticallyLevelByLevel$lambda$3$0(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final CharSequence introspectAutomaticallyLevelByLevel$lambda$1(BasicModMateDatabase it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    private static final Iterable introspectAutomaticallyLevelByLevel$lambda$3(BaseMultiDatabaseIntrospector this$0, BasicNamespace ns) {
        JBIterable jBIterable;
        BasicNamespace basicNamespace = ns;
        if (basicNamespace instanceof BasicModMateDatabase) {
            JBIterable jBIterable2 = UtilKt.asJBIterable((Iterable)this$0.getSchemasToIntrospect((BasicModMateDatabase)ns)).filter(arg_0 -> BaseMultiDatabaseIntrospector.introspectAutomaticallyLevelByLevel$lambda$3$0((Function1)new Function1<BasicNamespace, Boolean>((Object)this$0){

                public final Boolean invoke(BasicNamespace p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((BaseMultiDatabaseIntrospector)((Object)this.receiver)).inIntrospectionScope(p0);
                }
            }, arg_0));
            jBIterable = jBIterable2;
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"filter(...)");
        } else if (basicNamespace instanceof BasicModSchema) {
            jBIterable = BaseIntrospectionFunctions.asSingleOrEmptyJBIterable(this$0.adjustSchemaInstance((BasicSchema)ns));
        } else {
            JBIterable jBIterable3 = JBIterable.empty();
            jBIterable = jBIterable3;
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable3, (String)"empty(...)");
        }
        return (Iterable)jBIterable;
    }

    private static final Iterable introspectAutomaticallyLevelByLevel$lambda$4(Function1 $tmp0, Object p0) {
        return (Iterable)$tmp0.invoke(p0);
    }

    private static final Iterable introspectAutomaticallyLevelByLevel$lambda$5(BaseMultiDatabaseIntrospector this$0, BasicModMateDatabase it) {
        Intrinsics.checkNotNull((Object)it);
        return this$0.getSchemasToIntrospect(it);
    }

    private static final Iterable introspectAutomaticallyLevelByLevel$lambda$6(Function1 $tmp0, Object p0) {
        return (Iterable)$tmp0.invoke(p0);
    }

    private static final boolean introspectAutomaticallyLevelByLevel$lambda$7(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final BasicModSchema introspectAutomaticallyLevelByLevel$lambda$8(BasicSchema it) {
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type S of com.intellij.database.dialects.base.introspector.BaseMultiDatabaseIntrospector");
        return (BasicModSchema)it;
    }

    private static final BasicModSchema introspectAutomaticallyLevelByLevel$lambda$9(Function1 $tmp0, Object p0) {
        return (BasicModSchema)$tmp0.invoke(p0);
    }

    private static final BasicDatabase introspectAutomaticallyLevelByLevel$lambda$10(BasicModSchema it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getDatabase();
    }

    private static final BasicModMateDatabase introspectAutomaticallyLevelByLevel$lambda$11(BasicDatabase it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (BasicModMateDatabase)it;
    }

    private static final boolean introspectAutomaticallyNoLevels$lambda$1$0(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Iterable introspectAutomaticallyNoLevels$lambda$1(BaseMultiDatabaseIntrospector this$0, BasicNamespace ns) {
        JBIterable jBIterable;
        BasicNamespace basicNamespace = ns;
        if (basicNamespace instanceof BasicModMateDatabase) {
            JBIterable jBIterable2 = UtilKt.asJBIterable((Iterable)this$0.getSchemasToIntrospect((BasicModMateDatabase)ns)).filter(arg_0 -> BaseMultiDatabaseIntrospector.introspectAutomaticallyNoLevels$lambda$1$0((Function1)new Function1<BasicNamespace, Boolean>((Object)this$0){

                public final Boolean invoke(BasicNamespace p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((BaseMultiDatabaseIntrospector)((Object)this.receiver)).inIntrospectionScope(p0);
                }
            }, arg_0));
            jBIterable = jBIterable2;
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"filter(...)");
        } else if (basicNamespace instanceof BasicModSchema) {
            jBIterable = BaseIntrospectionFunctions.asSingleOrEmptyJBIterable(this$0.adjustSchemaInstance((BasicSchema)ns));
        } else {
            JBIterable jBIterable3 = JBIterable.empty();
            jBIterable = jBIterable3;
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable3, (String)"empty(...)");
        }
        return (Iterable)jBIterable;
    }

    private static final Iterable introspectAutomaticallyNoLevels$lambda$2(Function1 $tmp0, Object p0) {
        return (Iterable)$tmp0.invoke(p0);
    }

    private static final Iterable introspectAutomaticallyNoLevels$lambda$3(BaseMultiDatabaseIntrospector this$0, BasicModMateDatabase it) {
        Intrinsics.checkNotNull((Object)it);
        return this$0.getSchemasToIntrospect(it);
    }

    private static final Iterable introspectAutomaticallyNoLevels$lambda$4(Function1 $tmp0, Object p0) {
        return (Iterable)$tmp0.invoke(p0);
    }

    private static final boolean introspectAutomaticallyNoLevels$lambda$5(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final BasicModSchema introspectAutomaticallyNoLevels$lambda$6(BasicSchema it) {
        return it instanceof BasicModSchema ? (BasicModSchema)it : null;
    }

    private static final BasicModSchema introspectAutomaticallyNoLevels$lambda$7(Function1 $tmp0, Object p0) {
        return (BasicModSchema)$tmp0.invoke(p0);
    }

    private static final BasicModMateDatabase getDatabasesToIntrospect$lambda$0(BasicNamespace it) {
        return (BasicModMateDatabase)DasUtil.getParentOfClass((DasObject)((DasObject)it), BasicDatabase.class, (boolean)false);
    }

    private static final BasicModMateDatabase getDatabasesToIntrospect$lambda$1(Function1 $tmp0, Object p0) {
        return (BasicModMateDatabase)$tmp0.invoke(p0);
    }

    private static final boolean getDatabasesToIntrospect$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final BasicModMateDatabase getDatabasesToIntrospect$lambda$3(BasicModMateDatabase it) {
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type D of com.intellij.database.dialects.base.introspector.BaseMultiDatabaseIntrospector");
        return it;
    }

    private static final BasicModMateDatabase getDatabasesToIntrospect$lambda$4(Function1 $tmp0, Object p0) {
        return (BasicModMateDatabase)$tmp0.invoke(p0);
    }

    private static final CharSequence introspectDatabases$lambda$0(BasicDatabase it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    private static final Unit introspectSchemas$lambda$1(BasicSchema $schema, BaseMultiDatabaseIntrospector this$0, DBTransaction $tran, ArrayList $retrievers) {
        Intrinsics.checkNotNull((Object)$schema, (String)"null cannot be cast to non-null type S of com.intellij.database.dialects.base.introspector.BaseMultiDatabaseIntrospector");
        BasicModSchema s = (BasicModSchema)$schema;
        BaseNativeIntrospector.AbstractSchemaRetriever<BasicModSchema> retriever = this$0.createSchemaRetriever($tran, s);
        $retrievers.add(retriever);
        return Unit.INSTANCE;
    }

    private static final Unit introspectSchemas$lambda$2(BaseNativeIntrospector.AbstractSchemaRetriever $retriever) {
        $retriever.prepareParameters();
        $retriever.processPreliminaryPhase();
        return Unit.INSTANCE;
    }

    private static final Unit introspectSchemas$lambda$3(BaseNativeIntrospector.AbstractSchemaRetriever $retriever) {
        $retriever.processMainPhase();
        return Unit.INSTANCE;
    }

    private static final Unit introspectNativeDefinitions$lambda$1(BaseMultiDatabaseIntrospector this$0, BasicModMateDatabase $database, List $dbElements, boolean $withNestedElements, Map $result, DBTransaction transaction) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        BaseNativeIntrospector.AbstractNativeRetriever<BasicModMateDatabase> retriever = this$0.createNativeRetriever(transaction, $database);
        retriever.retrieveNativeDefinitions($dbElements, $withNestedElements, $result);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00a4\u0004\u0018\u0000*\b\b\u0003\u0010\u0001*\u00020\u00022\u001e\u0012\u0004\u0012\u0002H\u00010\u0003R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00028\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\b\u0010\r\u001a\u00020\u000bH\u0016J\b\u0010\u000e\u001a\u00020\u000bH\u0014J\b\u0010\u000f\u001a\u00020\u000bH\u0014\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$BaseDatabaseRetriever;", "D", "Lcom/intellij/database/model/basic/BasicModMateDatabase;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractDatabaseRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "database", "<init>", "(Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/model/basic/BasicModMateDatabase;)V", "process", "", "retrieveSchemas", "retrieveAuxiliaryObjects", "beforeServerAndDatabaseObjectsRetrieval", "beforeSchemasRetrieval", "intellij.database.dialects.base"})
    protected static abstract class BaseDatabaseRetriever<D extends BasicModMateDatabase>
    extends BaseNativeIntrospector.AbstractDatabaseRetriever<D> {
        final /* synthetic */ BaseMultiDatabaseIntrospector<MR, D, S> this$0;

        public BaseDatabaseRetriever(@NotNull DBTransaction transaction, D database) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter(database, (String)"database");
            this.this$0 = this$0;
            super((BaseNativeIntrospector)this$0, transaction, (BasicModDatabase)database);
        }

        @Override
        public void process() {
            String isCurrentStr = ((BasicNamespace)this.getDatabase()).isCurrent() ? "(current) " : "";
            String string = ((BasicModMateDatabase)this.getDatabase()).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String databaseName = string;
            String introspectionLogMessage = StringFun.centerAndPadAsTitle((String)("INTROSPECTING DATABASE " + databaseName + " " + isCurrentStr), (int)140, (char)'=');
            Object[] objectArray = new Object[]{databaseName};
            this.this$0.reportIntrospecting(introspectionLogMessage, "introspection.report.database.plain", objectArray);
            this.retrieveSchemas();
            this.retrieveAuxiliaryObjects();
        }

        @Override
        public void retrieveSchemas() {
            this.beforeSchemasRetrieval();
        }

        @Override
        public void retrieveAuxiliaryObjects() {
            this.beforeServerAndDatabaseObjectsRetrieval();
        }

        protected void beforeServerAndDatabaseObjectsRetrieval() {
        }

        protected void beforeSchemasRetrieval() {
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u00a4\u0004\u0018\u0000*\b\b\u0003\u0010\u0001*\u00020\u0002*\b\b\u0004\u0010\u0003*\u00020\u00042$\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0005R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0006B'\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00028\u0003\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00040\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0014\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$BaseDatabaseSchemasRetriever;", "D", "Lcom/intellij/database/model/basic/BasicModMateDatabase;", "S", "Lcom/intellij/database/model/basic/BasicModSchema;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractDatabaseSchemasRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "database", "schemas", "", "<init>", "(Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/model/basic/BasicModMateDatabase;Ljava/util/List;)V", "detectAndRemoveDroppedObjects", "", "intellij.database.dialects.base"})
    protected static abstract class BaseDatabaseSchemasRetriever<D extends BasicModMateDatabase, S extends BasicModSchema>
    extends BaseNativeIntrospector.AbstractDatabaseSchemasRetriever<D, S> {
        final /* synthetic */ BaseMultiDatabaseIntrospector<MR, D, S> this$0;

        public BaseDatabaseSchemasRetriever(@NotNull DBTransaction transaction, @NotNull D database, List<? extends S> schemas) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter(database, (String)"database");
            Intrinsics.checkNotNullParameter(schemas, (String)"schemas");
            this.this$0 = this$0;
            super((BaseNativeIntrospector)this$0, transaction, (BasicModDatabase)database, schemas);
        }

        protected void detectAndRemoveDroppedObjects() {
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00a4\u0004\u0018\u0000*\b\b\u0003\u0010\u0001*\u00020\u00022\u001e\u0012\u0004\u0012\u0002H\u00010\u0003R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00028\u0003\u00a2\u0006\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$BaseNativeRetriever;", "D", "Lcom/intellij/database/model/basic/BasicModMateDatabase;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractNativeRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "database", "<init>", "(Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/model/basic/BasicModMateDatabase;)V", "intellij.database.dialects.base"})
    protected static abstract class BaseNativeRetriever<D extends BasicModMateDatabase>
    extends BaseNativeIntrospector.AbstractNativeRetriever<D> {
        final /* synthetic */ BaseMultiDatabaseIntrospector<MR, D, S> this$0;

        public BaseNativeRetriever(@NotNull DBTransaction transaction, D database) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter(database, (String)"database");
            this.this$0 = this$0;
            super((BaseNativeIntrospector)this$0, transaction, (BasicModDatabase)database);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0094\u0004\u0018\u00002\u00180\u0001R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$BaseServerObjectsRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractServerObjectsRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "<init>", "(Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;)V", "intellij.database.dialects.base"})
    protected class BaseServerObjectsRetriever
    extends BaseNativeIntrospector.AbstractServerObjectsRetriever {
        public BaseServerObjectsRetriever(DBTransaction transaction) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            super(BaseMultiDatabaseIntrospector.this, transaction);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00a4\u0004\u0018\u0000*\u0004\b\u0003\u0010\u0001*\b\b\u0004\u0010\u0002*\u00020\u00032\u00020\u0004B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u000bJ\b\u0010\f\u001a\u00020\bH\u0014J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00030\u000e2\u0006\u0010\t\u001a\u00020\nH$J\u0016\u0010\u000f\u001a\u00020\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00030\u000eH\u0014J\u0016\u0010\u0011\u001a\u00020\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00030\u000eH\u0002J\u0014\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0014J\u001d\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00028\u0003H\u0014\u00a2\u0006\u0002\u0010\u001aJ!\u0010\u001b\u001a\u00028\u00042\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u001c2\u0006\u0010\u0019\u001a\u00028\u0003H$\u00a2\u0006\u0002\u0010\u001dJ+\u0010\u001e\u001a\u00028\u00042\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u001c2\u0006\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0004\u00a2\u0006\u0002\u0010#J#\u0010\u001e\u001a\u00028\u00042\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u001c2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0004\u00a2\u0006\u0002\u0010$J\u0012\u0010%\u001a\u00028\u0004*\u00020&H\u0082\b\u00a2\u0006\u0002\u0010'J\u0010\u0010(\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014\u00a8\u0006)"}, d2={"Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$DatabaseLister;", "T", "MD", "Lcom/intellij/database/model/basic/BasicModMateDatabase;", "", "<init>", "(Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector;)V", "listAndApplyDatabases", "", "tran", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "listAndApplyDatabases$intellij_database_dialects_base", "prepareParameters", "listDatabases", "", "traceDatabases", "dbs", "applyDatabases", "shouldUpdateCurrent", "", "databases", "", "isCurrent", "idx", "", "db", "(ILjava/lang/Object;)Z", "applyDatabase", "Lcom/intellij/database/model/families/ModNamingFamily;", "(Lcom/intellij/database/model/families/ModNamingFamily;Ljava/lang/Object;)Lcom/intellij/database/model/basic/BasicModMateDatabase;", "renew", "id", "", "name", "", "(Lcom/intellij/database/model/families/ModNamingFamily;JLjava/lang/String;)Lcom/intellij/database/model/basic/BasicModMateDatabase;", "(Lcom/intellij/database/model/families/ModNamingFamily;Ljava/lang/String;)Lcom/intellij/database/model/basic/BasicModMateDatabase;", "asMD", "Lcom/intellij/database/model/basic/BasicModNamedElement;", "(Lcom/intellij/database/model/basic/BasicModNamedElement;)Lcom/intellij/database/model/basic/BasicModMateDatabase;", "retrieveExternalDatabases", "intellij.database.dialects.base"})
    @SourceDebugExtension(value={"SMAP\nBaseMultiDatabaseIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseMultiDatabaseIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$DatabaseLister\n+ 2 BaseIntrospectionFunctions.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospectionFunctions\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,735:1\n394#1:736\n394#1:737\n179#2,4:738\n183#2,3:745\n1924#3,3:742\n*S KotlinDebug\n*F\n+ 1 BaseMultiDatabaseIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$DatabaseLister\n*L\n389#1:736\n391#1:737\n370#1:738,4\n370#1:745,3\n371#1:742,3\n*E\n"})
    protected abstract class DatabaseLister<T, MD extends BasicModMateDatabase> {
        public final void listAndApplyDatabases$intellij_database_dialects_base(@NotNull DBTransaction tran) {
            Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
            this.prepareParameters();
            List<T> dbs2 = this.listDatabases(tran);
            this.traceDatabases(dbs2);
            this.applyDatabases(dbs2);
            this.retrieveExternalDatabases(tran);
        }

        protected void prepareParameters() {
        }

        @NotNull
        protected abstract List<T> listDatabases(@NotNull DBTransaction var1);

        protected void traceDatabases(@NotNull List<? extends T> dbs2) {
            Intrinsics.checkNotNullParameter(dbs2, (String)"dbs");
            BaseMultiDatabaseIntrospector.this.trace("Listed " + dbs2.size() + " databases");
        }

        private final void applyDatabases(List<? extends T> dbs2) {
            BaseMultiDatabaseIntrospector.this.inModel(arg_0 -> DatabaseLister.applyDatabases$lambda$0(this, dbs2, arg_0));
        }

        protected boolean shouldUpdateCurrent(@NotNull Iterable<?> databases) {
            Intrinsics.checkNotNullParameter(databases, (String)"databases");
            return true;
        }

        protected boolean isCurrent(int idx, T db) {
            return idx == 0;
        }

        @NotNull
        protected abstract MD applyDatabase(@NotNull ModNamingFamily<?> var1, T var2);

        /*
         * WARNING - void declaration
         */
        @NotNull
        protected final MD renew(@NotNull ModNamingFamily<?> databases, long id, @Nullable String name) {
            void $this$asMD$iv;
            Intrinsics.checkNotNullParameter(databases, (String)"databases");
            DatabaseLister databaseLister = this;
            BasicModNamedElement basicModNamedElement = ((ModNamingIdentifyingFamily)databases).renew(id, name);
            Intrinsics.checkNotNullExpressionValue((Object)basicModNamedElement, (String)"renew(...)");
            BasicModNamedElement basicModNamedElement2 = basicModNamedElement;
            boolean $i$f$asMD = false;
            return (MD)((BasicModMateDatabase)$this$asMD$iv);
        }

        @NotNull
        protected final MD renew(@NotNull ModNamingFamily<?> databases, @Nullable String name) {
            Intrinsics.checkNotNullParameter(databases, (String)"databases");
            DatabaseLister databaseLister = this;
            String string = name;
            if (string == null) {
                string = "";
            }
            BasicModNamedElement basicModNamedElement = databases.createOrGet(string);
            Intrinsics.checkNotNullExpressionValue((Object)basicModNamedElement, (String)"createOrGet(...)");
            BasicModNamedElement $this$asMD$iv = basicModNamedElement;
            boolean $i$f$asMD = false;
            return (MD)((BasicModMateDatabase)$this$asMD$iv);
        }

        private final MD asMD(BasicModNamedElement $this$asMD) {
            boolean $i$f$asMD = false;
            Intrinsics.checkNotNull((Object)$this$asMD, (String)"null cannot be cast to non-null type MD of com.intellij.database.dialects.base.introspector.BaseMultiDatabaseIntrospector.DatabaseLister");
            return (MD)((BasicModMateDatabase)$this$asMD);
        }

        protected void retrieveExternalDatabases(@NotNull DBTransaction tran) {
            Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit applyDatabases$lambda$0(DatabaseLister this$0, List $dbs, BasicModMultiDatabaseRoot root) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            ModNamingFamily modNamingFamily = root.getDatabases();
            Intrinsics.checkNotNullExpressionValue((Object)modNamingFamily, (String)"getDatabases(...)");
            ModNamingFamily databases = modNamingFamily;
            boolean updateCurrent = this$0.shouldUpdateCurrent((Iterable)databases);
            ModFamily $this$modifyAndCleanup_u24default$iv = (ModFamily)databases;
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyAndCleanup = false;
            $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
            ModNamingFamily it = (ModNamingFamily)$this$modifyAndCleanup_u24default$iv;
            boolean bl = false;
            Iterable $this$forEachIndexed$iv = $dbs;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void db;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Object t = item$iv;
                int idx = n;
                boolean bl2 = false;
                Object database = this$0.applyDatabase(it, db);
                boolean current = this$0.isCurrent(idx, db);
                if (!updateCurrent) continue;
                ((BasicModNamespace)database).setCurrent(current);
            }
            $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
            $this$modifyAndCleanup_u24default$iv.sort();
            return Unit.INSTANCE;
        }
    }
}

