/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.actions;

import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import java.util.Set;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\b\n\u0002\b\u0007\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\f\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\r\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\"\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u000e\u001a\u00020\n*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"isUpperLetter", "", "shortcut", "Lcom/intellij/openapi/actionSystem/Shortcut;", "isSingleFirstLetter", "keyStroke", "Ljavax/swing/KeyStroke;", "isSingleLetter", "COMMON_SYMBOLS", "", "", "isLetterOrCommonSymbol", "isShift", "isNoModifiers", "modifiersEx", "getModifiersEx", "(Ljavax/swing/KeyStroke;)I", "intellij.rd.platform"})
public final class ShortcutsKt {
    @NotNull
    private static final Set<Integer> COMMON_SYMBOLS;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isUpperLetter(@NotNull Shortcut shortcut) {
        Intrinsics.checkNotNullParameter((Object)shortcut, (String)"shortcut");
        if (!(shortcut instanceof KeyboardShortcut)) return false;
        if (((KeyboardShortcut)shortcut).getSecondKeyStroke() != null) return false;
        KeyStroke keyStroke = ((KeyboardShortcut)shortcut).getFirstKeyStroke();
        Intrinsics.checkNotNullExpressionValue((Object)keyStroke, (String)"getFirstKeyStroke(...)");
        if (!ShortcutsKt.isUpperLetter(keyStroke)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isSingleFirstLetter(@NotNull Shortcut shortcut) {
        Intrinsics.checkNotNullParameter((Object)shortcut, (String)"shortcut");
        if (!(shortcut instanceof KeyboardShortcut)) return false;
        KeyStroke keyStroke = ((KeyboardShortcut)shortcut).getFirstKeyStroke();
        Intrinsics.checkNotNullExpressionValue((Object)keyStroke, (String)"getFirstKeyStroke(...)");
        if (!ShortcutsKt.isSingleLetter(keyStroke)) return false;
        return true;
    }

    private static final boolean isUpperLetter(KeyStroke keyStroke) {
        return ShortcutsKt.isShift(keyStroke) && ShortcutsKt.isLetterOrCommonSymbol(keyStroke);
    }

    private static final boolean isSingleLetter(KeyStroke keyStroke) {
        return ShortcutsKt.isNoModifiers(keyStroke) && ShortcutsKt.isLetterOrCommonSymbol(keyStroke);
    }

    private static final boolean isLetterOrCommonSymbol(KeyStroke keyStroke) {
        int n = keyStroke.getKeyCode();
        return (65 <= n ? n < 91 : false) || COMMON_SYMBOLS.contains(keyStroke.getKeyCode());
    }

    private static final boolean isShift(KeyStroke keyStroke) {
        return ShortcutsKt.getModifiersEx(keyStroke) == 64;
    }

    private static final boolean isNoModifiers(KeyStroke keyStroke) {
        return ShortcutsKt.getModifiersEx(keyStroke) == 0;
    }

    private static final int getModifiersEx(KeyStroke $this$modifiersEx) {
        return $this$modifiersEx.getModifiers() & 0xFFFFFFC0;
    }

    static {
        Object[] objectArray = new Integer[]{61, 45, 46, 44, 47, 92, 59, 222, 192};
        COMMON_SYMBOLS = SetsKt.setOf((Object[])objectArray);
    }
}

