/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.codeInspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.Language;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.codeInspection.GradleDslInspectionProvider;
import org.jetbrains.plugins.gradle.service.resolve.PropertiesKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/gradle/codeInspection/GradleRedundantKotlinStdLibInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "isAvailableForFile", "", "file", "Lcom/intellij/psi/PsiFile;", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "intellij.gradle.java"})
public final class GradleRedundantKotlinStdLibInspection
extends LocalInspectionTool {
    public boolean isAvailableForFile(@NotNull PsiFile file) {
        String kotlinStdlibDefaultDependencyProp;
        block3: {
            String string;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            for (PropertiesFile it : PropertiesKt.gradlePropertiesStream((PsiElement)file)) {
                boolean bl = false;
                IProperty iProperty = it.findPropertyByKey("kotlin.stdlib.default.dependency");
                String string2 = iProperty != null ? iProperty.getValue() : null;
                if (string2 == null) continue;
                string = string2;
                break block3;
            }
            string = kotlinStdlibDefaultDependencyProp = null;
        }
        if (Intrinsics.areEqual(kotlinStdlibDefaultDependencyProp, (Object)"false")) {
            return false;
        }
        Language language = file.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        Language language2 = language;
        GradleDslInspectionProvider gradleDslInspectionProvider = (GradleDslInspectionProvider)GradleDslInspectionProvider.Companion.getINSTANCE().forLanguage(language2);
        if (gradleDslInspectionProvider == null) {
            return false;
        }
        GradleDslInspectionProvider inspectionProvider = gradleDslInspectionProvider;
        return inspectionProvider.isRedundantKotlinStdLibInspectionAvailable(file);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Language language = holder.getFile().getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        Language language2 = language;
        GradleDslInspectionProvider gradleDslInspectionProvider = (GradleDslInspectionProvider)GradleDslInspectionProvider.Companion.getINSTANCE().forLanguage(language2);
        if (gradleDslInspectionProvider == null) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        GradleDslInspectionProvider inspectionProvider = gradleDslInspectionProvider;
        return inspectionProvider.getRedundantKotlinStdLibInspectionVisitor(holder, isOnTheFly);
    }
}

