/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.codeInspection.groovy;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.PsiMethodPattern;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.codeInspection.GradleInspectionBundle;
import org.jetbrains.plugins.gradle.codeInspection.fix.GradleDependencyNamedArgumentsFix;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.patterns.GroovyMethodCallPattern;
import org.jetbrains.plugins.groovy.lang.psi.patterns.GroovyPatternsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/gradle/codeInspection/groovy/GroovyAvoidDependencyNamedArgumentsNotationInspectionVisitor;", "Lorg/jetbrains/plugins/groovy/lang/psi/GroovyElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;)V", "visitMethodCall", "", "call", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrMethodCall;", "hasUnexpectedNamedArguments", "", "namedArguments", "", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/arguments/GrNamedArgument;", "Companion", "intellij.gradle.java"})
@SourceDebugExtension(value={"SMAP\nGroovyAvoidDependencyNamedArgumentsNotationInspectionVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GroovyAvoidDependencyNamedArgumentsNotationInspectionVisitor.kt\norg/jetbrains/plugins/gradle/codeInspection/groovy/GroovyAvoidDependencyNamedArgumentsNotationInspectionVisitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,56:1\n1586#2:57\n1661#2,3:58\n*S KotlinDebug\n*F\n+ 1 GroovyAvoidDependencyNamedArgumentsNotationInspectionVisitor.kt\norg/jetbrains/plugins/gradle/codeInspection/groovy/GroovyAvoidDependencyNamedArgumentsNotationInspectionVisitor\n*L\n46#1:57\n46#1:58,3\n*E\n"})
public final class GroovyAvoidDependencyNamedArgumentsNotationInspectionVisitor
extends GroovyElementVisitor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProblemsHolder holder;
    @NotNull
    private static final GroovyMethodCallPattern DEPENDENCY_CALL_PATTERN = GroovyMethodCallPattern.INSTANCE.resolvesTo((ElementPattern)GroovyPatternsKt.withKind((PsiMethodPattern)GroovyPatternsKt.psiMethod((String)"org.gradle.api.artifacts.dsl.DependencyHandler", (String[])new String[0]), (Object)"gradle:dependencyMethod"));
    @NotNull
    private static final GroovyMethodCallPattern SPECIAL_DEPENDENCY_CALL_PATTERN;

    public GroovyAvoidDependencyNamedArgumentsNotationInspectionVisitor(@NotNull ProblemsHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        this.holder = holder;
    }

    public void visitMethodCall(@NotNull GrMethodCall call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        if (!DEPENDENCY_CALL_PATTERN.accepts((Object)call) && !SPECIAL_DEPENDENCY_CALL_PATTERN.accepts((Object)call)) {
            return;
        }
        GrExpression[] grExpressionArray = call.getArgumentList().getExpressionArguments();
        Intrinsics.checkNotNullExpressionValue((Object)grExpressionArray, (String)"getExpressionArguments(...)");
        GrExpression[] arguments = grExpressionArray;
        if (arguments.length == 0) {
            GrNamedArgument[] grNamedArgumentArray = call.getNamedArguments();
            Intrinsics.checkNotNullExpressionValue((Object)grNamedArgumentArray, (String)"getNamedArguments(...)");
            if (this.hasUnexpectedNamedArguments(ArraysKt.asList((Object[])grNamedArgumentArray))) {
                return;
            }
            ProblemsHolder.ProblemBuilder problemBuilder = this.holder.problem((PsiElement)call, GradleInspectionBundle.message("inspection.message.avoid.dependency.named.arguments.notation.descriptor", new Object[0])).range(call.getArgumentList().getTextRangeInParent());
            GrArgumentList grArgumentList = call.getArgumentList();
            Intrinsics.checkNotNullExpressionValue((Object)grArgumentList, (String)"getArgumentList(...)");
            problemBuilder.maybeFix((LocalQuickFix)GradleDependencyNamedArgumentsFix.Companion.createFixIfPossible((GroovyPsiElement)grArgumentList)).register();
        } else {
            for (GrExpression argument : arguments) {
                if (!(argument instanceof GrListOrMap) || !((GrListOrMap)argument).isMap()) continue;
                GrNamedArgument[] grNamedArgumentArray = ((GrListOrMap)argument).getNamedArguments();
                Intrinsics.checkNotNullExpressionValue((Object)grNamedArgumentArray, (String)"getNamedArguments(...)");
                if (this.hasUnexpectedNamedArguments(ArraysKt.asList((Object[])grNamedArgumentArray))) continue;
                this.holder.problem((PsiElement)argument, GradleInspectionBundle.message("inspection.message.avoid.dependency.named.arguments.notation.descriptor", new Object[0])).maybeFix((LocalQuickFix)GradleDependencyNamedArgumentsFix.Companion.createFixIfPossible((GroovyPsiElement)argument)).register();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasUnexpectedNamedArguments(List<? extends GrNamedArgument> namedArguments) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = namedArguments;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            GrNamedArgument grNamedArgument = (GrNamedArgument)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getLabelName());
        }
        Set namedArgumentsNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Object[] objectArray = new String[]{"group", "name"};
        return !namedArgumentsNames.containsAll(SetsKt.setOf((Object[])objectArray));
    }

    static {
        String[] stringArray = new String[]{"platform", "enforcedPlatform", "testFixtures"};
        PsiElementPattern psiElementPattern = GroovyPatternsKt.psiMethod((String)"org.gradle.api.artifacts.dsl.DependencyHandler", (String[])new String[0]).withName(stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)psiElementPattern, (String)"withName(...)");
        SPECIAL_DEPENDENCY_CALL_PATTERN = GroovyMethodCallPattern.INSTANCE.resolvesTo((ElementPattern)psiElementPattern);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/gradle/codeInspection/groovy/GroovyAvoidDependencyNamedArgumentsNotationInspectionVisitor$Companion;", "", "<init>", "()V", "DEPENDENCY_CALL_PATTERN", "Lorg/jetbrains/plugins/groovy/lang/psi/patterns/GroovyMethodCallPattern;", "SPECIAL_DEPENDENCY_CALL_PATTERN", "intellij.gradle.java"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

