/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.build;

import com.intellij.execution.JavaRunConfigurationBase;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.util.ScriptFileUtil;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginSet;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.task.ExecuteRunConfigurationTask;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.build.GradleBaseApplicationEnvironmentProvider;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.runner.GroovyScriptRunConfiguration;
import org.jetbrains.plugins.groovy.runner.GroovyScriptRunner;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0007H\u0014J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u0007H\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/gradle/execution/build/GroovyGradleApplicationEnvironmentProvider;", "Lorg/jetbrains/plugins/gradle/execution/build/GradleBaseApplicationEnvironmentProvider;", "<init>", "()V", "getMainClass", "", "profile", "Lcom/intellij/execution/JavaRunConfigurationBase;", "getConfigurationRunName", "configureParameters", "Lcom/intellij/execution/configurations/JavaParameters;", "runProfile", "isApplicable", "", "task", "Lcom/intellij/task/ExecuteRunConfigurationTask;", "isGroovyPluginEnabledAndLoaded", "intellij.gradle.java"})
public final class GroovyGradleApplicationEnvironmentProvider
extends GradleBaseApplicationEnvironmentProvider {
    @Override
    @NotNull
    protected String getMainClass(@NotNull JavaRunConfigurationBase profile) {
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        return "org.codehaus.groovy.tools.GroovyStarter";
    }

    @Override
    @Nullable
    protected String getConfigurationRunName(@NotNull JavaRunConfigurationBase profile) {
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        GroovyScriptRunConfiguration groovyScriptRunConfiguration = profile instanceof GroovyScriptRunConfiguration ? (GroovyScriptRunConfiguration)profile : null;
        return groovyScriptRunConfiguration != null ? groovyScriptRunConfiguration.getName() : null;
    }

    @Override
    @Nullable
    protected JavaParameters configureParameters(@NotNull JavaRunConfigurationBase runProfile) {
        Intrinsics.checkNotNullParameter((Object)runProfile, (String)"runProfile");
        if (!(runProfile instanceof GroovyScriptRunConfiguration)) {
            return null;
        }
        VirtualFile virtualFile = ScriptFileUtil.findScriptFileByPath((String)((GroovyScriptRunConfiguration)runProfile).getScriptPath());
        if (virtualFile == null) {
            return null;
        }
        VirtualFile scriptFile = virtualFile;
        GroovyScriptRunner groovyScriptRunner = ((GroovyScriptRunConfiguration)runProfile).getScriptRunner();
        if (groovyScriptRunner == null) {
            return null;
        }
        GroovyScriptRunner runner = groovyScriptRunner;
        return ((GroovyScriptRunConfiguration)runProfile).createJavaParameters(scriptFile, runner);
    }

    public boolean isApplicable(@Nullable ExecuteRunConfigurationTask task) {
        ExecuteRunConfigurationTask executeRunConfigurationTask = task;
        if (executeRunConfigurationTask == null || (executeRunConfigurationTask = executeRunConfigurationTask.getRunProfile()) == null) {
            return false;
        }
        ExecuteRunConfigurationTask runProfile = executeRunConfigurationTask;
        if (!(runProfile instanceof JavaRunConfigurationBase) || !this.isGroovyPluginEnabledAndLoaded((JavaRunConfigurationBase)runProfile)) {
            return false;
        }
        if (!(runProfile instanceof GroovyScriptRunConfiguration)) {
            return false;
        }
        return GroovyConfigUtils.getInstance().isVersionAtLeast(((GroovyScriptRunConfiguration)runProfile).getModule(), "5.0", false);
    }

    private final boolean isGroovyPluginEnabledAndLoaded(JavaRunConfigurationBase runProfile) {
        Project project = runProfile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        Object object = CachedValuesManager.getManager((Project)project2).getCachedValue((UserDataHolder)runProfile, GroovyGradleApplicationEnvironmentProvider::isGroovyPluginEnabledAndLoaded$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (Boolean)object;
    }

    private static final CachedValueProvider.Result isGroovyPluginEnabledAndLoaded$lambda$0() {
        PluginId groovyPluginId = PluginId.Companion.getId("org.intellij.groovy");
        PluginSet pluginSet = PluginManagerCore.getPluginSet();
        Object[] objectArray = new Object[]{PsiModificationTracker.NEVER_CHANGED};
        return CachedValueProvider.Result.create((Object)pluginSet.isPluginEnabled(groovyPluginId), (Object[])objectArray);
    }
}

