/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner;

import com.intellij.ide.IdeTooltipManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CustomizedDataContext;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.observable.util.DisposerUtilKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.ui.FileColorManager;
import com.intellij.util.FunctionUtil;
import com.intellij.util.PopupUtilsKt;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import icons.ExternalSystemIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestRunConfigurationProducer;
import org.jetbrains.plugins.gradle.execution.test.runner.TestGradleConfigurationProducerUtilKt;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.TasksToRun;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u0000 \"2\u00020\u0001:\u0003!\"#B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002JH\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\"\u0010\u0011\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0014\u0012\u0012\u0012\b\u0012\u00060\u0007j\u0002`\u0015\u0012\u0004\u0012\u00020\u00160\u00140\u00130\u0012JP\u0010\b\u001a\u00020\t\"\u0004\b\u0000\u0010\u00172\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0016\u0010\u0018\u001a\u0012\u0012\b\u0012\u00060\u0007j\u0002`\u0019\u0012\u0004\u0012\u0002H\u00170\u00142\u0018\u0010\u0011\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00170\u0013\u0012\u0004\u0012\u00020\t0\u001aH\u0016J>\u0010\u001b\u001a\"\u0012\b\u0012\u00060\u0007j\u0002`\u0019\u0012\u0014\u0012\u0012\u0012\b\u0012\u00060\u0007j\u0002`\u0015\u0012\u0004\u0012\u00020\u00160\u00140\u00142\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00132\u0006\u0010\n\u001a\u00020\u000bH\u0002JP\u0010\u001e\u001a\u00020\t\"\u0004\b\u0000\u0010\u00172\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0016\u0010\u0018\u001a\u0012\u0012\b\u0012\u00060\u0007j\u0002`\u0019\u0012\u0004\u0012\u0002H\u00170\u00142\u0018\u0010\u0011\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00170\u0013\u0012\u0004\u0012\u00020\t0\u001aH\u0014J\u0018\u0010\u001f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010 \u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0003\u00a8\u0006$"}, d2={"Lorg/jetbrains/plugins/gradle/execution/test/runner/TestTasksChooser;", "", "<init>", "()V", "error", "", "message", "", "chooseTestTasks", "", "project", "Lcom/intellij/openapi/project/Project;", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "elements", "", "Lcom/intellij/psi/PsiElement;", "consumer", "Ljava/util/function/Consumer;", "", "", "Lorg/jetbrains/plugins/gradle/execution/test/runner/SourcePath;", "Lorg/jetbrains/plugins/gradle/util/TasksToRun;", "T", "testTasks", "Lorg/jetbrains/plugins/gradle/execution/test/runner/TestName;", "Lkotlin/Function1;", "findAllTestsTaskToRun", "sources", "Lcom/intellij/openapi/vfs/VirtualFile;", "showTestTasksPopupChooser", "showTestTasksNotFoundWarning", "suggestPopupTitle", "TestTaskListCellRenderer", "Companion", "TestTaskChooserListener", "intellij.gradle.java"})
@SourceDebugExtension(value={"SMAP\nTestTasksChooser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestTasksChooser.kt\norg/jetbrains/plugins/gradle/execution/test/runner/TestTasksChooser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,196:1\n1586#2:197\n1661#2,3:198\n1205#2,2:201\n1282#2,2:203\n1220#2,2:205\n1249#2,4:207\n1285#2:211\n1300#2,2:218\n1315#2,4:220\n1080#2:224\n1642#2,10:225\n1915#2:235\n1916#2:237\n1652#2:238\n78#3:212\n99#3,5:213\n1#4:236\n*S KotlinDebug\n*F\n+ 1 TestTasksChooser.kt\norg/jetbrains/plugins/gradle/execution/test/runner/TestTasksChooser\n*L\n51#1:197\n51#1:198,3\n78#1:201,2\n78#1:203,2\n78#1:205,2\n78#1:207,4\n78#1:211\n80#1:218,2\n80#1:220,4\n92#1:224\n104#1:225,10\n104#1:235\n104#1:237\n104#1:238\n79#1:212\n79#1:213,5\n104#1:236\n*E\n"})
public class TestTasksChooser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String TEST_TASK_NAME = "test";
    @JvmField
    @NotNull
    public static final DataKey<String> LOCATION;

    private final Void error(String message) {
        LOG.error(message);
        throw new IllegalArgumentException(message);
    }

    /*
     * WARNING - void declaration
     */
    public final void chooseTestTasks(@NotNull Project project, @NotNull DataContext context, @NotNull Iterable<? extends PsiElement> elements, @NotNull Consumer<List<Map<String, TasksToRun>>> consumer) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        Iterable<? extends PsiElement> $this$map$iv = elements;
        boolean $i$f$map = false;
        Iterable<? extends PsiElement> iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PsiElement psiElement = (PsiElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            VirtualFile virtualFile = TestGradleConfigurationProducerUtilKt.getSourceFile((PsiElement)it);
            if (virtualFile == null) {
                this.error("Can not find source file for " + (PsiElement)it);
                throw new KotlinNothingValueException();
            }
            collection.add(virtualFile);
        }
        List sources = (List)destination$iv$iv;
        Map<String, Map<String, TasksToRun>> testTasks = this.findAllTestsTaskToRun(sources, project);
        this.chooseTestTasks(project, context, testTasks, (Function1)new Function1<List<? extends Map<String, ? extends TasksToRun>>, Unit>(consumer){

            public final void invoke(List<? extends Map<String, ? extends TasksToRun>> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                ((Consumer)this.receiver).accept(p0);
            }
        });
    }

    public <T> void chooseTestTasks(@NotNull Project project, @NotNull DataContext context, @NotNull Map<String, ? extends T> testTasks, @NotNull Function1<? super List<? extends T>, Unit> consumer) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(testTasks, (String)"testTasks");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        TestTaskChooserListener testTaskChooserListener = TestTaskChooserListener.Companion.getTestTaskChooserListener$intellij_gradle_java();
        if (testTaskChooserListener != null) {
            TestTaskChooserListener it = testTaskChooserListener;
            boolean bl = false;
            it.chooseTestTasks(project, context, testTasks, consumer);
            return;
        }
        if (testTasks.isEmpty()) {
            this.showTestTasksNotFoundWarning(project, context);
        } else if (testTasks.size() == 1) {
            consumer.invoke((Object)CollectionsKt.toList((Iterable)testTasks.values()));
        } else {
            this.showTestTasksPopupChooser(project, context, testTasks, consumer);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Map<String, TasksToRun>> findAllTestsTaskToRun(List<? extends VirtualFile> sources, Project project) {
        void $this$associateWithTo$iv$iv;
        void $this$flatMapTo$iv$iv;
        Map testTasks;
        Object element$iv$iv;
        Map $this$associateTo$iv$iv;
        Iterable $this$associate$iv = sources;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Object destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        Iterator<Object> iterator = $this$associateTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void $this$associateByTo$iv$iv;
            void $this$associateBy$iv;
            element$iv$iv = iterator.next();
            Map map = destination$iv$iv;
            VirtualFile source = (VirtualFile)element$iv$iv;
            boolean bl = false;
            String string = source.getPath();
            List<TasksToRun> list = GradleTestRunConfigurationProducer.findAllTestsTaskToRun(source, project);
            Intrinsics.checkNotNullExpressionValue(list, (String)"findAllTestsTaskToRun(...)");
            Iterable iterable2 = list;
            String string2 = string;
            boolean $i$f$associateBy = false;
            int capacity$iv2 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            void var19_24 = $this$associateBy$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv2);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv2 : $this$associateByTo$iv$iv) {
                void it;
                TasksToRun tasksToRun = (TasksToRun)element$iv$iv2;
                Map map2 = destination$iv$iv2;
                boolean bl2 = false;
                map2.put(it.getTestName(), element$iv$iv2);
            }
            source = TuplesKt.to((Object)string2, (Object)destination$iv$iv2);
            map.put(source.getFirst(), source.getSecond());
        }
        Map $this$flatMap$iv = testTasks = destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$associateTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        iterator = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Object it = element$iv$iv = (Map.Entry)iterator.next();
            boolean bl = false;
            Iterable list$iv$iv = ((Map)it.getValue()).keySet();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Set testTaskNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $this$associateWith$iv = testTaskNames;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        destination$iv$iv = $this$associateWith$iv;
        Map destination$iv$iv3 = result$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv3 : $this$associateWithTo$iv$iv) {
            void name;
            String bl = (String)element$iv$iv3;
            Object t = element$iv$iv3;
            Map map = destination$iv$iv3;
            boolean bl3 = false;
            Map map3 = TestTasksChooser.Companion.mapNotNullValues(testTasks, arg_0 -> TestTasksChooser.findAllTestsTaskToRun$lambda$2$0((String)name, arg_0));
            map.put(t, map3);
        }
        return destination$iv$iv3;
    }

    /*
     * WARNING - void declaration
     */
    protected <T> void showTestTasksPopupChooser(@NotNull Project project, @NotNull DataContext context, @NotNull Map<String, ? extends T> testTasks, @NotNull Function1<? super List<? extends T>, Unit> consumer) {
        void $this$sortedByDescending$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(testTasks, (String)"testTasks");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        Iterable iterable = CollectionsKt.toList((Iterable)testTasks.keySet());
        boolean $i$f$sortedByDescending = false;
        JBPopupFactory.getInstance().createPopupChooserBuilder(CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                String it = (String)b;
                boolean bl = false;
                Comparable comparable = Boolean.valueOf(Intrinsics.areEqual((Object)it, (Object)"test"));
                it = (String)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Boolean.valueOf(Intrinsics.areEqual((Object)it, (Object)"test")));
            }
        })).setRenderer((ListCellRenderer)new TestTaskListCellRenderer(project)).setTitle(this.suggestPopupTitle(context)).setAutoselectOnMouseMove(false).setNamerForFiltering(FunctionUtil.id()).setMovable(true).setAdText(GradleBundle.message((String)"gradle.tests.tasks.choosing.popup.hint", (Object[])new Object[0])).setResizable(false).setRequestFocus(true).setMinSize((Dimension)JBUI.size((int)270, (int)55)).setItemsChosenCallback(arg_0 -> TestTasksChooser.showTestTasksPopupChooser$lambda$2(arg_0 -> TestTasksChooser.showTestTasksPopupChooser$lambda$1(testTasks, this, project, context, consumer, arg_0), arg_0)).createPopup().show(PopupUtilsKt.getBestPopupPosition((DataContext)context));
    }

    protected void showTestTasksNotFoundWarning(@NotNull Project project, @NotNull DataContext context) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        boolean bl2 = bl = !ApplicationManager.getApplication().isCommandLine();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        JBPopupFactory.getInstance().createBalloonBuilder((JComponent)new JLabel(GradleBundle.message((String)"gradle.tests.tasks.choosing.warning.text", (Object[])new Object[0]))).setFillColor(IdeTooltipManager.Companion.getInstance().getTextBackground(false)).createBalloon().show(PopupUtilsKt.getBestBalloonPosition((DataContext)context), Balloon.Position.above);
    }

    @NlsContexts.PopupTitle
    private final String suggestPopupTitle(DataContext context) {
        String string;
        String locationName = (String)context.getData(LOCATION);
        if (locationName == null) {
            String string2 = GradleBundle.message((String)"gradle.tests.tasks.choosing.popup.title.common", (Object[])new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        } else {
            Object[] objectArray = new Object[]{locationName};
            String string3 = GradleBundle.message((String)"gradle.tests.tasks.choosing.popup.title", (Object[])objectArray);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        }
        return string;
    }

    private static final TasksToRun findAllTestsTaskToRun$lambda$2$0(String $name, Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (TasksToRun)((Map)it.getValue()).get($name);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit showTestTasksPopupChooser$lambda$1(Map $testTasks, TestTasksChooser this$0, Project $project, DataContext $context, Function1 $consumer, Set it) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNull((Object)it);
        Iterable $this$mapNotNull$iv = it;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String p0 = (String)element$iv$iv;
            boolean bl2 = false;
            if ($testTasks.get(p0) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List choosesTestTasks = (List)destination$iv$iv;
        if (choosesTestTasks.isEmpty()) {
            this$0.showTestTasksNotFoundWarning($project, $context);
        } else {
            $consumer.invoke((Object)choosesTestTasks);
        }
        return Unit.INSTANCE;
    }

    private static final void showTestTasksPopupChooser$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @JvmStatic
    @NotNull
    public static final DataContext contextWithLocationName(@NotNull DataContext context, @Nullable String locationName) {
        return Companion.contextWithLocationName(context, locationName);
    }

    static {
        Logger logger = Logger.getInstance(TestTasksChooser.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        LOCATION = DataKey.Companion.create("org.jetbrains.plugins.gradle.execution.test.runner.TestTasksChooser.LOCATION");
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010&\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\bH\u0007JX\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u0002H\u0011\u0012\u0004\u0012\u0002H\u00120\u0010\"\u0004\b\u0000\u0010\u0011\"\u0004\b\u0001\u0010\u0013\"\u0004\b\u0002\u0010\u0012*\u000e\u0012\u0004\u0012\u0002H\u0011\u0012\u0004\u0012\u0002H\u00130\u00102 \u0010\u0014\u001a\u001c\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0011\u0012\u0004\u0012\u0002H\u00130\u0016\u0012\u0006\u0012\u0004\u0018\u0001H\u00120\u0015H\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/plugins/gradle/execution/test/runner/TestTasksChooser$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "TEST_TASK_NAME", "", "LOCATION", "Lcom/intellij/openapi/actionSystem/DataKey;", "contextWithLocationName", "Lcom/intellij/openapi/actionSystem/DataContext;", "context", "locationName", "mapNotNullValues", "", "K", "R", "V", "transform", "Lkotlin/Function1;", "", "intellij.gradle.java"})
    @SourceDebugExtension(value={"SMAP\nTestTasksChooser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestTasksChooser.kt\norg/jetbrains/plugins/gradle/execution/test/runner/TestTasksChooser$Companion\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,196:1\n139#2,10:197\n221#2:207\n222#2:210\n149#2:211\n1#3:208\n1#3:209\n*S KotlinDebug\n*F\n+ 1 TestTasksChooser.kt\norg/jetbrains/plugins/gradle/execution/test/runner/TestTasksChooser$Companion\n*L\n171#1:197,10\n171#1:207\n171#1:210\n171#1:211\n171#1:209\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final DataContext contextWithLocationName(@NotNull DataContext context, @Nullable String locationName) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (locationName == null) {
                return context;
            }
            DataContext dataContext = CustomizedDataContext.withSnapshot((DataContext)context, arg_0 -> Companion.contextWithLocationName$lambda$0(locationName, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"withSnapshot(...)");
            return dataContext;
        }

        /*
         * WARNING - void declaration
         */
        private final <K, V, R> Map<K, R> mapNotNullValues(Map<K, ? extends V> $this$mapNotNullValues, Function1<? super Map.Entry<? extends K, ? extends V>, ? extends R> transform) {
            void $this$mapNotNullTo$iv$iv;
            Map<K, ? extends V> $this$mapNotNull$iv = $this$mapNotNullValues;
            boolean $i$f$mapNotNull = false;
            Map<K, ? extends V> map = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Pair pair;
                Map.Entry element$iv$iv$iv;
                Map.Entry element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Map.Entry entry = element$iv$iv;
                boolean bl2 = false;
                if (transform.invoke(entry) != null) {
                    Object it;
                    boolean bl3 = false;
                    pair = TuplesKt.to(entry.getKey(), (Object)it);
                } else {
                    pair = null;
                }
                if (pair == null) continue;
                Pair it$iv$iv = pair;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return MapsKt.toMap((Iterable)((List)destination$iv$iv));
        }

        private static final void contextWithLocationName$lambda$0(String $locationName, DataSink sink) {
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            sink.set(LOCATION, (Object)$locationName);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\bg\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010JP\u0010\u0002\u001a\u00020\u0003\"\u0004\b\u0000\u0010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0016\u0010\t\u001a\u0012\u0012\b\u0012\u00060\u000bj\u0002`\f\u0012\u0004\u0012\u0002H\u00040\n2\u0018\u0010\r\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00040\u000f\u0012\u0004\u0012\u00020\u00030\u000eH&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0011\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/plugins/gradle/execution/test/runner/TestTasksChooser$TestTaskChooserListener;", "", "chooseTestTasks", "", "T", "project", "Lcom/intellij/openapi/project/Project;", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "testTasks", "", "", "Lorg/jetbrains/plugins/gradle/execution/test/runner/TestName;", "consumer", "Lkotlin/Function1;", "", "Companion", "intellij.gradle.java"})
    @ApiStatus.Internal
    public static interface TestTaskChooserListener {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public <T> void chooseTestTasks(@NotNull Project var1, @NotNull DataContext var2, @NotNull Map<String, ? extends T> var3, @NotNull Function1<? super List<? extends T>, Unit> var4);

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0007R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/gradle/execution/test/runner/TestTasksChooser$TestTaskChooserListener$Companion;", "", "<init>", "()V", "testTaskChooserListener", "Lorg/jetbrains/plugins/gradle/execution/test/runner/TestTasksChooser$TestTaskChooserListener;", "getTestTaskChooserListener$intellij_gradle_java", "()Lorg/jetbrains/plugins/gradle/execution/test/runner/TestTasksChooser$TestTaskChooserListener;", "setTestTaskChooserListener$intellij_gradle_java", "(Lorg/jetbrains/plugins/gradle/execution/test/runner/TestTasksChooser$TestTaskChooserListener;)V", "setTestTaskChooserListener", "", "listener", "disposable", "Lcom/intellij/openapi/Disposable;", "intellij.gradle.java"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @Nullable
            private static TestTaskChooserListener testTaskChooserListener;

            private Companion() {
            }

            @Nullable
            public final TestTaskChooserListener getTestTaskChooserListener$intellij_gradle_java() {
                return testTaskChooserListener;
            }

            public final void setTestTaskChooserListener$intellij_gradle_java(@Nullable TestTaskChooserListener testTaskChooserListener) {
                org.jetbrains.plugins.gradle.execution.test.runner.TestTasksChooser$TestTaskChooserListener$Companion.testTaskChooserListener = testTaskChooserListener;
            }

            @ApiStatus.Internal
            public final void setTestTaskChooserListener(@Nullable TestTaskChooserListener listener, @NotNull Disposable disposable) {
                Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
                TestTaskChooserListener previousValue = testTaskChooserListener;
                testTaskChooserListener = listener;
                DisposerUtilKt.whenDisposed((Disposable)disposable, () -> Companion.setTestTaskChooserListener$lambda$0(previousValue));
            }

            private static final Unit setTestTaskChooserListener$lambda$0(TestTaskChooserListener $previousValue) {
                testTaskChooserListener = $previousValue;
                return Unit.INSTANCE;
            }

            static {
                $$INSTANCE = new Companion();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J8\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0016R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/plugins/gradle/execution/test/runner/TestTasksChooser$TestTaskListCellRenderer;", "Ljavax/swing/DefaultListCellRenderer;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "cellInsets", "Lcom/intellij/util/ui/JBInsets;", "Lorg/jetbrains/annotations/NotNull;", "colorManager", "Lcom/intellij/ui/FileColorManager;", "kotlin.jvm.PlatformType", "getListCellRendererComponent", "Ljava/awt/Component;", "list", "Ljavax/swing/JList;", "value", "", "index", "", "isSelected", "", "cellHasFocus", "intellij.gradle.java"})
    private static final class TestTaskListCellRenderer
    extends DefaultListCellRenderer {
        @NotNull
        private final JBInsets cellInsets;
        private final FileColorManager colorManager;

        public TestTaskListCellRenderer(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            JBInsets jBInsets = JBUI.insets((int)1, (int)5);
            Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"insets(...)");
            this.cellInsets = jBInsets;
            this.colorManager = FileColorManager.getInstance((Project)project);
        }

        @Override
        @NotNull
        public Component getListCellRendererComponent(@Nullable JList<?> list, @Nullable Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            this.setText(String.valueOf(value));
            this.setIcon(ExternalSystemIcons.Task);
            this.setIconTextGap(this.cellInsets.left);
            this.setBorder(new EmptyBorder((Insets)this.cellInsets));
            if (!isSelected) {
                this.setBackground(this.colorManager.getScopeColor("Tests"));
            }
            return this;
        }
    }
}

