/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.jupyter.core.jupyter.preview;

import com.intellij.ide.plugins.cl.PluginAwareClassLoader;
import com.intellij.notebooks.jupyter.core.jupyter.preview.JupyterHttpUtilsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.PathUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.http.client.utils.URIBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.HttpRequestHandler;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\n\b&\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0004H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0004J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0019\u001a\u00020\u0004H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0015\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001b"}, d2={"Lcom/intellij/notebooks/jupyter/core/jupyter/preview/JupyterCefHttpHandlerBase;", "Lorg/jetbrains/ide/HttpRequestHandler;", "absolutePathFiles", "", "", "<init>", "(Ljava/util/Set;)V", "isSupported", "", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "process", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "context", "Lio/netty/channel/ChannelHandlerContext;", "processInternalLibs", "", "uri", "getFileFromUrl", "fullPath", "appName", "getAppName", "()Ljava/lang/String;", "readFile", "file", "Companion", "intellij.notebooks.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterCefHttpHandlerBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterCefHttpHandlerBase.kt\ncom/intellij/notebooks/jupyter/core/jupyter/preview/JupyterCefHttpHandlerBase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,126:1\n1#2:127\n23#3:128\n23#3:129\n*S KotlinDebug\n*F\n+ 1 JupyterCefHttpHandlerBase.kt\ncom/intellij/notebooks/jupyter/core/jupyter/preview/JupyterCefHttpHandlerBase\n*L\n93#1:128\n98#1:129\n*E\n"})
public abstract class JupyterCefHttpHandlerBase
extends HttpRequestHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<String> absolutePathFiles;
    @NotNull
    private static final Set<String> allowedTypes;
    @NotNull
    private static final String JUPYTER_HTTP_URI = "jupyter";
    @NotNull
    public static final String PATH_PREFIX = "/jupyter";

    public JupyterCefHttpHandlerBase(@NotNull Set<String> absolutePathFiles) {
        Intrinsics.checkNotNullParameter(absolutePathFiles, (String)"absolutePathFiles");
        this.absolutePathFiles = absolutePathFiles;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isSupported(@NotNull FullHttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (!super.isSupported(request)) return false;
        String it = request.uri();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        if (StringsKt.startsWith$default((String)it, (String)PATH_PREFIX, (boolean)false, (int)2, null)) return true;
        if (!this.absolutePathFiles.contains(it)) return false;
        return true;
    }

    public boolean process(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) {
        Intrinsics.checkNotNullParameter((Object)urlDecoder, (String)"urlDecoder");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String fullPath = urlDecoder.path();
        Intrinsics.checkNotNull((Object)fullPath);
        String string = this.getFileFromUrl(fullPath);
        if (string == null) {
            return false;
        }
        String uri = string;
        byte[] byArray = this.processInternalLibs(uri);
        if (byArray == null) {
            return false;
        }
        byte[] readBytes = byArray;
        String string2 = this.getAppName() + "/" + uri;
        Channel channel = context.channel();
        Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel(...)");
        EmptyHttpHeaders emptyHttpHeaders = EmptyHttpHeaders.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)emptyHttpHeaders, (String)"INSTANCE");
        this.sendData(readBytes, string2, request, channel, (HttpHeaders)emptyHttpHeaders);
        return true;
    }

    private final byte[] processInternalLibs(String uri) {
        try {
            String string = FileUtilRt.getExtension((String)uri);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExtension(...)");
            String extension = string;
            if (allowedTypes.contains(extension) || ApplicationManager.getApplication().isInternal() && Intrinsics.areEqual((Object)extension, (Object)"map")) {
                return this.readFile(uri);
            }
            JupyterCefHttpHandlerBase $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(JupyterCefHttpHandlerBase.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.info("Extension not allowed: " + extension);
            return null;
        }
        catch (Throwable t) {
            JupyterCefHttpHandlerBase $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(JupyterCefHttpHandlerBase.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Cannot process: " + uri, t);
            return null;
        }
    }

    @Nullable
    protected final String getFileFromUrl(@NotNull String fullPath) {
        Intrinsics.checkNotNullParameter((Object)fullPath, (String)"fullPath");
        if (this.absolutePathFiles.contains(fullPath)) {
            return fullPath;
        }
        if (StringsKt.startsWith$default((String)fullPath, (String)PATH_PREFIX, (boolean)false, (int)2, null)) {
            String string = StringsKt.replace$default((String)fullPath, (String)"//", (String)"/", (boolean)false, (int)4, null).substring(8);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            char[] cArray = new char[]{'/'};
            String uri = StringsKt.trimStart((String)string, (char[])cArray);
            if (((CharSequence)uri).length() > 0 && !StringsKt.contains$default((CharSequence)uri, (CharSequence)"..", (boolean)false, (int)2, null)) {
                return uri;
            }
        }
        return null;
    }

    @NotNull
    public abstract String getAppName();

    private final byte[] readFile(String file) {
        if (StringsKt.contains$default((CharSequence)file, (CharSequence)"BASE_EXTENSION_PATH", (boolean)false, (int)2, null)) {
            return null;
        }
        String appName = this.getAppName();
        URL resource = JupyterCefHttpHandlerBase.Companion.getResource(((Object)((Object)this)).getClass(), appName + "/" + file);
        return TextStreamsKt.readBytes((URL)resource);
    }

    static {
        Object[] objectArray = new String[]{"css", "js", "html", "svg", "woff", "woff2", "ttf"};
        allowedTypes = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\nJ\u001c\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\u0006H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/notebooks/jupyter/core/jupyter/preview/JupyterCefHttpHandlerBase$Companion;", "", "<init>", "()V", "allowedTypes", "", "", "JUPYTER_HTTP_URI", "PATH_PREFIX", "getJupyterHttpUrl", "Lorg/apache/http/client/utils/URIBuilder;", "getIndexUrl", "getResource", "Ljava/net/URL;", "javaClass", "Ljava/lang/Class;", "path", "intellij.notebooks.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final URIBuilder getJupyterHttpUrl() {
            return JupyterHttpUtilsKt.addPathSegment(JupyterHttpUtilsKt.getJupyterBaseUrl("http"), JupyterCefHttpHandlerBase.JUPYTER_HTTP_URI);
        }

        @NotNull
        public final URIBuilder getIndexUrl() {
            return JupyterHttpUtilsKt.addPathSegment(this.getJupyterHttpUrl(), "index.html");
        }

        private final URL getResource(Class<?> javaClass, String path) {
            URL url;
            URL uRL = javaClass.getClassLoader().getResource(path);
            if (uRL == null) {
                ClassLoader classLoader = javaClass.getClassLoader();
                Object object = classLoader instanceof PluginAwareClassLoader ? (PluginAwareClassLoader)classLoader : null;
                uRL = object != null && (object = object.getPluginDescriptor()) != null && (object = object.getPluginPath()) != null && (object = object.normalize()) != null && (object = object.resolve(path)) != null && (object = object.toUri()) != null ? ((URI)object).toURL() : null;
            }
            if (StringsKt.contains$default((CharSequence)String.valueOf(url = uRL), (CharSequence)"plugins/jupyter-plugin/lib/jupyter-web/", (boolean)false, (int)2, null)) {
                url = new URL(StringsKt.replace$default((String)String.valueOf(url), (String)"plugins/jupyter-plugin/lib/jupyter-web/", (String)"plugins/jupyter-plugin/jupyter-web/", (boolean)false, (int)4, null));
            } else if (StringsKt.contains$default((CharSequence)String.valueOf(url), (CharSequence)"out/classes/production/intellij.jupyter.plugin", (boolean)false, (int)2, null)) {
                url = new URL(StringsKt.replace$default((String)String.valueOf(url), (String)"out/classes/production/intellij.jupyter.plugin", (String)"out/dev-run/Python/plugins/jupyter-plugin", (boolean)false, (int)4, null));
            }
            if (url != null) {
                return url;
            }
            String string = PathUtil.getJarPathForClass(javaClass);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getJarPathForClass(...)");
            String myPath = string;
            File result = new File(new File(myPath).getParentFile().getParentFile(), path);
            URL uRL2 = result.toURI().toURL();
            Intrinsics.checkNotNullExpressionValue((Object)uRL2, (String)"toURL(...)");
            return uRL2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

