/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.PortField;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.ButtonsGroup;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.MutablePropertyKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.RowLayout;
import com.intellij.ui.dsl.builder.SpinnerKt;
import com.intellij.ui.dsl.builder.TextFieldKt;
import com.intellij.ui.dsl.builder.TextFieldWithBrowseButtonKt;
import com.intellij.ui.layout.ComponentPredicate;
import com.intellij.ui.layout.ComponentPredicateKt;
import com.intellij.util.EnvironmentUtil;
import java.awt.event.ActionEvent;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnConfigurationState;
import org.jetbrains.idea.svn.commandLine.SshTunnelRuntimeModule;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0002H\u0016J\u0010\u0010&\u001a\u00020'2\u0006\u0010%\u001a\u00020\u0002H\u0016J\u0010\u0010(\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0002H\u0016J\b\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020$H\u0016J\u001d\u0010,\u001a\u00020$2\u0006\u0010-\u001a\u00020\r2\u000b\u0010.\u001a\u00070\u001e\u00a2\u0006\u0002\b/H\u0002J\u0010\u00100\u001a\u00020$2\u0006\u00101\u001a\u00020\u001eH\u0002J\u0017\u00102\u001a\u00020$2\r\u00101\u001a\t\u0018\u00010\u001e\u00a2\u0006\u0002\b3H\u0002J\u0012\u00104\u001a\u00020$2\b\u00101\u001a\u0004\u0018\u00010\u001eH\u0002R\u0016\u0010\b\u001a\n \t*\u0004\u0018\u00010\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001f\u001a\u00020 \u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u00065"}, d2={"Lorg/jetbrains/idea/svn/dialogs/SshSettingConfigurableUi;", "Lcom/intellij/openapi/options/ConfigurableUi;", "Lorg/jetbrains/idea/svn/SvnConfiguration;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "svnConfiguration", "kotlin.jvm.PlatformType", "executablePathTextField", "Lcom/intellij/ui/components/JBTextField;", "executablePathField", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "userNameField", "portField", "Lcom/intellij/ui/PortField;", "passwordChoice", "Lcom/intellij/ui/components/JBRadioButton;", "privateKeyChoice", "privateKeyPathField", "subversionConfigChoice", "sshTunnelField", "updateTunnelButton", "Lcom/intellij/ui/dsl/builder/Cell;", "Ljavax/swing/JButton;", "svnSshVariableLabel", "Ljavax/swing/JLabel;", "svnSshVariableField", "sshTunnelFromConfig", "", "panel", "Lcom/intellij/openapi/ui/DialogPanel;", "getPanel", "()Lcom/intellij/openapi/ui/DialogPanel;", "reset", "", "settings", "isModified", "", "apply", "getComponent", "Ljavax/swing/JComponent;", "dispose", "registerBrowseDialog", "component", "dialogTitle", "Lcom/intellij/openapi/util/NlsContexts$DialogTitle;", "setSshTunnelSetting", "tunnelSetting", "updateSshTunnelDependentValues", "Lcom/intellij/openapi/util/NlsSafe;", "setUpdateTunnelButtonEnabled", "intellij.vcs.svn"})
@SourceDebugExtension(value={"SMAP\nSshSettingConfigurableUi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SshSettingConfigurableUi.kt\norg/jetbrains/idea/svn/dialogs/SshSettingConfigurableUi\n+ 2 ButtonsGroup.kt\ncom/intellij/ui/dsl/builder/ButtonsGroupKt\n*L\n1#1,196:1\n31#2:197\n*S KotlinDebug\n*F\n+ 1 SshSettingConfigurableUi.kt\norg/jetbrains/idea/svn/dialogs/SshSettingConfigurableUi\n*L\n132#1:197\n*E\n"})
public final class SshSettingConfigurableUi
implements ConfigurableUi<SvnConfiguration>,
Disposable {
    private final SvnConfiguration svnConfiguration;
    @NotNull
    private final JBTextField executablePathTextField;
    @NotNull
    private final TextFieldWithBrowseButton executablePathField;
    private JBTextField userNameField;
    @NotNull
    private final PortField portField;
    private JBRadioButton passwordChoice;
    private JBRadioButton privateKeyChoice;
    @NotNull
    private final TextFieldWithBrowseButton privateKeyPathField;
    private JBRadioButton subversionConfigChoice;
    private JBTextField sshTunnelField;
    private Cell<? extends JButton> updateTunnelButton;
    @NotNull
    private final JLabel svnSshVariableLabel;
    private JBTextField svnSshVariableField;
    @Nullable
    private String sshTunnelFromConfig;
    @NotNull
    private final DialogPanel panel;

    public SshSettingConfigurableUi(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.svnConfiguration = SvnConfiguration.getInstance(project);
        this.executablePathTextField = new JBTextField();
        this.executablePathField = new TextFieldWithBrowseButton((JTextField)this.executablePathTextField, null, (Disposable)this);
        this.portField = new PortField();
        this.privateKeyPathField = new TextFieldWithBrowseButton(null, (Disposable)this);
        this.svnSshVariableLabel = new JLabel();
        this.panel = BuilderKt.panel(arg_0 -> SshSettingConfigurableUi.panel$lambda$0(this, arg_0));
        String string = SvnBundle.message("dialog.title.ssh.settings.browse.executable", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.registerBrowseDialog(this.executablePathField, string);
        String string2 = SvnBundle.message("dialog.title.ssh.settings.browse.private.key", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        this.registerBrowseDialog(this.privateKeyPathField, string2);
        JBTextField jBTextField = this.sshTunnelField;
        if (jBTextField == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sshTunnelField");
            jBTextField = null;
        }
        this.setUpdateTunnelButtonEnabled(jBTextField.getText());
    }

    @NotNull
    public final DialogPanel getPanel() {
        return this.panel;
    }

    public void reset(@NotNull SvnConfiguration settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.panel.reset();
        String string = settings.getSshTunnelSetting();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSshTunnelSetting(...)");
        this.setSshTunnelSetting(string);
    }

    public boolean isModified(@NotNull SvnConfiguration settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        return this.panel.isModified();
    }

    public void apply(@NotNull SvnConfiguration settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.panel.apply();
    }

    @NotNull
    public JComponent getComponent() {
        return (JComponent)this.panel;
    }

    public void dispose() {
    }

    private final void registerBrowseDialog(TextFieldWithBrowseButton component, String dialogTitle) {
        component.addBrowseFolderListener(this.svnConfiguration.getProject(), FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor().withTitle(dialogTitle));
    }

    private final void setSshTunnelSetting(String tunnelSetting) {
        this.sshTunnelFromConfig = tunnelSetting;
        JBTextField jBTextField = this.sshTunnelField;
        if (jBTextField == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sshTunnelField");
            jBTextField = null;
        }
        jBTextField.setText(tunnelSetting);
        this.updateSshTunnelDependentValues(tunnelSetting);
    }

    private final void updateSshTunnelDependentValues(String tunnelSetting) {
        String string = SshTunnelRuntimeModule.getSvnSshVariableName(StringUtil.isEmpty((String)tunnelSetting) ? "$SVN_SSH ssh -q" : tunnelSetting);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSvnSshVariableName(...)");
        String svnSshVariableName = string;
        String string2 = EnvironmentUtil.getValue((String)svnSshVariableName);
        if (string2 == null) {
            string2 = "";
        }
        String svnSshVariableValue = string2;
        this.svnSshVariableLabel.setText(svnSshVariableName + ":");
        JBTextField jBTextField = this.svnSshVariableField;
        if (jBTextField == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"svnSshVariableField");
            jBTextField = null;
        }
        jBTextField.setText(svnSshVariableValue);
        boolean isSvnSshVariableNameInTunnel = !StringUtil.isEmpty((String)svnSshVariableName);
        this.svnSshVariableLabel.setVisible(isSvnSshVariableNameInTunnel);
        JBTextField jBTextField2 = this.svnSshVariableField;
        if (jBTextField2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"svnSshVariableField");
            jBTextField2 = null;
        }
        jBTextField2.setVisible(isSvnSshVariableNameInTunnel);
        this.executablePathTextField.getEmptyText().setText(SshTunnelRuntimeModule.getExecutablePath(tunnelSetting));
        this.setUpdateTunnelButtonEnabled(tunnelSetting);
    }

    private final void setUpdateTunnelButtonEnabled(String tunnelSetting) {
        Cell<? extends JButton> cell = this.updateTunnelButton;
        if (cell == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"updateTunnelButton");
            cell = null;
        }
        cell.enabled(!Intrinsics.areEqual((Object)tunnelSetting, (Object)this.sshTunnelFromConfig));
    }

    private static final Unit panel$lambda$0$0$0(SshSettingConfigurableUi this$0, SvnConfigurationState $state, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        TextFieldWithBrowseButtonKt.bindText((Cell)$this$row.cell((JComponent)this$0.executablePathField).align((Align)AlignX.FILL.INSTANCE), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl($state){

            public Object get() {
                return ((SvnConfigurationState)this.receiver).sshExecutablePath;
            }

            public void set(Object value) {
                ((SvnConfigurationState)this.receiver).sshExecutablePath = (String)value;
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$0$1(SshSettingConfigurableUi this$0, SvnConfigurationState $state, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.userNameField = (JBTextField)TextFieldKt.bindText((Cell)$this$row.textField().align((Align)AlignX.FILL.INSTANCE), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl($state){

            public Object get() {
                return ((SvnConfigurationState)this.receiver).sshUserName;
            }

            public void set(Object value) {
                ((SvnConfigurationState)this.receiver).sshUserName = (String)value;
            }
        })).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$0$2(SshSettingConfigurableUi this$0, SvnConfigurationState $state, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        SpinnerKt.bindIntValue((Cell)$this$row.cell((JComponent)this$0.portField), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl($state){

            public Object get() {
                return ((SvnConfigurationState)this.receiver).sshPort;
            }

            public void set(Object value) {
                ((SvnConfigurationState)this.receiver).sshPort = ((Number)value).intValue();
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$1$2$0$0(SshSettingConfigurableUi this$0, SvnConfigurationState $state, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        TextFieldWithBrowseButtonKt.bindText((Cell)$this$row.cell((JComponent)this$0.privateKeyPathField).align((Align)AlignX.FILL.INSTANCE), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl($state){

            public Object get() {
                return ((SvnConfigurationState)this.receiver).sshPrivateKeyPath;
            }

            public void set(Object value) {
                ((SvnConfigurationState)this.receiver).sshPrivateKeyPath = (String)value;
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$1$2$0(SshSettingConfigurableUi this$0, SvnConfigurationState $state, Panel $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        String string = SvnBundle.message("ssh.settings.private.key.path.label", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$indent.row(string, arg_0 -> SshSettingConfigurableUi.panel$lambda$0$1$2$0$0(this$0, $state, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$1$4$0$0$0(JBTextField $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.getEmptyText().setText("$SVN_SSH ssh -q");
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$1$4$0$0$1(SshSettingConfigurableUi this$0, JBTextField it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        JBTextField jBTextField = this$0.sshTunnelField;
        if (jBTextField == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sshTunnelField");
            jBTextField = null;
        }
        this$0.updateSshTunnelDependentValues(jBTextField.getText());
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$1$4$0$0$2(SshSettingConfigurableUi this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        JBTextField jBTextField = this$0.sshTunnelField;
        if (jBTextField == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sshTunnelField");
            jBTextField = null;
        }
        String tunnel = jBTextField.getText();
        this$0.svnConfiguration.setSshTunnelSetting(StringUtil.nullize((String)tunnel));
        String string = this$0.svnConfiguration.getSshTunnelSetting();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSshTunnelSetting(...)");
        this$0.setSshTunnelSetting(string);
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$1$4$0$1$0(JBTextField $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setEditable(false);
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$1$4$0$0(SshSettingConfigurableUi this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.sshTunnelField = (JBTextField)$this$row.textField().resizableColumn().align((Align)AlignX.FILL.INSTANCE).applyToComponent(SshSettingConfigurableUi::panel$lambda$0$1$4$0$0$0).onChanged(arg_0 -> SshSettingConfigurableUi.panel$lambda$0$1$4$0$0$1(this$0, arg_0)).getComponent();
        String string = SvnBundle.message("ssh.settings.update.tunnel.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this$0.updateTunnelButton = $this$row.button(string, arg_0 -> SshSettingConfigurableUi.panel$lambda$0$1$4$0$0$2(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$1$4$0$1(SshSettingConfigurableUi this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.svnSshVariableField = (JBTextField)$this$row.textField().align((Align)AlignX.FILL.INSTANCE).applyToComponent(SshSettingConfigurableUi::panel$lambda$0$1$4$0$1$0).getComponent();
        $this$row.cell();
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$1$4$0(SshSettingConfigurableUi this$0, Panel $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        String string = SvnBundle.message("ssh.settings.tunnel.label", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$indent.row(string, arg_0 -> SshSettingConfigurableUi.panel$lambda$0$1$4$0$0(this$0, arg_0)).layout(RowLayout.PARENT_GRID);
        $this$indent.row(this$0.svnSshVariableLabel, arg_0 -> SshSettingConfigurableUi.panel$lambda$0$1$4$0$1(this$0, arg_0)).layout(RowLayout.PARENT_GRID);
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$1$0(SshSettingConfigurableUi this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = SvnBundle.message("ssh.settings.password.choice.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this$0.passwordChoice = (JBRadioButton)$this$row.radioButton(string, (Object)SvnConfiguration.SshConnectionType.PASSWORD).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$1$1(SshSettingConfigurableUi this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = SvnBundle.message("ssh.settings.private.key.choice.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this$0.privateKeyChoice = (JBRadioButton)$this$row.radioButton(string, (Object)SvnConfiguration.SshConnectionType.PRIVATE_KEY).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$1$2(SshSettingConfigurableUi this$0, SvnConfigurationState $state, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        $this$panel.indent(arg_0 -> SshSettingConfigurableUi.panel$lambda$0$1$2$0(this$0, $state, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$1$3(SshSettingConfigurableUi this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = SvnBundle.message("ssh.settings.subversion.config.choice.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this$0.subversionConfigChoice = (JBRadioButton)ButtonKt.selected((Cell)$this$row.radioButton(string, (Object)SvnConfiguration.SshConnectionType.SUBVERSION_CONFIG), (boolean)true).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$1$4(SshSettingConfigurableUi this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        $this$panel.indent(arg_0 -> SshSettingConfigurableUi.panel$lambda$0$1$4$0(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$0(SshSettingConfigurableUi this$0, SvnConfigurationState $state, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        String string = SvnBundle.message("ssh.settings.executable.label", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$panel.row(string, arg_0 -> SshSettingConfigurableUi.panel$lambda$0$0$0(this$0, $state, arg_0));
        String string2 = SvnBundle.message("ssh.settings.user.name.label", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        $this$panel.row(string2, arg_0 -> SshSettingConfigurableUi.panel$lambda$0$0$1(this$0, $state, arg_0));
        String string3 = SvnBundle.message("ssh.settings.port.label", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        $this$panel.row(string3, arg_0 -> SshSettingConfigurableUi.panel$lambda$0$0$2(this$0, $state, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$1(SshSettingConfigurableUi this$0, Panel $passwordPanel, SvnConfigurationState $state, Panel $this$buttonsGroup) {
        Intrinsics.checkNotNullParameter((Object)$this$buttonsGroup, (String)"$this$buttonsGroup");
        Panel.row$default((Panel)$this$buttonsGroup, null, arg_0 -> SshSettingConfigurableUi.panel$lambda$0$1$0(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$buttonsGroup, null, arg_0 -> SshSettingConfigurableUi.panel$lambda$0$1$1(this$0, arg_0), (int)1, null);
        Panel panel2 = $this$buttonsGroup.panel(arg_0 -> SshSettingConfigurableUi.panel$lambda$0$1$2(this$0, $state, arg_0));
        JBRadioButton jBRadioButton = this$0.privateKeyChoice;
        if (jBRadioButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"privateKeyChoice");
            jBRadioButton = null;
        }
        panel2.enabledIf(ComponentPredicateKt.getSelected((AbstractButton)((AbstractButton)jBRadioButton)));
        JBRadioButton jBRadioButton2 = this$0.passwordChoice;
        if (jBRadioButton2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"passwordChoice");
            jBRadioButton2 = null;
        }
        ComponentPredicate componentPredicate = ComponentPredicateKt.getSelected((AbstractButton)((AbstractButton)jBRadioButton2));
        JBRadioButton jBRadioButton3 = this$0.privateKeyChoice;
        if (jBRadioButton3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"privateKeyChoice");
            jBRadioButton3 = null;
        }
        $passwordPanel.enabledIf(ComponentPredicateKt.or((ComponentPredicate)componentPredicate, (ComponentPredicate)ComponentPredicateKt.getSelected((AbstractButton)((AbstractButton)jBRadioButton3))));
        Panel.row$default((Panel)$this$buttonsGroup, null, arg_0 -> SshSettingConfigurableUi.panel$lambda$0$1$3(this$0, arg_0), (int)1, null);
        Panel panel3 = $this$buttonsGroup.panel(arg_0 -> SshSettingConfigurableUi.panel$lambda$0$1$4(this$0, arg_0));
        JBRadioButton jBRadioButton4 = this$0.subversionConfigChoice;
        if (jBRadioButton4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"subversionConfigChoice");
            jBRadioButton4 = null;
        }
        panel3.enabledIf(ComponentPredicateKt.getSelected((AbstractButton)((AbstractButton)jBRadioButton4)));
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit panel$lambda$0(SshSettingConfigurableUi this$0, Panel $this$panel) {
        void $this$bind$iv;
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        SvnConfigurationState svnConfigurationState = this$0.svnConfiguration.getState();
        Intrinsics.checkNotNullExpressionValue((Object)svnConfigurationState, (String)"getState(...)");
        SvnConfigurationState state = svnConfigurationState;
        Panel passwordPanel2 = $this$panel.panel(arg_0 -> SshSettingConfigurableUi.panel$lambda$0$0(this$0, state, arg_0));
        ButtonsGroup buttonsGroup = Panel.buttonsGroup$default((Panel)$this$panel, null, (boolean)false, arg_0 -> SshSettingConfigurableUi.panel$lambda$0$1(this$0, passwordPanel2, state, arg_0), (int)3, null);
        KMutableProperty0 prop$iv = (KMutableProperty0)new MutablePropertyReference0Impl(state){

            public Object get() {
                return ((SvnConfigurationState)this.receiver).sshConnectionType;
            }

            public void set(Object value) {
                ((SvnConfigurationState)this.receiver).sshConnectionType = (SvnConfiguration.SshConnectionType)((Object)value);
            }
        };
        boolean $i$f$bind = false;
        $this$bind$iv.bind(MutablePropertyKt.toMutableProperty((KMutableProperty0)prop$iv), SvnConfiguration.SshConnectionType.class);
        return Unit.INSTANCE;
    }
}

