/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.database.util.common.BooleanFun;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.formatter.model.AdjacentBlocks;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.BlockShape;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlExpressionBlock;
import com.intellij.sql.formatter.model.SqlFlowBlock;
import com.intellij.sql.formatter.model.SqlFormattingContext;
import com.intellij.sql.formatter.model.SqlFormattingFunKt;
import com.intellij.sql.formatter.model.SqlFormattingModelFun;
import com.intellij.sql.formatter.model.SqlNodeBlock;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.psi.SqlElementTypes;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\bH\u0014J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0012H\u0014J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\bH\u0016J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\n\u0010 \u001a\u0004\u0018\u00010\u001dH\u0002J\n\u0010!\u001a\u0004\u0018\u00010\u001dH\u0002J\u0012\u0010\"\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/sql/formatter/model/SqlFunctionCallBlock;", "Lcom/intellij/sql/formatter/model/SqlNodeBlock;", "Lcom/intellij/sql/formatter/model/SqlExpressionBlock;", "<init>", "()V", "countOfElements", "", "functionName", "Lcom/intellij/sql/formatter/model/SqlBlock;", "prefix", "suffix", "whetherToFlatten", "", "node", "Lcom/intellij/lang/ASTNode;", "determineRole", "Lcom/intellij/sql/formatter/model/BlockRole;", "considerBlock", "", "block", "isSpecialFunctionReference", "elementType", "Lcom/intellij/psi/tree/IElementType;", "configureFormattingAttributes", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "block2", "getNewLineIndent", "", "blocks", "Lcom/intellij/sql/formatter/model/AdjacentBlocks;", "getNewLineIndentForPrefix", "getNewLineIndentForSuffix", "getNewLineIndentForComment", "intellij.database.sql.core.impl"})
@SourceDebugExtension(value={"SMAP\nSqlExpressionBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlExpressionBlock.kt\ncom/intellij/sql/formatter/model/SqlFunctionCallBlock\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 SqlBlock.kt\ncom/intellij/sql/formatter/model/SqlBlock\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,369:1\n1#2:370\n112#3,4:371\n112#3,4:375\n112#3,4:379\n112#3,4:384\n1915#4:383\n1916#4:388\n*S KotlinDebug\n*F\n+ 1 SqlExpressionBlock.kt\ncom/intellij/sql/formatter/model/SqlFunctionCallBlock\n*L\n265#1:371,4\n266#1:375,4\n267#1:379,4\n274#1:384,4\n274#1:383\n274#1:388\n*E\n"})
public final class SqlFunctionCallBlock
extends SqlNodeBlock
implements SqlExpressionBlock {
    private int countOfElements;
    @Nullable
    private SqlBlock functionName;
    @Nullable
    private SqlBlock prefix;
    @Nullable
    private SqlBlock suffix;

    @Override
    protected boolean whetherToFlatten(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return node.getElementType() == SqlElementTypes.SQL_EXPRESSION_LIST || node.getElementType() == SqlElementTypes.SQL_ARGUMENT_LIST;
    }

    @Override
    @NotNull
    public BlockRole determineRole(@NotNull ASTNode node) {
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (node.getElementType() == SqlElementTypes.SQL_ANY_CALLABLE_REFERENCE) break block4;
                IElementType iElementType = node.getElementType();
                Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
                if (!this.isSpecialFunctionReference(iElementType)) break block5;
            }
            return BlockRole.BODY;
        }
        BlockRole r = super.determineRole(node);
        if (r == BlockRole.NOTHING) {
            r = BlockRole.ELEMENT;
        }
        return r;
    }

    @Override
    protected void considerBlock(@NotNull SqlBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        super.considerBlock(block);
        switch (WhenMappings.$EnumSwitchMapping$0[block.getRole().ordinal()]) {
            case 1: {
                if (this.functionName != null) break;
                this.functionName = block;
                break;
            }
            case 2: {
                if (this.prefix != null) break;
                this.prefix = block;
                break;
            }
            case 3: {
                this.suffix = block;
                break;
            }
            case 4: {
                int n = this.countOfElements;
                this.countOfElements = n + 1;
            }
        }
    }

    private final boolean isSpecialFunctionReference(IElementType elementType) {
        SqlLanguageDialect it = this.getContext().getDialect();
        boolean bl = false;
        return it instanceof SqlLanguageDialectEx && ((SqlLanguageDialectEx)it).isSpecialFunctionReference(elementType);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void configureFormattingAttributes() {
        if (BooleanFun.countNonNulls((Object)this.functionName, (Object)this.prefix, (Object)this.suffix) >= 2) {
            Indent indent$iv;
            Wrap wrap$iv;
            SqlBlock this_$iv;
            boolean $i$f$setAttributes;
            Alignment align$iv;
            Alignment a = SqlFormattingModelFun.makeLeftAlignment();
            SqlBlock sqlBlock = this.functionName;
            if (sqlBlock != null) {
                SqlBlock sqlBlock2 = sqlBlock;
                Object var4_4 = null;
                Indent indent = SqlFormattingFunKt.getNONE_INDENT();
                align$iv = a;
                $i$f$setAttributes = false;
                this_$iv.setMyWrap(wrap$iv);
                this_$iv.setMyIndent(indent$iv);
                this_$iv.setMyAlign(align$iv);
            }
            SqlBlock sqlBlock3 = this.prefix;
            if (sqlBlock3 != null) {
                this_$iv = sqlBlock3;
                wrap$iv = null;
                indent$iv = SqlFormattingFunKt.getNORMAL_INDENT();
                align$iv = a;
                $i$f$setAttributes = false;
                this_$iv.setMyWrap(wrap$iv);
                this_$iv.setMyIndent(indent$iv);
                this_$iv.setMyAlign(align$iv);
            }
            SqlBlock sqlBlock4 = this.suffix;
            if (sqlBlock4 != null) {
                this_$iv = sqlBlock4;
                wrap$iv = null;
                indent$iv = SqlFormattingFunKt.getNONE_INDENT();
                align$iv = a;
                $i$f$setAttributes = false;
                this_$iv.setMyWrap(wrap$iv);
                this_$iv.setMyIndent(indent$iv);
                this_$iv.setMyAlign(align$iv);
            }
        }
        if (this.countOfElements > 0) {
            boolean multi = this.countOfElements >= 2;
            this.setInnerWrap(this.getShape().compareTo((Enum)BlockShape.DECIDED_TO_ONE_ROW) > 0 && multi ? SqlFlowBlock.makeCascadeWrap$default(this, WrapType.NORMAL, false, 2, null) : null);
            Indent i2 = Indent.getContinuationIndent();
            Alignment a = multi ? SqlFormattingModelFun.makeLeftAlignment() : null;
            Iterable $this$forEach$iv = (Iterable)SqlFormattingModelFun.filter((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.ELEMENT);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void indent$iv;
                void wrap$iv;
                void this_$iv;
                SqlBlock it = (SqlBlock)element$iv;
                boolean bl = false;
                SqlBlock sqlBlock = it;
                Wrap wrap = this.getInnerWrap();
                Indent indent = i2;
                Alignment align$iv = a;
                boolean $i$f$setAttributes = false;
                this_$iv.setMyWrap((Wrap)wrap$iv);
                this_$iv.setMyIndent((Indent)indent$iv);
                this_$iv.setMyAlign(align$iv);
            }
        }
    }

    @Override
    @Nullable
    public Spacing decideSpacing(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
        Intrinsics.checkNotNullParameter((Object)block1, (String)"block1");
        Intrinsics.checkNotNullParameter((Object)block2, (String)"block2");
        SqlCodeStyleSettings s = this.getContext().getSql();
        IElementType t1 = SqlFormattingModelFun.primaryElementType(block1);
        IElementType t2 = SqlFormattingModelFun.primaryElementType(block2);
        boolean mr = this.getShape() == BlockShape.DECIDED_TO_MULTI_ROWS;
        return t2 == SqlElementTypes.SQL_LEFT_PAREN ? SqlFormattingContext.makeNoSpace$default(this.getContext(), false, 1, null) : (t1 == SqlElementTypes.SQL_LEFT_PAREN || t2 == SqlElementTypes.SQL_RIGHT_PAREN ? this.getContext().makeSpace(s.EXPR_CALL_SPACE_INSIDE_PARENTHESES) : (t2 == SqlElementTypes.SQL_COMMA ? this.getContext().makeSpace(s.EXPR_CALL_SPACE_BEFORE_COMMA) : (t1 == SqlElementTypes.SQL_COMMA ? this.getContext().makeSpace(s.EXPR_CALL_SPACE_AFTER_COMMA) : super.decideSpacing(block1, block2))));
    }

    @Override
    @Nullable
    public String getNewLineIndent(@NotNull AdjacentBlocks blocks) {
        Intrinsics.checkNotNullParameter((Object)blocks, (String)"blocks");
        return switch (WhenMappings.$EnumSwitchMapping$0[blocks.getRole2().ordinal()]) {
            case 2 -> this.getNewLineIndentForPrefix();
            case 3 -> this.getNewLineIndentForSuffix();
            case 4, 5 -> null;
            case 6, 7, 8 -> this.getNewLineIndentForComment(blocks);
            default -> super.getNewLineIndent(blocks);
        };
    }

    private final String getNewLineIndentForPrefix() {
        SqlBlock functionName = this.functionName;
        return functionName != null ? SqlFormattingContext.currIndentOf$default(this.getContext(), functionName, false, false, false, 14, null) : null;
    }

    private final String getNewLineIndentForSuffix() {
        SqlBlock blockX;
        SqlBlock sqlBlock = this.functionName;
        if (sqlBlock == null) {
            sqlBlock = this.prefix;
        }
        return (blockX = sqlBlock) != null ? SqlFormattingContext.currIndentOf$default(this.getContext(), blockX, true, false, false, 12, null) : null;
    }

    private final String getNewLineIndentForComment(AdjacentBlocks blocks) {
        int positionOfComment;
        int positionOfPrefix = CollectionsKt.indexOf(this.getNestedBlocks(), (Object)this.prefix);
        return positionOfPrefix < (positionOfComment = CollectionsKt.indexOf(this.getNestedBlocks(), (Object)blocks.getBlock2())) ? null : this.getNewLineIndentForPrefix();
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BlockRole.values().length];
            try {
                nArray[BlockRole.BODY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockRole.PREFIX.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockRole.SUFFIX.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockRole.ELEMENT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockRole.DELIMITER.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockRole.LARGE_COMMENT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockRole.TINY_COMMENT.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockRole.LINE_COMMENT.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

