/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.types.DasType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlJoinConditionClause;
import com.intellij.sql.psi.SqlJoinExpression;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlLateralAwareExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlTokenType;
import com.intellij.sql.psi.SqlUsingClause;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlBinaryExpressionImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 )2\u00020\u00012\u00020\u0002:\u0001)B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0014J\u0012\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001f\u001a\u0004\u0018\u00010\fH\u0016J\u0012\u0010 \u001a\u00020\u001c2\b\u0010\u001f\u001a\u0004\u0018\u00010\fH\u0014J\u0014\u0010!\u001a\u0004\u0018\u00010\f2\b\u0010\u001f\u001a\u0004\u0018\u00010\fH\u0004J*\u0010\"\u001a\u00020\u00132\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010\f2\u0006\u0010(\u001a\u00020\fH\u0016R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0014R\u0014\u0010\u0016\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0014R\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006*"}, d2={"Lcom/intellij/sql/psi/impl/SqlJoinExpressionImpl;", "Lcom/intellij/sql/psi/impl/SqlBinaryExpressionImpl;", "Lcom/intellij/sql/psi/SqlJoinExpression;", "elementType", "Lcom/intellij/psi/tree/IElementType;", "<init>", "(Lcom/intellij/psi/tree/IElementType;)V", "accept", "", "visitor", "Lcom/intellij/sql/psi/SqlVisitor;", "opSignElement", "Lcom/intellij/psi/PsiElement;", "getOpSignElement", "()Lcom/intellij/psi/PsiElement;", "opSign", "getOpSign", "()Lcom/intellij/psi/tree/IElementType;", "isLeft", "", "()Z", "isRight", "isNatural", "usingClause", "Lcom/intellij/sql/psi/SqlUsingClause;", "getUsingClause", "()Lcom/intellij/sql/psi/SqlUsingClause;", "getDasType", "Lcom/intellij/sql/psi/SqlTableType;", "computeDasType", "Lcom/intellij/database/types/DasType;", "end", "calcType", "getLastToCheck", "processDeclarations", "processor", "Lcom/intellij/sql/psi/SqlScopeProcessor;", "state", "Lcom/intellij/psi/ResolveState;", "lastParent", "place", "Companion", "intellij.database.sql.core.impl"})
@SourceDebugExtension(value={"SMAP\nSqlJoinExpressionImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlJoinExpressionImpl.kt\ncom/intellij/sql/psi/impl/SqlJoinExpressionImpl\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 SqlUtilFun.kt\ncom/intellij/sql/SqlUtilFun\n*L\n1#1,175:1\n128#2,2:176\n275#3:178\n275#3:179\n*S KotlinDebug\n*F\n+ 1 SqlJoinExpressionImpl.kt\ncom/intellij/sql/psi/impl/SqlJoinExpressionImpl\n*L\n26#1:176,2\n52#1:178\n85#1:179\n*E\n"})
public class SqlJoinExpressionImpl
extends SqlBinaryExpressionImpl
implements SqlJoinExpression {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public SqlJoinExpressionImpl(@NotNull IElementType elementType) {
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
        super(elementType);
    }

    @Override
    public void accept(@NotNull SqlVisitor visitor2) {
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        visitor2.visitSqlJoinExpression((SqlJoinExpression)this);
    }

    @Override
    @NotNull
    public PsiElement getOpSignElement() {
        Object element$iv2;
        block1: {
            PsiElement psiElement = this.getFirstChild();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getFirstChild(...)");
            Sequence $this$first$iv = PsiTreeUtilKt.siblings$default((PsiElement)psiElement, (boolean)false, (boolean)false, (int)3, null);
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                PsiElement it = (PsiElement)element$iv2;
                boolean bl = false;
                IElementType type = PsiTreeUtilKt.getElementType((PsiElement)it);
                if (!(type instanceof SqlKeywordTokenType || Intrinsics.areEqual((Object)type, (Object)SqlCommonTokens.SQL_COMMA))) continue;
                break block1;
            }
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        return (PsiElement)element$iv2;
    }

    @Override
    @NotNull
    public IElementType getOpSign() {
        SqlTokenType sqlTokenType = SqlCommonKeywords.SQL_JOIN;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType, (String)"SQL_JOIN");
        return (IElementType)sqlTokenType;
    }

    public boolean isLeft() {
        PsiElement element = this.getOpSignElement();
        return PsiTreeUtil.findSiblingForward((PsiElement)element, (IElementType)((IElementType)SqlCommonKeywords.SQL_LEFT), (boolean)false, null) != null || PsiTreeUtil.findSiblingForward((PsiElement)element, (IElementType)((IElementType)SqlCommonKeywords.SQL_FULL), (boolean)false, null) != null;
    }

    public boolean isRight() {
        PsiElement element = this.getOpSignElement();
        return PsiTreeUtil.findSiblingForward((PsiElement)element, (IElementType)((IElementType)SqlCommonKeywords.SQL_RIGHT), (boolean)false, null) != null || PsiTreeUtil.findSiblingForward((PsiElement)element, (IElementType)((IElementType)SqlCommonKeywords.SQL_FULL), (boolean)false, null) != null;
    }

    public boolean isNatural() {
        return this.findPsiChildByType((IElementType)SqlCommonKeywords.SQL_NATURAL) != null;
    }

    @Nullable
    public SqlUsingClause getUsingClause() {
        PsiElement $this$child$iv = (PsiElement)this;
        boolean $i$f$child = false;
        return (SqlUsingClause)PsiTreeUtil.getChildOfType((PsiElement)$this$child$iv, SqlUsingClause.class);
    }

    @NotNull
    public SqlTableType getDasType() {
        DasType dasType = this.getDasTypeWithCaching();
        Intrinsics.checkNotNull((Object)dasType, (String)"null cannot be cast to non-null type com.intellij.sql.psi.SqlTableType");
        return (SqlTableType)dasType;
    }

    @Override
    @NotNull
    protected DasType computeDasType() {
        return (DasType)this.calcType(null);
    }

    @NotNull
    public SqlTableType getDasType(@Nullable PsiElement end) {
        if (end == null || !PsiTreeUtil.isContextAncestor((PsiElement)((PsiElement)this), (PsiElement)end, (boolean)true)) {
            return this.getDasType();
        }
        return this.calcType(end);
    }

    @NotNull
    protected SqlTableType calcType(@Nullable PsiElement end) {
        PsiElement natural;
        SqlTableType expressionType;
        PsiElement lastToCheck = this.getLastToCheck(end);
        SqlExpression lOperand = this.getLOperand();
        DasType lType = SqlJoinExpressionImpl.getTypeLateralAware(lOperand, lastToCheck, end);
        SqlTableType sqlTableType = lType instanceof SqlTableType ? (SqlTableType)lType : null;
        if (sqlTableType == null) {
            sqlTableType = expressionType = SqlTableTypeBase.EMPTY_TABLE;
        }
        if (!Intrinsics.areEqual((Object)lOperand, (Object)lastToCheck)) {
            for (PsiElement child = lOperand.getNextSibling(); child != null; child = child.getNextSibling()) {
                if (child instanceof SqlExpression) {
                    DasType dasType = SqlJoinExpressionImpl.getDasTypeLateralAware((SqlExpression)child, lastToCheck, end);
                    expressionType = expressionType.join(SqlTableTypeBase.ensureTableType(dasType, child, (PsiElement)this));
                }
                if (Intrinsics.areEqual((Object)child, (Object)lastToCheck)) break;
            }
        }
        PsiElement $this$child$iv = (PsiElement)this;
        boolean $i$f$child = false;
        SqlUsingClause using = (SqlUsingClause)PsiTreeUtil.getChildOfType((PsiElement)$this$child$iv, SqlUsingClause.class);
        if (using != null) {
            SqlReferenceList refList = using.getReferenceList();
            Object object = refList;
            if (object == null || (object = object.getReferenceList()) == null) {
                object = CollectionsKt.emptyList();
            }
            Object list = object;
            Iterator iterator = list.iterator();
            block1: while (iterator.hasNext()) {
                SqlReferenceExpression expression = (SqlReferenceExpression)iterator.next();
                if (expression.resolve() == null) continue;
                int count = expressionType.getColumnCount();
                for (int i2 = 0; i2 < count; ++i2) {
                    PsiElement resolve;
                    PsiElement element;
                    PsiElement target;
                    Intrinsics.checkNotNullExpressionValue((Object)expressionType.getColumnElement(i2), (String)"getColumnElement(...)");
                    PsiElement psiElement = target = element instanceof SqlReferenceExpression ? ((SqlReferenceExpression)element).resolve() : element;
                    if (!resolve.isEquivalentTo(target)) continue;
                    expressionType = expressionType.subtract(element);
                    continue block1;
                }
            }
        }
        if ((natural = this.findPsiChildByType((IElementType)SqlCommonKeywords.SQL_NATURAL)) != null) {
            int count = expressionType.getColumnCount();
            MultiMap map = new MultiMap(CollectionFactory.createCaseInsensitiveStringMap());
            for (int i3 = 0; i3 < count; ++i3) {
                PsiElement element;
                String name = expressionType.getColumnName(i3);
                Intrinsics.checkNotNullExpressionValue((Object)expressionType.getColumnElement(i3), (String)"getColumnElement(...)");
                String string = name;
                if (string == null) {
                    string = "";
                }
                map.putValue((Object)string, (Object)element);
            }
            for (Map.Entry entry : map.entrySet()) {
                Collection value = (Collection)entry.getValue();
                if (value.size() != 2) continue;
                Intrinsics.checkNotNull((Object)value);
                expressionType = expressionType.subtract((PsiElement)CollectionsKt.first((Iterable)value));
            }
        }
        SqlTableType sqlTableType2 = expressionType;
        Intrinsics.checkNotNull((Object)sqlTableType2);
        return sqlTableType2;
    }

    @Nullable
    protected final PsiElement getLastToCheck(@Nullable PsiElement end) {
        PsiElement lastToCheck;
        for (lastToCheck = end; lastToCheck != null && !Intrinsics.areEqual((Object)lastToCheck.getContext(), (Object)((Object)this)); lastToCheck = lastToCheck.getContext()) {
        }
        return lastToCheck;
    }

    @Override
    public boolean processDeclarations(@NotNull SqlScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        boolean fromAlias;
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        if (!super.processDeclarations(processor, state, lastParent, place)) {
            return false;
        }
        if (!PsiTreeUtil.isContextAncestor((PsiElement)((PsiElement)this), (PsiElement)place, (boolean)false)) {
            return true;
        }
        boolean bl = fromAlias = lastParent instanceof SqlExpression && Intrinsics.areEqual((Object)((SqlExpression)lastParent).getParent(), (Object)((Object)this));
        if (!fromAlias) {
            if (lastParent instanceof SqlUsingClause || lastParent instanceof SqlJoinConditionClause) {
                if (!SqlImplUtil.processDeclarationsInType(this.getLOperand(), processor, state, place)) {
                    return false;
                }
                SqlExpression rOperand = this.getROperand();
                if (rOperand != null && !SqlImplUtil.processDeclarationsInType(rOperand, processor, state, place)) {
                    return false;
                }
            } else if (!SqlImplUtil.processDeclarationsInType(this, processor, state, place)) {
                return false;
            }
        }
        return true;
    }

    @JvmStatic
    @NotNull
    protected static final DasType getTypeLateralAware(@NotNull SqlExpression expression, @Nullable PsiElement lastToCheck, @Nullable PsiElement end) {
        return Companion.getTypeLateralAware(expression, lastToCheck, end);
    }

    @JvmStatic
    @NotNull
    protected static final DasType getDasTypeLateralAware(@NotNull SqlExpression expression, @Nullable PsiElement lastToCheck, @Nullable PsiElement end) {
        return Companion.getDasTypeLateralAware(expression, lastToCheck, end);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\tH\u0005J$\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\tH\u0005\u00a8\u0006\f"}, d2={"Lcom/intellij/sql/psi/impl/SqlJoinExpressionImpl$Companion;", "", "<init>", "()V", "getTypeLateralAware", "Lcom/intellij/database/types/DasType;", "expression", "Lcom/intellij/sql/psi/SqlExpression;", "lastToCheck", "Lcom/intellij/psi/PsiElement;", "end", "getDasTypeLateralAware", "intellij.database.sql.core.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        protected final DasType getTypeLateralAware(@NotNull SqlExpression expression, @Nullable PsiElement lastToCheck, @Nullable PsiElement end) {
            DasType dasType;
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            if (expression instanceof SqlLateralAwareExpression) {
                return (DasType)((SqlLateralAwareExpression)expression).getDasType(end);
            }
            if (Intrinsics.areEqual((Object)expression, (Object)lastToCheck)) {
                SqlTableType sqlTableType = SqlTableTypeBase.EMPTY_TABLE;
                Intrinsics.checkNotNullExpressionValue((Object)sqlTableType, (String)"EMPTY_TABLE");
                dasType = (DasType)sqlTableType;
            } else {
                DasType dasType2 = expression.getDasType();
                dasType = dasType2;
                Intrinsics.checkNotNullExpressionValue((Object)dasType2, (String)"getDasType(...)");
            }
            return dasType;
        }

        @JvmStatic
        @NotNull
        protected final DasType getDasTypeLateralAware(@NotNull SqlExpression expression, @Nullable PsiElement lastToCheck, @Nullable PsiElement end) {
            DasType dasType;
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            if (expression instanceof SqlLateralAwareExpression) {
                return (DasType)((SqlLateralAwareExpression)expression).getDasType(end);
            }
            if (Intrinsics.areEqual((Object)expression, (Object)lastToCheck)) {
                SqlTableType sqlTableType = SqlTableTypeBase.EMPTY_TABLE;
                Intrinsics.checkNotNullExpressionValue((Object)sqlTableType, (String)"EMPTY_TABLE");
                dasType = (DasType)sqlTableType;
            } else {
                DasType dasType2 = expression.getDasType();
                dasType = dasType2;
                Intrinsics.checkNotNullExpressionValue((Object)dasType2, (String)"getDasType(...)");
            }
            return dasType;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

