/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.types.DasType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.SqlWithClause;
import com.intellij.sql.psi.SqlWithCycleClause;
import com.intellij.sql.psi.SqlWithQueryExpression;
import com.intellij.sql.psi.impl.SqlQueryExpressionImpl;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J*\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0016J\u0018\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lcom/intellij/sql/psi/impl/SqlWithQueryExpressionImpl;", "Lcom/intellij/sql/psi/impl/SqlQueryExpressionImpl;", "Lcom/intellij/sql/psi/SqlWithQueryExpression;", "elementType", "Lcom/intellij/psi/tree/IElementType;", "<init>", "(Lcom/intellij/psi/tree/IElementType;)V", "accept", "", "visitor", "Lcom/intellij/sql/psi/SqlVisitor;", "withClause", "Lcom/intellij/sql/psi/SqlWithClause;", "getWithClause", "()Lcom/intellij/sql/psi/SqlWithClause;", "expression", "Lcom/intellij/sql/psi/SqlExpression;", "getExpression", "()Lcom/intellij/sql/psi/SqlExpression;", "getDasType", "Lcom/intellij/database/types/DasType;", "processDeclarations", "", "processor", "Lcom/intellij/sql/psi/SqlScopeProcessor;", "state", "Lcom/intellij/psi/ResolveState;", "lastParent", "Lcom/intellij/psi/PsiElement;", "place", "processCycleClause", "intellij.database.sql.core.impl"})
public final class SqlWithQueryExpressionImpl
extends SqlQueryExpressionImpl
implements SqlWithQueryExpression {
    public SqlWithQueryExpressionImpl(@NotNull IElementType elementType) {
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
        super(elementType);
    }

    @Override
    public void accept(@NotNull SqlVisitor visitor2) {
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        visitor2.visitSqlWithQueryExpression((SqlWithQueryExpression)this);
    }

    @NotNull
    public SqlWithClause getWithClause() {
        SqlWithClause sqlWithClause = this.findNotNullChildByClass(SqlWithClause.class);
        Intrinsics.checkNotNullExpressionValue((Object)sqlWithClause, (String)"findNotNullChildByClass(...)");
        return sqlWithClause;
    }

    @Nullable
    public SqlExpression getExpression() {
        return this.findChildByClass(SqlExpression.class);
    }

    @Override
    @NotNull
    public DasType getDasType() {
        SqlExpression sqlExpression = this.getExpression();
        if (sqlExpression == null || (sqlExpression = sqlExpression.getDasType()) == null) {
            sqlExpression = super.getDasType();
        }
        return sqlExpression;
    }

    @Override
    public boolean processDeclarations(@NotNull SqlScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        if (place.getParent() instanceof SqlWithCycleClause && processor.mayAccept(ObjectKind.COLUMN)) {
            if (!this.processCycleClause(processor, state)) {
                return false;
            }
            if (processor.isResultEmpty()) {
                return super.processDeclarations(processor, state, lastParent, place);
            }
        }
        return super.processDeclarations(processor, state, lastParent, place);
    }

    private final boolean processCycleClause(SqlScopeProcessor processor, ResolveState state) {
        for (SqlAsExpression queryDefinition : this.getWithClause().getQueryDefinitions()) {
            for (SqlDefinition columnAlias : queryDefinition.getColumnAliasList()) {
                if (processor.executeTarget((DasSymbol)columnAlias, null, Boolean.valueOf(false), state)) continue;
                return false;
            }
        }
        return true;
    }
}

