/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform.codeWithMe;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.remoteDev.downloader.JetBrainsClientDownloaderConfigurationProvider;
import com.intellij.util.io.PathKt;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\b\u0010\u001a\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001b\u001a\u00020\u0018J\u0006\u0010\u001c\u001a\u00020\u0016J\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u0018H\u0002J$\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u00182\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00050!H\u0002J8\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00050!2\u0006\u0010\u001e\u001a\u00020\u00182\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00180$H\u0002J \u0010'\u001a\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010(\u001a\u00020\u00182\b\u0010)\u001a\u0004\u0018\u00010\u0018H\u0002J\u001e\u0010-\u001a\u00020\u00162\u0006\u0010(\u001a\u00020\u00182\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$H\u0002J\u0010\u0010.\u001a\u00020\u00162\u0006\u0010/\u001a\u00020\u0018H\u0002J4\u00100\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020%010\t2\u0018\u00102\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020%010\tH\u0002J\f\u00103\u001a\u00020+*\u00020\u0018H\u0002J\u0016\u00104\u001a\u00020+*\u00020\u00182\b\u0010)\u001a\u0004\u0018\u00010\u0018H\u0002J\u0016\u00105\u001a\b\u0012\u0004\u0012\u00020\u00180$2\u0006\u0010)\u001a\u00020\u0018H\u0002J\u0014\u00106\u001a\u00020+*\u0002072\u0006\u00108\u001a\u000209H\u0002J\u001e\u0010:\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u000207010\t*\u00020\u0018H\u0002J\u001e\u0010;\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\t*\u00020\u00182\b\b\u0002\u0010<\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010*\u001a\u00020+*\u00020%8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010,R\u0018\u0010=\u001a\u00020+*\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b>\u0010?\u00a8\u0006@"}, d2={"Lcom/jetbrains/rd/platform/codeWithMe/CodeWithMeCleanup;", "", "<init>", "()V", "JbrNamePrefix", "", "MaxJbrFindDepth", "", "productNames", "", "installationFolders", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "config", "Lcom/intellij/remoteDev/downloader/JetBrainsClientDownloaderConfigurationProvider;", "getConfig", "()Lcom/intellij/remoteDev/downloader/JetBrainsClientDownloaderConfigurationProvider;", "jvmStartTimeMs", "", "currentBuildNumberBaseline", "cleanupPeriod", "cleanupCodeWithMeCaches", "", "systemPath", "Ljava/nio/file/Path;", "configPath", "baseLogsPath", "currentVersionLogsPath", "cleanupPluginsToMigrate", "removeEmptyFolders", "rootPath", "removeOldJavaRuntimes", "keptRuntimes", "", "removeOldInstallations", "keptVersions", "", "Lcom/intellij/openapi/util/Version;", "installationsToKeep", "removeOldSystemFolders", "path", "logsPath", "isMajorPartNewerThanCurrent", "", "(Lcom/intellij/openapi/util/Version;)Z", "removeOldConfigFolders", "removeFolder", "folder", "filterOutLatestConfig", "Lkotlin/Pair;", "folders", "configFolderIsTooOld", "systemFolderIsTooOld", "logsFolderCleanup", "isTooOld", "Ljava/nio/file/attribute/BasicFileAttributes;", "expiration", "Ljava/time/Instant;", "listDirectoryEntriesAndSelf", "listDirectoryEntriesSafe", "glob", "seemsLikeLink", "getSeemsLikeLink", "(Ljava/nio/file/Path;)Z", "intellij.platform.split"})
@SourceDebugExtension(value={"SMAP\nCodeWithMeCleanupManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeWithMeCleanupManager.kt\ncom/jetbrains/rd/platform/codeWithMe/CodeWithMeCleanup\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 7 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 8 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,436:1\n42#2,3:437\n1#3:440\n1#3:487\n1391#4:441\n1480#4,5:442\n1391#4:450\n1480#4,2:451\n1391#4:453\n1480#4,5:454\n1482#4,3:459\n1915#4,2:462\n1391#4:464\n1480#4,5:465\n1391#4:470\n1480#4,5:471\n1642#4,10:476\n1915#4:486\n1916#4:488\n1652#4:489\n1512#4:490\n1538#4,3:491\n1541#4,3:501\n1080#4:506\n1786#4,3:507\n1786#4,3:510\n1786#4,3:513\n1786#4,3:516\n628#5:447\n1342#5,2:448\n383#6,7:494\n221#7,2:504\n13#8:519\n*S KotlinDebug\n*F\n+ 1 CodeWithMeCleanupManager.kt\ncom/jetbrains/rd/platform/codeWithMe/CodeWithMeCleanup\n*L\n48#1:437,3\n288#1:487\n105#1:441\n105#1:442,5\n155#1:450\n155#1:451,2\n157#1:453\n157#1:454,5\n155#1:459,3\n163#1:462,2\n235#1:464\n235#1:465,5\n283#1:470\n283#1:471,5\n288#1:476,10\n288#1:486\n288#1:488\n288#1:489\n298#1:490\n298#1:491,3\n298#1:501,3\n344#1:506\n353#1:507,3\n363#1:510,3\n364#1:513,3\n382#1:516,3\n128#1:447\n137#1:448,2\n298#1:494,7\n309#1:504,2\n47#1:519\n*E\n"})
public final class CodeWithMeCleanup {
    @NotNull
    public static final CodeWithMeCleanup INSTANCE = new CodeWithMeCleanup();
    @NotNull
    private static final String JbrNamePrefix = "jbr";
    private static final int MaxJbrFindDepth = 6;
    @NotNull
    private static final List<String> productNames;
    @NotNull
    private static final List<String> installationFolders;
    @NotNull
    private static final Logger logger;
    private static final long jvmStartTimeMs;
    private static final int currentBuildNumberBaseline;
    private static final long cleanupPeriod;

    private CodeWithMeCleanup() {
    }

    private final JetBrainsClientDownloaderConfigurationProvider getConfig() {
        boolean $i$f$service = false;
        Class<JetBrainsClientDownloaderConfigurationProvider> serviceClass$iv = JetBrainsClientDownloaderConfigurationProvider.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        return (JetBrainsClientDownloaderConfigurationProvider)object;
    }

    public final void cleanupCodeWithMeCaches(@NotNull Path systemPath, @NotNull Path configPath, @Nullable Path baseLogsPath, @NotNull Path currentVersionLogsPath) {
        Intrinsics.checkNotNullParameter((Object)systemPath, (String)"systemPath");
        Intrinsics.checkNotNullParameter((Object)configPath, (String)"configPath");
        Intrinsics.checkNotNullParameter((Object)currentVersionLogsPath, (String)"currentVersionLogsPath");
        logger.info("running activity to cleanup old thin clients... Root path is '" + systemPath + "'. JvmStartTimeMs=" + jvmStartTimeMs);
        try {
            Set<Version> keptVersions = this.removeOldSystemFolders(systemPath, baseLogsPath);
            this.removeOldConfigFolders(configPath, keptVersions);
            Set<Path> installationsToKeep = this.logsFolderCleanup(currentVersionLogsPath);
            if (this.getConfig().getClientVersionManagementEnabled()) {
                Map<Path, String> keptRuntimes = this.removeOldInstallations(systemPath, keptVersions, installationsToKeep);
                this.removeOldJavaRuntimes(systemPath, keptRuntimes);
            }
            this.removeEmptyFolders(systemPath);
        }
        catch (CancellationException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    public final void cleanupPluginsToMigrate() {
        Path path = PathManager.getPluginsDir();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPluginsDir(...)");
        Path pluginsDir = path;
        if (Intrinsics.areEqual((Object)PathsKt.getName((Path)pluginsDir), (Object)"frontend")) {
            Path pluginsToMigrateDir = pluginsDir.getParent().resolve("frontend-to-migrate");
            Intrinsics.checkNotNull((Object)pluginsToMigrateDir);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.isDirectory(pluginsToMigrateDir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                logger.info("Remove folder which was used to migrate frontend plugins from previous version: " + pluginsToMigrateDir);
                this.removeFolder(pluginsToMigrateDir);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void removeEmptyFolders(Path rootPath) {
        for (String folderName : installationFolders) {
            Path path;
            Intrinsics.checkNotNullExpressionValue((Object)rootPath.resolve(folderName), (String)"resolve(...)");
            try {
                boolean bl;
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (!Files.isDirectory(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
                Path path2 = path;
                Closeable closeable = Files.newDirectoryStream(path2, "*");
                Throwable throwable = null;
                try {
                    DirectoryStream directoryStream = (DirectoryStream)closeable;
                    Intrinsics.checkNotNull((Object)directoryStream);
                    Sequence it = CollectionsKt.asSequence((Iterable)directoryStream);
                    boolean bl2 = false;
                    bl = it.iterator().hasNext();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                if (bl) continue;
                Files.deleteIfExists(path);
            }
            catch (Exception e) {
                logger.warn("Failed to delete an installation folder: " + path, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void removeOldJavaRuntimes(Path rootPath, Map<Path, String> keptRuntimes) {
        void $this$forEach$iv;
        Sequence $this$sortedByDescending$iv;
        void $this$flatMapTo$iv$iv;
        Path path;
        String string = System.getProperty("java.home");
        if (string != null) {
            String it = string;
            boolean bl = false;
            Path path2 = Paths.get(it, new String[0]);
            path = path2;
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        } else {
            path = null;
        }
        Path homeJbrPath = path;
        Iterable $this$flatMap$iv = installationFolders;
        boolean $i$f$flatMap22 = false;
        Iterable bl = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Path path3;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)rootPath.resolve(it), (String)"resolve(...)");
            List list = INSTANCE.listDirectoryEntriesSafe(path3, "jbr*");
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List runtimes = (List)destination$iv$iv;
        Instant monthAgo = Instant.now().minus(30L, ChronoUnit.DAYS);
        Sequence $i$f$flatMap22 = SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)runtimes), arg_0 -> CodeWithMeCleanup.removeOldJavaRuntimes$lambda$2(homeJbrPath, arg_0)), CodeWithMeCleanup::removeOldJavaRuntimes$lambda$3);
        boolean $i$f$sortedByDescending = false;
        $this$sortedByDescending$iv = SequencesKt.drop((Sequence)SequencesKt.mapIndexed((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)b;
                boolean bl = false;
                Comparable comparable = (FileTime)it.getSecond();
                it = (Pair)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((FileTime)it.getSecond()));
            }
        }), CodeWithMeCleanup::removeOldJavaRuntimes$lambda$5), (int)2);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl3 = false;
            Path folder = (Path)pair.component1();
            FileTime lastModified = (FileTime)pair.component2();
            Instant installedOrUsedTime = lastModified.toInstant();
            if (installedOrUsedTime.compareTo(monthAgo) >= 0) {
                logger.info("keep Java runtime " + PathsKt.getName((Path)folder) + " because it is not old enough, path is '" + folder + "'");
                continue;
            }
            if (keptRuntimes.containsKey(folder)) {
                logger.info("keep Java runtime " + PathsKt.getName((Path)folder) + " because " + keptRuntimes.get(folder) + " still uses it, path is '" + folder + "'");
                continue;
            }
            logger.info("remove Java runtime " + PathsKt.getName((Path)folder) + " because it is older than a month, path is '" + folder + "'");
            INSTANCE.removeFolder(folder);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Map<Path, String> removeOldInstallations(Path rootPath, Set<Version> keptVersions, Set<? extends Path> installationsToKeep) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = installationFolders;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$flatMapTo$iv$iv2;
            String folderName = (String)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)rootPath.resolve(folderName), (String)"resolve(...)");
            Iterable $this$flatMap$iv2 = productNames;
            boolean $i$f$flatMap2 = false;
            Iterable iterable2 = $this$flatMap$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            for (Object element$iv$iv2 : $this$flatMapTo$iv$iv2) {
                Path path;
                String productName = (String)element$iv$iv2;
                boolean bl2 = false;
                List list = INSTANCE.listDirectoryEntriesSafe(path, productName + "*");
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
                Iterable list$iv$iv = list;
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List installations = (List)destination$iv$iv;
        Map keptRuntimes = new LinkedHashMap();
        Iterable $this$forEach$iv = installations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean keepInstallation;
            Version version;
            String versionString;
            Path folder = (Path)element$iv;
            boolean bl = false;
            char[] cArray = new char[]{'-'};
            if ((String)CollectionsKt.getOrNull((List)StringsKt.split$default((CharSequence)PathsKt.getName((Path)folder), (char[])cArray, (boolean)false, (int)0, (int)6, null), (int)1) == null || Version.parseVersion((String)versionString) == null) continue;
            Object object = PathKt.basicAttributesIfExists((Path)folder);
            long lastModifiedMs = object != null && (object = object.lastModifiedTime()) != null ? ((FileTime)object).to(TimeUnit.MILLISECONDS) : -1L;
            logger.info(version + " lastModifiedMs=" + lastModifiedMs);
            if (INSTANCE.isMajorPartNewerThanCurrent(version)) {
                logger.info("keep JetBrains Client installation with version " + version + " because its major part is newer than current");
                v2 = true;
            } else if (keptVersions.contains(version)) {
                logger.info("keep Code With Me client installation with version " + version + " because its system folder still exists, path is '" + folder + "'");
                v2 = true;
            } else if (installationsToKeep.contains(folder)) {
                logger.info("keep Code With Me client installation " + folder + " because it was used recently");
                v2 = true;
            } else if (lastModifiedMs > jvmStartTimeMs) {
                logger.info("keep Code With Me client installation with version " + version + " because it was last modified after this IDE instance was started");
                v2 = true;
            } else {
                v2 = keepInstallation = false;
            }
            if (keepInstallation) {
                Files.walkFileTree(folder, SetsKt.emptySet(), 6, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>((Map<Path, String>)keptRuntimes, folder){
                    final /* synthetic */ Map<Path, String> $keptRuntimes;
                    final /* synthetic */ Path $folder;
                    {
                        this.$keptRuntimes = $keptRuntimes;
                        this.$folder = $folder;
                    }

                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
                        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
                        if (CodeWithMeCleanup.access$removeOldInstallations$lambda$1$isJbrLink(dir)) {
                            this.$keptRuntimes.put(dir.toRealPath(new LinkOption[0]).getParent(), PathsKt.getName((Path)this.$folder));
                            return FileVisitResult.TERMINATE;
                        }
                        FileVisitResult fileVisitResult = super.visitFile(dir, attrs);
                        Intrinsics.checkNotNullExpressionValue((Object)((Object)fileVisitResult), (String)"visitFile(...)");
                        return fileVisitResult;
                    }

                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
                        if (CodeWithMeCleanup.access$removeOldInstallations$lambda$1$isJbrLink(dir)) {
                            LinkOption[] linkOptionArray = new LinkOption[]{};
                            if (!Files.exists(dir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                                return FileVisitResult.CONTINUE;
                            }
                        }
                        FileVisitResult fileVisitResult = super.postVisitDirectory(dir, exc);
                        Intrinsics.checkNotNullExpressionValue((Object)((Object)fileVisitResult), (String)"postVisitDirectory(...)");
                        return fileVisitResult;
                    }

                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
                        if (CodeWithMeCleanup.access$removeOldInstallations$lambda$1$isJbrLink(file)) {
                            this.$keptRuntimes.put(file.toRealPath(new LinkOption[0]).getParent(), PathsKt.getName((Path)this.$folder));
                            return FileVisitResult.TERMINATE;
                        }
                        FileVisitResult fileVisitResult = super.visitFile(file, attrs);
                        Intrinsics.checkNotNullExpressionValue((Object)((Object)fileVisitResult), (String)"visitFile(...)");
                        return fileVisitResult;
                    }

                    public FileVisitResult visitFileFailed(Path file, IOException exc) {
                        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                        Intrinsics.checkNotNullParameter((Object)exc, (String)"exc");
                        if (CodeWithMeCleanup.access$getSeemsLikeLink(CodeWithMeCleanup.INSTANCE, file)) {
                            LinkOption[] linkOptionArray = new LinkOption[]{};
                            if (!Files.exists(file, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                                return FileVisitResult.CONTINUE;
                            }
                        }
                        FileVisitResult fileVisitResult = super.visitFileFailed(file, exc);
                        Intrinsics.checkNotNullExpressionValue((Object)((Object)fileVisitResult), (String)"visitFileFailed(...)");
                        return fileVisitResult;
                    }
                });
                continue;
            }
            logger.info("remove Code With Me client installation with version " + version + " because its system folder is removed, path is '" + folder + "'");
            INSTANCE.removeFolder(folder);
        }
        return keptRuntimes;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<Version> removeOldSystemFolders(Path path, Path logsPath) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = productNames;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            String productName = (String)element$iv$iv;
            boolean bl = false;
            List list = INSTANCE.listDirectoryEntriesSafe(path, productName + "?*");
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List systemFolders = (List)destination$iv$iv;
        logger.info("found " + systemFolders.size() + " Code With Me client system folders to check");
        Set keptVersions = new LinkedHashSet();
        for (Path folder : systemFolders) {
            Object v1;
            block8: {
                Iterable iterable2 = productNames;
                Iterator iterator = iterable2.iterator();
                while (iterator.hasNext()) {
                    Object t = iterator.next();
                    String it = (String)t;
                    boolean bl = false;
                    if (!StringsKt.startsWith$default((String)PathsKt.getName((Path)folder), (String)it, (boolean)false, (int)2, null)) continue;
                    v1 = t;
                    break block8;
                }
                v1 = null;
            }
            String currentProductName = v1;
            if (currentProductName == null) {
                logger.error("Name of a config folder '" + PathsKt.getName((Path)folder) + "' doesn't start with any of known product names: " + CollectionsKt.joinToString$default((Iterable)productNames, null, null, null, (int)0, null, null, (int)63, null));
                continue;
            }
            Version version = Version.parseVersion((String)StringsKt.removePrefix((String)PathsKt.getName((Path)folder), (CharSequence)currentProductName));
            if (version == null) {
                logger.info("failed to parse version for the folder '" + PathsKt.getName((Path)folder) + "', path is " + folder);
                continue;
            }
            if (this.isMajorPartNewerThanCurrent(version)) {
                logger.info("keep system folder with version " + version + ", because its major part is newer than current");
                continue;
            }
            if (this.systemFolderIsTooOld(folder, logsPath)) {
                logger.info("remove system folder with version " + version + " because it is older than two weeks, path is '" + folder + "'");
                this.removeFolder(folder);
                if (logsPath == null) continue;
                Path logFolder = logsPath.resolve(PathsKt.getName((Path)folder));
                logger.info("remove log folder with version " + version + " because its system folder was removed,  path is '" + logFolder + "'");
                Intrinsics.checkNotNull((Object)logFolder);
                this.removeFolder(logFolder);
                continue;
            }
            logger.info("keep system folder with version " + version + ", it is not old enough, path is '" + folder + "'");
            keptVersions.add(version);
        }
        return keptVersions;
    }

    private final boolean isMajorPartNewerThanCurrent(Version $this$isMajorPartNewerThanCurrent) {
        int baseLine = $this$isMajorPartNewerThanCurrent.major > 2000 ? ($this$isMajorPartNewerThanCurrent.major - 2000) * 10 + $this$isMajorPartNewerThanCurrent.minor : $this$isMajorPartNewerThanCurrent.major;
        return baseLine > currentBuildNumberBaseline;
    }

    /*
     * WARNING - void declaration
     */
    private final void removeOldConfigFolders(Path path, Set<Version> keptVersions) {
        void $this$groupByTo$iv$iv;
        void $this$groupBy$iv;
        void $this$mapNotNullTo$iv$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = productNames;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            String productName = (String)element$iv$iv;
            boolean bl = false;
            List list = INSTANCE.listDirectoryEntriesSafe(path, productName + "?*");
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List configFolders = (List)destination$iv$iv;
        logger.info("found " + configFolders.size() + " Code With Me client config folders to check");
        Iterable $this$mapNotNull$iv = configFolders;
        boolean $i$f$mapNotNull = false;
        destination$iv$iv = $this$mapNotNull$iv;
        Object destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator bl = $this$forEach$iv$iv$iv.iterator();
        while (bl.hasNext()) {
            Pair pair;
            Object v1;
            Path it;
            block14: {
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = bl.next();
                boolean bl2 = false;
                it = (Path)element$iv$iv;
                boolean bl3 = false;
                Iterable iterable2 = productNames;
                for (Object t : iterable2) {
                    String name = (String)t;
                    boolean bl4 = false;
                    if (!StringsKt.startsWith$default((String)PathsKt.getName((Path)it), (String)name, (boolean)false, (int)2, null)) continue;
                    v1 = t;
                    break block14;
                }
                v1 = null;
            }
            if ((String)v1 == null) {
                CodeWithMeCleanup $this$removeOldConfigFolders_u24lambda_u241_u241 = INSTANCE;
                boolean bl5 = false;
                logger.error("Name of a system folder '" + PathsKt.getName((Path)it) + "' doesn't start with any of known product names: " + CollectionsKt.joinToString$default((Iterable)productNames, null, null, null, (int)0, null, null, (int)63, null));
                pair = null;
            } else {
                Version version;
                String currentProductName;
                pair = Version.parseVersion((String)StringsKt.removePrefix((String)PathsKt.getName((Path)it), (CharSequence)currentProductName)) == null ? null : TuplesKt.to((Object)it, (Object)version);
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl6 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv2;
        boolean $i$f$groupBy = false;
        $this$mapNotNullTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            void $this$getOrPut$iv$iv$iv;
            Pair it = (Pair)element$iv$iv;
            boolean bl7 = false;
            Integer key$iv$iv = ((Version)it.getSecond()).major;
            Object bl2 = destination$iv$iv2;
            Integer key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl8 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Object configsByMajor = destination$iv$iv2;
        Set twoLastMajors = SequencesKt.toSet((Sequence)SequencesKt.take((Sequence)SequencesKt.sortedDescending((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)configsByMajor.keySet()), CodeWithMeCleanup::removeOldConfigFolders$lambda$3)), (int)2));
        logger.info("keep only " + twoLastMajors + " major versions");
        Object $this$forEach$iv = configsByMajor;
        boolean $i$f$forEach2 = false;
        for (Map.Entry element$iv : $this$forEach$iv.entrySet()) {
            Map.Entry entry = element$iv;
            boolean bl9 = false;
            int major = ((Number)entry.getKey()).intValue();
            List<Pair<Path, Version>> folders = (List<Pair<Path, Version>>)entry.getValue();
            List<Pair<Path, Version>> filteredFolders = twoLastMajors.contains(major) ? INSTANCE.filterOutLatestConfig((List<? extends Pair<? extends Path, Version>>)folders) : folders;
            for (Pair<Path, Version> pair : filteredFolders) {
                Path folder = (Path)pair.component1();
                Version version = (Version)pair.component2();
                if (INSTANCE.configFolderIsTooOld(folder)) {
                    if (keptVersions.contains(version)) {
                        logger.info("keep config folder with version " + version + " because its system folder still exists, path is '" + folder + "'");
                        continue;
                    }
                    if (INSTANCE.isMajorPartNewerThanCurrent(version)) {
                        logger.info("keep config folder with version " + version + " because its major part is newer than the current version");
                        continue;
                    }
                    logger.info("remove config folder with version " + version + " because it is older than two weeks, path is '" + folder + "'");
                    INSTANCE.removeFolder(folder);
                    continue;
                }
                logger.info("keep config folder with version " + version + ", it is not old enough, path is '" + folder + "'");
            }
        }
    }

    private final void removeFolder(Path folder) {
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.notExists(folder, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return;
        }
        try {
            Path tempFolder = FileUtil.createTempDirectory((File)folder.toFile().getParentFile(), (String)PathsKt.getName((Path)folder), (String)"", (boolean)false).toPath();
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            Files.move(folder, tempFolder, copyOptionArray);
            FileUtil.delete((Path)tempFolder);
        }
        catch (Exception e) {
            logger.error("failed to remove folder " + folder, (Throwable)e);
        }
    }

    private final List<Pair<Path, Version>> filterOutLatestConfig(List<? extends Pair<? extends Path, Version>> folders) {
        List sorted;
        block0: {
            Iterable $this$sortedByDescending$iv = folders;
            boolean $i$f$sortedByDescending = false;
            sorted = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Pair it = (Pair)b;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Version)it.getSecond());
                    it = (Pair)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Version)it.getSecond())));
                }
            });
            Pair pair = (Pair)CollectionsKt.getOrNull((List)sorted, (int)0);
            if (pair == null) break block0;
            Pair it = pair;
            boolean bl = false;
            logger.info("keep config folder with version " + it.getSecond() + ", it is the most up-to-date config folder with " + ((Version)it.getSecond()).major + " major version, path is '" + it.getFirst() + "'");
        }
        return CollectionsKt.drop((Iterable)sorted, (int)1);
    }

    private final boolean configFolderIsTooOld(Path $this$configFolderIsTooOld) {
        boolean bl;
        block3: {
            Instant twoWeeksAgo = Instant.now().minus(14L, ChronoUnit.DAYS);
            Iterable $this$all$iv = this.listDirectoryEntriesAndSelf($this$configFolderIsTooOld);
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Pair pair = (Pair)element$iv;
                    boolean bl2 = false;
                    BasicFileAttributes attrs = (BasicFileAttributes)pair.component2();
                    Intrinsics.checkNotNull((Object)twoWeeksAgo);
                    if (INSTANCE.isTooOld(attrs, twoWeeksAgo)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean systemFolderIsTooOld(Path $this$systemFolderIsTooOld, Path logsPath) {
        BasicFileAttributes attrs;
        Pair pair;
        boolean bl;
        Instant twoWeeksAgo = Instant.now().minus(14L, ChronoUnit.DAYS);
        List<Pair<Path, BasicFileAttributes>> files = this.listDirectoryEntriesAndSelf($this$systemFolderIsTooOld);
        Path path = logsPath;
        if (path == null || (path = path.resolve(PathsKt.getName((Path)$this$systemFolderIsTooOld))) == null) {
            path = $this$systemFolderIsTooOld.resolve("log");
        }
        Path logFolder = path;
        Intrinsics.checkNotNull((Object)logFolder);
        List<Pair<Path, BasicFileAttributes>> logFiles = this.listDirectoryEntriesAndSelf(logFolder);
        Iterable $this$all$iv = files;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            bl = true;
        } else {
            for (Object element$iv : $this$all$iv) {
                pair = (Pair)element$iv;
                boolean bl2 = false;
                attrs = (BasicFileAttributes)pair.component2();
                Intrinsics.checkNotNull((Object)twoWeeksAgo);
                if (INSTANCE.isTooOld(attrs, twoWeeksAgo)) continue;
                return false;
            }
            bl = true;
        }
        if (!bl) return false;
        $this$all$iv = logFiles;
        $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            Object element$iv;
            if (!iterator.hasNext()) return true;
            element$iv = iterator.next();
            pair = (Pair)element$iv;
            boolean bl3 = false;
            attrs = (BasicFileAttributes)pair.component2();
            Intrinsics.checkNotNull((Object)twoWeeksAgo);
        } while (INSTANCE.isTooOld(attrs, twoWeeksAgo));
        return false;
    }

    private final Set<Path> logsFolderCleanup(Path logsPath) {
        logger.info("Starting the logs folder cleanup. Path: " + logsPath);
        if (!Pattern.compile("\\d{4}-\\d{2}-\\d{2}_at_\\d{2}-\\d{2}-\\d{2}(-\\d{3})?(_\\d)?").matcher(((Object)logsPath.getFileName()).toString()).matches()) {
            return SetsKt.emptySet();
        }
        Path parentLogsPath = logsPath.getParent();
        logger.info("Checking the outdated logs directories by path: " + parentLogsPath);
        Instant cleanupPeriod = Instant.now().minus(CodeWithMeCleanup.cleanupPeriod, ChronoUnit.DAYS);
        Intrinsics.checkNotNull((Object)parentLogsPath);
        List logFiles = CodeWithMeCleanup.listDirectoryEntriesSafe$default(this, parentLogsPath, null, 1, null);
        if (logFiles == null) {
            return SetsKt.emptySet();
        }
        LinkedHashSet<Path> usedInstallationPaths = new LinkedHashSet<Path>();
        for (Path file : logFiles) {
            boolean removeFolder;
            block9: {
                Iterable $this$all$iv = this.listDirectoryEntriesAndSelf(file);
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    v0 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        Pair pair = (Pair)element$iv;
                        boolean bl = false;
                        BasicFileAttributes attrib = (BasicFileAttributes)pair.component2();
                        Intrinsics.checkNotNull((Object)cleanupPeriod);
                        if (INSTANCE.isTooOld(attrib, cleanupPeriod)) continue;
                        v0 = false;
                        break block9;
                    }
                    v0 = removeFolder = true;
                }
            }
            if (removeFolder) {
                logger.info("removing log entity because it is older than " + CodeWithMeCleanup.cleanupPeriod + ", path: '" + file + "'");
                this.removeFolder(file);
                continue;
            }
            Path installationHomeFile = file.resolve(".home");
            Intrinsics.checkNotNull((Object)installationHomeFile);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(installationHomeFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
            try {
                Path appHomePath;
                Intrinsics.checkNotNullExpressionValue((Object)Paths.get(PathsKt.readText$default((Path)installationHomeFile, null, (int)1, null), new String[0]), (String)"get(...)");
                usedInstallationPaths.add(appHomePath);
                usedInstallationPaths.add(appHomePath.getParent().normalize());
                usedInstallationPaths.add(appHomePath.getParent().getParent().normalize());
            }
            catch (Throwable t) {
                logger.warn("Failed to read " + installationHomeFile, t);
            }
        }
        return usedInstallationPaths;
    }

    private final boolean isTooOld(BasicFileAttributes $this$isTooOld, Instant expiration) {
        return $this$isTooOld.lastModifiedTime().toInstant().compareTo(expiration) < 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<Pair<Path, BasicFileAttributes>> listDirectoryEntriesAndSelf(Path $this$listDirectoryEntriesAndSelf) {
        List result2 = new ArrayList();
        try {
            AutoCloseable autoCloseable = Files.find($this$listDirectoryEntriesAndSelf, 1, (arg_0, arg_1) -> CodeWithMeCleanup.listDirectoryEntriesAndSelf$lambda$0(result2, arg_0, arg_1), new FileVisitOption[0]);
            Throwable throwable = null;
            try {
                Stream it = (Stream)autoCloseable;
                boolean bl = false;
                long l = it.count();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            logger.warn("failed to list directory entries with attributes for path '" + $this$listDirectoryEntriesAndSelf + "'", (Throwable)e);
        }
        return result2;
    }

    private final List<Path> listDirectoryEntriesSafe(Path $this$listDirectoryEntriesSafe, String glob) {
        List list;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists($this$listDirectoryEntriesSafe, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return null;
        }
        try {
            list = PathsKt.listDirectoryEntries((Path)$this$listDirectoryEntriesSafe, (String)glob);
        }
        catch (Exception e) {
            logger.warn("failed to list directory entries for path '" + $this$listDirectoryEntriesSafe + "'", (Throwable)e);
            list = null;
        }
        return list;
    }

    static /* synthetic */ List listDirectoryEntriesSafe$default(CodeWithMeCleanup codeWithMeCleanup, Path path, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "*";
        }
        return codeWithMeCleanup.listDirectoryEntriesSafe(path, string);
    }

    private final boolean getSeemsLikeLink(Path $this$seemsLikeLink) {
        FileAttributes fileAttributes = FileSystemUtil.getAttributes((File)$this$seemsLikeLink.toFile());
        return fileAttributes != null ? fileAttributes.isSymLink() : false;
    }

    private static final boolean removeOldJavaRuntimes$lambda$2(Path $homeJbrPath, Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if ($homeJbrPath == null || !$homeJbrPath.startsWith(it)) {
            return true;
        }
        logger.info("keep Java runtime " + PathsKt.getName((Path)it) + " because the current process is running under this runtime, full path is '" + it + "'");
        return false;
    }

    private static final Pair removeOldJavaRuntimes$lambda$3(Path folder) {
        Iterable iterable;
        Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
        try {
            iterable = INSTANCE.listDirectoryEntriesAndSelf(folder);
            Path path = folder;
            Iterator iterator = iterable.iterator();
            if (!iterator.hasNext()) {
                throw new NoSuchElementException();
            }
            Object object = (Pair)iterator.next();
            boolean bl = false;
            BasicFileAttributes attrs = (BasicFileAttributes)object.component2();
            object = attrs.lastModifiedTime();
            while (iterator.hasNext()) {
                Object object2 = (Pair)iterator.next();
                $i$a$-maxOf-CodeWithMeCleanup$removeOldJavaRuntimes$2$1 = false;
                BasicFileAttributes attrs2 = (BasicFileAttributes)object2.component2();
                if (object.compareTo(object2 = (Comparable)attrs2.lastModifiedTime()) >= 0) continue;
                object = object2;
            }
            iterable = TuplesKt.to((Object)path, (Object)object);
        }
        catch (Exception e) {
            logger.warn("Failed to get last modified time", (Throwable)e);
            iterable = null;
        }
        return iterable;
    }

    private static final Pair removeOldJavaRuntimes$lambda$5(int index, Pair pair) {
        Intrinsics.checkNotNullParameter((Object)pair, (String)"pair");
        if (index < 2) {
            String order = index == 0 ? "most" : "second most";
            logger.info("keep Java runtime " + PathsKt.getName((Path)((Path)pair.getFirst())) + " because it is the " + order + " recent runtime downloaded, path is '" + pair.getFirst() + "'");
        }
        return pair;
    }

    private static final boolean removeOldInstallations$lambda$1$isJbrLink(Path $this$removeOldInstallations_u24lambda_u241_u24isJbrLink) {
        return Intrinsics.areEqual((Object)PathsKt.getName((Path)$this$removeOldInstallations_u24lambda_u241_u24isJbrLink), (Object)JbrNamePrefix) && INSTANCE.getSeemsLikeLink($this$removeOldInstallations_u24lambda_u241_u24isJbrLink);
    }

    private static final boolean removeOldConfigFolders$lambda$3(int it) {
        return it < 1000;
    }

    private static final boolean listDirectoryEntriesAndSelf$lambda$0(List $result, Path path, BasicFileAttributes attrs) {
        $result.add(TuplesKt.to((Object)path, (Object)attrs));
        return true;
    }

    public static final /* synthetic */ boolean access$removeOldInstallations$lambda$1$isJbrLink(Path $receiver) {
        return CodeWithMeCleanup.removeOldInstallations$lambda$1$isJbrLink($receiver);
    }

    public static final /* synthetic */ boolean access$getSeemsLikeLink(CodeWithMeCleanup $this, Path $receiver) {
        return $this.getSeemsLikeLink($receiver);
    }

    static {
        Object[] objectArray = new String[]{"CodeWithMeGuest", "IntelliJClient", "JetBrainsClient"};
        productNames = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"CodeWithMeClientDist", "IntelliJClient", "JetBrainsClientDist"};
        installationFolders = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CodeWithMeCleanup.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        CodeWithMeCleanup.logger = logger;
        jvmStartTimeMs = ManagementFactory.getRuntimeMXBean().getStartTime();
        currentBuildNumberBaseline = ApplicationInfo.getInstance().getBuild().getBaselineVersion();
        String string = System.getProperty("rdct.logs.cleanup.period", "14");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        cleanupPeriod = Long.parseLong(string);
    }
}

