/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.javascript.debugger.JavaScriptNameMapperKt;
import com.intellij.javascript.debugger.NameMapper;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.MappingEntry;
import org.jetbrains.debugger.sourcemap.Mappings;
import org.jetbrains.debugger.sourcemap.SourceMap;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\fJ$\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0014J0\u0010\u0014\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0014J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001cH\u0016\u00a8\u0006\u001d"}, d2={"Lcom/intellij/javascript/debugger/JavaScriptNameMapper;", "Lcom/intellij/javascript/debugger/NameMapper;", "document", "Lcom/intellij/openapi/editor/Document;", "generatedDocument", "mappingList", "Lorg/jetbrains/debugger/sourcemap/Mappings;", "map", "Lorg/jetbrains/debugger/sourcemap/SourceMap;", "transpiledFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/editor/Document;Lcom/intellij/openapi/editor/Document;Lorg/jetbrains/debugger/sourcemap/Mappings;Lorg/jetbrains/debugger/sourcemap/SourceMap;Lcom/intellij/openapi/vfs/VirtualFile;)V", "extractName", "", "kotlin.jvm.PlatformType", "rawGeneratedName", "", "context", "Lcom/intellij/psi/PsiElement;", "getGeneratedName", "element", "sourceMap", "mappings", "", "Lorg/jetbrains/debugger/sourcemap/MappingEntry;", "identifierOrNamedElement", "saveMapping", "", "intellij.javascript.debugger.backend"})
public final class JavaScriptNameMapper
extends NameMapper {
    public JavaScriptNameMapper(@NotNull Document document, @NotNull Document generatedDocument, @NotNull Mappings mappingList, @NotNull SourceMap map, @Nullable VirtualFile transpiledFile) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)generatedDocument, (String)"generatedDocument");
        Intrinsics.checkNotNullParameter((Object)mappingList, (String)"mappingList");
        Intrinsics.checkNotNullParameter((Object)map, (String)"map");
        super(document, generatedDocument, mappingList, map, transpiledFile);
    }

    protected String extractName(@Nullable CharSequence rawGeneratedName, @Nullable PsiElement context) {
        return JavaScriptNameMapperKt.doExtractName(rawGeneratedName, context);
    }

    @Nullable
    protected String getGeneratedName(@NotNull PsiElement element, @NotNull Document document, @NotNull SourceMap sourceMap, @NotNull List<? extends MappingEntry> mappings) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)sourceMap, (String)"sourceMap");
        Intrinsics.checkNotNullParameter(mappings, (String)"mappings");
        return JavaScriptNameMapperKt.computeGeneratedName(element, document, sourceMap, mappings);
    }

    @Nullable
    public String map(@NotNull PsiElement identifierOrNamedElement, boolean saveMapping) {
        boolean mapBySourceCode;
        Intrinsics.checkNotNullParameter((Object)identifierOrNamedElement, (String)"identifierOrNamedElement");
        boolean bl = mapBySourceCode = identifierOrNamedElement instanceof JSThisExpression ? Registry.Companion.is("js.debugger.map.this.by.source.code", false) : Registry.Companion.is("js.debugger.name.mappings.by.source.code", false);
        if (!this.getSourceMap().getHasNameMappings() && !mapBySourceCode) {
            return null;
        }
        if (identifierOrNamedElement instanceof JSVariable) {
            PsiElement psiElement = ((JSVariable)identifierOrNamedElement).getLastChild();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getLastChild(...)");
            this.doMap(psiElement, mapBySourceCode, saveMapping);
            PsiElement psiElement2 = ((JSVariable)identifierOrNamedElement).getFirstChild();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getFirstChild(...)");
            return this.doMap(psiElement2, mapBySourceCode, saveMapping);
        }
        return this.doMap(identifierOrNamedElement, mapBySourceCode, saveMapping);
    }
}

