/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.scripts;

import com.intellij.javascript.debugger.scripts.FileInfo;
import com.intellij.javascript.debugger.scripts.FileNode;
import com.intellij.javascript.debugger.scripts.SourcesTreeComponent;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b \u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0001\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H$R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\fR\u0014\u0010\r\u001a\u00020\u000b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0014\u0010\u0019\u001a\u00020\u001a8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\""}, d2={"Lcom/intellij/javascript/debugger/scripts/ScriptTreeActionBase;", "Lcom/intellij/openapi/actionSystem/AnAction;", "treeComponent", "Lcom/intellij/javascript/debugger/scripts/SourcesTreeComponent;", "text", "", "<init>", "(Lcom/intellij/javascript/debugger/scripts/SourcesTreeComponent;Ljava/lang/String;)V", "getTreeComponent", "()Lcom/intellij/javascript/debugger/scripts/SourcesTreeComponent;", "isOnlyFile", "", "()Z", "invisibleIfDisabled", "getInvisibleIfDisabled", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isApplicable", "info", "Lcom/intellij/javascript/debugger/scripts/FileInfo;", "actionPerformed", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "perform", "node", "Lcom/intellij/javascript/debugger/scripts/FileNode;", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "intellij.javascript.debugger.backend"})
public abstract class ScriptTreeActionBase
extends AnAction {
    @NotNull
    private final SourcesTreeComponent treeComponent;

    public ScriptTreeActionBase(@NotNull SourcesTreeComponent treeComponent, @NlsActions.ActionText @Nullable String text) {
        Intrinsics.checkNotNullParameter((Object)treeComponent, (String)"treeComponent");
        super(text);
        this.treeComponent = treeComponent;
    }

    @NotNull
    protected final SourcesTreeComponent getTreeComponent() {
        return this.treeComponent;
    }

    protected boolean isOnlyFile() {
        return true;
    }

    protected boolean getInvisibleIfDisabled() {
        return true;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        FileNode node = this.treeComponent.getSelectedNode();
        boolean applicable = node != null && (!this.isOnlyFile() || node.getFileInfo().isFile()) && this.isApplicable(node.getFileInfo());
        e.getPresentation().setEnabled(applicable);
        if (this.getInvisibleIfDisabled()) {
            e.getPresentation().setVisible(applicable);
        }
    }

    protected boolean isApplicable(@NotNull FileInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        return true;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        FileNode node = this.treeComponent.getSelectedNode();
        if (node != null) {
            DataContext dataContext = e.getDataContext();
            Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
            this.perform(node, dataContext);
        }
    }

    @NotNull
    protected final Project getProject() {
        Project project = this.treeComponent.getDebugProcess().getSession().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return project;
    }

    protected abstract void perform(@NotNull FileNode var1, @NotNull DataContext var2);
}

