/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.chains;

import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.chains.DiffRequestSelectionChain;
import com.intellij.diff.chains.SimpleDiffRequestChain;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.ErrorDiffRequest;
import com.intellij.diff.requests.LoadingDiffRequest;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.EventDispatcher;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.EventListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AsyncDiffRequestChain
extends UserDataHolderBase
implements DiffRequestSelectionChain {
    private final EventDispatcher<Listener> myDispatcher = EventDispatcher.create(Listener.class);
    private volatile ListSelection<? extends DiffRequestProducer> myRequests = null;
    @Nullable
    private ProgressIndicator myIndicator;
    private int myAssignments = 0;

    public void addListener(@NotNull Listener listener, @NotNull Disposable disposable) {
        if (listener == null) {
            AsyncDiffRequestChain.$$$reportNull$$$0(0);
        }
        if (disposable == null) {
            AsyncDiffRequestChain.$$$reportNull$$$0(1);
        }
        this.myDispatcher.addListener((EventListener)listener, disposable);
    }

    public void removeListener(@NotNull Listener listener) {
        if (listener == null) {
            AsyncDiffRequestChain.$$$reportNull$$$0(2);
        }
        this.myDispatcher.removeListener((EventListener)listener);
    }

    @NotNull
    public ListSelection<? extends DiffRequestProducer> getListSelection() {
        ListSelection<? extends DiffRequestProducer> requests = this.myRequests;
        if (requests == null) {
            ListSelection listSelection = ListSelection.createSingleton((Object)new SimpleDiffRequestChain.DiffRequestProducerWrapper((DiffRequest)new LoadingDiffRequest()));
            if (listSelection == null) {
                AsyncDiffRequestChain.$$$reportNull$$$0(3);
            }
            return listSelection;
        }
        ListSelection<? extends DiffRequestProducer> listSelection = requests;
        if (listSelection == null) {
            AsyncDiffRequestChain.$$$reportNull$$$0(4);
        }
        return listSelection;
    }

    @RequiresBackgroundThread
    @NotNull
    public ListSelection<? extends DiffRequestProducer> loadRequestsInBackground() {
        ListSelection<? extends DiffRequestProducer> listSelection;
        ThreadingAssertions.assertBackgroundThread();
        try {
            listSelection = this.loadRequestProducers();
        }
        catch (DiffRequestProducerException e) {
            ListSelection listSelection2 = ListSelection.createSingleton((Object)new SimpleDiffRequestChain.DiffRequestProducerWrapper((DiffRequest)new ErrorDiffRequest((Throwable)e)));
            if (listSelection2 == null) {
                AsyncDiffRequestChain.$$$reportNull$$$0(6);
            }
            return listSelection2;
        }
        if (listSelection == null) {
            AsyncDiffRequestChain.$$$reportNull$$$0(5);
        }
        return listSelection;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public void onAssigned(boolean bl) {
        void isAssigned;
        ThreadingAssertions.assertEventDispatchThread();
        if (isAssigned != false) {
            if (this.myAssignments == 0 && this.myIndicator == null) {
                this.myIndicator = this.startLoading();
            }
            ++this.myAssignments;
        } else {
            --this.myAssignments;
            if (this.myAssignments == 0 && this.myIndicator != null) {
                this.myIndicator.cancel();
                this.myIndicator = null;
            }
        }
        assert (this.myAssignments >= 0);
    }

    @RequiresEdt
    @Nullable
    private ProgressIndicator startLoading() {
        ThreadingAssertions.assertEventDispatchThread();
        if (this.myRequests != null) {
            return null;
        }
        return BackgroundTaskUtil.executeAndTryWait(indicator -> {
            ListSelection<? extends DiffRequestProducer> producers = this.loadRequestsInBackground();
            return () -> {
                indicator.checkCanceled();
                this.applyLoadedChanges(producers);
            };
        }, null);
    }

    @RequiresEdt
    private void applyLoadedChanges(@NotNull ListSelection<? extends DiffRequestProducer> producers) {
        if (producers == null) {
            AsyncDiffRequestChain.$$$reportNull$$$0(7);
        }
        ThreadingAssertions.assertEventDispatchThread();
        if (this.myRequests != null) {
            return;
        }
        this.myRequests = producers;
        this.myIndicator = null;
        ((Listener)this.myDispatcher.getMulticaster()).onRequestsLoaded();
    }

    @RequiresBackgroundThread
    @NotNull
    protected abstract ListSelection<? extends DiffRequestProducer> loadRequestProducers() throws DiffRequestProducerException;

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/chains/AsyncDiffRequestChain";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/chains/AsyncDiffRequestChain";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getListSelection";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "loadRequestsInBackground";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "applyLoadedChanges";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }

    public static interface Listener
    extends EventListener {
        @RequiresEdt
        public void onRequestsLoaded();
    }
}

