/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.merge;

import com.intellij.diff.comparison.ComparisonMergeUtil;
import com.intellij.diff.merge.MergeConflictModelKt;
import com.intellij.diff.merge.TextMergeChange;
import com.intellij.diff.merge.TextMergeRequest;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.MergeConflictResolutionStrategy;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.diagnostic.Logger;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/diff/merge/TextAutoResolver;", "", "mergeRequest", "Lcom/intellij/diff/merge/TextMergeRequest;", "<init>", "(Lcom/intellij/diff/merge/TextMergeRequest;)V", "resolve", "", "change", "Lcom/intellij/diff/merge/TextMergeChange;", "Companion", "intellij.platform.diff.impl"})
@SourceDebugExtension(value={"SMAP\nMergeConflictModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MergeConflictModel.kt\ncom/intellij/diff/merge/TextAutoResolver\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,362:1\n13#2:363\n*S KotlinDebug\n*F\n+ 1 MergeConflictModel.kt\ncom/intellij/diff/merge/TextAutoResolver\n*L\n344#1:363\n*E\n"})
final class TextAutoResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TextMergeRequest mergeRequest;
    @NotNull
    private static final Logger LOG;

    public TextAutoResolver(@NotNull TextMergeRequest mergeRequest) {
        Intrinsics.checkNotNullParameter((Object)mergeRequest, (String)"mergeRequest");
        this.mergeRequest = mergeRequest;
    }

    @Nullable
    public final CharSequence resolve(@NotNull TextMergeChange change) {
        CharSequence rightText;
        CharSequence baseText;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        boolean bl2 = bl = change.getConflictType().getResolutionStrategy() == MergeConflictResolutionStrategy.TEXT;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        List texts = ThreeSide.Companion.map(arg_0 -> TextAutoResolver.resolve$lambda$0(this, change, arg_0));
        CharSequence leftText = (CharSequence)ThreeSide.LEFT.select(texts);
        CharSequence newContent = ComparisonMergeUtil.tryResolveConflict((CharSequence)leftText, (CharSequence)(baseText = (CharSequence)ThreeSide.BASE.select(texts)), (CharSequence)(rightText = (CharSequence)ThreeSide.RIGHT.select(texts)));
        if (newContent == null) {
            String string = "Can't resolve conflicting change:\n'%s'\n'%s'\n'%s'\n";
            Object[] objectArray = new Object[]{leftText, baseText, rightText};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            LOG.warn(string2);
        }
        return newContent;
    }

    private static final CharSequence resolve$lambda$0(TextAutoResolver this$0, TextMergeChange $change, ThreeSide side) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        return DiffUtil.getLinesContent(MergeConflictModelKt.access$getDocument(this$0.mergeRequest, side), $change.getStartLine(side), $change.getEndLine(side));
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(TextAutoResolver.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/diff/merge/TextAutoResolver$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.diff.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

