/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.simple;

import com.intellij.diff.tools.simple.DiffViewerHighlighters;
import com.intellij.diff.tools.simple.ThreesideDiffChangeBase;
import com.intellij.diff.tools.util.text.MergeInnerDifferences;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffGutterOperation;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.TextDiffType;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\u0010\u001e\n\u0002\b\u0012\b'\u0018\u0000 52\u00020\u0001:\u00015B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0016\u0010\"\u001a\u00020#2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00160$H\u0005J\u0010\u0010%\u001a\u00020#2\u0006\u0010&\u001a\u00020\u0016H\u0005J\u0016\u0010'\u001a\u00020#2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00160$H\u0005J\u0012\u0010(\u001a\u00020#2\b\u0010)\u001a\u0004\u0018\u00010\u0019H\u0005J\b\u0010*\u001a\u00020#H\u0005J\b\u0010+\u001a\u00020#H\u0005J\b\u0010,\u001a\u00020#H'J\b\u0010-\u001a\u00020#H\u0007J\b\u0010.\u001a\u00020#H\u0005J\b\u0010/\u001a\u00020#H\u0007J\b\u00100\u001a\u00020#H\u0005J\b\u00101\u001a\u00020#H\u0017J\u0010\u00102\u001a\u00020#2\u0006\u00103\u001a\u00020\bH\u0002J\u0010\u00104\u001a\u00020#2\u0006\u00103\u001a\u00020\bH\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0094\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R \u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00160\u001b8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00160\u001b8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001dR\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00190\u001b8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u001d\u00a8\u00066"}, d2={"Lcom/intellij/diff/tools/simple/DiffViewerHighlighters;", "", "change", "Lcom/intellij/diff/tools/simple/ThreesideDiffChangeBase;", "innerFragments", "Lcom/intellij/diff/tools/util/text/MergeInnerDifferences;", "editorProvider", "Lkotlin/Function1;", "Lcom/intellij/diff/util/ThreeSide;", "Lcom/intellij/openapi/editor/ex/EditorEx;", "<init>", "(Lcom/intellij/diff/tools/simple/ThreesideDiffChangeBase;Lcom/intellij/diff/tools/util/text/MergeInnerDifferences;Lkotlin/jvm/functions/Function1;)V", "getChange", "()Lcom/intellij/diff/tools/simple/ThreesideDiffChangeBase;", "getInnerFragments", "()Lcom/intellij/diff/tools/util/text/MergeInnerDifferences;", "setInnerFragments", "(Lcom/intellij/diff/tools/util/text/MergeInnerDifferences;)V", "getEditorProvider", "()Lkotlin/jvm/functions/Function1;", "_highlighters", "", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "_innerHighlighters", "_operations", "Lcom/intellij/diff/util/DiffGutterOperation;", "highlighters", "", "getHighlighters", "()Ljava/util/List;", "innerHighlighters", "getInnerHighlighters", "operations", "getOperations", "addHighlighters", "", "", "addHighlighter", "highlighter", "addInnerHighlighters", "addOperation", "operation", "installHighlighters", "installInnerHighlighters", "installOperations", "destroy", "destroyHighlighters", "destroyInnerHighlighters", "destroyOperations", "reinstallAll", "createInnerHighlighter", "side", "createHighlighter", "Companion", "intellij.platform.diff.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nDiffViewerHighlighters.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiffViewerHighlighters.kt\ncom/intellij/diff/tools/simple/DiffViewerHighlighters\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,142:1\n1#2:143\n*E\n"})
public abstract class DiffViewerHighlighters {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ThreesideDiffChangeBase change;
    @Nullable
    private MergeInnerDifferences innerFragments;
    @NotNull
    private final Function1<ThreeSide, EditorEx> editorProvider;
    @NotNull
    private final List<RangeHighlighter> _highlighters;
    @NotNull
    private final List<RangeHighlighter> _innerHighlighters;
    @NotNull
    private final List<DiffGutterOperation> _operations;

    public DiffViewerHighlighters(@NotNull ThreesideDiffChangeBase change, @Nullable MergeInnerDifferences innerFragments, @NotNull Function1<? super ThreeSide, ? extends EditorEx> editorProvider) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        Intrinsics.checkNotNullParameter(editorProvider, (String)"editorProvider");
        this.change = change;
        this.innerFragments = innerFragments;
        this.editorProvider = editorProvider;
        this._highlighters = new ArrayList();
        this._innerHighlighters = new ArrayList();
        this._operations = new ArrayList();
    }

    @NotNull
    protected ThreesideDiffChangeBase getChange() {
        return this.change;
    }

    @Nullable
    protected MergeInnerDifferences getInnerFragments() {
        return this.innerFragments;
    }

    protected void setInnerFragments(@Nullable MergeInnerDifferences mergeInnerDifferences) {
        this.innerFragments = mergeInnerDifferences;
    }

    @NotNull
    protected final Function1<ThreeSide, EditorEx> getEditorProvider() {
        return this.editorProvider;
    }

    @NotNull
    protected final List<RangeHighlighter> getHighlighters() {
        return this._highlighters;
    }

    @NotNull
    protected final List<RangeHighlighter> getInnerHighlighters() {
        return this._innerHighlighters;
    }

    @NotNull
    protected final List<DiffGutterOperation> getOperations() {
        return this._operations;
    }

    @RequiresEdt
    protected final void addHighlighters(@NotNull Collection<? extends RangeHighlighter> highlighters) {
        Intrinsics.checkNotNullParameter(highlighters, (String)"highlighters");
        this._highlighters.addAll(highlighters);
    }

    @RequiresEdt
    protected final void addHighlighter(@NotNull RangeHighlighter highlighter) {
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        this._highlighters.add(highlighter);
    }

    @RequiresEdt
    protected final void addInnerHighlighters(@NotNull Collection<? extends RangeHighlighter> highlighters) {
        Intrinsics.checkNotNullParameter(highlighters, (String)"highlighters");
        this._innerHighlighters.addAll(highlighters);
    }

    @RequiresEdt
    protected final void addOperation(@Nullable DiffGutterOperation operation) {
        block0: {
            DiffGutterOperation diffGutterOperation = operation;
            if (diffGutterOperation == null) break block0;
            DiffGutterOperation it = diffGutterOperation;
            boolean bl = false;
            this._operations.add(it);
        }
    }

    @RequiresEdt
    protected final void installHighlighters() {
        boolean bl = this.getHighlighters().isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.createHighlighter(ThreeSide.BASE);
        if (this.getChange().isChange(Side.LEFT)) {
            this.createHighlighter(ThreeSide.LEFT);
        }
        if (this.getChange().isChange(Side.RIGHT)) {
            this.createHighlighter(ThreeSide.RIGHT);
        }
    }

    @RequiresEdt
    protected final void installInnerHighlighters() {
        boolean bl = this.getInnerHighlighters().isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.createInnerHighlighter(ThreeSide.BASE);
        if (this.getChange().isChange(Side.LEFT)) {
            this.createInnerHighlighter(ThreeSide.LEFT);
        }
        if (this.getChange().isChange(Side.RIGHT)) {
            this.createInnerHighlighter(ThreeSide.RIGHT);
        }
    }

    @RequiresEdt
    public abstract void installOperations();

    @RequiresEdt
    public final void destroy() {
        this.destroyHighlighters();
        this.destroyInnerHighlighters();
        this.destroyOperations();
    }

    @RequiresEdt
    protected final void destroyHighlighters() {
        DiffViewerHighlighters.Companion.disposeAndClear(this._highlighters, destroyHighlighters.1.INSTANCE);
    }

    @RequiresEdt
    public final void destroyInnerHighlighters() {
        DiffViewerHighlighters.Companion.disposeAndClear(this._innerHighlighters, destroyInnerHighlighters.1.INSTANCE);
    }

    @RequiresEdt
    protected final void destroyOperations() {
        DiffViewerHighlighters.Companion.disposeAndClear(this._operations, destroyOperations.1.INSTANCE);
    }

    @RequiresEdt
    public void reinstallAll() {
        this.destroyHighlighters();
        this.installHighlighters();
        this.destroyInnerHighlighters();
        this.installInnerHighlighters();
        this.destroyOperations();
        this.installOperations();
    }

    private final void createInnerHighlighter(ThreeSide side) {
        if (this.getChange().isResolved(side)) {
            return;
        }
        MergeInnerDifferences mergeInnerDifferences = this.getInnerFragments();
        if (mergeInnerDifferences == null) {
            return;
        }
        MergeInnerDifferences innerFragments = mergeInnerDifferences;
        List<TextRange> list = innerFragments.get(side);
        if (list == null) {
            return;
        }
        List<TextRange> ranges = list;
        EditorEx editor = (EditorEx)this.editorProvider.invoke((Object)side);
        int start = DiffUtil.getLinesRange((Document)editor.getDocument(), this.getChange().getStartLine(side), this.getChange().getEndLine(side)).getStartOffset();
        for (TextRange fragment : ranges) {
            int innerStart = start + fragment.getStartOffset();
            int innerEnd = start + fragment.getEndOffset();
            List<RangeHighlighter> list2 = DiffDrawUtil.createInlineHighlighter((Editor)editor, innerStart, innerEnd, this.getChange().getDiffType());
            Intrinsics.checkNotNullExpressionValue(list2, (String)"createInlineHighlighter(...)");
            this.addInnerHighlighters((Collection<? extends RangeHighlighter>)list2);
        }
    }

    private final void createHighlighter(ThreeSide side) {
        EditorEx editor = (EditorEx)this.editorProvider.invoke((Object)side);
        TextDiffType type = this.getChange().getDiffType();
        int startLine = this.getChange().getStartLine(side);
        int endLine = this.getChange().getEndLine(side);
        boolean resolved = this.getChange().isResolved(side);
        boolean ignored = !resolved && this.getInnerFragments() != null;
        boolean shouldHideWithoutLineNumbers = side == ThreeSide.BASE && !this.getChange().isChange(Side.LEFT) && this.getChange().isChange(Side.RIGHT);
        List<RangeHighlighter> list = new DiffDrawUtil.LineHighlighterBuilder((Editor)editor, startLine, endLine, type).withIgnored(ignored).withResolved(resolved).withHideWithoutLineNumbers(shouldHideWithoutLineNumbers).withHideStripeMarkers(side == ThreeSide.BASE).done();
        Intrinsics.checkNotNullExpressionValue(list, (String)"done(...)");
        this.addHighlighters((Collection<? extends RangeHighlighter>)list);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u0005\"\u0004\b\u0000\u0010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00060\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u00020\u00050\nH\u0002\u00a8\u0006\u000b"}, d2={"Lcom/intellij/diff/tools/simple/DiffViewerHighlighters$Companion;", "", "<init>", "()V", "disposeAndClear", "", "S", "collection", "", "disposer", "Lkotlin/Function1;", "intellij.platform.diff.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final <S> void disposeAndClear(Collection<S> collection, Function1<? super S, Unit> disposer) {
            for (S element : collection) {
                disposer.invoke(element);
            }
            collection.clear();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

