/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.text;

import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.editor.Document;
import org.jetbrains.annotations.NotNull;

final class LineOffsetsDocumentWrapper
implements LineOffsets {
    @NotNull
    private final Document myDocument;

    LineOffsetsDocumentWrapper(@NotNull Document document) {
        if (document == null) {
            LineOffsetsDocumentWrapper.$$$reportNull$$$0(0);
        }
        this.myDocument = document;
    }

    public int getLineStart(int line) {
        return this.myDocument.getLineStartOffset(line);
    }

    public int getLineEnd(int line) {
        return this.myDocument.getLineEndOffset(line);
    }

    public int getLineEnd(int line, boolean includeNewline) {
        if (this.myDocument.getLineCount() == 0) {
            return 0;
        }
        return this.myDocument.getLineEndOffset(line) + (includeNewline ? this.myDocument.getLineSeparatorLength(line) : 0);
    }

    public int getLineNumber(int offset) {
        return this.myDocument.getLineNumber(offset);
    }

    public int getLineCount() {
        return DiffUtil.getLineCount(this.myDocument);
    }

    public int getTextLength() {
        return this.myDocument.getTextLength();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/tools/util/text/LineOffsetsDocumentWrapper", "<init>"));
    }
}

