/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.model.source;

import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.model.Pointer;
import com.intellij.model.Symbol;
import com.intellij.model.psi.PsiSymbolService;
import com.intellij.polySymbols.PolySymbolKind;
import com.intellij.polySymbols.search.PsiSourcedPolySymbol;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.codeInsight.VueUtilKt;
import org.jetbrains.vuejs.model.VueDirective;
import org.jetbrains.vuejs.model.VueDirectiveModifier;
import org.jetbrains.vuejs.model.VueEntitiesContainer;
import org.jetbrains.vuejs.model.VueMode;
import org.jetbrains.vuejs.model.VueModelVisitor;
import org.jetbrains.vuejs.model.typed.VueTypedDirectives;
import org.jetbrains.vuejs.web.VueSymbolQueryConfiguratorKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B+\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010#\u001a\u00020\u00012\u0006\u0010$\u001a\u00020\nH\u0016J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00000&H\u0016J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0016J\u0014\u0010+\u001a\u00020(2\b\u0010,\u001a\u0004\u0018\u00010-H\u0096\u0082\u0004J\n\u0010.\u001a\u00020/H\u0096\u0080\u0004J\n\u00100\u001a\u00020\u0004H\u0096\u0080\u0004R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\u0004\u0018\u00010\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u001b\u0010\u001a\u001a\u00020\u001b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0015\u00a8\u00061"}, d2={"Lorg/jetbrains/vuejs/model/source/VueScriptSetupLocalDirective;", "Lorg/jetbrains/vuejs/model/VueDirective;", "Lcom/intellij/polySymbols/search/PsiSourcedPolySymbol;", "name", "", "rawSource", "Lcom/intellij/lang/javascript/psi/JSPsiNamedElementBase;", "mode", "Lorg/jetbrains/vuejs/model/VueMode;", "vueProximity", "Lorg/jetbrains/vuejs/model/VueModelVisitor$Proximity;", "<init>", "(Ljava/lang/String;Lcom/intellij/lang/javascript/psi/JSPsiNamedElementBase;Lorg/jetbrains/vuejs/model/VueMode;Lorg/jetbrains/vuejs/model/VueModelVisitor$Proximity;)V", "getName", "()Ljava/lang/String;", "getVueProximity", "()Lorg/jetbrains/vuejs/model/VueModelVisitor$Proximity;", "parents", "", "Lorg/jetbrains/vuejs/model/VueEntitiesContainer;", "getParents", "()Ljava/util/List;", "kind", "Lcom/intellij/polySymbols/PolySymbolKind;", "getKind", "()Lcom/intellij/polySymbols/PolySymbolKind;", "source", "Lcom/intellij/psi/PsiElement;", "getSource", "()Lcom/intellij/psi/PsiElement;", "source$delegate", "Lkotlin/Lazy;", "directiveModifiers", "Lorg/jetbrains/vuejs/model/VueDirectiveModifier;", "getDirectiveModifiers", "withVueProximity", "proximity", "createPointer", "Lcom/intellij/model/Pointer;", "isEquivalentTo", "", "symbol", "Lcom/intellij/model/Symbol;", "equals", "other", "", "hashCode", "", "toString", "intellij.vuejs.backend"})
@SourceDebugExtension(value={"SMAP\nVueScriptSetupLocalDirective.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VueScriptSetupLocalDirective.kt\norg/jetbrains/vuejs/model/source/VueScriptSetupLocalDirective\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,84:1\n1#2:85\n*E\n"})
public final class VueScriptSetupLocalDirective
implements VueDirective,
PsiSourcedPolySymbol {
    @NotNull
    private final String name;
    @NotNull
    private final JSPsiNamedElementBase rawSource;
    @NotNull
    private final VueMode mode;
    @Nullable
    private final VueModelVisitor.Proximity vueProximity;
    @NotNull
    private final List<VueEntitiesContainer> parents;
    @NotNull
    private final Lazy source$delegate;

    public VueScriptSetupLocalDirective(@NotNull String name, @NotNull JSPsiNamedElementBase rawSource, @NotNull VueMode mode, @Nullable VueModelVisitor.Proximity vueProximity) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)rawSource, (String)"rawSource");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        this.name = name;
        this.rawSource = rawSource;
        this.mode = mode;
        this.vueProximity = vueProximity;
        this.parents = CollectionsKt.emptyList();
        this.source$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> VueScriptSetupLocalDirective.source_delegate$lambda$0(this));
    }

    public /* synthetic */ VueScriptSetupLocalDirective(String string, JSPsiNamedElementBase jSPsiNamedElementBase, VueMode vueMode, VueModelVisitor.Proximity proximity, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            proximity = null;
        }
        this(string, jSPsiNamedElementBase, vueMode, proximity);
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public VueModelVisitor.Proximity getVueProximity() {
        return this.vueProximity;
    }

    @Override
    @NotNull
    public List<VueEntitiesContainer> getParents() {
        return this.parents;
    }

    @NotNull
    public PolySymbolKind getKind() {
        return VueSymbolQueryConfiguratorKt.getVUE_SCRIPT_SETUP_LOCAL_DIRECTIVES();
    }

    @Override
    @NotNull
    public PsiElement getSource() {
        Lazy lazy = this.source$delegate;
        return (PsiElement)lazy.getValue();
    }

    @Override
    @NotNull
    public List<VueDirectiveModifier> getDirectiveModifiers() {
        Object object = CachedValuesManager.getCachedValue((PsiElement)this.getSource(), () -> VueScriptSetupLocalDirective._get_directiveModifiers_$lambda$0(this));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (List)object;
    }

    @Override
    @NotNull
    public VueDirective withVueProximity(@NotNull VueModelVisitor.Proximity proximity) {
        Intrinsics.checkNotNullParameter((Object)((Object)proximity), (String)"proximity");
        return new VueScriptSetupLocalDirective(this.getName(), this.rawSource, this.mode, proximity);
    }

    @NotNull
    public Pointer<VueScriptSetupLocalDirective> createPointer() {
        String name = this.getName();
        SmartPsiElementPointer source = SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)this.rawSource));
        VueMode mode = this.mode;
        VueModelVisitor.Proximity vueProximity = this.getVueProximity();
        return () -> VueScriptSetupLocalDirective.createPointer$lambda$0(source, name, mode, vueProximity);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isEquivalentTo(@NotNull Symbol symbol) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        if (super.isEquivalentTo(symbol)) return true;
        PsiElement psiElement = PsiSymbolService.getInstance().extractElementFromSymbol(symbol);
        if (psiElement != null) {
            PsiElement it = psiElement;
            boolean bl2 = false;
            if (it.getManager().areElementsEquivalent(it, (PsiElement)this.rawSource)) {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        if (!(symbol instanceof VueScriptSetupLocalDirective)) return false;
        if (!Intrinsics.areEqual((Object)((VueScriptSetupLocalDirective)symbol).getSource(), (Object)this.getSource())) return false;
        if (!Intrinsics.areEqual((Object)((VueScriptSetupLocalDirective)symbol).getName(), (Object)this.getName())) return false;
        return true;
    }

    public boolean equals(@Nullable Object other) {
        return other == this || other instanceof VueScriptSetupLocalDirective && Intrinsics.areEqual((Object)((VueScriptSetupLocalDirective)other).getName(), (Object)this.getName()) && Intrinsics.areEqual((Object)((VueScriptSetupLocalDirective)other).rawSource, (Object)this.rawSource) && ((VueScriptSetupLocalDirective)other).getVueProximity() == this.getVueProximity();
    }

    public int hashCode() {
        int result = this.getName().hashCode();
        result = 31 * result + this.rawSource.hashCode();
        VueModelVisitor.Proximity proximity = this.getVueProximity();
        result = 31 * result + (proximity != null ? proximity.hashCode() : 0);
        return result;
    }

    @NotNull
    public String toString() {
        return "VueScriptSetupLocalDirective(" + this.getName() + ")";
    }

    private static final JSPsiNamedElementBase source_delegate$lambda$0(VueScriptSetupLocalDirective this$0) {
        return VueUtilKt.resolveIfImportSpecifier(this$0.rawSource);
    }

    private static final CachedValueProvider.Result _get_directiveModifiers_$lambda$0(VueScriptSetupLocalDirective this$0) {
        Object[] objectArray = new Object[]{PsiModificationTracker.MODIFICATION_COUNT};
        return CachedValueProvider.Result.create(VueTypedDirectives.INSTANCE.getDirectiveModifiers(this$0.getSource(), this$0.mode), (Object[])objectArray);
    }

    private static final VueScriptSetupLocalDirective createPointer$lambda$0(SmartPsiElementPointer $source, String $name, VueMode $mode, VueModelVisitor.Proximity $vueProximity) {
        JSPsiNamedElementBase jSPsiNamedElementBase = (JSPsiNamedElementBase)$source.dereference();
        if (jSPsiNamedElementBase == null) {
            return null;
        }
        JSPsiNamedElementBase newSource = jSPsiNamedElementBase;
        return new VueScriptSetupLocalDirective($name, newSource, $mode, $vueProximity);
    }
}

