/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.model.source;

import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.model.Pointer;
import com.intellij.model.Symbol;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.polySymbols.PolySymbol;
import com.intellij.polySymbols.PolySymbolKind;
import com.intellij.polySymbols.refactoring.PolySymbolRenameTarget;
import com.intellij.polySymbols.search.PsiSourcedPolySymbol;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.codeInsight.VueUtilKt;
import org.jetbrains.vuejs.model.VueDirective;
import org.jetbrains.vuejs.model.VueDirectiveModifier;
import org.jetbrains.vuejs.model.VueEntitiesContainer;
import org.jetbrains.vuejs.model.VueMode;
import org.jetbrains.vuejs.model.VueModelVisitor;
import org.jetbrains.vuejs.model.typed.VueTypedDirectives;
import org.jetbrains.vuejs.web.VueSymbolQueryConfiguratorKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B9\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010$\u001a\u00020\u00012\u0006\u0010%\u001a\u00020\u000bH\u0016J\u0010\u0010&\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000'H\u0016J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0016J\u0014\u0010,\u001a\u00020)2\b\u0010-\u001a\u0004\u0018\u00010.H\u0096\u0082\u0004J\n\u0010/\u001a\u000200H\u0096\u0080\u0004J\n\u00101\u001a\u00020\u0004H\u0096\u0080\u0004R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001cR\u0016\u0010 \u001a\u0004\u0018\u00010!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u00062"}, d2={"Lorg/jetbrains/vuejs/model/source/VueSourceDirective;", "Lorg/jetbrains/vuejs/model/VueDirective;", "Lcom/intellij/polySymbols/search/PsiSourcedPolySymbol;", "name", "", "source", "Lcom/intellij/psi/PsiElement;", "typeSource", "mode", "Lorg/jetbrains/vuejs/model/VueMode;", "vueProximity", "Lorg/jetbrains/vuejs/model/VueModelVisitor$Proximity;", "<init>", "(Ljava/lang/String;Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;Lorg/jetbrains/vuejs/model/VueMode;Lorg/jetbrains/vuejs/model/VueModelVisitor$Proximity;)V", "getSource", "()Lcom/intellij/psi/PsiElement;", "getVueProximity", "()Lorg/jetbrains/vuejs/model/VueModelVisitor$Proximity;", "kind", "Lcom/intellij/polySymbols/PolySymbolKind;", "getKind", "()Lcom/intellij/polySymbols/PolySymbolKind;", "getName", "()Ljava/lang/String;", "parents", "", "Lorg/jetbrains/vuejs/model/VueEntitiesContainer;", "getParents", "()Ljava/util/List;", "directiveModifiers", "Lorg/jetbrains/vuejs/model/VueDirectiveModifier;", "getDirectiveModifiers", "renameTarget", "Lcom/intellij/polySymbols/refactoring/PolySymbolRenameTarget;", "getRenameTarget", "()Lcom/intellij/polySymbols/refactoring/PolySymbolRenameTarget;", "withVueProximity", "proximity", "createPointer", "Lcom/intellij/model/Pointer;", "isEquivalentTo", "", "symbol", "Lcom/intellij/model/Symbol;", "equals", "other", "", "hashCode", "", "toString", "intellij.vuejs.backend"})
public final class VueSourceDirective
implements VueDirective,
PsiSourcedPolySymbol {
    @NotNull
    private final PsiElement source;
    @Nullable
    private final PsiElement typeSource;
    @NotNull
    private final VueMode mode;
    @Nullable
    private final VueModelVisitor.Proximity vueProximity;
    @NotNull
    private final String name;
    @NotNull
    private final List<VueEntitiesContainer> parents;

    public VueSourceDirective(@NotNull String name, @NotNull PsiElement source, @Nullable PsiElement typeSource, @NotNull VueMode mode, @Nullable VueModelVisitor.Proximity vueProximity) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        this.source = source;
        this.typeSource = typeSource;
        this.mode = mode;
        this.vueProximity = vueProximity;
        this.name = VueUtilKt.fromAsset$default(name, false, 2, null);
        this.parents = CollectionsKt.emptyList();
    }

    public /* synthetic */ VueSourceDirective(String string, PsiElement psiElement, PsiElement psiElement2, VueMode vueMode, VueModelVisitor.Proximity proximity, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            psiElement2 = null;
        }
        if ((n & 8) != 0) {
            vueMode = VueMode.CLASSIC;
        }
        if ((n & 0x10) != 0) {
            proximity = null;
        }
        this(string, psiElement, psiElement2, vueMode, proximity);
    }

    @Override
    @NotNull
    public PsiElement getSource() {
        return this.source;
    }

    @Override
    @Nullable
    public VueModelVisitor.Proximity getVueProximity() {
        return this.vueProximity;
    }

    @NotNull
    public PolySymbolKind getKind() {
        return VueSymbolQueryConfiguratorKt.getVUE_DIRECTIVES();
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public List<VueEntitiesContainer> getParents() {
        return this.parents;
    }

    @Override
    @NotNull
    public List<VueDirectiveModifier> getDirectiveModifiers() {
        if (this.typeSource == null) {
            return CollectionsKt.emptyList();
        }
        Object object = CachedValuesManager.getCachedValue((PsiElement)this.typeSource, () -> VueSourceDirective._get_directiveModifiers_$lambda$0(this));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (List)object;
    }

    @Nullable
    public PolySymbolRenameTarget getRenameTarget() {
        return this.getSource() instanceof JSLiteralExpression ? PolySymbolRenameTarget.Companion.create((PolySymbol)this) : null;
    }

    @Override
    @NotNull
    public VueDirective withVueProximity(@NotNull VueModelVisitor.Proximity proximity) {
        Intrinsics.checkNotNullParameter((Object)((Object)proximity), (String)"proximity");
        return new VueSourceDirective(this.getName(), this.getSource(), this.typeSource, this.mode, proximity);
    }

    @NotNull
    public Pointer<? extends VueSourceDirective> createPointer() {
        String name = this.getName();
        SmartPsiElementPointer source = SmartPointersKt.createSmartPointer((PsiElement)this.getSource());
        PsiElement psiElement = this.typeSource;
        SmartPsiElementPointer typeSource = psiElement != null ? SmartPointersKt.createSmartPointer((PsiElement)psiElement) : null;
        VueMode mode = this.mode;
        VueModelVisitor.Proximity vueProximity = this.getVueProximity();
        return () -> VueSourceDirective.createPointer$lambda$0(source, typeSource, name, mode, vueProximity);
    }

    public boolean isEquivalentTo(@NotNull Symbol symbol) {
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        return super.isEquivalentTo(symbol) || symbol instanceof VueSourceDirective && Intrinsics.areEqual((Object)((VueSourceDirective)symbol).getSource(), (Object)this.getSource()) && Intrinsics.areEqual((Object)((VueSourceDirective)symbol).getName(), (Object)this.getName());
    }

    public boolean equals(@Nullable Object other) {
        return other == this || other instanceof VueSourceDirective && Intrinsics.areEqual((Object)((VueSourceDirective)other).getName(), (Object)this.getName()) && Intrinsics.areEqual((Object)((VueSourceDirective)other).getSource(), (Object)this.getSource()) && ((VueSourceDirective)other).getVueProximity() == this.getVueProximity();
    }

    public int hashCode() {
        int result = this.getName().hashCode();
        result = 31 * result + this.getSource().hashCode();
        VueModelVisitor.Proximity proximity = this.getVueProximity();
        result = 31 * result + (proximity != null ? proximity.hashCode() : 0);
        return result;
    }

    @NotNull
    public String toString() {
        return "VueSourceDirective(" + this.getName() + ")";
    }

    private static final CachedValueProvider.Result _get_directiveModifiers_$lambda$0(VueSourceDirective this$0) {
        List<VueDirectiveModifier> list = VueTypedDirectives.INSTANCE.getDirectiveModifiers(this$0.typeSource, this$0.mode);
        Object[] objectArray = new Object[2];
        Project project = this$0.typeSource.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        objectArray[0] = DumbService.Companion.getInstance(project).getModificationTracker();
        objectArray[1] = PsiModificationTracker.MODIFICATION_COUNT;
        return CachedValueProvider.Result.create(list, (Object[])objectArray);
    }

    private static final VueSourceDirective createPointer$lambda$0(SmartPsiElementPointer $source, SmartPsiElementPointer $typeSource, String $name, VueMode $mode, VueModelVisitor.Proximity $vueProximity) {
        PsiElement psiElement;
        PsiElement psiElement2 = $source.dereference();
        if (psiElement2 == null) {
            return null;
        }
        PsiElement newSource = psiElement2;
        if ($typeSource != null) {
            psiElement = $typeSource.dereference();
            if (psiElement == null) {
                return null;
            }
        } else {
            psiElement = null;
        }
        PsiElement newTypeSource = psiElement;
        return new VueSourceDirective($name, newSource, newTypeSource, $mode, $vueProximity);
    }
}

