/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.dupLocator.DuplicatesPresentation;
import com.intellij.dupLocator.DuplicatesProfile;
import com.intellij.dupLocator.DuplocatorSettingsEditor;
import com.intellij.dupLocator.DuplocatorState;
import com.intellij.dupLocator.JavaDuplocatorSettingsEditor;
import com.intellij.dupLocator.resultUI.BaseDuplicatesView;
import com.intellij.dupLocator.resultUI.CodeFragmentType;
import com.intellij.dupLocator.resultUI.CodeNode;
import com.intellij.dupLocator.resultUI.DuplicatesView;
import com.intellij.dupLocator.resultUI.GroupNode;
import com.intellij.dupLocator.resultUI.InvalidatedException;
import com.intellij.dupLocator.resultUI.MethodBodyType;
import com.intellij.dupLocator.resultUI.TextFragmentType;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.extractMethod.ExtractMethodHandler;
import com.intellij.refactoring.extractMethod.ExtractMethodProcessor;
import com.intellij.refactoring.extractMethod.JavaDuplicatesExtractMethodProcessor;
import com.intellij.refactoring.util.duplicates.MethodDuplicatesHandler;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaDuplicatesPresentation
implements DuplicatesPresentation {
    private static final Logger LOG = Logger.getInstance(JavaDuplicatesPresentation.class);
    private final JavaLanguage myLanguage = (JavaLanguage)Language.findInstance(JavaLanguage.class);

    @NotNull
    public DuplicatesProfile getProfile() {
        DuplicatesProfile duplicatesProfile = DuplicatesProfile.findProfileForLanguage((Language)this.myLanguage);
        if (duplicatesProfile == null) {
            JavaDuplicatesPresentation.$$$reportNull$$$0(0);
        }
        return duplicatesProfile;
    }

    @Nullable
    private static PsiClass getContainingClass(@NotNull CodeNode node) throws InvalidatedException {
        PsiFile file;
        if (node == null) {
            JavaDuplicatesPresentation.$$$reportNull$$$0(1);
        }
        if ((file = PsiManager.getInstance((Project)node.getProject()).findFile(node.getVirtualFile())) == null) {
            return null;
        }
        PsiElement psiElement = file.findElementAt(node.getRangeMarker().getStartOffset());
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiClass.class, (boolean)false);
        while (psiClass instanceof PsiAnonymousClass) {
            psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiClass, PsiClass.class, (boolean)true);
        }
        return psiClass;
    }

    @Nullable
    public static PsiElement getEnclosingElement(@NotNull CodeNode node) throws InvalidatedException {
        VirtualFile virtualFile;
        if (node == null) {
            JavaDuplicatesPresentation.$$$reportNull$$$0(2);
        }
        if ((virtualFile = FileDocumentManager.getInstance().getFile(node.getRangeMarker().getDocument())) == null || !virtualFile.isValid()) {
            return null;
        }
        PsiFile file = PsiManager.getInstance((Project)node.getProject()).findFile(virtualFile);
        return file != null ? PsiUtil.getElementInclusiveRange((PsiElement)file, (TextRange)node.getTextRange()) : null;
    }

    @Nullable
    public CodeFragmentType getType(@NotNull CodeNode node) throws InvalidatedException {
        PsiElement element;
        if (node == null) {
            JavaDuplicatesPresentation.$$$reportNull$$$0(3);
        }
        if ((element = JavaDuplicatesPresentation.getEnclosingElement(node)) == null) {
            return null;
        }
        RangeMarker rangeMarker = node.getRangeMarker();
        if (!element.getTextRange().equals((Object)node.getTextRange())) {
            return new TextFragmentType(JavaDuplicatesPresentation.getContainingClass(node), rangeMarker);
        }
        PsiElement parent = element.getParent();
        if (parent instanceof PsiMethod) {
            return new MethodBodyType((PsiMethod)parent);
        }
        return new TextFragmentType(JavaDuplicatesPresentation.getContainingClass(node), rangeMarker);
    }

    public boolean isFixAbilityProvided() {
        return true;
    }

    public boolean isFixAvailable(@NotNull CodeNode node) {
        if (node == null) {
            JavaDuplicatesPresentation.$$$reportNull$$$0(4);
        }
        try {
            PsiElement enclosingElement = JavaDuplicatesPresentation.getEnclosingElement(node);
            if (enclosingElement != null) {
                JavaDuplicatesExtractMethodProcessor processor = JavaDuplicatesPresentation.getProcessor(node.getTextRange(), enclosingElement, false);
                if (processor != null) {
                    processor.applyDefaults("newMethod", "private");
                    Set files = node.getParent().getAffectedFiles();
                    if (processor.hasDuplicates(files)) {
                        return true;
                    }
                } else {
                    PsiElement element = enclosingElement.getParent();
                    if (element instanceof PsiMethod) {
                        PsiMethod psiMethod = (PsiMethod)element;
                        if (psiMethod.getBody() == null) {
                            return false;
                        }
                        PsiManager psiManager = PsiManager.getInstance((Project)node.getProject());
                        Set files = node.getParent().getAffectedFiles();
                        for (VirtualFile virtualFile : files) {
                            if (MethodDuplicatesHandler.hasDuplicates((PsiElement)psiManager.findFile(virtualFile), (PsiMember)psiMethod).isEmpty()) continue;
                            return true;
                        }
                    }
                }
            }
        }
        catch (InvalidatedException invalidatedException) {
            // empty catch block
        }
        return false;
    }

    public void applyFix(@NotNull CodeNode node) {
        if (node == null) {
            JavaDuplicatesPresentation.$$$reportNull$$$0(5);
        }
        try {
            PsiMethod psiMethod;
            Project project = node.getProject();
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            GroupNode groupNode = node.getParent();
            PsiElement enclosingElement = JavaDuplicatesPresentation.getEnclosingElement(node);
            LOG.assertTrue(enclosingElement != null);
            PsiFile file = enclosingElement.getContainingFile();
            PsiElement parent = enclosingElement.getParent();
            Set affectedFiles = groupNode.getAffectedFiles();
            if (parent instanceof PsiMethod) {
                psiMethod = (PsiMethod)parent;
            } else {
                JavaDuplicatesExtractMethodProcessor processor = JavaDuplicatesPresentation.getProcessor(node.getTextRange(), enclosingElement, true);
                LOG.assertTrue(processor != null);
                if (!ExtractMethodHandler.invokeOnElements((Project)project, (ExtractMethodProcessor)processor, (PsiFile)file, (boolean)false)) {
                    return;
                }
                psiMethod = processor.getExtractedMethod();
                affectedFiles.remove(file.getVirtualFile());
            }
            if (!affectedFiles.isEmpty()) {
                MethodDuplicatesHandler.invokeOnScope((Project)project, (PsiMember)psiMethod, (AnalysisScope)new AnalysisScope(project, (Collection)affectedFiles));
            }
        }
        catch (InvalidatedException e1) {
            LOG.error((Throwable)e1);
        }
    }

    @NotNull
    public DuplicatesView createView(@NotNull Project project) {
        if (project == null) {
            JavaDuplicatesPresentation.$$$reportNull$$$0(6);
        }
        return new BaseDuplicatesView(project);
    }

    @Nullable
    private static JavaDuplicatesExtractMethodProcessor getProcessor(@NotNull TextRange textRange, @NotNull PsiElement enclosingElement, boolean interactive) {
        PsiFile file;
        PsiElement[] elements;
        if (textRange == null) {
            JavaDuplicatesPresentation.$$$reportNull$$$0(7);
        }
        if (enclosingElement == null) {
            JavaDuplicatesPresentation.$$$reportNull$$$0(8);
        }
        if ((elements = JavaDuplicatesPresentation.getSegmentElements((Segment)textRange, file = enclosingElement.getContainingFile())).length == 0) {
            return null;
        }
        Editor editor = interactive ? ExtractMethodHandler.openEditor((PsiFile)file) : null;
        JavaDuplicatesExtractMethodProcessor processor = new JavaDuplicatesExtractMethodProcessor(elements, editor, JavaDuplicatesPresentation.getRefactoringName());
        if (processor.prepare(interactive)) {
            return processor;
        }
        return null;
    }

    @NotNull
    public DuplocatorSettingsEditor createEditor(@NotNull DuplocatorState state) {
        if (state == null) {
            JavaDuplicatesPresentation.$$$reportNull$$$0(9);
        }
        return new JavaDuplocatorSettingsEditor();
    }

    public static PsiElement @NotNull [] getSegmentElements(@NotNull Segment textRange, @NotNull PsiFile file) {
        PsiExpression expr;
        if (textRange == null) {
            JavaDuplicatesPresentation.$$$reportNull$$$0(10);
        }
        if (file == null) {
            JavaDuplicatesPresentation.$$$reportNull$$$0(11);
        }
        if ((expr = CodeInsightUtil.findExpressionInRange((PsiFile)file, (int)textRange.getStartOffset(), (int)textRange.getEndOffset())) != null) {
            PsiElement[] psiElementArray = new PsiElement[]{expr};
            if (psiElementArray == null) {
                JavaDuplicatesPresentation.$$$reportNull$$$0(12);
            }
            return psiElementArray;
        }
        PsiElement[] psiElementArray = CodeInsightUtil.findStatementsInRange((PsiFile)file, (int)textRange.getStartOffset(), (int)textRange.getEndOffset());
        if (psiElementArray == null) {
            JavaDuplicatesPresentation.$$$reportNull$$$0(13);
        }
        return psiElementArray;
    }

    @NlsContexts.DialogTitle
    public static String getRefactoringName() {
        return RefactoringBundle.message((String)"refactoring.extract.method.from.duplicate.code");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dupLocator/JavaDuplicatesPresentation";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enclosingElement";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfile";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dupLocator/JavaDuplicatesPresentation";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSegmentElements";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getContainingClass";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getEnclosingElement";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isFixAvailable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createView";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getProcessor";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSegmentElements";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11 -> new IllegalArgumentException(string);
        };
    }
}

