/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.gradle;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramDataView;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.VisibilityLevel;
import com.intellij.diagram.extras.custom.CommonDiagramExtras;
import com.intellij.diagram.gradle.GradleArtifact;
import com.intellij.diagram.gradle.GradleElement;
import com.intellij.diagram.gradle.GradleFileDependencyElement;
import com.intellij.diagram.gradle.GradleLibraryDependencyElement;
import com.intellij.diagram.gradle.GradleProjectDependencyElement;
import com.intellij.diagram.gradle.GradleRootElement;
import com.intellij.diagram.gradle.GradleUmlEdge;
import com.intellij.diagram.gradle.GradleUmlNode;
import com.intellij.diagram.gradle.GradleUmlVisibilityManager;
import com.intellij.diagram.gradle.GradleUnresolvedElement;
import com.intellij.diagram.util.DiagramAlgorithmsService;
import com.intellij.diagram.util.DiagramSelectionService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.project.dependencies.ArtifactDependencyNode;
import com.intellij.openapi.externalSystem.model.project.dependencies.DependencyNode;
import com.intellij.openapi.externalSystem.model.project.dependencies.DependencyScopeNode;
import com.intellij.openapi.externalSystem.model.project.dependencies.FileCollectionDependencyNode;
import com.intellij.openapi.externalSystem.model.project.dependencies.ProjectDependencyNode;
import com.intellij.openapi.externalSystem.model.project.dependencies.ReferenceNode;
import com.intellij.openapi.externalSystem.model.project.dependencies.UnknownDependencyNode;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataImportListener;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.dependency.analyzer.GradleDependencyNodeIndex;
import org.jetbrains.plugins.gradle.util.GradleModuleData;

public final class GradleUmlDataModel
extends DiagramDataModel<GradleElement> {
    private static final Logger LOG = Logger.getInstance(GradleUmlDataModel.class);
    @Nullable
    private final GradleRootElement myElement;
    private final List<DiagramNode<GradleElement>> myNodes;
    private final List<DiagramEdge<GradleElement>> myEdges;
    private List<DependencyScopeNode> myConfigurations;
    private final MessageBusConnection myConnection;
    private boolean myDisposed;
    private volatile boolean myDelayedRefreshScheduled;

    public GradleUmlDataModel(@NotNull Project project, @Nullable GradleRootElement element, @NotNull DiagramProvider<GradleElement> provider) {
        if (project == null) {
            GradleUmlDataModel.$$$reportNull$$$0(0);
        }
        if (provider == null) {
            GradleUmlDataModel.$$$reportNull$$$0(1);
        }
        super(project, provider);
        this.myNodes = new ArrayList<DiagramNode<GradleElement>>();
        this.myEdges = new ArrayList<DiagramEdge<GradleElement>>();
        this.myDisposed = false;
        this.myDelayedRefreshScheduled = false;
        this.myElement = element;
        this.myConnection = this.getProject().getMessageBus().connect();
        this.myConnection.setDefaultHandler(this::handleGradleModelImport);
        this.myConnection.subscribe(ProjectDataImportListener.TOPIC);
    }

    @NotNull
    public Collection<? extends DiagramNode<GradleElement>> getNodes() {
        List<DiagramNode<GradleElement>> list = this.myNodes;
        if (list == null) {
            GradleUmlDataModel.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public Collection<? extends DiagramEdge<GradleElement>> getEdges() {
        List<DiagramEdge<GradleElement>> list = this.myEdges;
        if (list == null) {
            GradleUmlDataModel.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public String getNodeName(@NotNull DiagramNode<GradleElement> n) {
        if (n == null) {
            GradleUmlDataModel.$$$reportNull$$$0(4);
        }
        String string = ((GradleElement)n.getIdentifyingElement()).getName();
        if (string == null) {
            GradleUmlDataModel.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    public DiagramNode<GradleElement> addElement(GradleElement element) {
        GradleUmlNode node;
        if (element != null && !this.myNodes.contains((Object)(node = new GradleUmlNode(element, (DiagramProvider<GradleElement>)this.getProvider())))) {
            this.myNodes.add((DiagramNode<GradleElement>)node);
            return node;
        }
        return null;
    }

    public void refreshDataModel() {
        if (this.myElement == null) {
            return;
        }
        if (this.myConfigurations != null) {
            ModelData modelData = this.buildModel(this.myElement, this.myConfigurations, this.getViewOptions());
            this.updateModel(modelData);
        } else {
            this.scheduleDelayedRefresh();
        }
    }

    private void scheduleDelayedRefresh() {
        if (this.myDelayedRefreshScheduled) {
            return;
        }
        this.myDelayedRefreshScheduled = true;
        ApplicationManager.getApplication().invokeLater(() -> {
            this.refreshDataModelAsync(null).thenAccept(__ -> DumbService.getInstance((Project)this.getProject()).smartInvokeLater(() -> this.updatePresentation()));
            this.myDelayedRefreshScheduled = false;
        });
    }

    private void handleGradleModelImport(MethodHandle event, Object ... params) {
        this.scheduleDelayedRefresh();
    }

    private void updateModel(ModelData modelData) {
        this.myConfigurations = modelData.getConfigurations();
        this.myNodes.clear();
        this.myEdges.clear();
        this.myNodes.addAll(modelData.getNodes());
        this.myEdges.addAll(modelData.getEdges());
    }

    @NotNull
    public CompletableFuture<Void> refreshDataModelAsync(@Nullable ProgressIndicator indicator) {
        GradleRootElement rootElement = this.myElement;
        if (rootElement == null) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            if (completableFuture == null) {
                GradleUmlDataModel.$$$reportNull$$$0(6);
            }
            return completableFuture;
        }
        GradleModuleData moduleData = rootElement.getGradleModuleData();
        if (moduleData == null) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            if (completableFuture == null) {
                GradleUmlDataModel.$$$reportNull$$$0(7);
            }
            return completableFuture;
        }
        Project project = this.getProject();
        ViewOptions viewOptions = (ViewOptions)ReadAction.compute(() -> this.getViewOptions());
        VisibilityLevel visibility = viewOptions.getVisibility();
        CompletionStage result = GradleDependencyNodeIndex.getOrCollectDependencies((Project)project, (GradleModuleData)moduleData).thenAccept(nodes -> {
            List configurations = ContainerUtil.filter((Collection)nodes, it -> GradleUmlDataModel.suite(it.getScope(), visibility));
            ModelData modelData = this.buildModel(rootElement, configurations, viewOptions);
            ApplicationManager.getApplication().invokeAndWait(() -> this.updateModel(modelData));
        });
        return GradleUmlDataModel.waitIfUnderProgress(result, indicator);
    }

    @NotNull
    private static <T> CompletableFuture<T> waitIfUnderProgress(CompletableFuture<T> future, @Nullable ProgressIndicator indicator) {
        CompletableFuture<T> completableFuture;
        if (indicator == null) {
            CompletableFuture<T> completableFuture2 = future;
            if (completableFuture2 == null) {
                GradleUmlDataModel.$$$reportNull$$$0(8);
            }
            return completableFuture2;
        }
        try {
            completableFuture = CompletableFuture.completedFuture(future.get());
        }
        catch (Exception ex) {
            CompletableFuture completableFuture3 = CompletableFuture.failedFuture(ex);
            if (completableFuture3 == null) {
                GradleUmlDataModel.$$$reportNull$$$0(10);
            }
            return completableFuture3;
        }
        if (completableFuture == null) {
            GradleUmlDataModel.$$$reportNull$$$0(9);
        }
        return completableFuture;
    }

    @NotNull
    private ViewOptions getViewOptions() {
        return new ViewOptions(this.getVisibilityManager().getCurrentVisibilityLevel(), Objects.requireNonNull(this.getNodeContentManager()).isCategoryEnabled(CommonDiagramExtras.PATH_TO_ROOT), CommonDiagramExtras.isSelectionMode((DiagramBuilder)this.getBuilder()), DiagramSelectionService.getInstance().getSelectedNodes(this.getBuilder()));
    }

    private ModelData buildModel(@NotNull GradleRootElement element, @NotNull List<DependencyScopeNode> configurations, @NotNull ViewOptions viewOptions) {
        if (element == null) {
            GradleUmlDataModel.$$$reportNull$$$0(11);
        }
        if (configurations == null) {
            GradleUmlDataModel.$$$reportNull$$$0(12);
        }
        if (viewOptions == null) {
            GradleUmlDataModel.$$$reportNull$$$0(13);
        }
        ModelData modelData = new ModelData(this.getProject(), new GradleUmlNode(element, (DiagramProvider<GradleElement>)this.getProvider()), configurations);
        modelData.addNode(modelData.getRoot());
        modelData.getModuleNodes().put(element.getGradlePath(), modelData.getRoot());
        for (DependencyScopeNode configuration : configurations) {
            if (!GradleUmlDataModel.suite(configuration.getScope(), viewOptions.getVisibility())) continue;
            this.addNodesRecursively(modelData, modelData.getRoot(), configuration.getDependencies());
        }
        if (viewOptions.isPathToRoot()) {
            if (!viewOptions.getSelectedNodes().isEmpty()) {
                GradleUmlDataModel.removeAllExceptPathsFromRootToNodes(modelData, viewOptions.getSelectedNodes());
            }
        } else if (viewOptions.isSelectionMode()) {
            DiagramAlgorithmsService.getInstance().removeNonSelectedDependencies((DiagramDataView)modelData, viewOptions.getSelectedNodes());
        }
        return modelData;
    }

    private void updatePresentation() {
        if (!this.getProject().isDisposed() && !this.myDisposed) {
            this.myModificationTracker.incModificationCount();
            DiagramBuilder builder = this.getBuilder();
            builder.queryUpdate().withDataReload().withPresentationUpdate().withRelayout().run();
        }
    }

    private static void removeAllExceptPathsFromRootToNodes(@NotNull ModelData modelData, @NotNull Collection<DiagramNode> nodes) {
        if (modelData == null) {
            GradleUmlDataModel.$$$reportNull$$$0(14);
        }
        if (nodes == null) {
            GradleUmlDataModel.$$$reportNull$$$0(15);
        }
        Set pathEdges = DiagramAlgorithmsService.getInstance().getPathsFromRoot((DiagramNode)modelData.getRoot(), nodes, (DiagramDataView)modelData);
        Set pathNodes = DiagramAlgorithmsService.getInstance().collectNodes((Collection)pathEdges);
        for (DiagramNode diagramNode : modelData.getNodes().toArray(new DiagramNode[0])) {
            if (pathNodes.contains(diagramNode) || diagramNode == modelData.getRoot()) continue;
            modelData.getNodes().remove(diagramNode);
        }
        for (DiagramNode diagramNode : modelData.getEdges().toArray(new DiagramEdge[0])) {
            if (pathEdges.contains(diagramNode)) continue;
            modelData.getEdges().remove(diagramNode);
        }
    }

    private void addNodesRecursively(@NotNull ModelData modelData, @NotNull GradleUmlNode node, @NotNull Collection<DependencyNode> dependencies) {
        if (modelData == null) {
            GradleUmlDataModel.$$$reportNull$$$0(16);
        }
        if (node == null) {
            GradleUmlDataModel.$$$reportNull$$$0(17);
        }
        if (dependencies == null) {
            GradleUmlDataModel.$$$reportNull$$$0(18);
        }
        for (DependencyNode child : dependencies) {
            GradleElement childElement;
            GradleUmlNode childNode;
            if (child instanceof ProjectDependencyNode) {
                ProjectDependencyNode projectComponentNode = (ProjectDependencyNode)child;
                String localModuleName = projectComponentNode.getProjectName();
                childNode = modelData.getModuleNodes().get(localModuleName);
                if (childNode == null) {
                    childElement = new GradleProjectDependencyElement(this.getProject(), localModuleName);
                    childNode = new GradleUmlNode(childElement, (DiagramProvider<GradleElement>)this.getProvider());
                    modelData.addNode(childNode);
                    modelData.getModuleNodes().put(localModuleName, childNode);
                    modelData.getReferenceNodes().put(projectComponentNode.getId(), childNode);
                    this.addNodesRecursively(modelData, childNode, projectComponentNode.getDependencies());
                }
                modelData.addEdge(node, childNode);
                continue;
            }
            if (child instanceof ArtifactDependencyNode) {
                ArtifactDependencyNode artifactComponentNode = (ArtifactDependencyNode)child;
                GradleArtifact artifact = new GradleArtifact(artifactComponentNode.getGroup(), artifactComponentNode.getModule(), artifactComponentNode.getVersion());
                childNode = modelData.getArtifactNodes().get(artifact);
                if (childNode == null) {
                    childElement = new GradleLibraryDependencyElement(this.getProject(), artifact);
                    childNode = new GradleUmlNode(childElement, (DiagramProvider<GradleElement>)this.getProvider());
                    modelData.getArtifactNodes().put(artifact, childNode);
                    modelData.getReferenceNodes().put(artifactComponentNode.getId(), childNode);
                    modelData.addNode(childNode);
                    this.addNodesRecursively(modelData, childNode, artifactComponentNode.getDependencies());
                }
                modelData.addEdge(node, childNode);
                continue;
            }
            if (child instanceof FileCollectionDependencyNode) {
                FileCollectionDependencyNode fileCollectionDependencyNode = (FileCollectionDependencyNode)child;
                GradleFileDependencyElement childElement2 = new GradleFileDependencyElement(this.getProject(), String.valueOf(fileCollectionDependencyNode.getId()), fileCollectionDependencyNode.getDisplayName(), fileCollectionDependencyNode.getPath());
                childNode = new GradleUmlNode(childElement2, (DiagramProvider<GradleElement>)this.getProvider());
                modelData.getReferenceNodes().put(fileCollectionDependencyNode.getId(), childNode);
                modelData.addNode(childNode);
                modelData.addEdge(node, childNode);
                continue;
            }
            if (child instanceof ReferenceNode) {
                ReferenceNode referenceNode = (ReferenceNode)child;
                GradleUmlNode childNode2 = modelData.getReferenceNodes().get(referenceNode.getId());
                if (childNode2 != null) {
                    modelData.addEdge(node, childNode2);
                    continue;
                }
                LOG.debug("Unable to find reference from Gradle dependency report", new Object[]{referenceNode.getId()});
                continue;
            }
            if (!(child instanceof UnknownDependencyNode)) continue;
            UnknownDependencyNode unknownDependencyNode = (UnknownDependencyNode)child;
            String coordinates = unknownDependencyNode.getDisplayName();
            childNode = modelData.getUnresolvedNodes().get(coordinates);
            if (childNode == null) {
                childElement = new GradleUnresolvedElement(this.getProject(), coordinates);
                childNode = new GradleUmlNode(childElement, (DiagramProvider<GradleElement>)this.getProvider());
                modelData.getUnresolvedNodes().put(coordinates, childNode);
                modelData.getReferenceNodes().put(unknownDependencyNode.getId(), childNode);
                modelData.addNode(childNode);
            }
            modelData.addEdge(node, childNode);
        }
    }

    private static boolean suite(@Nullable String configurationName, VisibilityLevel visibility) {
        if (visibility == GradleUmlVisibilityManager.ALL || configurationName == null) {
            return true;
        }
        if (visibility == GradleUmlVisibilityManager.STANDARD) {
            return GradleUmlVisibilityManager.isStandardConfiguration(configurationName);
        }
        if (GradleUmlVisibilityManager.isStandardConfiguration(configurationName)) {
            return configurationName.equals(visibility.getName());
        }
        return false;
    }

    @NotNull
    public ModificationTracker getModificationTracker() {
        SimpleModificationTracker simpleModificationTracker = this.myModificationTracker;
        if (simpleModificationTracker == null) {
            GradleUmlDataModel.$$$reportNull$$$0(19);
        }
        return simpleModificationTracker;
    }

    public void dispose() {
        this.myConnection.disconnect();
        this.myDisposed = true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5, 6, 7, 8, 9, 10, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagram/gradle/GradleUmlDataModel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "n";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurations";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewOptions";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelData";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagram/gradle/GradleUmlDataModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdges";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeName";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "refreshDataModelAsync";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "waitIfUnderProgress";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTracker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 19: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNodeName";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "buildModel";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "removeAllExceptPathsFromRootToNodes";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addNodesRecursively";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5, 6, 7, 8, 9, 10, 19 -> new IllegalStateException(string);
        };
    }

    private static final class ViewOptions {
        public final VisibilityLevel myVisibility;
        public final boolean myPathToRoot;
        public final boolean mySelectionMode;
        public final List<DiagramNode> mySelectedNodes;

        private ViewOptions(VisibilityLevel visibility, boolean pathToRoot, boolean selectionMode, List<DiagramNode> selectedNodes) {
            this.myVisibility = visibility;
            this.myPathToRoot = pathToRoot;
            this.mySelectionMode = selectionMode;
            this.mySelectedNodes = selectedNodes;
        }

        private VisibilityLevel getVisibility() {
            return this.myVisibility;
        }

        private boolean isPathToRoot() {
            return this.myPathToRoot;
        }

        private boolean isSelectionMode() {
            return this.mySelectionMode;
        }

        private List<DiagramNode> getSelectedNodes() {
            return this.mySelectedNodes;
        }
    }

    private static final class ModelData
    implements DiagramDataView<GradleElement> {
        private final List<DiagramNode<GradleElement>> myNodes = new ArrayList<DiagramNode<GradleElement>>();
        private final List<DiagramEdge<GradleElement>> myEdges = new ArrayList<DiagramEdge<GradleElement>>();
        private final Project myProject;
        private final GradleUmlNode myRoot;
        private final List<DependencyScopeNode> myConfigurations;
        private final Map<GradleArtifact, GradleUmlNode> myArtifactNodes = new HashMap<GradleArtifact, GradleUmlNode>();
        private final Map<String, GradleUmlNode> myModuleNodes = new HashMap<String, GradleUmlNode>();
        private final Map<Long, GradleUmlNode> myReferenceNodes = new HashMap<Long, GradleUmlNode>();
        private final Map<String, GradleUmlNode> myUnresolvedNodes = new HashMap<String, GradleUmlNode>();

        private ModelData(Project project, GradleUmlNode root, List<DependencyScopeNode> configurations) {
            this.myProject = project;
            this.myRoot = root;
            this.myConfigurations = configurations;
        }

        public GradleUmlNode getRoot() {
            return this.myRoot;
        }

        public List<DependencyScopeNode> getConfigurations() {
            return this.myConfigurations;
        }

        @NotNull
        public Map<GradleArtifact, GradleUmlNode> getArtifactNodes() {
            Map<GradleArtifact, GradleUmlNode> map = this.myArtifactNodes;
            if (map == null) {
                ModelData.$$$reportNull$$$0(0);
            }
            return map;
        }

        @NotNull
        public Map<String, GradleUmlNode> getModuleNodes() {
            Map<String, GradleUmlNode> map = this.myModuleNodes;
            if (map == null) {
                ModelData.$$$reportNull$$$0(1);
            }
            return map;
        }

        @NotNull
        public Map<Long, GradleUmlNode> getReferenceNodes() {
            Map<Long, GradleUmlNode> map = this.myReferenceNodes;
            if (map == null) {
                ModelData.$$$reportNull$$$0(2);
            }
            return map;
        }

        @NotNull
        public Map<String, GradleUmlNode> getUnresolvedNodes() {
            Map<String, GradleUmlNode> map = this.myUnresolvedNodes;
            if (map == null) {
                ModelData.$$$reportNull$$$0(3);
            }
            return map;
        }

        @NotNull
        public Project getProject() {
            Project project = this.myProject;
            if (project == null) {
                ModelData.$$$reportNull$$$0(4);
            }
            return project;
        }

        @NotNull
        public Collection<DiagramNode<GradleElement>> getNodes() {
            List<DiagramNode<GradleElement>> list = this.myNodes;
            if (list == null) {
                ModelData.$$$reportNull$$$0(5);
            }
            return list;
        }

        @NotNull
        public Collection<DiagramEdge<GradleElement>> getEdges() {
            List<DiagramEdge<GradleElement>> list = this.myEdges;
            if (list == null) {
                ModelData.$$$reportNull$$$0(6);
            }
            return list;
        }

        public void addNode(@NotNull GradleUmlNode node) {
            if (node == null) {
                ModelData.$$$reportNull$$$0(7);
            }
            this.myNodes.add((DiagramNode<GradleElement>)node);
        }

        public void addEdge(@NotNull GradleUmlNode node, @NotNull GradleUmlNode childNode) {
            if (node == null) {
                ModelData.$$$reportNull$$$0(8);
            }
            if (childNode == null) {
                ModelData.$$$reportNull$$$0(9);
            }
            this.myEdges.add((DiagramEdge<GradleElement>)new GradleUmlEdge(node, childNode));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 7, 8, 9 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diagram/gradle/GradleUmlDataModel$ModelData";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "childNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getArtifactNodes";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModuleNodes";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReferenceNodes";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnresolvedNodes";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProject";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNodes";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEdges";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diagram/gradle/GradleUmlDataModel$ModelData";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "addNode";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "addEdge";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 7, 8, 9 -> new IllegalArgumentException(string);
            };
        }
    }
}

