/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.relocated.com.github.weisj.jsvg.geometry;

import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.relocated.com.github.weisj.jsvg.geometry.MeasurableShape;
import org.jetbrains.relocated.com.github.weisj.jsvg.geometry.size.Length;
import org.jetbrains.relocated.com.github.weisj.jsvg.geometry.size.MeasureContext;
import org.jetbrains.relocated.com.github.weisj.jsvg.renderer.RenderContext;

public final class SVGRectangle
implements MeasurableShape {
    @NotNull
    private final Rectangle2D.Float rect = new Rectangle2D.Float();
    @NotNull
    private final Length x;
    @NotNull
    private final Length y;
    @NotNull
    private final Length w;
    @NotNull
    private final Length h;

    public SVGRectangle(@NotNull Length x2, @NotNull Length y2, @NotNull Length w, @NotNull Length h) {
        this.x = x2;
        this.y = y2;
        this.w = w;
        this.h = h;
    }

    private void validateShape(@NotNull MeasureContext measureContext) {
        this.rect.setRect(this.x.resolveWidth(measureContext), this.y.resolveHeight(measureContext), this.w.resolveWidth(measureContext), this.h.resolveHeight(measureContext));
    }

    @Override
    @NotNull
    public Shape shape(@NotNull RenderContext context, boolean validate) {
        if (validate) {
            this.validateShape(context.measureContext());
        }
        return this.rect;
    }

    @Override
    @NotNull
    public Rectangle2D bounds(@NotNull RenderContext context, boolean validate) {
        if (validate) {
            this.validateShape(context.measureContext());
        }
        return this.rect;
    }

    @Override
    public double pathLength(@NotNull MeasureContext measureContext) {
        return 2.0f * (this.w.resolveWidth(measureContext) + this.h.resolveHeight(measureContext));
    }
}

