/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.common;

import ai.grazie.gec.model.problem.ProblemFix;
import ai.grazie.nlp.patterns.standard.LikelyPatterns;
import ai.grazie.rules.Example;
import ai.grazie.rules.MatchingResult;
import ai.grazie.rules.Rule;
import ai.grazie.rules.RuleMatch;
import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.document.ConsistencyChecker;
import ai.grazie.rules.document.DocumentRule;
import ai.grazie.rules.document.DocumentSentence;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeMatch;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.Tree;
import ai.grazie.text.TextRange;
import ai.grazie.text.exclusions.Exclusion;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.tools.StringTools;

public class SentenceCapitalizationRule
extends Rule
implements DocumentRule {
    private static final NodePattern looksLikeProductName = NodePattern.N.formCaseSensitive("[a-z][a-z_0-9]+").noPos().noSpaceAfter().directlyBefore(CommonPatterns.HYPHEN_NODE);
    private static final NodePattern allowedPunctuation = NodePattern.or(NodePattern.N.form("['\"\u201c\u201d\u201e\u00ab\u00bb`\u2018\u2019]"), CommonPatterns.HYPHEN_LIKE_NODE);
    private static final NodePattern pathPart = NodePattern.or(NodePattern.N.noSpaceAfter().directlyBefore(CommonPatterns.anySlash), NodePattern.N.form("[a-z]:[/\\\\][a-z].*"));
    private static final NodePattern ignoreFirstWord = NodePattern.or(looksLikeProductName, pathPart, NodePattern.N.directlyAfter(NodePattern.N.form("[\\[{<(`]")), NodePattern.N.form("\\p{L}{1,2}\\d+"), CommonPatterns.inCodeContext);
    private final String message;
    private final String capitalizeFix;

    public SentenceCapitalizationRule(String displayName, String description, @Nullable String url, String example, String message, String capitalizeFix) {
        super("Style.SENTENCE_CAPITALIZATION", displayName, description, url, SentenceCapitalizationRule.createExample(example));
        this.message = message;
        this.capitalizeFix = capitalizeFix;
    }

    private static Example createExample(String example) {
        assert (StringTools.startsWithLowercase((String)example));
        return new Example("<b>" + example.substring(0, 2) + "</b>" + example.substring(2), "<b>" + StringTools.uppercaseFirstChar((String)example.substring(0, 2)) + "</b>" + example.substring(2));
    }

    @Override
    @NotNull
    public MatchingResult match(Tree tree) {
        return MatchingResult.EMPTY;
    }

    private static boolean mustBeUpperCase(Node node) {
        return Character.isUpperCase(node.form().charAt(0)) && !node.posReadings().isEmpty() && node.tree().treeSupport().tagToken(node.lowForm()).tokenReadings().stream().noneMatch(r -> r.pos() != null);
    }

    @Override
    public MatchingResult checkDocument(List<DocumentSentence.Analyzed> sentences) {
        if (sentences.stream().allMatch(s -> s.intro.isEmpty())) {
            sentences = DocumentSentence.inferStructure(sentences);
        }
        ArrayList<RuleMatch> matches = new ArrayList<RuleMatch>();
        for (List<DocumentSentence.Analyzed> fragment : DocumentSentence.fragments(ConsistencyChecker.onlyConsistencyEnabledDomains(sentences))) {
            if (fragment.size() <= 1) continue;
            matches.addAll(this.checkFragment(fragment));
        }
        return MatchingResult.from(matches);
    }

    private List<RuleMatch> checkFragment(List<DocumentSentence.Analyzed> fragment) {
        final ArrayList<ProblemFix.Part.Change> correctors = new ArrayList<ProblemFix.Part.Change>();
        final ArrayList<ai.grazie.rules.tree.TextRange> hoverRanges = new ArrayList<ai.grazie.rules.tree.TextRange>();
        ArrayList<1> problems = new ArrayList<1>();
        boolean hasCaps = false;
        for (DocumentSentence.Analyzed sentence : fragment) {
            Node node;
            Tree tree = sentence.tree;
            if (tree == null || sentence.language != this.language() || (node = SentenceCapitalizationRule.findFirstWord(tree)) == null || SentenceCapitalizationRule.hasUnknownExclusionsBefore(sentence, node.startOffset())) continue;
            ai.grazie.rules.tree.TextRange highlightInSentence = ai.grazie.rules.tree.TextRange.fromLength(node.startOffset(), 2);
            final ai.grazie.rules.tree.TextRange highlightInDoc = highlightInSentence.shiftRight(tree.startOffset());
            hoverRanges.add(highlightInDoc);
            if (Character.isUpperCase(node.form().charAt(0))) {
                hasCaps = true;
                continue;
            }
            if (sentence.suppressions.contains(highlightInSentence)) continue;
            correctors.add(new ProblemFix.Part.Change(new TextRange(node.startOffset(), node.endOffset()).shift(tree.startOffset()), StringTools.uppercaseFirstChar((String)node.form())));
            problems.add(new RuleMatch(this, this.message){

                @Override
                public NodeMatch.SuppressableKind suppressableKind() {
                    return NodeMatch.SuppressableKind.UPPERCASE_SENTENCE_START;
                }

                @Override
                public List<ProblemFix> problemFixes() {
                    return List.of(new ProblemFix(correctors.toArray(new ProblemFix.Part[0]), null, SentenceCapitalizationRule.this.capitalizeFix));
                }

                @Override
                public List<ai.grazie.rules.tree.TextRange> reportedRanges() {
                    return List.of(highlightInDoc);
                }

                @Override
                public List<ai.grazie.rules.tree.TextRange> hoverReportedRanges() {
                    return hoverRanges;
                }
            });
        }
        return hasCaps ? problems : List.of();
    }

    public static boolean hasUnknownExclusionsBefore(DocumentSentence sentence, int offset) {
        return sentence.exclusions.stream().anyMatch(e -> e.getOffset() <= offset && e.getKind() == Exclusion.Kind.Unknown);
    }

    @Nullable
    private static Node findFirstWord(Tree tree) {
        if (tree.text().length() < 3) {
            return null;
        }
        for (Node node : tree.nodes()) {
            if (CommonPatterns.nonWordPunct.matches(node)) {
                if (allowedPunctuation.matches(node)) continue;
                return null;
            }
            String form = node.form();
            if (!Character.isLetter(form.charAt(0)) || CommonPatterns.isCustomCase(form) || SentenceCapitalizationRule.mustBeUpperCase(node) || LikelyPatterns.IsURL.matches((CharSequence)node.lowForm()) || ignoreFirstWord.matches(node)) {
                return null;
            }
            return node;
        }
        return null;
    }
}

