/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.ui.EDT;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.ExecutionContext;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileTransferUtil {
    private static final Logger LOG = Logger.getInstance(FileTransferUtil.class);
    private static final int BUFFER_SIZE = 1024;

    private FileTransferUtil() {
    }

    public static void copyContent(FileObject srcFile, FileObject destFile, ExecutionContext context) throws IOException {
        if (destFile.exists() && context.getProject() != null && PublishConfig.getInstance(context.getProject()).isUseTempFile()) {
            FileObject parent = destFile.getParent();
            if (parent != null) {
                FileObject temp = parent.resolveFile(destFile.getName().getBaseName() + ".new");
                temp.createFile();
                try (OutputStream outstr = temp.getContent().getOutputStream();){
                    FileTransferUtil.writeContent(srcFile, outstr, context);
                    destFile.delete();
                    System.out.println("delete destFile");
                    temp.moveTo(destFile);
                    System.out.println("moveTo destFile");
                }
            }
        } else {
            try (OutputStream outstr = destFile.getContent().getOutputStream();){
                FileTransferUtil.writeContent(srcFile, outstr, context);
            }
        }
    }

    public static void writeContent(FileObject file, OutputStream outstr, ExecutionContext context) throws IOException {
        LOG.assertTrue(!EDT.isCurrentThreadEdt() || ApplicationManager.getApplication().isUnitTestMode(), (Object)"No remote server interactions in dispatch thread!");
        ProgressIndicator pi = context.getProgressIndicator();
        pi.checkCanceled();
        context.setCurrentFileFraction(0.0);
        try (InputStream instr = file.getContent().getInputStream();){
            int nread;
            long size = file.getContent().getSize();
            long read = 0L;
            boolean readMoreThanSizeWarning = false;
            boolean sizeChangedWarning = false;
            byte[] buffer = new byte[1024];
            while ((nread = instr.read(buffer)) >= 0) {
                pi.checkCanceled();
                outstr.write(buffer, 0, nread);
                if ((read += (long)nread) > size) {
                    String fileName = context.isServerSideModification() ? DeploymentPathUtils.getLocalPath(file) : context.getServer().getPresentablePath(file);
                    long newSize = file.getContent().getSize();
                    if (newSize > size && newSize > read) {
                        if (!sizeChangedWarning) {
                            context.console(WDBundle.message("warning.file.0.was.changed.on.server.while.retrying.to.copy.from.it", fileName), ConsoleViewContentType.SYSTEM_OUTPUT);
                            LOG.warn("Changed size: file '" + file.getName().getPath() + "', is read " + read + ", size " + newSize);
                            sizeChangedWarning = true;
                        }
                        size = newSize;
                    } else {
                        if (!readMoreThanSizeWarning) {
                            context.console(WDBundle.message("warning.while.copying.file.0.got.more.content.than.file.size", fileName), ConsoleViewContentType.SYSTEM_OUTPUT);
                            LOG.warn("More content than file size: file '" + file.getName().getPath() + "', is read " + read + ", size " + newSize);
                            readMoreThanSizeWarning = true;
                        }
                        size = read;
                    }
                }
                context.setCurrentFileFraction((float)read / (float)size);
                pi.checkCanceled();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getContent(FileObject file, @Nullable ProgressIndicator pi) throws IOException {
        LOG.assertTrue(!EDT.isCurrentThreadEdt() || ApplicationManager.getApplication().isUnitTestMode(), (Object)"No remote server interactions in dispatch thread!");
        FileContent content = file.getContent();
        if (pi != null) {
            pi.checkCanceled();
        }
        InputStream in = content.getInputStream();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        try {
            int nRead;
            while ((nRead = in.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
                if (pi == null) continue;
                pi.checkCanceled();
            }
        }
        finally {
            in.close();
        }
        buffer.flush();
        return buffer.toByteArray();
    }

    public static void writeContent(byte @NotNull [] source, OutputStream outstr, ExecutionContext context) throws IOException {
        if (source == null) {
            FileTransferUtil.$$$reportNull$$$0(0);
        }
        LOG.assertTrue(!EDT.isCurrentThreadEdt() || ApplicationManager.getApplication().isUnitTestMode(), (Object)"No remote server interactions in dispatch thread!");
        ProgressIndicator pi = context.getProgressIndicator();
        pi.checkCanceled();
        context.setCurrentFileFraction(0.0);
        try (ByteArrayInputStream instr = new ByteArrayInputStream(source);){
            int nread;
            long size = source.length;
            long read = 0L;
            byte[] buffer = new byte[1024];
            while ((nread = instr.read(buffer)) >= 0) {
                pi.checkCanceled();
                outstr.write(buffer, 0, nread);
                context.setCurrentFileFraction((float)(read += (long)nread) / (float)size);
                pi.checkCanceled();
            }
            LOG.debug("Uploaded " + read + " bytes, came " + size + " bytes");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/jetbrains/plugins/webDeployment/FileTransferUtil", "writeContent"));
    }
}

