/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.adapter;

import com.jgoodies.binding.list.SelectionInList;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.common.base.Preconditions;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public final class ComboBoxAdapter<E>
extends AbstractListModel
implements ComboBoxModel {
    private final ListModel listModel;
    private ValueModel selectionHolder;
    private final PropertyChangeListener selectionChangeHandler;

    public ComboBoxAdapter(List<E> items, ValueModel selectionHolder) {
        this(new ListModelAdapter<E>(items), selectionHolder);
        Preconditions.checkNotNull(items, (String)"The list must not be null.");
    }

    public ComboBoxAdapter(ListModel listModel, ValueModel selectionHolder) {
        this.listModel = (ListModel)Preconditions.checkNotNull((Object)listModel, (String)"The ListModel must not be null.");
        this.selectionHolder = (ValueModel)Preconditions.checkNotNull((Object)selectionHolder, (String)"The selection holder must not be null.");
        listModel.addListDataListener(new ListDataChangeHandler());
        this.selectionChangeHandler = new SelectionChangeHandler();
        this.setSelectionHolder(selectionHolder);
    }

    public ComboBoxAdapter(E[] items, ValueModel selectionHolder) {
        this(new ListModelAdapter<E>(items), selectionHolder);
    }

    public ComboBoxAdapter(SelectionInList<E> selectionInList) {
        this(selectionInList, selectionInList);
        selectionInList.addPropertyChangeListener("selectionHolder", new SelectionHolderChangeHandler());
    }

    public E getSelectedItem() {
        return (E)this.selectionHolder.getValue();
    }

    @Override
    public void setSelectedItem(Object object) {
        this.selectionHolder.setValue(object);
    }

    @Override
    public int getSize() {
        return this.listModel.getSize();
    }

    @Override
    public E getElementAt(int index) {
        return this.listModel.getElementAt(index);
    }

    private void setSelectionHolder(ValueModel newSelectionHolder) {
        ValueModel oldSelectionHolder = this.selectionHolder;
        if (oldSelectionHolder != null) {
            oldSelectionHolder.removeValueChangeListener(this.selectionChangeHandler);
        }
        this.selectionHolder = (ValueModel)Preconditions.checkNotNull((Object)newSelectionHolder, (String)"The selection holder must not be null.");
        newSelectionHolder.addValueChangeListener(this.selectionChangeHandler);
    }

    private void fireContentsChanged() {
        this.fireContentsChanged(this, -1, -1);
    }

    private static final class ListModelAdapter<E>
    extends AbstractListModel {
        private final List<E> aList;

        ListModelAdapter(List<E> list) {
            this.aList = list;
        }

        ListModelAdapter(E[] elements) {
            this(Arrays.asList(elements));
        }

        @Override
        public int getSize() {
            return this.aList.size();
        }

        @Override
        public E getElementAt(int index) {
            return this.aList.get(index);
        }
    }

    private final class SelectionHolderChangeHandler
    implements PropertyChangeListener {
        private SelectionHolderChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ComboBoxAdapter.this.setSelectionHolder((ValueModel)evt.getNewValue());
            ComboBoxAdapter.this.fireContentsChanged();
        }
    }

    private final class ListDataChangeHandler
    implements ListDataListener {
        private ListDataChangeHandler() {
        }

        @Override
        public void intervalAdded(ListDataEvent evt) {
            ComboBoxAdapter.this.fireIntervalAdded(ComboBoxAdapter.this, evt.getIndex0(), evt.getIndex1());
        }

        @Override
        public void intervalRemoved(ListDataEvent evt) {
            ComboBoxAdapter.this.fireIntervalRemoved(ComboBoxAdapter.this, evt.getIndex0(), evt.getIndex1());
        }

        @Override
        public void contentsChanged(ListDataEvent evt) {
            ComboBoxAdapter.this.fireContentsChanged(ComboBoxAdapter.this, evt.getIndex0(), evt.getIndex1());
        }
    }

    private final class SelectionChangeHandler
    implements PropertyChangeListener {
        private SelectionChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ComboBoxAdapter.this.fireContentsChanged();
        }
    }
}

