/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.junit5.report;

import com.intellij.junit5.report.AbstractTestReporter;
import com.intellij.junit5.report.ExecutionState;
import com.intellij.junit5.report.SuiteReporter;
import com.intellij.junit5.report.TestReporter;
import com.intellij.rt.execution.junit.MapSerializerUtil;
import java.util.ArrayList;
import java.util.List;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.launcher.TestIdentifier;

public class CompositeTestReporter
extends AbstractTestReporter {
    private final TestReporter asTest;
    private final SuiteReporter asSuite;

    public CompositeTestReporter(TestIdentifier identifier, ExecutionState state) {
        super(identifier, state);
        this.asTest = new TestReporter(identifier, state);
        this.asSuite = new SuiteReporter(identifier, state);
    }

    @Override
    public List<String> start() {
        ArrayList<String> out = new ArrayList<String>();
        out.addAll(this.asSuite.start());
        out.addAll(this.asTest.start());
        return out;
    }

    @Override
    public List<String> output(ReportEntry entry) {
        return this.asTest.output(entry);
    }

    @Override
    public List<String> finish(TestExecutionResult result) {
        ArrayList<String> out = new ArrayList<String>();
        out.addAll(this.asTest.finish(result));
        out.addAll(this.asSuite.finish(result));
        return out;
    }

    @Override
    public List<String> treeStarted() {
        ArrayList<String> out = new ArrayList<String>(this.asSuite.treeStarted());
        String testNode = MapSerializerUtil.asString((String)"suiteTreeNode", this.attributes(AbstractTestReporter.ReportedField.ID, AbstractTestReporter.ReportedField.NAME, AbstractTestReporter.ReportedField.NODE_ID, AbstractTestReporter.ReportedField.PARENT_NODE_ID, AbstractTestReporter.ReportedField.HINT, AbstractTestReporter.ReportedField.METAINFO));
        out.add(testNode);
        return out;
    }

    @Override
    public List<String> treeFinished() {
        return this.asSuite.treeFinished();
    }

    @Override
    public List<String> skip(String reason) {
        return this.asTest.skip(reason);
    }
}

