/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.dataframe;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.exc.StreamConstraintsException;
import com.intellij.notebooks.dataframe.DataFrameParsingNotifications;
import com.intellij.notebooks.dataframe.KotlinDataframeParser;
import com.intellij.notebooks.dataframe.KotlinDataframeTableDataProviderBaseKt;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ComponentManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.scientific.tables.api.DSDataFrameInfo;
import com.intellij.scientific.tables.api.DSTableDataType;
import com.intellij.scientific.tables.api.DSTableRawData;
import com.intellij.scientific.tables.api.DataId;
import com.intellij.scientific.tables.api.NestedTableDataProvider;
import com.intellij.scientific.tables.api.filters.FilterExpression;
import com.intellij.scientific.tables.utils.ScientificTablesCoroutineKt;
import com.intellij.scientific.tables.utils.exceptions.DSTableDataException;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\b&\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0096@\u00a2\u0006\u0002\u0010\u0016J\u001e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0015H\u0096@\u00a2\u0006\u0002\u0010\u001cJ/\u0010\u001d\u001a\u0002H\u001e\"\u0004\b\u0000\u0010\u001e2\b\b\u0001\u0010\u001f\u001a\u00020\u00152\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u001e0!H\u0084\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\"J\u0012\u0010#\u001a\u0004\u0018\u00010\u00152\u0006\u0010$\u001a\u00020\u0015H\u0005J\b\u0010%\u001a\u00020&H\u0004J \u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00152\u000e\b\u0002\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00150+H\u0004J\u0010\u0010,\u001a\u00020\u00152\u0006\u0010-\u001a\u00020\u0015H\u0004J(\u0010.\u001a\u00020\u00152\u0006\u0010/\u001a\u00020\u00152\b\u00100\u001a\u0004\u0018\u0001012\u0006\u00102\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u00103J\u000e\u00104\u001a\u00020(H\u0096@\u00a2\u0006\u0002\u00105J\u0018\u00106\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u00107\u001a\u00020(H\u0004J\u0018\u00108\u001a\u00020\u00182\u0006\u00109\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u0015H\u0004J\u0010\u0010:\u001a\u00020&2\u0006\u0010;\u001a\u00020\u0007H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006<"}, d2={"Lcom/intellij/notebooks/dataframe/KotlinDataFrameProviderBase;", "Lcom/intellij/scientific/tables/api/NestedTableDataProvider;", "project", "Lcom/intellij/openapi/project/Project;", "parser", "Lcom/intellij/notebooks/dataframe/KotlinDataframeParser;", "columnsLimit", "", "notifications", "Lcom/intellij/notebooks/dataframe/DataFrameParsingNotifications;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/notebooks/dataframe/KotlinDataframeParser;ILcom/intellij/notebooks/dataframe/DataFrameParsingNotifications;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getNotifications", "()Lcom/intellij/notebooks/dataframe/DataFrameParsingNotifications;", "getType", "Lcom/intellij/scientific/tables/api/DSTableDataType;", "parseStaticTableToFrameInfo", "Lcom/intellij/scientific/tables/api/DSDataFrameInfo;", "text", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "parseStaticTableToTableData", "Lcom/intellij/scientific/tables/api/DSTableRawData;", "dataId", "Lcom/intellij/scientific/tables/api/DataId;", "table", "(Lcom/intellij/scientific/tables/api/DataId;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "executeParsing", "T", "textData", "parseFunction", "Lkotlin/Function0;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "extractNonComparableColumnTypeMessage", "exceptionMessage", "notifyUnknownParsingException", "", "isNonComparableColumnSortingError", "", "response", "errorIndicators", "", "extractColumnNameFromSortErrorMessage", "errorMsg", "getFilteringCommand", "tableVariable", "filters", "Lcom/intellij/scientific/tables/api/filters/FilterExpression;", "tableColumnsNumber", "(Ljava/lang/String;Lcom/intellij/scientific/tables/api/filters/FilterExpression;ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isFallbackToStaticTableSupported", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "parseFrameInfoFromKotlinDataframeOutput", "isPreview", "parseDataFromKotlinDataframeOutput", "id", "requireNumberOfColumnsLessThanLimit", "numberOfColumns", "intellij.notebooks.dataframe"})
@SourceDebugExtension(value={"SMAP\nKotlinDataframeTableDataProviderBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinDataframeTableDataProviderBase.kt\ncom/intellij/notebooks/dataframe/KotlinDataFrameProviderBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,207:1\n1786#2,3:208\n*S KotlinDebug\n*F\n+ 1 KotlinDataframeTableDataProviderBase.kt\ncom/intellij/notebooks/dataframe/KotlinDataFrameProviderBase\n*L\n105#1:208,3\n*E\n"})
public abstract class KotlinDataFrameProviderBase
implements NestedTableDataProvider {
    @NotNull
    private final Project project;
    @NotNull
    private final KotlinDataframeParser parser;
    private final int columnsLimit;
    @NotNull
    private final DataFrameParsingNotifications notifications;

    public KotlinDataFrameProviderBase(@NotNull Project project, @NotNull KotlinDataframeParser parser, int columnsLimit, @NotNull DataFrameParsingNotifications notifications) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        Intrinsics.checkNotNullParameter((Object)notifications, (String)"notifications");
        this.project = project;
        this.parser = parser;
        this.columnsLimit = columnsLimit;
        this.notifications = notifications;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final DataFrameParsingNotifications getNotifications() {
        return this.notifications;
    }

    @NotNull
    public DSTableDataType getType() {
        return DSTableDataType.EXTERNAL;
    }

    @Nullable
    public Object parseStaticTableToFrameInfo(@NotNull String text, @NotNull Continuation<? super DSDataFrameInfo> $completion) {
        return this.parseFrameInfoFromKotlinDataframeOutput(text, true);
    }

    @Nullable
    public Object parseStaticTableToTableData(@NotNull DataId dataId, @NotNull String table, @NotNull Continuation<? super DSTableRawData> $completion) {
        return this.parseDataFromKotlinDataframeOutput(dataId, table);
    }

    protected final <T> T executeParsing(@NlsSafe @NotNull String textData, @NotNull Function0<? extends T> parseFunction) throws DSTableDataException {
        Object object;
        Intrinsics.checkNotNullParameter((Object)textData, (String)"textData");
        Intrinsics.checkNotNullParameter(parseFunction, (String)"parseFunction");
        boolean $i$f$executeParsing = false;
        try {
            object = parseFunction.invoke();
        }
        catch (DSTableDataException e) {
            throw e;
        }
        catch (JsonParseException e) {
            if (KotlinDataFrameProviderBase.isNonComparableColumnSortingError$default(this, textData, null, 2, null)) {
                ScientificTablesCoroutineKt.launchEdt((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, textData, null){
                    int I$0;
                    int I$1;
                    Object L$0;
                    int label;
                    final /* synthetic */ KotlinDataFrameProviderBase this$0;
                    final /* synthetic */ String $textData;
                    {
                        this.this$0 = $receiver;
                        this.$textData = $textData;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object invokeSuspend(Object $result) {
                        var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                $i$f$serviceAsync = 0;
                                v0 = ApplicationManager.getApplication();
                                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getApplication(...)");
                                $this$serviceAsync$iv$iv = (ComponentManager)v0;
                                $i$f$serviceAsync = 0;
                                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$serviceAsync$iv$iv);
                                this.I$0 = $i$f$serviceAsync;
                                this.I$1 = $i$f$serviceAsync;
                                this.label = 1;
                                v1 = ((ComponentManagerEx)$this$serviceAsync$iv$iv).getServiceAsync(NotificationGroupManager.class, (Continuation)this);
                                if (v1 == var5_2) {
                                    return var5_2;
                                }
                                ** GOTO lbl26
                            }
                            case 1: {
                                $i$f$serviceAsync = this.I$1;
                                $i$f$serviceAsync = this.I$0;
                                $this$serviceAsync$iv$iv = (ComponentManager)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
lbl26:
                                // 2 sources

                                v2 = ((NotificationGroupManager)v1).getNotificationGroup(this.this$0.getNotifications().getNotificationGroupId());
                                v3 = this.this$0.getNotifications().nonComparableSortTitle(this.this$0.extractColumnNameFromSortErrorMessage(this.$textData));
                                v4 = this.this$0.extractNonComparableColumnTypeMessage(this.$textData);
                                if (v4 == null) {
                                    v4 = this.this$0.getNotifications().getNonComparableSortContentFallback();
                                }
                                v2.createNotification(v3, v4, NotificationType.WARNING).notify(this.this$0.getProject());
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }));
                throw new DSTableDataException(this.getNotifications().getNonComparableSortException(), (Throwable)e);
            }
            this.notifyUnknownParsingException();
            throw new DSTableDataException("Error parsing data from Kotlin DataFrame output. Reason: " + e.getLocalizedMessage(), (Throwable)e);
        }
        catch (StreamConstraintsException e) {
            ScientificTablesCoroutineKt.launchEdt((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int I$0;
                int I$1;
                Object L$0;
                int label;
                final /* synthetic */ KotlinDataFrameProviderBase this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            $i$f$serviceAsync = 0;
                            v0 = ApplicationManager.getApplication();
                            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getApplication(...)");
                            $this$serviceAsync$iv$iv = (ComponentManager)v0;
                            $i$f$serviceAsync = 0;
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$serviceAsync$iv$iv);
                            this.I$0 = $i$f$serviceAsync;
                            this.I$1 = $i$f$serviceAsync;
                            this.label = 1;
                            v1 = ((ComponentManagerEx)$this$serviceAsync$iv$iv).getServiceAsync(NotificationGroupManager.class, (Continuation)this);
                            if (v1 == var5_2) {
                                return var5_2;
                            }
                            ** GOTO lbl26
                        }
                        case 1: {
                            $i$f$serviceAsync = this.I$1;
                            $i$f$serviceAsync = this.I$0;
                            $this$serviceAsync$iv$iv = (ComponentManager)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl26:
                            // 2 sources

                            ((NotificationGroupManager)v1).getNotificationGroup(this.this$0.getNotifications().getNotificationGroupId()).createNotification(this.this$0.getNotifications().getCannotRenderDataFrame(), this.this$0.getNotifications().getCannotParseDataFrame(), NotificationType.WARNING).notify(this.this$0.getProject());
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
            throw new DSTableDataException("Error parsing data from Kotlin DataFrame output. Reason: " + e.getLocalizedMessage(), (Throwable)e);
        }
        catch (IOException e) {
            this.notifyUnknownParsingException();
            throw new DSTableDataException("Error parsing data from Kotlin DataFrame output. Reason: " + e.getLocalizedMessage(), (Throwable)e);
        }
        catch (RuntimeException e) {
            this.notifyUnknownParsingException();
            throw new DSTableDataException("Error parsing data from Kotlin DataFrame output. Reason: " + e.getLocalizedMessage(), (Throwable)e);
        }
        return (T)object;
    }

    @NlsSafe
    @Nullable
    protected final String extractNonComparableColumnTypeMessage(@NotNull String exceptionMessage) {
        MatchResult matchResult;
        Intrinsics.checkNotNullParameter((Object)exceptionMessage, (String)"exceptionMessage");
        Regex regex = new Regex("Column '(.+?)' has type '(.+?)' that is not Comparable");
        MatchResult matchResult2 = matchResult = Regex.find$default((Regex)regex, (CharSequence)exceptionMessage, (int)0, (int)2, null);
        return matchResult2 != null ? matchResult2.getValue() : null;
    }

    protected final void notifyUnknownParsingException() {
        NotificationGroupManager.getInstance().getNotificationGroup(this.notifications.getNotificationGroupId()).createNotification(this.notifications.getCannotRenderDataFrame(), this.notifications.getCannotParseDataFrameUnknown(), NotificationType.WARNING).notify(this.project);
    }

    protected final boolean isNonComparableColumnSortingError(@NotNull String response, @NotNull List<String> errorIndicators) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            Intrinsics.checkNotNullParameter(errorIndicators, (String)"errorIndicators");
            Iterable $this$all$iv = errorIndicators;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    String indicator = (String)element$iv;
                    boolean bl2 = false;
                    if (StringsKt.contains$default((CharSequence)response, (CharSequence)indicator, (boolean)false, (int)2, null)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public static /* synthetic */ boolean isNonComparableColumnSortingError$default(KotlinDataFrameProviderBase kotlinDataFrameProviderBase, String string, List list, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: isNonComparableColumnSortingError");
        }
        if ((n & 2) != 0) {
            Object[] objectArray = new String[]{"Column", "has type", "that is not Comparable"};
            list = CollectionsKt.listOf((Object[])objectArray);
        }
        return kotlinDataFrameProviderBase.isNonComparableColumnSortingError(string, list);
    }

    @NotNull
    protected final String extractColumnNameFromSortErrorMessage(@NotNull String errorMsg) {
        Intrinsics.checkNotNullParameter((Object)errorMsg, (String)"errorMsg");
        Regex regex = new Regex("Column '+(.*?)'+");
        MatchResult matchResult = Regex.find$default((Regex)regex, (CharSequence)errorMsg, (int)0, (int)2, null);
        Object object = matchResult;
        if (object == null || (object = object.getGroupValues()) == null || (object = (String)object.get(1)) == null) {
            object = "";
        }
        return object;
    }

    @Nullable
    public Object getFilteringCommand(@NotNull String tableVariable, @Nullable FilterExpression filters, int tableColumnsNumber, @NotNull Continuation<? super String> $completion) {
        return tableVariable;
    }

    @Nullable
    public Object isFallbackToStaticTableSupported(@NotNull Continuation<? super Boolean> $completion) {
        return KotlinDataFrameProviderBase.isFallbackToStaticTableSupported$suspendImpl(this, $completion);
    }

    static /* synthetic */ Object isFallbackToStaticTableSupported$suspendImpl(KotlinDataFrameProviderBase $this, Continuation<? super Boolean> $completion) {
        return Boxing.boxBoolean((boolean)true);
    }

    @NotNull
    protected final DSDataFrameInfo parseFrameInfoFromKotlinDataframeOutput(@NotNull String text, boolean isPreview) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        DSDataFrameInfo info = KotlinDataframeTableDataProviderBaseKt.access$asDsTableInfo(this.parser.parseDataFrameInfo(text), isPreview);
        this.requireNumberOfColumnsLessThanLimit(info.getColumnNames().size());
        return info;
    }

    @NotNull
    protected final DSTableRawData parseDataFromKotlinDataframeOutput(@NotNull DataId id, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        List<List<Object>> columnValues = this.parser.parseDataFrameData(text);
        this.requireNumberOfColumnsLessThanLimit(columnValues.size());
        return new DSTableRawData(id, columnValues);
    }

    private final void requireNumberOfColumnsLessThanLimit(int numberOfColumns) {
        if (numberOfColumns > this.columnsLimit) {
            NotificationGroupManager.getInstance().getNotificationGroup(this.notifications.getNotificationGroupId()).createNotification(this.notifications.getTooManyColumnsTitle(), this.notifications.tooManyColumnsContent(numberOfColumns), NotificationType.WARNING).notify(this.project);
            throw new DSTableDataException("Attempt to create grid with " + numberOfColumns + " columns");
        }
    }
}

